import{s as Sr,o as Lr,n as V}from"../chunks/scheduler.9bc65507.js";import{S as Rr,i as Xr,g as o,s as a,u as g,A as Pr,h as s,f as n,c as i,j as f,v as _,y as u,k as h,o as t,a as c,w as M,d as b,t as y,x as v}from"../chunks/index.78c82d43.js";import{T as gn}from"../chunks/Tip.87d55b76.js";import{D as E}from"../chunks/Docstring.f3d04bd2.js";import{C as Mn}from"../chunks/CodeBlock.48618ec2.js";import{I as B}from"../chunks/IconCopyLink.bedaa44d.js";import{E as _n}from"../chunks/ExampleCodeBlock.872b014d.js";function Ar($){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=T},l(p){r=s(p,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(p,m){c(p,r,m)},p:V,d(p){p&&n(r)}}}function Qr($){let r,T="Example:",p,m,w;return m=new Mn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZU1Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyc3VzbmF0byUyRmVybmllLW0tYmFzZV9weXRvcmNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwRXJuaWVNTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMModel.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){r=o("p"),r.textContent=T,p=a(),g(m.$$.fragment)},l(l){r=s(l,"P",{"data-svelte-h":!0}),u(r)!=="svelte-11lpom8"&&(r.textContent=T),p=i(l),_(m.$$.fragment,l)},m(l,k){c(l,r,k),c(l,p,k),M(m,l,k),w=!0},p:V,i(l){w||(b(m.$$.fragment,l),w=!0)},o(l){y(m.$$.fragment,l),w=!1},d(l){l&&(n(r),n(p)),v(m,l)}}}function Yr($){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=T},l(p){r=s(p,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(p,m){c(p,r,m)},p:V,d(p){p&&n(r)}}}function Or($){let r,T="Example of single-label classification:",p,m,w;return m=new Mn({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEVybmllTUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBbW9kZWwlMjAlM0QlMjBFcm5pZU1Gb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMEVybmllTUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`}}),{c(){r=o("p"),r.textContent=T,p=a(),g(m.$$.fragment)},l(l){r=s(l,"P",{"data-svelte-h":!0}),u(r)!=="svelte-ykxpe4"&&(r.textContent=T),p=i(l),_(m.$$.fragment,l)},m(l,k){c(l,r,k),c(l,p,k),M(m,l,k),w=!0},p:V,i(l){w||(b(m.$$.fragment,l),w=!0)},o(l){y(m.$$.fragment,l),w=!1},d(l){l&&(n(r),n(p)),v(m,l)}}}function Dr($){let r,T="Example of multi-label classification:",p,m,w;return m=new Mn({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEVybmllTUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBbW9kZWwlMjAlM0QlMjBFcm5pZU1Gb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIlMkMlMjBwcm9ibGVtX3R5cGUlM0QlMjJtdWx0aV9sYWJlbF9jbGFzc2lmaWNhdGlvbiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWRzJTIwJTNEJTIwdG9yY2guYXJhbmdlKDAlMkMlMjBsb2dpdHMuc2hhcGUlNUItMSU1RCklNUJ0b3JjaC5zaWdtb2lkKGxvZ2l0cykuc3F1ZWV6ZShkaW0lM0QwKSUyMCUzRSUyMDAuNSU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMEVybmllTUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`}}),{c(){r=o("p"),r.textContent=T,p=a(),g(m.$$.fragment)},l(l){r=s(l,"P",{"data-svelte-h":!0}),u(r)!=="svelte-1l8e32d"&&(r.textContent=T),p=i(l),_(m.$$.fragment,l)},m(l,k){c(l,r,k),c(l,p,k),M(m,l,k),w=!0},p:V,i(l){w||(b(m.$$.fragment,l),w=!0)},o(l){y(m.$$.fragment,l),w=!1},d(l){l&&(n(r),n(p)),v(m,l)}}}function Kr($){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=T},l(p){r=s(p,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(p,m){c(p,r,m)},p:V,d(p){p&&n(r)}}}function ea($){let r,T="Example:",p,m,w;return m=new Mn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZU1Gb3JNdWx0aXBsZUNob2ljZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyc3VzbmF0byUyRmVybmllLW0tYmFzZV9weXRvcmNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwRXJuaWVNRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJJbiUyMEl0YWx5JTJDJTIwcGl6emElMjBzZXJ2ZWQlMjBpbiUyMGZvcm1hbCUyMHNldHRpbmdzJTJDJTIwc3VjaCUyMGFzJTIwYXQlMjBhJTIwcmVzdGF1cmFudCUyQyUyMGlzJTIwcHJlc2VudGVkJTIwdW5zbGljZWQuJTIyJTBBY2hvaWNlMCUyMCUzRCUyMCUyMkl0JTIwaXMlMjBlYXRlbiUyMHdpdGglMjBhJTIwZm9yayUyMGFuZCUyMGElMjBrbmlmZS4lMjIlMEFjaG9pY2UxJTIwJTNEJTIwJTIySXQlMjBpcyUyMGVhdGVuJTIwd2hpbGUlMjBoZWxkJTIwaW4lMjB0aGUlMjBoYW5kLiUyMiUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvcigwKS51bnNxdWVlemUoMCklMjAlMjAlMjMlMjBjaG9pY2UwJTIwaXMlMjBjb3JyZWN0JTIwKGFjY29yZGluZyUyMHRvJTIwV2lraXBlZGlhJTIwJTNCKSklMkMlMjBiYXRjaCUyMHNpemUlMjAxJTBBJTBBZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIoJTVCcHJvbXB0JTJDJTIwcHJvbXB0JTVEJTJDJTIwJTVCY2hvaWNlMCUyQyUyMGNob2ljZTElNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqJTdCayUzQSUyMHYudW5zcXVlZXplKDApJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGVuY29kaW5nLml0ZW1zKCklN0QlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTIwJTIwJTIzJTIwYmF0Y2glMjBzaXplJTIwaXMlMjAxJTBBJTBBJTIzJTIwdGhlJTIwbGluZWFyJTIwY2xhc3NpZmllciUyMHN0aWxsJTIwbmVlZHMlMjB0byUyMGJlJTIwdHJhaW5lZCUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForMultipleChoice
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;In Italy, pizza served in formal settings, such as at a restaurant, is presented unsliced.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice0 = <span class="hljs-string">&quot;It is eaten with a fork and a knife.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice1 = <span class="hljs-string">&quot;It is eaten while held in the hand.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># choice0 is correct (according to Wikipedia ;)), batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer([prompt, prompt], [choice0, choice1], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**{k: v.unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items()}, labels=labels)  <span class="hljs-comment"># batch size is 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the linear classifier still needs to be trained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){r=o("p"),r.textContent=T,p=a(),g(m.$$.fragment)},l(l){r=s(l,"P",{"data-svelte-h":!0}),u(r)!=="svelte-11lpom8"&&(r.textContent=T),p=i(l),_(m.$$.fragment,l)},m(l,k){c(l,r,k),c(l,p,k),M(m,l,k),w=!0},p:V,i(l){w||(b(m.$$.fragment,l),w=!0)},o(l){y(m.$$.fragment,l),w=!1},d(l){l&&(n(r),n(p)),v(m,l)}}}function ta($){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=T},l(p){r=s(p,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(p,m){c(p,r,m)},p:V,d(p){p&&n(r)}}}function na($){let r,T="Example:",p,m,w;return m=new Mn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZU1Gb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBbW9kZWwlMjAlM0QlMjBFcm5pZU1Gb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmdGYWNlJTIwaXMlMjBhJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBQYXJpcyUyMGFuZCUyME5ldyUyMFlvcmslMjIlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSklMEElMEElMjMlMjBOb3RlJTIwdGhhdCUyMHRva2VucyUyMGFyZSUyMGNsYXNzaWZpZWQlMjByYXRoZXIlMjB0aGVuJTIwaW5wdXQlMjB3b3JkcyUyMHdoaWNoJTIwbWVhbnMlMjB0aGF0JTBBJTIzJTIwdGhlcmUlMjBtaWdodCUyMGJlJTIwbW9yZSUyMHByZWRpY3RlZCUyMHRva2VuJTIwY2xhc3NlcyUyMHRoYW4lMjB3b3Jkcy4lMEElMjMlMjBNdWx0aXBsZSUyMHRva2VuJTIwY2xhc3NlcyUyMG1pZ2h0JTIwYWNjb3VudCUyMGZvciUyMHRoZSUyMHNhbWUlMjB3b3JkJTBBcHJlZGljdGVkX3Rva2Vuc19jbGFzc2VzJTIwJTNEJTIwJTVCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCdC5pdGVtKCklNUQlMjBmb3IlMjB0JTIwaW4lMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTVCMCU1RCU1RCUwQSUwQWxhYmVscyUyMCUzRCUyMHByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForTokenClassification.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`}}),{c(){r=o("p"),r.textContent=T,p=a(),g(m.$$.fragment)},l(l){r=s(l,"P",{"data-svelte-h":!0}),u(r)!=="svelte-11lpom8"&&(r.textContent=T),p=i(l),_(m.$$.fragment,l)},m(l,k){c(l,r,k),c(l,p,k),M(m,l,k),w=!0},p:V,i(l){w||(b(m.$$.fragment,l),w=!0)},o(l){y(m.$$.fragment,l),w=!1},d(l){l&&(n(r),n(p)),v(m,l)}}}function oa($){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=T},l(p){r=s(p,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(p,m){c(p,r,m)},p:V,d(p){p&&n(r)}}}function sa($){let r,T="Example:",p,m,w;return m=new Mn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZU1Gb3JRdWVzdGlvbkFuc3dlcmluZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyc3VzbmF0byUyRmVybmllLW0tYmFzZV9weXRvcmNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwRXJuaWVNRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiklMEElMEFxdWVzdGlvbiUyQyUyMHRleHQlMjAlM0QlMjAlMjJXaG8lMjB3YXMlMjBKaW0lMjBIZW5zb24lM0YlMjIlMkMlMjAlMjJKaW0lMjBIZW5zb24lMjB3YXMlMjBhJTIwbmljZSUyMHB1cHBldCUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihxdWVzdGlvbiUyQyUyMHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMuYXJnbWF4KCklMEFhbnN3ZXJfZW5kX2luZGV4JTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRzLmFyZ21heCgpJTBBJTBBcHJlZGljdF9hbnN3ZXJfdG9rZW5zJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcyU1QjAlMkMlMjBhbnN3ZXJfc3RhcnRfaW5kZXglMjAlM0ElMjBhbnN3ZXJfZW5kX2luZGV4JTIwJTJCJTIwMSU1RCUwQSUwQSUyMyUyMHRhcmdldCUyMGlzJTIwJTIybmljZSUyMHB1cHBldCUyMiUwQXRhcmdldF9zdGFydF9pbmRleCUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxNCU1RCklMEF0YXJnZXRfZW5kX2luZGV4JTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjE1JTVEKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHN0YXJ0X3Bvc2l0aW9ucyUzRHRhcmdldF9zdGFydF9pbmRleCUyQyUyMGVuZF9wb3NpdGlvbnMlM0R0YXJnZXRfZW5kX2luZGV4KSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = torch.tensor([<span class="hljs-number">14</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = torch.tensor([<span class="hljs-number">15</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`}}),{c(){r=o("p"),r.textContent=T,p=a(),g(m.$$.fragment)},l(l){r=s(l,"P",{"data-svelte-h":!0}),u(r)!=="svelte-11lpom8"&&(r.textContent=T),p=i(l),_(m.$$.fragment,l)},m(l,k){c(l,r,k),c(l,p,k),M(m,l,k),w=!0},p:V,i(l){w||(b(m.$$.fragment,l),w=!0)},o(l){y(m.$$.fragment,l),w=!1},d(l){l&&(n(r),n(p)),v(m,l)}}}function ra($){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=o("p"),r.innerHTML=T},l(p){r=s(p,"P",{"data-svelte-h":!0}),u(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(p,m){c(p,r,m)},p:V,d(p){p&&n(r)}}}function aa($){let r,T,p,m,w,l,k,Ze,vo,wt,Fs="ErnieM",qn,D,le,bn,qe,To,kt,Us="Overview",Hn,He,Is=`The ErnieM model was proposed in <a href="https://arxiv.org/abs/2012.15674" rel="nofollow">ERNIE-M: Enhanced Multilingual Representation by Aligning
Cross-lingual Semantics with Monolingual Corpora</a>  by Xuan Ouyang, Shuohuan Wang, Chao Pang, Yu Sun,
Hao Tian, Hua Wu, Haifeng Wang.`,Gn,Ge,Ws="The abstract from the paper is the following:",Vn,Ve,Ns="<em>Recent studies have demonstrated that pre-trained cross-lingual models achieve impressive performance in downstream cross-lingual tasks. This improvement benefits from learning a large amount of monolingual and parallel corpora. Although it is generally acknowledged that parallel corpora are critical for improving the model performance, existing methods are often constrained by the size of parallel corpora, especially for lowresource languages. In this paper, we propose ERNIE-M, a new training method that encourages the model to align the representation of multiple languages with monolingual corpora, to overcome the constraint that the parallel corpus size places on the model performance. Our key insight is to integrate back-translation into the pre-training process. We generate pseudo-parallel sentence pairs on a monolingual corpus to enable the learning of semantic alignments between different languages, thereby enhancing the semantic modeling of cross-lingual models. Experimental results show that ERNIE-M outperforms existing cross-lingual models and delivers new state-of-the-art results in various cross-lingual downstream tasks.</em>",Bn,Be,Zs="Tips:",Sn,Se,qs="<li>Ernie-M is a BERT-like model so it is a stacked Transformer Encoder.</li> <li>Instead of using MaskedLM for pretraining (like BERT) the authors used two novel techniques: <code>Cross-attention Masked Language Modeling</code> and <code>Back-translation Masked Language Modeling</code>. For now these two LMHead objectives are not implemented here.</li> <li>It is a multilingual language model.</li> <li>Next Sentence Prediction was not used in pretraining process.</li>",Ln,Le,Hs='This model was contributed by <a href="https://huggingface.co/susnato" rel="nofollow">Susnato Dhar</a>. The original code can be found <a href="https://github.com/PaddlePaddle/PaddleNLP/tree/develop/paddlenlp/transformers/ernie_m" rel="nofollow">here</a>.',Rn,K,de,yn,Re,wo,$t,Gs="Documentation resources",Xn,Xe,Vs='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/token_classification">Token classification task guide</a></li> <li><a href="../tasks/question_answering">Question answering task guide</a></li> <li><a href="../tasks/multiple_choice">Multiple choice task guide</a></li>',Pn,ee,ce,vn,Pe,ko,Et,Bs="ErnieMConfig",An,W,Ae,$o,Ct,Ss=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a>. It is used to instantiate a
Ernie-M model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <code>Ernie-M</code> <a href="https://huggingface.co/susnato/ernie-m-base_pytorch" rel="nofollow">susnato/ernie-m-base_pytorch</a> architecture.`,Eo,xt,Ls=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Co,jt,Rs=`A normal_initializer initializes weight matrices as normal distributions. See
<code>ErnieMPretrainedModel._init_weights()</code> for how weights are initialized in <code>ErnieMModel</code>.`,Qn,te,pe,Tn,Qe,xo,Jt,Xs="ErnieMTokenizer",Yn,C,Ye,jo,zt,Ps="Constructs a Ernie-M tokenizer. It uses the <code>sentencepiece</code> tools to cut the words to sub-words.",Jo,S,Oe,zo,Ft,As=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. An ErnieM sequence has the following format:`,Fo,Ut,Qs="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences: <code>[CLS] A [SEP] [SEP] B [SEP]</code></li>",Uo,me,De,Io,It,Ys=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>encode</code> method.`,Wo,he,Ke,No,Wt,Os=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a> Should be overridden in a subclass if the model has a special way of
building: those.`,Zo,Nt,et,On,ne,ue,wn,tt,qo,Zt,Ds="ErnieMModel",Dn,x,nt,Ho,qt,Ks="The bare ErnieM Model transformer outputting raw hidden-states without any specific head on top.",Go,Ht,er=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Vo,Gt,tr=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Bo,N,ot,So,Vt,nr='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a> forward method, overrides the <code>__call__</code> special method.',Lo,fe,Ro,ge,Kn,oe,_e,kn,st,Xo,Bt,or="ErnieMForSequenceClassification",eo,j,rt,Po,St,sr=`ErnieM Model transformer with a sequence classification/regression head on top (a linear layer on top of
the pooled output) e.g. for GLUE tasks.`,Ao,Lt,rr=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Qo,Rt,ar=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Yo,I,at,Oo,Xt,ir='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMForSequenceClassification">ErnieMForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Do,Me,Ko,be,es,ye,to,se,ve,$n,it,ts,Pt,lr="ErnieMForMultipleChoice",no,J,lt,ns,At,dr=`ErnieM Model with a multiple choice classification head on top (a linear layer on top of
the pooled output and a softmax) e.g. for RocStories/SWAG tasks.`,os,Qt,cr=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ss,Yt,pr=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,rs,Z,dt,as,Ot,mr='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMForMultipleChoice">ErnieMForMultipleChoice</a> forward method, overrides the <code>__call__</code> special method.',is,Te,ls,we,oo,re,ke,En,ct,ds,Dt,hr="ErnieMForTokenClassification",so,z,pt,cs,Kt,ur=`ErnieM Model with a token classification head on top (a linear layer on top of
the hidden-states output) e.g. for Named-Entity-Recognition (NER) tasks.`,ps,en,fr=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ms,tn,gr=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,hs,q,mt,us,nn,_r='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMForTokenClassification">ErnieMForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',fs,$e,gs,Ee,ro,ae,Ce,Cn,ht,_s,on,Mr="ErnieMForQuestionAnswering",ao,F,ut,Ms,sn,br=`ErnieM Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,bs,rn,yr=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ys,an,vr=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,vs,H,ft,Ts,ln,Tr='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMForQuestionAnswering">ErnieMForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',ws,xe,ks,je,io,ie,Je,xn,gt,$s,dn,wr="ErnieMForInformationExtraction",lo,U,_t,Es,cn,kr=`ErnieMForInformationExtraction is a Ernie-M Model with two linear layer on top of the hidden-states output to
compute <code>start_prob</code> and <code>end_prob</code>, designed for Universal Information Extraction.`,Cs,pn,$r=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,xs,mn,Er=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,js,L,Mt,Js,hn,Cr='The <a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMForInformationExtraction">ErnieMForInformationExtraction</a> forward method, overrides the <code>__call__</code> special method.',zs,ze,co,jn,po;return Ze=new B({}),qe=new B({}),Re=new B({}),Pe=new B({}),Ae=new E({props:{name:"class transformers.ErnieMConfig",anchor:"transformers.ErnieMConfig",parameters:[{name:"vocab_size",val:": int = 250002"},{name:"hidden_size",val:": int = 768"},{name:"num_hidden_layers",val:": int = 12"},{name:"num_attention_heads",val:": int = 12"},{name:"intermediate_size",val:": int = 3072"},{name:"hidden_act",val:": str = 'gelu'"},{name:"hidden_dropout_prob",val:": float = 0.1"},{name:"attention_probs_dropout_prob",val:": float = 0.1"},{name:"max_position_embeddings",val:": int = 514"},{name:"initializer_range",val:": float = 0.02"},{name:"pad_token_id",val:": int = 1"},{name:"layer_norm_eps",val:": float = 1e-05"},{name:"classifier_dropout",val:" = None"},{name:"is_decoder",val:" = False"},{name:"act_dropout",val:" = 0.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ErnieMConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 250002) &#x2014;
Vocabulary size of <code>inputs_ids</code> in <a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a>. Also is the vocab size of token embedding matrix.
Defines the number of different tokens that can be represented by the <code>inputs_ids</code> passed when calling
<a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a>.`,name:"vocab_size"},{anchor:"transformers.ErnieMConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the embedding layer, encoder layers and pooler layer.`,name:"hidden_size"},{anchor:"transformers.ErnieMConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.ErnieMConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.ErnieMConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the feed-forward (ff) layer in the encoder. Input tensors to feed-forward layers are
firstly projected from hidden_size to intermediate_size, and then projected back to hidden_size. Typically
intermediate_size is larger than hidden_size.`,name:"intermediate_size"},{anchor:"transformers.ErnieMConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function in the feed-forward layer. <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code> and any other torch
supported activation functions are supported.`,name:"hidden_act"},{anchor:"transformers.ErnieMConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings and encoder.`,name:"hidden_dropout_prob"},{anchor:"transformers.ErnieMConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability used in <code>MultiHeadAttention</code> in all encoder layers to drop some attention target.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.ErnieMConfig.act_dropout",description:`<strong>act_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
This dropout probability is used in <code>ErnieMEncoderLayer</code> after activation.`,name:"act_dropout"},{anchor:"transformers.ErnieMConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum value of the dimensionality of position encoding, which dictates the maximum supported length
of an input sequence.`,name:"max_position_embeddings"},{anchor:"transformers.ErnieMConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.ErnieMConfig.classifier_dropout",description:`<strong>classifier_dropout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The dropout ratio for the classification head.`,name:"classifier_dropout"},{anchor:"transformers.ErnieMConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the normal initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.ErnieMConfig.pad_token_id(int,",description:`<strong>pad_token_id(<code>int</code>,</strong> <em>optional</em>, defaults to 1) &#x2014;
The index of padding token in the token vocabulary.`,name:"pad_token_id(int,"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/configuration_ernie_m.py#L31"}}),Qe=new B({}),Ye=new E({props:{name:"class transformers.ErnieMTokenizer",anchor:"transformers.ErnieMTokenizer",parameters:[{name:"sentencepiece_model_ckpt",val:""},{name:"vocab_file",val:" = None"},{name:"do_lower_case",val:" = False"},{name:"encoding",val:" = 'utf8'"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"sp_model_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ErnieMTokenizer.sentencepiece_model_file",description:`<strong>sentencepiece_model_file</strong> (<code>str</code>) &#x2014;
The file path of sentencepiece model.`,name:"sentencepiece_model_file"},{anchor:"transformers.ErnieMTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The file path of the vocabulary.`,name:"vocab_file"},{anchor:"transformers.ErnieMTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>str</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.ErnieMTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
A special token representing the <code>unknown (out-of-vocabulary)</code> token. An unknown token is set to be
<code>unk_token</code> inorder to be converted to an ID.`,name:"unk_token"},{anchor:"transformers.ErnieMTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
A special token separating two different sentences in the same input.`,name:"sep_token"},{anchor:"transformers.ErnieMTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
A special token used to make arrays of tokens the same size for batching purposes.`,name:"pad_token"},{anchor:"transformers.ErnieMTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
A special token used for sequence classification. It is the last token of the sequence when built with
special tokens.`,name:"cls_token"},{anchor:"transformers.ErnieMTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
A special token representing a masked token. This is the token used in the masked language modeling task
which the model tries to predict the original unmasked ones.`,name:"mask_token"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/tokenization_ernie_m.py#L62"}}),Oe=new E({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.ErnieMTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],parametersDescription:[{anchor:"transformers.ErnieMTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.ErnieMTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/tokenization_ernie_m.py#L262",returnDescription:`
<p>List of input_id with the appropriate special tokens.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),De=new E({props:{name:"get_special_tokens_mask",anchor:"transformers.ErnieMTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"},{name:"already_has_special_tokens",val:" = False"}],parametersDescription:[{anchor:"transformers.ErnieMTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.ErnieMTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.ErnieMTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/tokenization_ernie_m.py#L305",returnDescription:`
<p>The list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),Ke=new E({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.ErnieMTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.ErnieMTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
The first tokenized sequence.`,name:"token_ids_0"},{anchor:"transformers.ErnieMTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
The second tokenized sequence.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/tokenization_ernie_m.py#L334",returnDescription:`
<p>The token type ids.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),et=new E({props:{name:"save_vocabulary",anchor:"transformers.ErnieMTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/tokenization_ernie_m.py#L403"}}),tt=new B({}),nt=new E({props:{name:"class transformers.ErnieMModel",anchor:"transformers.ErnieMModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.ErnieMModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/modeling_ernie_m.py#L499"}}),ot=new E({props:{name:"forward",anchor:"transformers.ErnieMModel.forward",parameters:[{name:"input_ids",val:": typing.Union[<built-in method tensor of type object at 0x7f473a4a6500>, NoneType] = None"},{name:"position_ids",val:": typing.Union[<built-in method tensor of type object at 0x7f473a4a6500>, NoneType] = None"},{name:"attention_mask",val:": typing.Union[<built-in method tensor of type object at 0x7f473a4a6500>, NoneType] = None"},{name:"head_mask",val:": typing.Union[<built-in method tensor of type object at 0x7f473a4a6500>, NoneType] = None"},{name:"inputs_embeds",val:": typing.Union[<built-in method tensor of type object at 0x7f473a4a6500>, NoneType] = None"},{name:"past_key_values",val:": typing.Union[typing.Tuple[typing.Tuple[<built-in method tensor of type object at 0x7f473a4a6500>]], NoneType] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ErnieMModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/modeling_ernie_m.py#L522",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fe=new gn({props:{$$slots:{default:[Ar]},$$scope:{ctx:$}}}),ge=new _n({props:{anchor:"transformers.ErnieMModel.forward.example",$$slots:{default:[Qr]},$$scope:{ctx:$}}}),st=new B({}),rt=new E({props:{name:"class transformers.ErnieMForSequenceClassification",anchor:"transformers.ErnieMForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/modeling_ernie_m.py#L613"}}),at=new E({props:{name:"forward",anchor:"transformers.ErnieMForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.ErnieMForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/modeling_ernie_m.py#L630",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Me=new gn({props:{$$slots:{default:[Yr]},$$scope:{ctx:$}}}),be=new _n({props:{anchor:"transformers.ErnieMForSequenceClassification.forward.example",$$slots:{default:[Or]},$$scope:{ctx:$}}}),ye=new _n({props:{anchor:"transformers.ErnieMForSequenceClassification.forward.example-2",$$slots:{default:[Dr]},$$scope:{ctx:$}}}),it=new B({}),lt=new E({props:{name:"class transformers.ErnieMForMultipleChoice",anchor:"transformers.ErnieMForMultipleChoice",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForMultipleChoice.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/modeling_ernie_m.py#L715"}}),dt=new E({props:{name:"forward",anchor:"transformers.ErnieMForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.ErnieMForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForMultipleChoice.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForMultipleChoice.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForMultipleChoice.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForMultipleChoice.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForMultipleChoice.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForMultipleChoice.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForMultipleChoice.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the multiple choice classification loss. Indices should be in <code>[0, ..., num_choices-1]</code> where <code>num_choices</code> is the size of the second dimension of the input tensors. (See
<code>input_ids</code> above)`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/modeling_ernie_m.py#L730",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <em>(1,)</em>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) — <em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Te=new gn({props:{$$slots:{default:[Kr]},$$scope:{ctx:$}}}),we=new _n({props:{anchor:"transformers.ErnieMForMultipleChoice.forward.example",$$slots:{default:[ea]},$$scope:{ctx:$}}}),ct=new B({}),pt=new E({props:{name:"class transformers.ErnieMForTokenClassification",anchor:"transformers.ErnieMForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/modeling_ernie_m.py#L805"}}),mt=new E({props:{name:"forward",anchor:"transformers.ErnieMForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.ErnieMForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/modeling_ernie_m.py#L821",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$e=new gn({props:{$$slots:{default:[ta]},$$scope:{ctx:$}}}),Ee=new _n({props:{anchor:"transformers.ErnieMForTokenClassification.forward.example",$$slots:{default:[na]},$$scope:{ctx:$}}}),ht=new B({}),ut=new E({props:{name:"class transformers.ErnieMForQuestionAnswering",anchor:"transformers.ErnieMForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/modeling_ernie_m.py#L886"}}),ft=new E({props:{name:"forward",anchor:"transformers.ErnieMForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"end_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.ErnieMForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/modeling_ernie_m.py#L898",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),xe=new gn({props:{$$slots:{default:[oa]},$$scope:{ctx:$}}}),je=new _n({props:{anchor:"transformers.ErnieMForQuestionAnswering.forward.example",$$slots:{default:[sa]},$$scope:{ctx:$}}}),gt=new B({}),_t=new E({props:{name:"class transformers.ErnieMForInformationExtraction",anchor:"transformers.ErnieMForInformationExtraction",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForInformationExtraction.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/modeling_ernie_m.py#L984"}}),Mt=new E({props:{name:"forward",anchor:"transformers.ErnieMForInformationExtraction.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"end_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.ErnieMForInformationExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForInformationExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForInformationExtraction.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForInformationExtraction.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForInformationExtraction.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForInformationExtraction.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForInformationExtraction.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForInformationExtraction.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForInformationExtraction.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for position (index) for computing the start_positions loss. Position outside of the sequence are
not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.ErnieMForInformationExtraction.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) for computing the end_positions loss. Position outside of the sequence are not
taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/ernie_m/modeling_ernie_m.py#L993"}}),ze=new gn({props:{$$slots:{default:[ra]},$$scope:{ctx:$}}}),{c(){r=o("meta"),T=a(),p=o("p"),m=a(),w=o("h1"),l=o("a"),k=o("span"),g(Ze.$$.fragment),vo=a(),wt=o("span"),wt.textContent=Fs,qn=a(),D=o("h2"),le=o("a"),bn=o("span"),g(qe.$$.fragment),To=a(),kt=o("span"),kt.textContent=Us,Hn=a(),He=o("p"),He.innerHTML=Is,Gn=a(),Ge=o("p"),Ge.textContent=Ws,Vn=a(),Ve=o("p"),Ve.innerHTML=Ns,Bn=a(),Be=o("p"),Be.textContent=Zs,Sn=a(),Se=o("ol"),Se.innerHTML=qs,Ln=a(),Le=o("p"),Le.innerHTML=Hs,Rn=a(),K=o("h2"),de=o("a"),yn=o("span"),g(Re.$$.fragment),wo=a(),$t=o("span"),$t.textContent=Gs,Xn=a(),Xe=o("ul"),Xe.innerHTML=Vs,Pn=a(),ee=o("h2"),ce=o("a"),vn=o("span"),g(Pe.$$.fragment),ko=a(),Et=o("span"),Et.textContent=Bs,An=a(),W=o("div"),g(Ae.$$.fragment),$o=a(),Ct=o("p"),Ct.innerHTML=Ss,Eo=a(),xt=o("p"),xt.innerHTML=Ls,Co=a(),jt=o("p"),jt.innerHTML=Rs,Qn=a(),te=o("h2"),pe=o("a"),Tn=o("span"),g(Qe.$$.fragment),xo=a(),Jt=o("span"),Jt.textContent=Xs,Yn=a(),C=o("div"),g(Ye.$$.fragment),jo=a(),zt=o("p"),zt.innerHTML=Ps,Jo=a(),S=o("div"),g(Oe.$$.fragment),zo=a(),Ft=o("p"),Ft.textContent=As,Fo=a(),Ut=o("ul"),Ut.innerHTML=Qs,Uo=a(),me=o("div"),g(De.$$.fragment),Io=a(),It=o("p"),It.innerHTML=Ys,Wo=a(),he=o("div"),g(Ke.$$.fragment),No=a(),Wt=o("p"),Wt.innerHTML=Os,Zo=a(),Nt=o("div"),g(et.$$.fragment),On=a(),ne=o("h2"),ue=o("a"),wn=o("span"),g(tt.$$.fragment),qo=a(),Zt=o("span"),Zt.textContent=Ds,Dn=a(),x=o("div"),g(nt.$$.fragment),Ho=a(),qt=o("p"),qt.textContent=Ks,Go=a(),Ht=o("p"),Ht.innerHTML=er,Vo=a(),Gt=o("p"),Gt.innerHTML=tr,Bo=a(),N=o("div"),g(ot.$$.fragment),So=a(),Vt=o("p"),Vt.innerHTML=nr,Lo=a(),g(fe.$$.fragment),Ro=a(),g(ge.$$.fragment),Kn=a(),oe=o("h2"),_e=o("a"),kn=o("span"),g(st.$$.fragment),Xo=a(),Bt=o("span"),Bt.textContent=or,eo=a(),j=o("div"),g(rt.$$.fragment),Po=a(),St=o("p"),St.textContent=sr,Ao=a(),Lt=o("p"),Lt.innerHTML=rr,Qo=a(),Rt=o("p"),Rt.innerHTML=ar,Yo=a(),I=o("div"),g(at.$$.fragment),Oo=a(),Xt=o("p"),Xt.innerHTML=ir,Do=a(),g(Me.$$.fragment),Ko=a(),g(be.$$.fragment),es=a(),g(ye.$$.fragment),to=a(),se=o("h2"),ve=o("a"),$n=o("span"),g(it.$$.fragment),ts=a(),Pt=o("span"),Pt.textContent=lr,no=a(),J=o("div"),g(lt.$$.fragment),ns=a(),At=o("p"),At.textContent=dr,os=a(),Qt=o("p"),Qt.innerHTML=cr,ss=a(),Yt=o("p"),Yt.innerHTML=pr,rs=a(),Z=o("div"),g(dt.$$.fragment),as=a(),Ot=o("p"),Ot.innerHTML=mr,is=a(),g(Te.$$.fragment),ls=a(),g(we.$$.fragment),oo=a(),re=o("h2"),ke=o("a"),En=o("span"),g(ct.$$.fragment),ds=a(),Dt=o("span"),Dt.textContent=hr,so=a(),z=o("div"),g(pt.$$.fragment),cs=a(),Kt=o("p"),Kt.textContent=ur,ps=a(),en=o("p"),en.innerHTML=fr,ms=a(),tn=o("p"),tn.innerHTML=gr,hs=a(),q=o("div"),g(mt.$$.fragment),us=a(),nn=o("p"),nn.innerHTML=_r,fs=a(),g($e.$$.fragment),gs=a(),g(Ee.$$.fragment),ro=a(),ae=o("h2"),Ce=o("a"),Cn=o("span"),g(ht.$$.fragment),_s=a(),on=o("span"),on.textContent=Mr,ao=a(),F=o("div"),g(ut.$$.fragment),Ms=a(),sn=o("p"),sn.innerHTML=br,bs=a(),rn=o("p"),rn.innerHTML=yr,ys=a(),an=o("p"),an.innerHTML=vr,vs=a(),H=o("div"),g(ft.$$.fragment),Ts=a(),ln=o("p"),ln.innerHTML=Tr,ws=a(),g(xe.$$.fragment),ks=a(),g(je.$$.fragment),io=a(),ie=o("h2"),Je=o("a"),xn=o("span"),g(gt.$$.fragment),$s=a(),dn=o("span"),dn.textContent=wr,lo=a(),U=o("div"),g(_t.$$.fragment),Es=a(),cn=o("p"),cn.innerHTML=kr,Cs=a(),pn=o("p"),pn.innerHTML=$r,xs=a(),mn=o("p"),mn.innerHTML=Er,js=a(),L=o("div"),g(Mt.$$.fragment),Js=a(),hn=o("p"),hn.innerHTML=Cr,zs=a(),g(ze.$$.fragment),co=a(),jn=o("p"),this.h()},l(e){const d=Pr("svelte-1phssyn",document.head);r=s(d,"META",{name:!0,content:!0}),d.forEach(n),T=i(e),p=s(e,"P",{}),f(p).forEach(n),m=i(e),w=s(e,"H1",{class:!0});var bt=f(w);l=s(bt,"A",{id:!0,class:!0,href:!0});var Jn=f(l);k=s(Jn,"SPAN",{});var zn=f(k);_(Ze.$$.fragment,zn),zn.forEach(n),Jn.forEach(n),vo=i(bt),wt=s(bt,"SPAN",{"data-svelte-h":!0}),u(wt)!=="svelte-18hf435"&&(wt.textContent=Fs),bt.forEach(n),qn=i(e),D=s(e,"H2",{class:!0});var yt=f(D);le=s(yt,"A",{id:!0,class:!0,href:!0});var Fn=f(le);bn=s(Fn,"SPAN",{});var Un=f(bn);_(qe.$$.fragment,Un),Un.forEach(n),Fn.forEach(n),To=i(yt),kt=s(yt,"SPAN",{"data-svelte-h":!0}),u(kt)!=="svelte-1jsw1pg"&&(kt.textContent=Us),yt.forEach(n),Hn=i(e),He=s(e,"P",{"data-svelte-h":!0}),u(He)!=="svelte-1leh8xw"&&(He.innerHTML=Is),Gn=i(e),Ge=s(e,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-vfdo9a"&&(Ge.textContent=Ws),Vn=i(e),Ve=s(e,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-hvyogk"&&(Ve.innerHTML=Ns),Bn=i(e),Be=s(e,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-axv494"&&(Be.textContent=Zs),Sn=i(e),Se=s(e,"OL",{"data-svelte-h":!0}),u(Se)!=="svelte-539a85"&&(Se.innerHTML=qs),Ln=i(e),Le=s(e,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-ht78wx"&&(Le.innerHTML=Hs),Rn=i(e),K=s(e,"H2",{class:!0});var vt=f(K);de=s(vt,"A",{id:!0,class:!0,href:!0});var In=f(de);yn=s(In,"SPAN",{});var Wn=f(yn);_(Re.$$.fragment,Wn),Wn.forEach(n),In.forEach(n),wo=i(vt),$t=s(vt,"SPAN",{"data-svelte-h":!0}),u($t)!=="svelte-n3f0j0"&&($t.textContent=Gs),vt.forEach(n),Xn=i(e),Xe=s(e,"UL",{"data-svelte-h":!0}),u(Xe)!=="svelte-1521k64"&&(Xe.innerHTML=Vs),Pn=i(e),ee=s(e,"H2",{class:!0});var Tt=f(ee);ce=s(Tt,"A",{id:!0,class:!0,href:!0});var Nn=f(ce);vn=s(Nn,"SPAN",{});var Zn=f(vn);_(Pe.$$.fragment,Zn),Zn.forEach(n),Nn.forEach(n),ko=i(Tt),Et=s(Tt,"SPAN",{"data-svelte-h":!0}),u(Et)!=="svelte-1sgkz27"&&(Et.textContent=Bs),Tt.forEach(n),An=i(e),W=s(e,"DIV",{class:!0});var Fe=f(W);_(Ae.$$.fragment,Fe),$o=i(Fe),Ct=s(Fe,"P",{"data-svelte-h":!0}),u(Ct)!=="svelte-8eba87"&&(Ct.innerHTML=Ss),Eo=i(Fe),xt=s(Fe,"P",{"data-svelte-h":!0}),u(xt)!=="svelte-cfh5wl"&&(xt.innerHTML=Ls),Co=i(Fe),jt=s(Fe,"P",{"data-svelte-h":!0}),u(jt)!=="svelte-199crak"&&(jt.innerHTML=Rs),Fe.forEach(n),Qn=i(e),te=s(e,"H2",{class:!0});var mo=f(te);pe=s(mo,"A",{id:!0,class:!0,href:!0});var xr=f(pe);Tn=s(xr,"SPAN",{});var jr=f(Tn);_(Qe.$$.fragment,jr),jr.forEach(n),xr.forEach(n),xo=i(mo),Jt=s(mo,"SPAN",{"data-svelte-h":!0}),u(Jt)!=="svelte-gcvvyi"&&(Jt.textContent=Xs),mo.forEach(n),Yn=i(e),C=s(e,"DIV",{class:!0});var G=f(C);_(Ye.$$.fragment,G),jo=i(G),zt=s(G,"P",{"data-svelte-h":!0}),u(zt)!=="svelte-16hpk2a"&&(zt.innerHTML=Ps),Jo=i(G),S=s(G,"DIV",{class:!0});var un=f(S);_(Oe.$$.fragment,un),zo=i(un),Ft=s(un,"P",{"data-svelte-h":!0}),u(Ft)!=="svelte-ld95nz"&&(Ft.textContent=As),Fo=i(un),Ut=s(un,"UL",{"data-svelte-h":!0}),u(Ut)!=="svelte-fnydu1"&&(Ut.innerHTML=Qs),un.forEach(n),Uo=i(G),me=s(G,"DIV",{class:!0});var ho=f(me);_(De.$$.fragment,ho),Io=i(ho),It=s(ho,"P",{"data-svelte-h":!0}),u(It)!=="svelte-9bhc6n"&&(It.innerHTML=Ys),ho.forEach(n),Wo=i(G),he=s(G,"DIV",{class:!0});var uo=f(he);_(Ke.$$.fragment,uo),No=i(uo),Wt=s(uo,"P",{"data-svelte-h":!0}),u(Wt)!=="svelte-sahzwn"&&(Wt.innerHTML=Os),uo.forEach(n),Zo=i(G),Nt=s(G,"DIV",{class:!0});var Jr=f(Nt);_(et.$$.fragment,Jr),Jr.forEach(n),G.forEach(n),On=i(e),ne=s(e,"H2",{class:!0});var fo=f(ne);ue=s(fo,"A",{id:!0,class:!0,href:!0});var zr=f(ue);wn=s(zr,"SPAN",{});var Fr=f(wn);_(tt.$$.fragment,Fr),Fr.forEach(n),zr.forEach(n),qo=i(fo),Zt=s(fo,"SPAN",{"data-svelte-h":!0}),u(Zt)!=="svelte-i51vu2"&&(Zt.textContent=Ds),fo.forEach(n),Dn=i(e),x=s(e,"DIV",{class:!0});var R=f(x);_(nt.$$.fragment,R),Ho=i(R),qt=s(R,"P",{"data-svelte-h":!0}),u(qt)!=="svelte-x3zjez"&&(qt.textContent=Ks),Go=i(R),Ht=s(R,"P",{"data-svelte-h":!0}),u(Ht)!=="svelte-ev63c"&&(Ht.innerHTML=er),Vo=i(R),Gt=s(R,"P",{"data-svelte-h":!0}),u(Gt)!=="svelte-68lg8f"&&(Gt.innerHTML=tr),Bo=i(R),N=s(R,"DIV",{class:!0});var Ue=f(N);_(ot.$$.fragment,Ue),So=i(Ue),Vt=s(Ue,"P",{"data-svelte-h":!0}),u(Vt)!=="svelte-bq8keu"&&(Vt.innerHTML=nr),Lo=i(Ue),_(fe.$$.fragment,Ue),Ro=i(Ue),_(ge.$$.fragment,Ue),Ue.forEach(n),R.forEach(n),Kn=i(e),oe=s(e,"H2",{class:!0});var go=f(oe);_e=s(go,"A",{id:!0,class:!0,href:!0});var Ur=f(_e);kn=s(Ur,"SPAN",{});var Ir=f(kn);_(st.$$.fragment,Ir),Ir.forEach(n),Ur.forEach(n),Xo=i(go),Bt=s(go,"SPAN",{"data-svelte-h":!0}),u(Bt)!=="svelte-1mt4ijt"&&(Bt.textContent=or),go.forEach(n),eo=i(e),j=s(e,"DIV",{class:!0});var X=f(j);_(rt.$$.fragment,X),Po=i(X),St=s(X,"P",{"data-svelte-h":!0}),u(St)!=="svelte-jluzg6"&&(St.textContent=sr),Ao=i(X),Lt=s(X,"P",{"data-svelte-h":!0}),u(Lt)!=="svelte-ev63c"&&(Lt.innerHTML=rr),Qo=i(X),Rt=s(X,"P",{"data-svelte-h":!0}),u(Rt)!=="svelte-68lg8f"&&(Rt.innerHTML=ar),Yo=i(X),I=s(X,"DIV",{class:!0});var P=f(I);_(at.$$.fragment,P),Oo=i(P),Xt=s(P,"P",{"data-svelte-h":!0}),u(Xt)!=="svelte-idwr6e"&&(Xt.innerHTML=ir),Do=i(P),_(Me.$$.fragment,P),Ko=i(P),_(be.$$.fragment,P),es=i(P),_(ye.$$.fragment,P),P.forEach(n),X.forEach(n),to=i(e),se=s(e,"H2",{class:!0});var _o=f(se);ve=s(_o,"A",{id:!0,class:!0,href:!0});var Wr=f(ve);$n=s(Wr,"SPAN",{});var Nr=f($n);_(it.$$.fragment,Nr),Nr.forEach(n),Wr.forEach(n),ts=i(_o),Pt=s(_o,"SPAN",{"data-svelte-h":!0}),u(Pt)!=="svelte-1chsvy3"&&(Pt.textContent=lr),_o.forEach(n),no=i(e),J=s(e,"DIV",{class:!0});var A=f(J);_(lt.$$.fragment,A),ns=i(A),At=s(A,"P",{"data-svelte-h":!0}),u(At)!=="svelte-d30d0y"&&(At.textContent=dr),os=i(A),Qt=s(A,"P",{"data-svelte-h":!0}),u(Qt)!=="svelte-ev63c"&&(Qt.innerHTML=cr),ss=i(A),Yt=s(A,"P",{"data-svelte-h":!0}),u(Yt)!=="svelte-68lg8f"&&(Yt.innerHTML=pr),rs=i(A),Z=s(A,"DIV",{class:!0});var Ie=f(Z);_(dt.$$.fragment,Ie),as=i(Ie),Ot=s(Ie,"P",{"data-svelte-h":!0}),u(Ot)!=="svelte-1p16u9a"&&(Ot.innerHTML=mr),is=i(Ie),_(Te.$$.fragment,Ie),ls=i(Ie),_(we.$$.fragment,Ie),Ie.forEach(n),A.forEach(n),oo=i(e),re=s(e,"H2",{class:!0});var Mo=f(re);ke=s(Mo,"A",{id:!0,class:!0,href:!0});var Zr=f(ke);En=s(Zr,"SPAN",{});var qr=f(En);_(ct.$$.fragment,qr),qr.forEach(n),Zr.forEach(n),ds=i(Mo),Dt=s(Mo,"SPAN",{"data-svelte-h":!0}),u(Dt)!=="svelte-1yoh1y1"&&(Dt.textContent=hr),Mo.forEach(n),so=i(e),z=s(e,"DIV",{class:!0});var Q=f(z);_(pt.$$.fragment,Q),cs=i(Q),Kt=s(Q,"P",{"data-svelte-h":!0}),u(Kt)!=="svelte-pdhuup"&&(Kt.textContent=ur),ps=i(Q),en=s(Q,"P",{"data-svelte-h":!0}),u(en)!=="svelte-ev63c"&&(en.innerHTML=fr),ms=i(Q),tn=s(Q,"P",{"data-svelte-h":!0}),u(tn)!=="svelte-68lg8f"&&(tn.innerHTML=gr),hs=i(Q),q=s(Q,"DIV",{class:!0});var We=f(q);_(mt.$$.fragment,We),us=i(We),nn=s(We,"P",{"data-svelte-h":!0}),u(nn)!=="svelte-16ojg1i"&&(nn.innerHTML=_r),fs=i(We),_($e.$$.fragment,We),gs=i(We),_(Ee.$$.fragment,We),We.forEach(n),Q.forEach(n),ro=i(e),ae=s(e,"H2",{class:!0});var bo=f(ae);Ce=s(bo,"A",{id:!0,class:!0,href:!0});var Hr=f(Ce);Cn=s(Hr,"SPAN",{});var Gr=f(Cn);_(ht.$$.fragment,Gr),Gr.forEach(n),Hr.forEach(n),_s=i(bo),on=s(bo,"SPAN",{"data-svelte-h":!0}),u(on)!=="svelte-q2jfk"&&(on.textContent=Mr),bo.forEach(n),ao=i(e),F=s(e,"DIV",{class:!0});var Y=f(F);_(ut.$$.fragment,Y),Ms=i(Y),sn=s(Y,"P",{"data-svelte-h":!0}),u(sn)!=="svelte-cu4xzn"&&(sn.innerHTML=br),bs=i(Y),rn=s(Y,"P",{"data-svelte-h":!0}),u(rn)!=="svelte-ev63c"&&(rn.innerHTML=yr),ys=i(Y),an=s(Y,"P",{"data-svelte-h":!0}),u(an)!=="svelte-68lg8f"&&(an.innerHTML=vr),vs=i(Y),H=s(Y,"DIV",{class:!0});var Ne=f(H);_(ft.$$.fragment,Ne),Ts=i(Ne),ln=s(Ne,"P",{"data-svelte-h":!0}),u(ln)!=="svelte-grh40"&&(ln.innerHTML=Tr),ws=i(Ne),_(xe.$$.fragment,Ne),ks=i(Ne),_(je.$$.fragment,Ne),Ne.forEach(n),Y.forEach(n),io=i(e),ie=s(e,"H2",{class:!0});var yo=f(ie);Je=s(yo,"A",{id:!0,class:!0,href:!0});var Vr=f(Je);xn=s(Vr,"SPAN",{});var Br=f(xn);_(gt.$$.fragment,Br),Br.forEach(n),Vr.forEach(n),$s=i(yo),dn=s(yo,"SPAN",{"data-svelte-h":!0}),u(dn)!=="svelte-mp4euv"&&(dn.textContent=wr),yo.forEach(n),lo=i(e),U=s(e,"DIV",{class:!0});var O=f(U);_(_t.$$.fragment,O),Es=i(O),cn=s(O,"P",{"data-svelte-h":!0}),u(cn)!=="svelte-192fs6z"&&(cn.innerHTML=kr),Cs=i(O),pn=s(O,"P",{"data-svelte-h":!0}),u(pn)!=="svelte-ev63c"&&(pn.innerHTML=$r),xs=i(O),mn=s(O,"P",{"data-svelte-h":!0}),u(mn)!=="svelte-68lg8f"&&(mn.innerHTML=Er),js=i(O),L=s(O,"DIV",{class:!0});var fn=f(L);_(Mt.$$.fragment,fn),Js=i(fn),hn=s(fn,"P",{"data-svelte-h":!0}),u(hn)!=="svelte-1f8h2fi"&&(hn.innerHTML=Cr),zs=i(fn),_(ze.$$.fragment,fn),fn.forEach(n),O.forEach(n),co=i(e),jn=s(e,"P",{}),f(jn).forEach(n),this.h()},h(){h(r,"name","hf:doc:metadata"),h(r,"content",JSON.stringify(ia)),h(l,"id","erniem"),h(l,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(l,"href","#erniem"),h(w,"class","relative group"),h(le,"id","overview"),h(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(le,"href","#overview"),h(D,"class","relative group"),h(de,"id","documentation-resources"),h(de,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(de,"href","#documentation-resources"),h(K,"class","relative group"),h(ce,"id","transformers.ErnieMConfig"),h(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ce,"href","#transformers.ErnieMConfig"),h(ee,"class","relative group"),h(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(pe,"id","transformers.ErnieMTokenizer"),h(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(pe,"href","#transformers.ErnieMTokenizer"),h(te,"class","relative group"),h(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ue,"id","transformers.ErnieMModel"),h(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ue,"href","#transformers.ErnieMModel"),h(ne,"class","relative group"),h(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(_e,"id","transformers.ErnieMForSequenceClassification"),h(_e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(_e,"href","#transformers.ErnieMForSequenceClassification"),h(oe,"class","relative group"),h(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ve,"id","transformers.ErnieMForMultipleChoice"),h(ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ve,"href","#transformers.ErnieMForMultipleChoice"),h(se,"class","relative group"),h(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ke,"id","transformers.ErnieMForTokenClassification"),h(ke,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ke,"href","#transformers.ErnieMForTokenClassification"),h(re,"class","relative group"),h(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ce,"id","transformers.ErnieMForQuestionAnswering"),h(Ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Ce,"href","#transformers.ErnieMForQuestionAnswering"),h(ae,"class","relative group"),h(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Je,"id","transformers.ErnieMForInformationExtraction"),h(Je,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Je,"href","#transformers.ErnieMForInformationExtraction"),h(ie,"class","relative group"),h(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,d){t(document.head,r),c(e,T,d),c(e,p,d),c(e,m,d),c(e,w,d),t(w,l),t(l,k),M(Ze,k,null),t(w,vo),t(w,wt),c(e,qn,d),c(e,D,d),t(D,le),t(le,bn),M(qe,bn,null),t(D,To),t(D,kt),c(e,Hn,d),c(e,He,d),c(e,Gn,d),c(e,Ge,d),c(e,Vn,d),c(e,Ve,d),c(e,Bn,d),c(e,Be,d),c(e,Sn,d),c(e,Se,d),c(e,Ln,d),c(e,Le,d),c(e,Rn,d),c(e,K,d),t(K,de),t(de,yn),M(Re,yn,null),t(K,wo),t(K,$t),c(e,Xn,d),c(e,Xe,d),c(e,Pn,d),c(e,ee,d),t(ee,ce),t(ce,vn),M(Pe,vn,null),t(ee,ko),t(ee,Et),c(e,An,d),c(e,W,d),M(Ae,W,null),t(W,$o),t(W,Ct),t(W,Eo),t(W,xt),t(W,Co),t(W,jt),c(e,Qn,d),c(e,te,d),t(te,pe),t(pe,Tn),M(Qe,Tn,null),t(te,xo),t(te,Jt),c(e,Yn,d),c(e,C,d),M(Ye,C,null),t(C,jo),t(C,zt),t(C,Jo),t(C,S),M(Oe,S,null),t(S,zo),t(S,Ft),t(S,Fo),t(S,Ut),t(C,Uo),t(C,me),M(De,me,null),t(me,Io),t(me,It),t(C,Wo),t(C,he),M(Ke,he,null),t(he,No),t(he,Wt),t(C,Zo),t(C,Nt),M(et,Nt,null),c(e,On,d),c(e,ne,d),t(ne,ue),t(ue,wn),M(tt,wn,null),t(ne,qo),t(ne,Zt),c(e,Dn,d),c(e,x,d),M(nt,x,null),t(x,Ho),t(x,qt),t(x,Go),t(x,Ht),t(x,Vo),t(x,Gt),t(x,Bo),t(x,N),M(ot,N,null),t(N,So),t(N,Vt),t(N,Lo),M(fe,N,null),t(N,Ro),M(ge,N,null),c(e,Kn,d),c(e,oe,d),t(oe,_e),t(_e,kn),M(st,kn,null),t(oe,Xo),t(oe,Bt),c(e,eo,d),c(e,j,d),M(rt,j,null),t(j,Po),t(j,St),t(j,Ao),t(j,Lt),t(j,Qo),t(j,Rt),t(j,Yo),t(j,I),M(at,I,null),t(I,Oo),t(I,Xt),t(I,Do),M(Me,I,null),t(I,Ko),M(be,I,null),t(I,es),M(ye,I,null),c(e,to,d),c(e,se,d),t(se,ve),t(ve,$n),M(it,$n,null),t(se,ts),t(se,Pt),c(e,no,d),c(e,J,d),M(lt,J,null),t(J,ns),t(J,At),t(J,os),t(J,Qt),t(J,ss),t(J,Yt),t(J,rs),t(J,Z),M(dt,Z,null),t(Z,as),t(Z,Ot),t(Z,is),M(Te,Z,null),t(Z,ls),M(we,Z,null),c(e,oo,d),c(e,re,d),t(re,ke),t(ke,En),M(ct,En,null),t(re,ds),t(re,Dt),c(e,so,d),c(e,z,d),M(pt,z,null),t(z,cs),t(z,Kt),t(z,ps),t(z,en),t(z,ms),t(z,tn),t(z,hs),t(z,q),M(mt,q,null),t(q,us),t(q,nn),t(q,fs),M($e,q,null),t(q,gs),M(Ee,q,null),c(e,ro,d),c(e,ae,d),t(ae,Ce),t(Ce,Cn),M(ht,Cn,null),t(ae,_s),t(ae,on),c(e,ao,d),c(e,F,d),M(ut,F,null),t(F,Ms),t(F,sn),t(F,bs),t(F,rn),t(F,ys),t(F,an),t(F,vs),t(F,H),M(ft,H,null),t(H,Ts),t(H,ln),t(H,ws),M(xe,H,null),t(H,ks),M(je,H,null),c(e,io,d),c(e,ie,d),t(ie,Je),t(Je,xn),M(gt,xn,null),t(ie,$s),t(ie,dn),c(e,lo,d),c(e,U,d),M(_t,U,null),t(U,Es),t(U,cn),t(U,Cs),t(U,pn),t(U,xs),t(U,mn),t(U,js),t(U,L),M(Mt,L,null),t(L,Js),t(L,hn),t(L,zs),M(ze,L,null),c(e,co,d),c(e,jn,d),po=!0},p(e,[d]){const bt={};d&2&&(bt.$$scope={dirty:d,ctx:e}),fe.$set(bt);const Jn={};d&2&&(Jn.$$scope={dirty:d,ctx:e}),ge.$set(Jn);const zn={};d&2&&(zn.$$scope={dirty:d,ctx:e}),Me.$set(zn);const yt={};d&2&&(yt.$$scope={dirty:d,ctx:e}),be.$set(yt);const Fn={};d&2&&(Fn.$$scope={dirty:d,ctx:e}),ye.$set(Fn);const Un={};d&2&&(Un.$$scope={dirty:d,ctx:e}),Te.$set(Un);const vt={};d&2&&(vt.$$scope={dirty:d,ctx:e}),we.$set(vt);const In={};d&2&&(In.$$scope={dirty:d,ctx:e}),$e.$set(In);const Wn={};d&2&&(Wn.$$scope={dirty:d,ctx:e}),Ee.$set(Wn);const Tt={};d&2&&(Tt.$$scope={dirty:d,ctx:e}),xe.$set(Tt);const Nn={};d&2&&(Nn.$$scope={dirty:d,ctx:e}),je.$set(Nn);const Zn={};d&2&&(Zn.$$scope={dirty:d,ctx:e}),ze.$set(Zn)},i(e){po||(b(Ze.$$.fragment,e),b(qe.$$.fragment,e),b(Re.$$.fragment,e),b(Pe.$$.fragment,e),b(Ae.$$.fragment,e),b(Qe.$$.fragment,e),b(Ye.$$.fragment,e),b(Oe.$$.fragment,e),b(De.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),b(tt.$$.fragment,e),b(nt.$$.fragment,e),b(ot.$$.fragment,e),b(fe.$$.fragment,e),b(ge.$$.fragment,e),b(st.$$.fragment,e),b(rt.$$.fragment,e),b(at.$$.fragment,e),b(Me.$$.fragment,e),b(be.$$.fragment,e),b(ye.$$.fragment,e),b(it.$$.fragment,e),b(lt.$$.fragment,e),b(dt.$$.fragment,e),b(Te.$$.fragment,e),b(we.$$.fragment,e),b(ct.$$.fragment,e),b(pt.$$.fragment,e),b(mt.$$.fragment,e),b($e.$$.fragment,e),b(Ee.$$.fragment,e),b(ht.$$.fragment,e),b(ut.$$.fragment,e),b(ft.$$.fragment,e),b(xe.$$.fragment,e),b(je.$$.fragment,e),b(gt.$$.fragment,e),b(_t.$$.fragment,e),b(Mt.$$.fragment,e),b(ze.$$.fragment,e),po=!0)},o(e){y(Ze.$$.fragment,e),y(qe.$$.fragment,e),y(Re.$$.fragment,e),y(Pe.$$.fragment,e),y(Ae.$$.fragment,e),y(Qe.$$.fragment,e),y(Ye.$$.fragment,e),y(Oe.$$.fragment,e),y(De.$$.fragment,e),y(Ke.$$.fragment,e),y(et.$$.fragment,e),y(tt.$$.fragment,e),y(nt.$$.fragment,e),y(ot.$$.fragment,e),y(fe.$$.fragment,e),y(ge.$$.fragment,e),y(st.$$.fragment,e),y(rt.$$.fragment,e),y(at.$$.fragment,e),y(Me.$$.fragment,e),y(be.$$.fragment,e),y(ye.$$.fragment,e),y(it.$$.fragment,e),y(lt.$$.fragment,e),y(dt.$$.fragment,e),y(Te.$$.fragment,e),y(we.$$.fragment,e),y(ct.$$.fragment,e),y(pt.$$.fragment,e),y(mt.$$.fragment,e),y($e.$$.fragment,e),y(Ee.$$.fragment,e),y(ht.$$.fragment,e),y(ut.$$.fragment,e),y(ft.$$.fragment,e),y(xe.$$.fragment,e),y(je.$$.fragment,e),y(gt.$$.fragment,e),y(_t.$$.fragment,e),y(Mt.$$.fragment,e),y(ze.$$.fragment,e),po=!1},d(e){e&&(n(T),n(p),n(m),n(w),n(qn),n(D),n(Hn),n(He),n(Gn),n(Ge),n(Vn),n(Ve),n(Bn),n(Be),n(Sn),n(Se),n(Ln),n(Le),n(Rn),n(K),n(Xn),n(Xe),n(Pn),n(ee),n(An),n(W),n(Qn),n(te),n(Yn),n(C),n(On),n(ne),n(Dn),n(x),n(Kn),n(oe),n(eo),n(j),n(to),n(se),n(no),n(J),n(oo),n(re),n(so),n(z),n(ro),n(ae),n(ao),n(F),n(io),n(ie),n(lo),n(U),n(co),n(jn)),n(r),v(Ze),v(qe),v(Re),v(Pe),v(Ae),v(Qe),v(Ye),v(Oe),v(De),v(Ke),v(et),v(tt),v(nt),v(ot),v(fe),v(ge),v(st),v(rt),v(at),v(Me),v(be),v(ye),v(it),v(lt),v(dt),v(Te),v(we),v(ct),v(pt),v(mt),v($e),v(Ee),v(ht),v(ut),v(ft),v(xe),v(je),v(gt),v(_t),v(Mt),v(ze)}}}const ia={local:"erniem",sections:[{local:"overview",title:"Overview"},{local:"documentation-resources",title:"Documentation resources"},{local:"transformers.ErnieMConfig",title:"ErnieMConfig"},{local:"transformers.ErnieMTokenizer",title:"ErnieMTokenizer"},{local:"transformers.ErnieMModel",title:"ErnieMModel"},{local:"transformers.ErnieMForSequenceClassification",title:"ErnieMForSequenceClassification"},{local:"transformers.ErnieMForMultipleChoice",title:"ErnieMForMultipleChoice"},{local:"transformers.ErnieMForTokenClassification",title:"ErnieMForTokenClassification"},{local:"transformers.ErnieMForQuestionAnswering",title:"ErnieMForQuestionAnswering"},{local:"transformers.ErnieMForInformationExtraction",title:"ErnieMForInformationExtraction"}],title:"ErnieM"};function la($){return Lr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ga extends Rr{constructor(r){super(),Xr(this,r,la,aa,Sr,{})}}export{ga as component};
