import{s as it,n as ot,o as rt}from"../chunks/scheduler.9bc65507.js";import{S as ht,i as mt,g as p,s as l,r,A as ct,h as i,f as t,c as n,j as nt,u as h,x as o,k as pt,y as Mt,a,v as m,d as c,t as M,w as d}from"../chunks/index.707bf1b6.js";import{C as y}from"../chunks/CodeBlock.54a9f38d.js";import{H as u}from"../chunks/Heading.342b1fa6.js";function dt(be){let j,Js,Us,fs,g,ws,U,Is,T,Ce=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong> as well as message text.`,bs,J,xe=`Most commonly, these roles are “user” for messages sent by the user, and “assistant” for messages sent by the model.
Some models also support a “system” role. System messages are usually sent at the beginning of the conversation
and include directives about how the model should behave in the subsequent chat.`,Cs,f,Ne=`All language models, including models fine-tuned for chat, operate on linear sequences of tokens and do not intrinsically
have special handling for roles. This means that role information is usually injected by adding control tokens
between messages, to indicate both the message boundary and the relevant roles.`,xs,w,ke=`Unfortunately, there isn’t (yet!) a standard for which tokens to use, and so different models have been trained
with wildly different formatting and control tokens for chat. This can be a real problem for users - if you use the
wrong format, then the model will be confused by your input, and your performance will be a lot worse than it should be.
This is the problem that <strong>chat templates</strong> aim to resolve.`,Ns,I,ve=`Chat conversations are typically represented as a list of dictionaries, where each dictionary contains <code>role</code>
and <code>content</code> keys, and represents a single chat message. Chat templates are strings containing a Jinja template that
specifies how to format a conversation for a given model into a single tokenizable sequence. By storing this information
with the tokenizer, we can ensure that models get input data in the format they expect.`,ks,b,Qe=`Let’s make this concrete with a quick example using the <code>BlenderBot</code> model. BlenderBot has an extremely simple default
template, which mostly just adds whitespace between rounds of dialogue:`,vs,C,Qs,x,Ze=`Notice how the entire chat is condensed into a single string. If we use <code>tokenize=True</code>, which is the default setting,
that string will also be tokenized for us. To see a more complex template in action, though, let’s use the
<code>meta-llama/Llama-2-7b-chat-hf</code> model. Note that this model has gated access, so you will have to
<a href="https://huggingface.co/meta-llama/Llama-2-7b-chat-hf" rel="nofollow">request access on the repo</a> if you want to run this code yourself:`,Zs,N,$s,k,$e=`Note that this time, the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!)`,As,v,_s,Q,Ae=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. If no chat template is set, the
default template for that model class is used instead. Let’s take a look at the template for <code>BlenderBot</code>:`,Gs,Z,Ss,$,_e=`That’s kind of intimidating. Let’s add some newlines and indentation to make it more readable. Note that
we remove the first newline after each block as well as any preceding whitespace before a block by default, using the
Jinja <code>trim_blocks</code> and <code>lstrip_blocks</code> flags. This means that you can write your templates with indentations and
newlines and still have them function correctly!`,zs,A,Bs,_,Ge=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,Ws,G,Vs,S,Se="Effectively, the template does three things:",Rs,z,ze="<li>For each message, if the message is a user message, add a blank space before it, otherwise print nothing.</li> <li>Add the message content</li> <li>If the message is not the last message, add two spaces after it. After the final message, print the EOS token.</li>",qs,B,Be=`This is a pretty simple template - it doesn’t add any control tokens, and it doesn’t support “system” messages, which
are a common way to give the model directives about how it should behave in the subsequent conversation.
But Jinja gives you a lot of flexibility to do those things! Let’s see a Jinja template that can format inputs
similarly to the way LLaMA formats them (note that the real LLaMA template includes handling for default system
messages and slightly different system message handling in general - don’t use this one in your actual code!)`,Hs,W,Es,V,We=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens based
on the “role” of each message, which represents who sent it. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,Xs,R,Fs,q,Ve=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,Ys,H,Ls,E,Re=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/v4.34.1/en/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,Ps,X,Ds,F,qe=`The method <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/v4.34.1/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/v4.34.1/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>.`,Ks,Y,Os,L,He=`Before the introduction of chat templates, chat handling was hardcoded at the model class level. For backwards
compatibility, we have retained this class-specific handling as default templates, also set at the class level. If a
model does not have a chat template set, but there is a default template for its model class, the <code>ConversationalPipeline</code>
class and methods like <code>apply_chat_template</code> will use the class template instead. You can find out what the default
template for your tokenizer is by checking the <code>tokenizer.default_chat_template</code> attribute.`,se,P,Ee=`This is something we do purely for backward compatibility reasons, to avoid breaking any existing workflows. Even when
the class template is appropriate for your model, we strongly recommend overriding the default template by
setting the <code>chat_template</code> attribute explicitly to make it clear to users that your model has been correctly configured
for chat, and to future-proof in case the default templates are ever altered or deprecated.`,ee,D,te,K,Xe=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,ae,O,Fe=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. Our default template for models that don’t have a class-specific template follows the
<a href="https://github.com/openai/openai-python/blob/main/chatml.md" rel="nofollow">ChatML format</a>, and this is a good, flexible choice for many use-cases. It looks like this:`,le,ss,ne,es,Ye=`If you like this one, here it is in one-liner form, ready to copy into your code. The one-liner also includes
handy support for “generation prompts” - see the next section for more!`,pe,ts,ie,as,Le=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,oe,ls,re,ns,Pe=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/v4.34.1/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,he,ps,me,is,De=`You may notice that the <code>apply_chat_template</code> method has an <code>add_generation_prompt</code> argument. This argument tells
the template to add tokens that indicate the start of a bot response. For example, consider the following chat:`,ce,os,Me,rs,Ke="Here’s what this will look like without a generation prompt, using the ChatML template we described above:",de,hs,ye,ms,Oe="And here’s what it looks like <strong>with</strong> a generation prompt:",je,cs,ue,Ms,st=`Note that this time, we’ve added the tokens that indicate the start of a bot response. This ensures that when the model
generates text it will write a bot response instead of doing something unexpected, like continuing the user’s
message. Remember, chat models are still just language models - they’re trained to continue text, and chat is just a
special kind of text to them! You need to guide them with the appropriate control tokens so they know what they’re
supposed to be doing.`,ge,ds,et=`Not all models require generation prompts. Some models, like BlenderBot and LLaMA, don’t have any
special tokens before bot responses. In these cases, the <code>add_generation_prompt</code> argument will have no effect. The exact
effect that <code>add_generation_prompt</code> has will depend on the template being used.`,Ue,ys,Te,js,tt=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.apply_chat_template">apply_chat_template()</a>. This applies even if you’re not the model owner - if you’re using a model
with an empty chat template, or one that’s still using the default class template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to
the model repository so that this attribute can be set properly!`,Je,us,at=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>ConversationalPipeline</code>!`,fe,gs,lt=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,we,Ts,Ie;return g=new u({props:{title:"Templates for Chat Models",local:"templates-for-chat-models",headingTag:"h1"}}),U=new u({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),C=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>`,wrap:!1}}),N=new y({props:{code:"JTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGVsbG8lMkMlMjBob3clMjBhcmUlMjB5b3UlM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkknbSUyMGRvaW5nJTIwZ3JlYXQuJTIwSG93JTIwY2FuJTIwSSUyMGhlbHAlMjB5b3UlMjB0b2RheSUzRiUyMiU3RCUyQyUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkknZCUyMGxpa2UlMjB0byUyMHNob3clMjBvZmYlMjBob3clMjBjaGF0JTIwdGVtcGxhdGluZyUyMHdvcmtzISUyMiU3RCUyQyUwQSU1RCUwQQ==",highlighted:`&gt;&gt; <span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
&gt;&gt; tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)

&gt;&gt; chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

&gt;&gt; tokenizer.use_default_system_prompt = <span class="hljs-literal">False</span>
&gt;&gt; tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST] I&#x27;m doing great. How can I help you today? &lt;/s&gt;&lt;s&gt;[INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),v=new u({props:{title:"How do chat templates work?",local:"how-do-chat-templates-work",headingTag:"h2"}}),Z=new y({props:{code:"JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5kZWZhdWx0X2NoYXRfdGVtcGxhdGU=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.default_chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),A=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUyMCUyMCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3QiUyMGVvc190b2tlbiUyMCU3RCU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not loop.last <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;  &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ eos_token }}</span>`,wrap:!1}}),G=new y({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),W=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1JTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3QiUyMCclM0MlM0NTWVMlM0UlM0UlNUMlNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),R=new u({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h2"}}),H=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdzeXN0ZW0nJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RC5zdHJpcCgpJTIwJTJCJTIwJyU1QyU1Q24lM0MlM0MlMkZTWVMlM0UlM0UlNUMlNUNuJTVDJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyU1QkFTU1QlNUQlMjAnJTIwJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclMjAlNUIlMkZBU1NUJTVEJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),X=new y({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),Y=new u({props:{title:"What are “default” templates?",local:"what-are-default-templates",headingTag:"h2"}}),D=new u({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h2"}}),ss=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),ts=new y({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEKSUyMg==",highlighted:'<span class="language-xml">tokenizer.chat_template = &quot;</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not add_generation_prompt is defined <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">set</span> add_generation_prompt = false <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> add_generation_prompt <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;|im_start|&gt;assistant\\n&#x27;</span> }}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">)&quot;</span>',wrap:!1}}),ls=new y({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|<span class="hljs-type">im_start</span>|<span class="hljs-type">&gt;system</span>
You are a helpful chatbot that will <span class="hljs-built_in">do</span> its best not to say anything so stupid that people tweet about it.&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;user</span>
How are you?&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;assistant</span>
I&#x27;m doing great!&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),ps=new u({props:{title:"What are “generation prompts”?",local:"what-are-generation-prompts",headingTag:"h2"}}),os=new y({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),hs=new y({props:{code:"JTNFJTNFJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`&gt;&gt; tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),cs=new y({props:{code:"JTNFJTNFJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`&gt;&gt; tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),ys=new u({props:{title:"I want to use chat templates! How should I get started?",local:"i-want-to-use-chat-templates-how-should-i-get-started",headingTag:"h2"}}),{c(){j=p("meta"),Js=l(),Us=p("p"),fs=l(),r(g.$$.fragment),ws=l(),r(U.$$.fragment),Is=l(),T=p("p"),T.innerHTML=Ce,bs=l(),J=p("p"),J.textContent=xe,Cs=l(),f=p("p"),f.textContent=Ne,xs=l(),w=p("p"),w.innerHTML=ke,Ns=l(),I=p("p"),I.innerHTML=ve,ks=l(),b=p("p"),b.innerHTML=Qe,vs=l(),r(C.$$.fragment),Qs=l(),x=p("p"),x.innerHTML=Ze,Zs=l(),r(N.$$.fragment),$s=l(),k=p("p"),k.textContent=$e,As=l(),r(v.$$.fragment),_s=l(),Q=p("p"),Q.innerHTML=Ae,Gs=l(),r(Z.$$.fragment),Ss=l(),$=p("p"),$.innerHTML=_e,zs=l(),r(A.$$.fragment),Bs=l(),_=p("p"),_.innerHTML=Ge,Ws=l(),r(G.$$.fragment),Vs=l(),S=p("p"),S.textContent=Se,Rs=l(),z=p("ol"),z.innerHTML=ze,qs=l(),B=p("p"),B.textContent=Be,Hs=l(),r(W.$$.fragment),Es=l(),V=p("p"),V.textContent=We,Xs=l(),r(R.$$.fragment),Fs=l(),q=p("p"),q.innerHTML=Ve,Ys=l(),r(H.$$.fragment),Ls=l(),E=p("p"),E.innerHTML=Re,Ps=l(),r(X.$$.fragment),Ds=l(),F=p("p"),F.innerHTML=qe,Ks=l(),r(Y.$$.fragment),Os=l(),L=p("p"),L.innerHTML=He,se=l(),P=p("p"),P.innerHTML=Ee,ee=l(),r(D.$$.fragment),te=l(),K=p("p"),K.textContent=Xe,ae=l(),O=p("p"),O.innerHTML=Fe,le=l(),r(ss.$$.fragment),ne=l(),es=p("p"),es.textContent=Ye,pe=l(),r(ts.$$.fragment),ie=l(),as=p("p"),as.innerHTML=Le,oe=l(),r(ls.$$.fragment),re=l(),ns=p("p"),ns.innerHTML=Pe,he=l(),r(ps.$$.fragment),me=l(),is=p("p"),is.innerHTML=De,ce=l(),r(os.$$.fragment),Me=l(),rs=p("p"),rs.textContent=Ke,de=l(),r(hs.$$.fragment),ye=l(),ms=p("p"),ms.innerHTML=Oe,je=l(),r(cs.$$.fragment),ue=l(),Ms=p("p"),Ms.textContent=st,ge=l(),ds=p("p"),ds.innerHTML=et,Ue=l(),r(ys.$$.fragment),Te=l(),js=p("p"),js.innerHTML=tt,Je=l(),us=p("p"),us.innerHTML=at,fe=l(),gs=p("p"),gs.textContent=lt,we=l(),Ts=p("p"),this.h()},l(s){const e=ct("svelte-u9bgzb",document.head);j=i(e,"META",{name:!0,content:!0}),e.forEach(t),Js=n(s),Us=i(s,"P",{}),nt(Us).forEach(t),fs=n(s),h(g.$$.fragment,s),ws=n(s),h(U.$$.fragment,s),Is=n(s),T=i(s,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1ktexn3"&&(T.innerHTML=Ce),bs=n(s),J=i(s,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1xlggqv"&&(J.textContent=xe),Cs=n(s),f=i(s,"P",{"data-svelte-h":!0}),o(f)!=="svelte-pmlzkx"&&(f.textContent=Ne),xs=n(s),w=i(s,"P",{"data-svelte-h":!0}),o(w)!=="svelte-17e4zh4"&&(w.innerHTML=ke),Ns=n(s),I=i(s,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1bgzjn5"&&(I.innerHTML=ve),ks=n(s),b=i(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1n6wf0k"&&(b.innerHTML=Qe),vs=n(s),h(C.$$.fragment,s),Qs=n(s),x=i(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1ensusj"&&(x.innerHTML=Ze),Zs=n(s),h(N.$$.fragment,s),$s=n(s),k=i(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-7ppdar"&&(k.textContent=$e),As=n(s),h(v.$$.fragment,s),_s=n(s),Q=i(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-9hx4bd"&&(Q.innerHTML=Ae),Gs=n(s),h(Z.$$.fragment,s),Ss=n(s),$=i(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-vicnrv"&&($.innerHTML=_e),zs=n(s),h(A.$$.fragment,s),Bs=n(s),_=i(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-zet1qo"&&(_.innerHTML=Ge),Ws=n(s),h(G.$$.fragment,s),Vs=n(s),S=i(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-9bdwn1"&&(S.textContent=Se),Rs=n(s),z=i(s,"OL",{"data-svelte-h":!0}),o(z)!=="svelte-yy2gop"&&(z.innerHTML=ze),qs=n(s),B=i(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-jxu6rq"&&(B.textContent=Be),Hs=n(s),h(W.$$.fragment,s),Es=n(s),V=i(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-dqaxjt"&&(V.textContent=We),Xs=n(s),h(R.$$.fragment,s),Fs=n(s),q=i(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1ubxgh9"&&(q.innerHTML=Ve),Ys=n(s),h(H.$$.fragment,s),Ls=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1s78mv5"&&(E.innerHTML=Re),Ps=n(s),h(X.$$.fragment,s),Ds=n(s),F=i(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-g1dxjd"&&(F.innerHTML=qe),Ks=n(s),h(Y.$$.fragment,s),Os=n(s),L=i(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-fwloaj"&&(L.innerHTML=He),se=n(s),P=i(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-118w8i2"&&(P.innerHTML=Ee),ee=n(s),h(D.$$.fragment,s),te=n(s),K=i(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-5u6sqi"&&(K.textContent=Xe),ae=n(s),O=i(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-u7dsj6"&&(O.innerHTML=Fe),le=n(s),h(ss.$$.fragment,s),ne=n(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-kumxzd"&&(es.textContent=Ye),pe=n(s),h(ts.$$.fragment,s),ie=n(s),as=i(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-soh9qu"&&(as.innerHTML=Le),oe=n(s),h(ls.$$.fragment,s),re=n(s),ns=i(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-1pn28ct"&&(ns.innerHTML=Pe),he=n(s),h(ps.$$.fragment,s),me=n(s),is=i(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-1jrs4or"&&(is.innerHTML=De),ce=n(s),h(os.$$.fragment,s),Me=n(s),rs=i(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-ku5b4p"&&(rs.textContent=Ke),de=n(s),h(hs.$$.fragment,s),ye=n(s),ms=i(s,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-61bp3d"&&(ms.innerHTML=Oe),je=n(s),h(cs.$$.fragment,s),ue=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-1h8j73s"&&(Ms.textContent=st),ge=n(s),ds=i(s,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-76qw2e"&&(ds.innerHTML=et),Ue=n(s),h(ys.$$.fragment,s),Te=n(s),js=i(s,"P",{"data-svelte-h":!0}),o(js)!=="svelte-1xvzw3v"&&(js.innerHTML=tt),Je=n(s),us=i(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-1dmaop5"&&(us.innerHTML=at),fe=n(s),gs=i(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-197jyne"&&(gs.textContent=lt),we=n(s),Ts=i(s,"P",{}),nt(Ts).forEach(t),this.h()},h(){pt(j,"name","hf:doc:metadata"),pt(j,"content",yt)},m(s,e){Mt(document.head,j),a(s,Js,e),a(s,Us,e),a(s,fs,e),m(g,s,e),a(s,ws,e),m(U,s,e),a(s,Is,e),a(s,T,e),a(s,bs,e),a(s,J,e),a(s,Cs,e),a(s,f,e),a(s,xs,e),a(s,w,e),a(s,Ns,e),a(s,I,e),a(s,ks,e),a(s,b,e),a(s,vs,e),m(C,s,e),a(s,Qs,e),a(s,x,e),a(s,Zs,e),m(N,s,e),a(s,$s,e),a(s,k,e),a(s,As,e),m(v,s,e),a(s,_s,e),a(s,Q,e),a(s,Gs,e),m(Z,s,e),a(s,Ss,e),a(s,$,e),a(s,zs,e),m(A,s,e),a(s,Bs,e),a(s,_,e),a(s,Ws,e),m(G,s,e),a(s,Vs,e),a(s,S,e),a(s,Rs,e),a(s,z,e),a(s,qs,e),a(s,B,e),a(s,Hs,e),m(W,s,e),a(s,Es,e),a(s,V,e),a(s,Xs,e),m(R,s,e),a(s,Fs,e),a(s,q,e),a(s,Ys,e),m(H,s,e),a(s,Ls,e),a(s,E,e),a(s,Ps,e),m(X,s,e),a(s,Ds,e),a(s,F,e),a(s,Ks,e),m(Y,s,e),a(s,Os,e),a(s,L,e),a(s,se,e),a(s,P,e),a(s,ee,e),m(D,s,e),a(s,te,e),a(s,K,e),a(s,ae,e),a(s,O,e),a(s,le,e),m(ss,s,e),a(s,ne,e),a(s,es,e),a(s,pe,e),m(ts,s,e),a(s,ie,e),a(s,as,e),a(s,oe,e),m(ls,s,e),a(s,re,e),a(s,ns,e),a(s,he,e),m(ps,s,e),a(s,me,e),a(s,is,e),a(s,ce,e),m(os,s,e),a(s,Me,e),a(s,rs,e),a(s,de,e),m(hs,s,e),a(s,ye,e),a(s,ms,e),a(s,je,e),m(cs,s,e),a(s,ue,e),a(s,Ms,e),a(s,ge,e),a(s,ds,e),a(s,Ue,e),m(ys,s,e),a(s,Te,e),a(s,js,e),a(s,Je,e),a(s,us,e),a(s,fe,e),a(s,gs,e),a(s,we,e),a(s,Ts,e),Ie=!0},p:ot,i(s){Ie||(c(g.$$.fragment,s),c(U.$$.fragment,s),c(C.$$.fragment,s),c(N.$$.fragment,s),c(v.$$.fragment,s),c(Z.$$.fragment,s),c(A.$$.fragment,s),c(G.$$.fragment,s),c(W.$$.fragment,s),c(R.$$.fragment,s),c(H.$$.fragment,s),c(X.$$.fragment,s),c(Y.$$.fragment,s),c(D.$$.fragment,s),c(ss.$$.fragment,s),c(ts.$$.fragment,s),c(ls.$$.fragment,s),c(ps.$$.fragment,s),c(os.$$.fragment,s),c(hs.$$.fragment,s),c(cs.$$.fragment,s),c(ys.$$.fragment,s),Ie=!0)},o(s){M(g.$$.fragment,s),M(U.$$.fragment,s),M(C.$$.fragment,s),M(N.$$.fragment,s),M(v.$$.fragment,s),M(Z.$$.fragment,s),M(A.$$.fragment,s),M(G.$$.fragment,s),M(W.$$.fragment,s),M(R.$$.fragment,s),M(H.$$.fragment,s),M(X.$$.fragment,s),M(Y.$$.fragment,s),M(D.$$.fragment,s),M(ss.$$.fragment,s),M(ts.$$.fragment,s),M(ls.$$.fragment,s),M(ps.$$.fragment,s),M(os.$$.fragment,s),M(hs.$$.fragment,s),M(cs.$$.fragment,s),M(ys.$$.fragment,s),Ie=!1},d(s){s&&(t(Js),t(Us),t(fs),t(ws),t(Is),t(T),t(bs),t(J),t(Cs),t(f),t(xs),t(w),t(Ns),t(I),t(ks),t(b),t(vs),t(Qs),t(x),t(Zs),t($s),t(k),t(As),t(_s),t(Q),t(Gs),t(Ss),t($),t(zs),t(Bs),t(_),t(Ws),t(Vs),t(S),t(Rs),t(z),t(qs),t(B),t(Hs),t(Es),t(V),t(Xs),t(Fs),t(q),t(Ys),t(Ls),t(E),t(Ps),t(Ds),t(F),t(Ks),t(Os),t(L),t(se),t(P),t(ee),t(te),t(K),t(ae),t(O),t(le),t(ne),t(es),t(pe),t(ie),t(as),t(oe),t(re),t(ns),t(he),t(me),t(is),t(ce),t(Me),t(rs),t(de),t(ye),t(ms),t(je),t(ue),t(Ms),t(ge),t(ds),t(Ue),t(Te),t(js),t(Je),t(us),t(fe),t(gs),t(we),t(Ts)),t(j),d(g,s),d(U,s),d(C,s),d(N,s),d(v,s),d(Z,s),d(A,s),d(G,s),d(W,s),d(R,s),d(H,s),d(X,s),d(Y,s),d(D,s),d(ss,s),d(ts,s),d(ls,s),d(ps,s),d(os,s),d(hs,s),d(cs,s),d(ys,s)}}}const yt='{"title":"Templates for Chat Models","local":"templates-for-chat-models","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"How do chat templates work?","local":"how-do-chat-templates-work","sections":[],"depth":2},{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":2},{"title":"What are “default” templates?","local":"what-are-default-templates","sections":[],"depth":2},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":2},{"title":"What are “generation prompts”?","local":"what-are-generation-prompts","sections":[],"depth":2},{"title":"I want to use chat templates! How should I get started?","local":"i-want-to-use-chat-templates-how-should-i-get-started","sections":[],"depth":2}],"depth":1}';function jt(be){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jt extends ht{constructor(j){super(),mt(this,j,jt,dt,it,{})}}export{Jt as component};
