# Quiz am Ende des Kapitels

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

Lass uns testen, was du im vorheringen Kapitel gelernt hast!
  
### 1. Auf welche Modelle sind die Hub-Modelle beschränkt?

<Question
	choices={[
		{
			text: "Modelle aus der 🤗 Transformers Bibliothek.",
			explain: "Obwohl Modelle aus der 🤗 Transformers-Bibliothek auf dem Hugging Face Hub unterstützt werden, sind sie nicht die einzigen!"
		},
		{
			text: "Alle Modelle mit einer ähnlichen Schnittstelle (Interface) wie 🤗 Transformers.",
			explain: "Beim Hochladen von Modellen auf den Hugging Face Hub werden keine Schnittstellenanforderungen festgelegt."
			
		},
		{
			text: "Es gibt keine",
			explain: "Korrekt! Es gibt keine Einschränkungen, um Modelle auf den Hub hochzuladen",
            correct: true
		},
        {
			text: "Modelle, die in irgendeiner Weise mit NLP zu tun haben",
			explain: "Es werden keine Anforderungen an den Einsatzbereich gestellt!"
		}
	]}
/>

### 2. Wie kannst du die Modelle auf dem Hub verwalten?

<Question
	choices={[
		{
			text: "Durch einen GCP-Account.",
			explain: "Inkorrekt!"
		},
		{
			text: "Durch Peer-to-Peer-Verteilung.",
			explain: "Inkorrekt!"
		},
		{
			text: "Durch git und git-lfs.",
			explain: "Korrekt! Modelle auf dem Hub sind einfach Git-Repositories, die für große Dateien <code>git-lfs</code> benutzen.",
            correct: true
		}
	]}
/>

### 3. Was kannst du mit der Hugging Face Hub-Weboberfläche tun?

<Question
	choices={[
		{
			text: "Ein vorhandenes Repository forken.",
			explain: "Das Forken eines Repositorys ist auf dem Hugging Face Hub nicht möglich."
		},
		{
			text: "Ein neues Modell-Repository erstellen.",
			explain: "Richtig! Das ist jedoch nicht alles, was Sie tun können.",
            correct: true
		},
		{
			text: "Dateien editieren und verwalten.",
			explain: "Richtig! Das ist aber nicht die einzige Antwort.",
            correct: true
		},
        {
			text: "Dateien hochladen.",
			explain: "Korrekt! Aber das ist nicht alles.",
            correct: true
		},
        {
			text: "Unterschiede zwischen Versionen sehen.",
			explain: "Korrekt! Aber das ist nicht alles.",
            correct: true
		}
	]}
/>

### 4. Was ist eine Modellkarte?

<Question
	choices={[
		{
			text: "Eine grobe Beschreibung des Modells, daher weniger wichtig als die Modell- und Tokenizer-Dateien.",
			explain: "Es ist zwar eine Beschreibung des Modells, aber es ist ein wichtiger Teil: Wenn es unvollständig ist oder fehlt, wird der Nutzen des Modells drastisch reduziert."
		},
		{
			text: "Eine Möglichkeit, Reproduzierbarkeit, Wiederverwendbarkeit und Fairness sicherzustellen.",
			explain: "Richtig! Das Teilen der richtigen Informationen auf der Modellkarte hilft Benutzern, dein Modell zu nutzen und sich seiner Grenzen und Vorurteile bewusst zu werden.",
            correct: true
		},
		{
			text: "Eine Python-Datei, die ausgeführt werden kann, um Informationen zum Modell zu holen",
			explain: "Modellkarten sind einfache Markdown-Dateien."
		}
	]}
/>

### 5. Welche dieser Objekte der 🤗 Transformers-Bibliothek können mit `push_to_hub()` direkt auf dem Hub geteilt werden?

{#if fw === 'pt'}
<Question
	choices={[
		{
			text: "Ein Tokenizer",
			explain: "Richtig! Alle Tokenizer verfügen über die Methode <code>push_to_hub</code>, und wenn su sie verwendest, werden alle Tokenizer-Dateien (Vokabular, Architektur des Tokenizers usw.) in ein bestimmtes Repo verschoben. Aber das ist nicht die einzig richtige Antwort!",
            correct: true
		},
		{
			text: "Eine Modell-Konfiguration",
			explain: "Richtig! Alle Modellkonfigurationen verfügen über die Methode <code>push_to_hub</code>, und wenn Sie sie verwenden, werden sie an ein bestimmtes Repo gepusht. Was kannst du sonst noch teilen?",
            correct: true
		},
		{
			text: "Ein Model",
			explain: "Richtig! Alle Modelle verfügen über die Methode <code>push_to_hub</code>, und wenn du sie verwendest, werden sie und ihre Konfigurationsdateien in ein bestimmtes Repo gepusht. Das ist jedoch nicht alles, was du teilen kannst.",
            correct: true
		},
        {
			text: "Ein Trainer",
			explain: "Das ist richtig – der <code>Trainer</code> implementiert auch die Methode <code>push_to_hub</code> und lädt mit dieser Methode das Modell, seine Konfiguration, den Tokenizer und einen Modellkartenentwurf auf einen gegebenen Server hoch repo. Versuch es auch mit einer anderen Antwort!",
            correct: true
		}
	]}
/>
{:else}
<Question
	choices={[
		{
			text: "Ein tokenizer",
			explain: "Correct! All tokenizers have the <code>push_to_hub</code> method, and using it will push all the tokenizer files (vocabulary, architecture of the tokenizer, etc.) to a given repo. That's not the only right answer, though!",
			explain: "Richtig! Alle Tokenizer verfügen über die Methode <code>push_to_hub</code>, und wenn du sie verwendest, werden alle Tokenizer-Dateien (Vokabular, Architektur des Tokenizers usw.) in ein bestimmtes Repo verschoben. Das ist aber nicht die einzige richtige Antwort!",
            correct: true
		},
		{
			text: "Eine Modell-Konfiguration",
			explain: "Right! All model configurations have the <code>push_to_hub</code> method, and using it will push them to a given repo. What else can you share?",
			explain: "Richtig! Alle Modellkonfigurationen verfügen über die Methode <code>push_to_hub</code>, und wenn du sie verwendest, werden sie an ein bestimmtes Repo gepusht. Was kannst du sonst noch teilen?",
            correct: true
		},
		{
			text: "Ein Modell",
			explain: "Richtig! Alle Modelle verfügen über die Methode <code>push_to_hub</code>, und wenn du sie verwendest, werden sie und ihre Konfigurationsdateien in ein bestimmtes Repo gepusht. Das ist jedoch nicht alles, was du teilen kannst.",
            correct: true
		},
		{
			text: "Alles oben mit einem speziellen `Callback`",
			explain: "Das ist richtig – der <code>PushToHubCallback</code> sendet während des Trainings regelmäßig alle diese Objekte an ein Repo.",
            correct: true
		}
	]}
/>
{/if}

### 6. Was ist der erste Schritt bei Verwendung der Methode `push_to_hub()` oder der CLI-Tools?

<Question
	choices={[
		{
			text: "Login auf der Website.",
			explain: "Das hilft auf deinem lokalen Rechner nicht."
		},
		{
			text: "'huggingface-cli login' im Terminal auszuführen.",
			explain: "Richtig – dadurch wird dein persönlicher Token heruntergeladen und zwischengespeichert.",
            correct: true
		},
		{
			text: "'notebook_login()' im Notebook auszuführen.",
			explain: "Richtig – es wird ein Widget angezeigt, mit dem du dichh authentifizieren kannst.",
            correct: true
		},
	]}
/>

### 7. Du verwendest ein Modell und einen Tokenizer – wie kannst du diese auf den Hub hochladen?

<Question
	choices={[
		{
			text: "Mittels der push_to_hub Methode direkt auf dem Model und dem Tokenizer.",
			explain: "Korrekt!",
            correct: true
		},
		{
			text: "Innerhalb der Python-Runtime, indem man sie in ein <code>huggingface_hub</code>-Dienstprogramm einschließt.",
			explain: "Modelle und Tokenizer profitieren bereits von den Dienstprogrammen <code>huggingface_hub</code>: kein zusätzlicher Wrapping erforderlich!"
		},
		{
			text: "Indem du sie auf der Festplatte speicherst und <code>transformers-cli upload-model</code> aufrufst",
			explain: "Der Befehl <code>upload-model</code> existiert nicht."
		}
	]}
/>

### 8. Welche Git-Operationen kann man mit der Klasse „Repository“ ausführen?

<Question
	choices={[
		{
			text: "Ein Commit.",
			explain: "Richtig, dafür ist die <code>git_commit()</code> Methode da.",
            correct: true
		},
		{
			text: "Ein Pull",
			explain: "Das ist der Zweck der <code>git_pull()</code> Methode.",
            correct: true
		},
		{
			text: "Ein Push",
			explain: "Die Methode <code>git_push()</code> macht das.",
            correct: true
		},
		{
			text: "Ein Merge",
			explain: "Nein, die Operation wird mit dieser API nie möglich sein."
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/de/chapter4/6.mdx" />