import{s as ut,o as Ut,n as Ps}from"../chunks/scheduler.cc52f4b9.js";import{S as wt,i as Tt,e as j,s as a,c as M,h as mt,a as J,d as n,b as e,f as Jt,g as i,j as u,k as ht,l as gt,m as t,n as y,t as r,o,p as c}from"../chunks/index.5b747fde.js";import{T as Ys}from"../chunks/Tip.f0925d57.js";import{C as xt,H as In,E as Ct}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d38ac5a9.js";import{Y as dt}from"../chunks/Youtube.8bb4154e.js";import{C as U}from"../chunks/CodeBlock.665bfc37.js";import{C as ft}from"../chunks/CourseFloatingBanner.b33fcd79.js";function It(m){let p,w="💡 This section covers BPE in depth, going as far as showing a full implementation. You can skip to the end if you just want a general overview of the tokenization algorithm.";return{c(){p=j("p"),p.textContent=w},l(h){p=J(h,"P",{"data-svelte-h":!0}),u(p)!=="svelte-ng6y15"&&(p.textContent=w)},m(h,T){t(h,p,T)},p:Ps,d(h){h&&n(p)}}}function bt(m){let p,w="The GPT-2 and RoBERTa tokenizers (which are pretty similar) have a clever way to deal with this: they don’t look at words as being written with Unicode characters, but with bytes. This way the base vocabulary has a small size (256), but every character you can think of will still be included and not end up being converted to the unknown token. This trick is called <em>byte-level BPE</em>.";return{c(){p=j("p"),p.innerHTML=w},l(h){p=J(h,"P",{"data-svelte-h":!0}),u(p)!=="svelte-98dqph"&&(p.innerHTML=w)},m(h,T){t(h,p,T)},p:Ps,d(h){h&&n(p)}}}function kt(m){let p,w="✏️ <strong>Now your turn!</strong> What do you think the next merge rule will be?";return{c(){p=j("p"),p.innerHTML=w},l(h){p=J(h,"P",{"data-svelte-h":!0}),u(p)!=="svelte-oqvl3w"&&(p.innerHTML=w)},m(h,T){t(h,p,T)},p:Ps,d(h){h&&n(p)}}}function $t(m){let p,w="✏️ <strong>Now your turn!</strong> How do you think  the word <code>&quot;unhug&quot;</code> will be tokenized?";return{c(){p=j("p"),p.innerHTML=w},l(h){p=J(h,"P",{"data-svelte-h":!0}),u(p)!=="svelte-amahqs"&&(p.innerHTML=w)},m(h,T){t(h,p,T)},p:Ps,d(h){h&&n(p)}}}function qt(m){let p,w="💡 Using <code>train_new_from_iterator()</code> on the same corpus won’t result in the exact same vocabulary. This is because when there is a choice of the most frequent pair, we selected the first one encountered, while the 🤗 Tokenizers library selects the first one based on its inner IDs.";return{c(){p=j("p"),p.innerHTML=w},l(h){p=J(h,"P",{"data-svelte-h":!0}),u(p)!=="svelte-lvgbtz"&&(p.innerHTML=w)},m(h,T){t(h,p,T)},p:Ps,d(h){h&&n(p)}}}function Qt(m){let p,w="⚠️ Our implementation will throw an error if there is an unknown character since we didn’t do anything to handle them. GPT-2 doesn’t actually have an unknown token (it’s impossible to get an unknown character when using byte-level BPE), but this could happen here because we did not include all the possible bytes in the initial vocabulary. This aspect of BPE is beyond the scope of this section, so we’ve left the details out.";return{c(){p=j("p"),p.textContent=w},l(h){p=J(h,"P",{"data-svelte-h":!0}),u(p)!=="svelte-165040c"&&(p.textContent=w)},m(h,T){t(h,p,T)},p:Ps,d(h){h&&n(p)}}}function At(m){let p,w,h,T,b,Fs,k,Ls,$,Os,q,bn="Byte-Pair Encoding (BPE) was initially developed as an algorithm to compress texts, and then used by OpenAI for tokenization when pretraining the GPT model. It’s used by a lot of Transformer models, including GPT, GPT-2, RoBERTa, BART, and DeBERTa.",sl,Q,ll,g,nl,A,tl,B,kn="BPE training starts by computing the unique set of words used in the corpus (after the normalization and pre-tokenization steps are completed), then building the vocabulary by taking all the symbols used to write those words. As a very simple example, let’s say our corpus uses these five words:",al,z,el,V,$n="The base vocabulary will then be <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code>. For real-world cases, that base vocabulary will contain all the ASCII characters, at the very least, and probably some Unicode characters as well. If an example you are tokenizing uses a character that is not in the training corpus, that character will be converted to the unknown token. That’s one reason why lots of NLP models are very bad at analyzing content with emojis, for instance.",pl,x,Ml,v,qn="After getting this base vocabulary, we add new tokens until the desired vocabulary size is reached by learning <em>merges</em>, which are rules to merge two elements of the existing vocabulary together into a new one. So, at the beginning these merges will create tokens with two characters, and then, as training progresses, longer subwords.",il,E,Qn="At any step during the tokenizer training, the BPE algorithm will search for the most frequent pair of existing tokens (by “pair,” here we mean two consecutive tokens in a word). That most frequent pair is the one that will be merged, and we rinse and repeat for the next step.",yl,Z,An="Going back to our previous example, let’s assume the words had the following frequencies:",rl,S,ol,G,Bn="meaning <code>&quot;hug&quot;</code> was present 10 times in the corpus, <code>&quot;pug&quot;</code> 5 times, <code>&quot;pun&quot;</code> 12 times, <code>&quot;bun&quot;</code> 4 times, and <code>&quot;hugs&quot;</code> 5 times. We start the training by splitting each word into characters (the ones that form our initial vocabulary) so we can see each word as a list of tokens:",cl,N,jl,_,zn="Then we look at pairs. The pair <code>(&quot;h&quot;, &quot;u&quot;)</code> is present in the words <code>&quot;hug&quot;</code> and <code>&quot;hugs&quot;</code>, so 15 times total in the corpus. It’s not the most frequent pair, though: that honor belongs to <code>(&quot;u&quot;, &quot;g&quot;)</code>, which is present in <code>&quot;hug&quot;</code>, <code>&quot;pug&quot;</code>, and <code>&quot;hugs&quot;</code>, for a grand total of 20 times in the vocabulary.",Jl,H,Vn="Thus, the first merge rule learned by the tokenizer is <code>(&quot;u&quot;, &quot;g&quot;) -&gt; &quot;ug&quot;</code>, which means that <code>&quot;ug&quot;</code> will be added to the vocabulary, and the pair should be merged in all the words of the corpus. At the end of this stage, the vocabulary and corpus look like this:",hl,X,ul,D,vn="Now we have some pairs that result in a token longer than two characters: the pair <code>(&quot;h&quot;, &quot;ug&quot;)</code>, for instance (present 15 times in the corpus). The most frequent pair at this stage is <code>(&quot;u&quot;, &quot;n&quot;)</code>, however, present 16 times in the corpus, so the second merge rule learned is <code>(&quot;u&quot;, &quot;n&quot;) -&gt; &quot;un&quot;</code>. Adding that to the vocabulary and merging all existing occurrences leads us to:",Ul,W,wl,R,En="Now the most frequent pair is <code>(&quot;h&quot;, &quot;ug&quot;)</code>, so we learn the merge rule <code>(&quot;h&quot;, &quot;ug&quot;) -&gt; &quot;hug&quot;</code>, which gives us our first three-letter token. After the merge, the corpus looks like this:",Tl,Y,ml,P,Zn="And we continue like this until we reach the desired vocabulary size.",gl,C,xl,K,Cl,F,Sn="Tokenization follows the training process closely, in the sense that new inputs are tokenized by applying the following steps:",dl,L,Gn="<li>Normalization</li> <li>Pre-tokenization</li> <li>Splitting the words into individual characters</li> <li>Applying the merge rules learned in order on those splits</li>",fl,O,Nn="Let’s take the example we used during training, with the three merge rules learned:",Il,ss,bl,ls,_n="The word <code>&quot;bug&quot;</code> will be tokenized as <code>[&quot;b&quot;, &quot;ug&quot;]</code>. <code>&quot;mug&quot;</code>, however, will be tokenized as <code>[&quot;[UNK]&quot;, &quot;ug&quot;]</code> since the letter <code>&quot;m&quot;</code> was not in the base vocabulary. Likewise, the word <code>&quot;thug&quot;</code> will be tokenized as <code>[&quot;[UNK]&quot;, &quot;hug&quot;]</code>: the letter <code>&quot;t&quot;</code> is not in the base vocabulary, and applying the merge rules results first in <code>&quot;u&quot;</code> and <code>&quot;g&quot;</code> being merged and then <code>&quot;h&quot;</code> and <code>&quot;ug&quot;</code> being merged.",kl,d,$l,ns,ql,ts,Hn="Now let’s take a look at an implementation of the BPE algorithm. This won’t be an optimized version you can actually use on a big corpus; we just want to show you the code so you can understand the algorithm a little bit better.",Ql,as,Xn="First we need a corpus, so let’s create a simple one with a few sentences:",Al,es,Bl,ps,Dn="Next, we need to pre-tokenize that corpus into words. Since we are replicating a BPE tokenizer (like GPT-2), we will use the <code>gpt2</code> tokenizer for the pre-tokenization:",zl,Ms,Vl,is,Wn="Then we compute the frequencies of each word in the corpus as we do the pre-tokenization:",vl,ys,El,rs,Zl,os,Rn="The next step is to compute the base vocabulary, formed by all the characters used in the corpus:",Sl,cs,Gl,js,Nl,Js,Yn="We also add the special tokens used by the model at the beginning of that vocabulary. In the case of GPT-2, the only special token is <code>&quot;&lt;|endoftext|&gt;&quot;</code>:",_l,hs,Hl,us,Pn="We now need to split each word into individual characters, to be able to start training:",Xl,Us,Dl,ws,Kn="Now that we are ready for training, let’s write a function that computes the frequency of each pair. We’ll need to use this at each step of the training:",Wl,Ts,Rl,ms,Fn="Let’s have a look at a part of this dictionary after the initial splits:",Yl,gs,Pl,xs,Kl,Cs,Ln="Now, finding the most frequent pair only takes a quick loop:",Fl,ds,Ll,fs,Ol,Is,On="So the first merge to learn is <code>(&#39;Ġ&#39;, &#39;t&#39;) -&gt; &#39;Ġt&#39;</code>, and we add <code>&#39;Ġt&#39;</code> to the vocabulary:",sn,bs,ln,ks,st="To continue, we need to apply that merge in our <code>splits</code> dictionary. Let’s write another function for this:",nn,$s,tn,qs,lt="And we can have a look at the result of the first merge:",an,Qs,en,As,pn,Bs,nt="Now we have everything we need to loop until we have learned all the merges we want. Let’s aim for a vocab size of 50:",Mn,zs,yn,Vs,tt="As a result, we’ve learned 19 merge rules (the initial vocabulary had a size of 31 — 30 characters in the alphabet, plus the special token):",rn,vs,on,Es,cn,Zs,at="And the vocabulary is composed of the special token, the initial alphabet, and all the results of the merges:",jn,Ss,Jn,Gs,hn,f,un,Ns,et="To tokenize a new text, we pre-tokenize it, split it, then apply all the merge rules learned:",Un,_s,wn,Hs,pt="We can try this on any text composed of characters in the alphabet:",Tn,Xs,mn,Ds,gn,I,xn,Ws,Mt="That’s it for the BPE algorithm! Next, we’ll have a look at WordPiece.",Cn,Rs,dn,Ks,fn;return b=new xt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),k=new In({props:{title:"Byte-Pair Encoding tokenization",local:"byte-pair-encoding-tokenization",headingTag:"h1"}}),$=new ft({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section5.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section5.ipynb"}]}}),Q=new dt({props:{id:"HEikzVL-lZU"}}),g=new Ys({props:{$$slots:{default:[It]},$$scope:{ctx:m}}}),A=new In({props:{title:"Training algorithm",local:"training-algorithm",headingTag:"h2"}}),z=new U({props:{code:"JTIyaHVnJTIyJTJDJTIwJTIycHVnJTIyJTJDJTIwJTIycHVuJTIyJTJDJTIwJTIyYnVuJTIyJTJDJTIwJTIyaHVncyUyMg==",highlighted:'<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;pug&quot;</span>, <span class="hljs-string">&quot;pun&quot;</span>, <span class="hljs-string">&quot;bun&quot;</span>, <span class="hljs-string">&quot;hugs&quot;</span>',wrap:!1}}),x=new Ys({props:{$$slots:{default:[bt]},$$scope:{ctx:m}}}),S=new U({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),N=new U({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),X=new U({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiU1RCUwQUNvcnB1cyUzQSUyMCglMjJoJTIyJTIwJTIydWclMjIlMkMlMjAxMCklMkMlMjAoJTIycCUyMiUyMCUyMnVnJTIyJTJDJTIwNSklMkMlMjAoJTIycCUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwMTIpJTJDJTIwKCUyMmIlMjIlMjAlMjJ1JTIyJTIwJTIybiUyMiUyQyUyMDQpJTJDJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyMCUyMnMlMjIlMkMlMjA1KQ==",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),W=new U({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),Y=new U({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTJDJTIwJTIyaHVnJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),C=new Ys({props:{$$slots:{default:[kt]},$$scope:{ctx:m}}}),K=new In({props:{title:"Tokenization algorithm",local:"tokenization-algorithm",headingTag:"h2"}}),ss=new U({props:{code:"KCUyMnUlMjIlMkMlMjAlMjJnJTIyKSUyMC0lM0UlMjAlMjJ1ZyUyMiUwQSglMjJ1JTIyJTJDJTIwJTIybiUyMiklMjAtJTNFJTIwJTIydW4lMjIlMEEoJTIyaCUyMiUyQyUyMCUyMnVnJTIyKSUyMC0lM0UlMjAlMjJodWclMjI=",highlighted:`<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;ug&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;un&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;hug&quot;</span>`,wrap:!1}}),d=new Ys({props:{$$slots:{default:[$t]},$$scope:{ctx:m}}}),ns=new In({props:{title:"Implementing BPE",local:"implementing-bpe",headingTag:"h2"}}),es=new U({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),Ms=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),ys=new U({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBcHJpbnQod29yZF9mcmVxcyk=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

<span class="hljs-built_in">print</span>(word_freqs)`,wrap:!1}}),rs=new U({props:{code:"ZGVmYXVsdGRpY3QoaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCclQzQlQTBpcyclM0ElMjAyJTJDJTIwJyVDNCVBMHRoZSclM0ElMjAxJTJDJTIwJyVDNCVBMEh1Z2dpbmcnJTNBJTIwMSUyQyUyMCclQzQlQTBGYWNlJyUzQSUyMDElMkMlMjAnJUM0JUEwQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJyVDNCVBMGNoYXB0ZXInJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCclQzQlQTBhYm91dCclM0ElMjAxJTJDJTIwJyVDNCVBMHRva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJyVDNCVBMHNlY3Rpb24nJTNBJTIwMSUyQyUyMCclQzQlQTBzaG93cyclM0ElMjAxJTJDJTIwJyVDNCVBMHNldmVyYWwnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCclQzQlQTBhbGdvcml0aG1zJyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMjAnJTJDJyUzQSUyMDElMkMlMjAnJUM0JUEweW91JyUzQSUyMDElMkMlMjAnJUM0JUEwd2lsbCclM0ElMjAxJTJDJTIwJyVDNCVBMGJlJyUzQSUyMDElMkMlMjAnJUM0JUEwYWJsZSclM0ElMjAxJTJDJTIwJyVDNCVBMHRvJyUzQSUyMDElMkMlMjAnJUM0JUEwdW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJyVDNCVBMGhvdyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJyVDNCVBMHRoZXknJTNBJTIwMSUyQyUyMCclQzQlQTBhcmUnJTNBJTIwMSUyQyUyMCclQzQlQTB0cmFpbmVkJyUzQSUyMDElMkMlMjAnJUM0JUEwYW5kJyUzQSUyMDElMkMlMjAnJUM0JUEwZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(<span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠHugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠFace&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠCourse&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;Ġchapter&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġabout&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġsection&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġshows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġseveral&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġalgorithms&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġyou&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġwill&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġbe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġable&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġunderstand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġhow&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġthey&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġare&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtrained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġgenerate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),cs=new U({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGV0dGVyJTIwbm90JTIwaW4lMjBhbHBoYWJldCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFscGhhYmV0LmFwcGVuZChsZXR0ZXIpJTBBYWxwaGFiZXQuc29ydCgpJTBBJTBBcHJpbnQoYWxwaGFiZXQp",highlighted:`alphabet = []

<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word:
        <span class="hljs-keyword">if</span> letter <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(letter)
alphabet.sort()

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),js=new U({props:{code:"JTVCJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclMkMlMjAnZSclMkMlMjAnZiclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAnayclMkMlMjAnbCclMkMlMjAnbSclMkMlMjAnbiclMkMlMjAnbyclMkMlMjAncCclMkMlMjAnciclMkMlMjAncyclMkMlMEElMjAlMjAndCclMkMlMjAndSclMkMlMjAndiclMkMlMjAndyclMkMlMjAneSclMkMlMjAneiclMkMlMjAnJUM0JUEwJyU1RA==",highlighted:`[ <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>,
  <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>]`,wrap:!1}}),hs=new U({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQlMjAlMkIlMjBhbHBoYWJldC5jb3B5KCk=",highlighted:'vocab = [<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>] + alphabet.copy()',wrap:!1}}),Us=new U({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCd29yZCUzQSUyMCU1QmMlMjBmb3IlMjBjJTIwaW4lMjB3b3JkJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9mcmVxcy5rZXlzKCklN0Q=",highlighted:'splits = {word: [c <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()}',wrap:!1}}),Ts=new U({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX2ZyZXFzKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMkMlMjBmcmVxJTIwaW4lMjB3b3JkX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0cyU1QndvcmQlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGxlbihzcGxpdCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlNUJwYWlyJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHBhaXJfZnJlcXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_freqs</span>(<span class="hljs-params">splits</span>):
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            pair_freqs[pair] += freq
    <span class="hljs-keyword">return</span> pair_freqs`,wrap:!1}}),gs=new U({props:{code:"cGFpcl9mcmVxcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9mcmVxcyhzcGxpdHMpJTBBJTBBZm9yJTIwaSUyQyUyMGtleSUyMGluJTIwZW51bWVyYXRlKHBhaXJfZnJlcXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX2ZyZXFzJTVCa2V5JTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUzRCUyMDUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhaw==",highlighted:`pair_freqs = compute_pair_freqs(splits)

<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_freqs.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_freqs[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),xs=new U({props:{code:"KCdUJyUyQyUyMCdoJyklM0ElMjAzJTBBKCdoJyUyQyUyMCdpJyklM0ElMjAzJTBBKCdpJyUyQyUyMCdzJyklM0ElMjA1JTBBKCclQzQlQTAnJTJDJTIwJ2knKSUzQSUyMDIlMEEoJyVDNCVBMCclMkMlMjAndCcpJTNBJTIwNyUwQSgndCclMkMlMjAnaCcpJTNBJTIwMw==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-number">5</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">2</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-number">7</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>`,wrap:!1}}),ds=new U({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X2ZyZXElMjAlM0QlMjBOb25lJTBBJTBBZm9yJTIwcGFpciUyQyUyMGZyZXElMjBpbiUyMHBhaXJfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X2ZyZXElMjBpcyUyME5vbmUlMjBvciUyMG1heF9mcmVxJTIwJTNDJTIwZnJlcSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfZnJlcSUyMCUzRCUyMGZyZXElMEElMEFwcmludChiZXN0X3BhaXIlMkMlMjBtYXhfZnJlcSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_freq = <span class="hljs-literal">None</span>

<span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
    <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
        best_pair = pair
        max_freq = freq

<span class="hljs-built_in">print</span>(best_pair, max_freq)`,wrap:!1}}),fs=new U({props:{code:"KCclQzQlQTAnJTJDJTIwJ3QnKSUyMDc=",highlighted:'(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>) <span class="hljs-number">7</span>',wrap:!1}}),bs=new U({props:{code:"bWVyZ2VzJTIwJTNEJTIwJTdCKCUyMiVDNCVBMCUyMiUyQyUyMCUyMnQlMjIpJTNBJTIwJTIyJUM0JUEwdCUyMiU3RCUwQXZvY2FiLmFwcGVuZCglMjIlQzQlQTB0JTIyKQ==",highlighted:`merges = {(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>): <span class="hljs-string">&quot;Ġt&quot;</span>}
vocab.append(<span class="hljs-string">&quot;Ġt&quot;</span>)`,wrap:!1}}),$s=new U({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCYSUyMCUyQiUyMGIlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>

        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                split = split[:i] + [a + b] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),Qs=new U({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjIlQzQlQTAlMjIlMkMlMjAlMjJ0JTIyJTJDJTIwc3BsaXRzKSUwQXByaW50KHNwbGl0cyU1QiUyMiVDNCVBMHRyYWluZWQlMjIlNUQp",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, splits)
<span class="hljs-built_in">print</span>(splits[<span class="hljs-string">&quot;Ġtrained&quot;</span>])`,wrap:!1}}),As=new U({props:{code:"JTVCJyVDNCVBMHQnJTJDJTIwJ3InJTJDJTIwJ2EnJTJDJTIwJ2knJTJDJTIwJ24nJTJDJTIwJ2UnJTJDJTIwJ2QnJTVE",highlighted:'[<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]',wrap:!1}}),zs=new U({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDUwJTBBJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfZnJlcXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMG1heF9mcmVxJTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG1heF9mcmVxJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfZnJlcSUyMCUzQyUyMGZyZXElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlMjAlM0QlMjBwYWlyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2ZyZXElMjAlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG1lcmdlcyU1QmJlc3RfcGFpciU1RCUyMCUzRCUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwdm9jYWIuYXBwZW5kKGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEKQ==",highlighted:`vocab_size = <span class="hljs-number">50</span>

<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    pair_freqs = compute_pair_freqs(splits)
    best_pair = <span class="hljs-string">&quot;&quot;</span>
    max_freq = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
        <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
            best_pair = pair
            max_freq = freq
    splits = merge_pair(*best_pair, splits)
    merges[best_pair] = best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    vocab.append(best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>])`,wrap:!1}}),vs=new U({props:{code:"cHJpbnQobWVyZ2VzKQ==",highlighted:'<span class="hljs-built_in">print</span>(merges)',wrap:!1}}),Es=new U({props:{code:"JTdCKCclQzQlQTAnJTJDJTIwJ3QnKSUzQSUyMCclQzQlQTB0JyUyQyUyMCgnaSclMkMlMjAncycpJTNBJTIwJ2lzJyUyQyUyMCgnZSclMkMlMjAncicpJTNBJTIwJ2VyJyUyQyUyMCgnJUM0JUEwJyUyQyUyMCdhJyklM0ElMjAnJUM0JUEwYSclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ28nKSUzQSUyMCclQzQlQTB0byclMkMlMjAoJ2UnJTJDJTIwJ24nKSUzQSUyMCdlbiclMkMlMEElMjAoJ1QnJTJDJTIwJ2gnKSUzQSUyMCdUaCclMkMlMjAoJ1RoJyUyQyUyMCdpcycpJTNBJTIwJ1RoaXMnJTJDJTIwKCdvJyUyQyUyMCd1JyklM0ElMjAnb3UnJTJDJTIwKCdzJyUyQyUyMCdlJyklM0ElMjAnc2UnJTJDJTIwKCclQzQlQTB0byclMkMlMjAnaycpJTNBJTIwJyVDNCVBMHRvayclMkMlMEElMjAoJyVDNCVBMHRvayclMkMlMjAnZW4nKSUzQSUyMCclQzQlQTB0b2tlbiclMkMlMjAoJ24nJTJDJTIwJ2QnKSUzQSUyMCduZCclMkMlMjAoJyVDNCVBMCclMkMlMjAnaXMnKSUzQSUyMCclQzQlQTBpcyclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ2gnKSUzQSUyMCclQzQlQTB0aCclMkMlMjAoJyVDNCVBMHRoJyUyQyUyMCdlJyklM0ElMjAnJUM0JUEwdGhlJyUyQyUwQSUyMCgnaSclMkMlMjAnbicpJTNBJTIwJ2luJyUyQyUyMCgnJUM0JUEwYSclMkMlMjAnYicpJTNBJTIwJyVDNCVBMGFiJyUyQyUyMCgnJUM0JUEwdG9rZW4nJTJDJTIwJ2knKSUzQSUyMCclQzQlQTB0b2tlbmknJTdE",highlighted:`{(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-string">&#x27;Ġt&#x27;</span>, (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-string">&#x27;is&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>): <span class="hljs-string">&#x27;er&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>): <span class="hljs-string">&#x27;Ġa&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>): <span class="hljs-string">&#x27;Ġto&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;en&#x27;</span>,
 (<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Th&#x27;</span>, (<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;This&#x27;</span>, (<span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>): <span class="hljs-string">&#x27;ou&#x27;</span>, (<span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;se&#x27;</span>, (<span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>): <span class="hljs-string">&#x27;Ġtok&#x27;</span>,
 (<span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>): <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, (<span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>): <span class="hljs-string">&#x27;nd&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;Ġis&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Ġth&#x27;</span>, (<span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;Ġthe&#x27;</span>,
 (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;in&#x27;</span>, (<span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>): <span class="hljs-string">&#x27;Ġab&#x27;</span>, (<span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>}`,wrap:!1}}),Ss=new U({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),Gs=new U({props:{code:"JTVCJyUzQyU3Q2VuZG9mdGV4dCU3QyUzRSclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdkJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdrJyUyQyUyMCdsJyUyQyUyMCdtJyUyQyUyMCduJyUyQyUyMCdvJyUyQyUwQSUyMCdwJyUyQyUyMCdyJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd2JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCd6JyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMHQnJTJDJTIwJ2lzJyUyQyUyMCdlciclMkMlMjAnJUM0JUEwYSclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2VuJyUyQyUyMCdUaCclMkMlMjAnVGhpcyclMkMlMjAnb3UnJTJDJTIwJ3NlJyUyQyUwQSUyMCclQzQlQTB0b2snJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCduZCclMkMlMjAnJUM0JUEwaXMnJTJDJTIwJyVDNCVBMHRoJyUyQyUyMCclQzQlQTB0aGUnJTJDJTIwJ2luJyUyQyUyMCclQzQlQTBhYiclMkMlMjAnJUM0JUEwdG9rZW5pJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;&lt;|endoftext|&gt;&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>,
 <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;se&#x27;</span>,
 <span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;nd&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;Ġab&#x27;</span>, <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>]`,wrap:!1}}),f=new Ys({props:{$$slots:{default:[qt]},$$scope:{ctx:m}}}),_s=new U({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBzcGxpdHMlMjAlM0QlMjAlNUIlNUJsJTIwZm9yJTIwbCUyMGluJTIwd29yZCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHByZV90b2tlbml6ZWRfdGV4dCU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBtZXJnZSUyMGluJTIwbWVyZ2VzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpZHglMkMlMjBzcGxpdCUyMGluJTIwZW51bWVyYXRlKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdoaWxlJTIwaSUyMCUzQyUyMGxlbihzcGxpdCklMjAtJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3BsaXQlNUJpJTVEJTIwJTNEJTNEJTIwcGFpciU1QjAlNUQlMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwcGFpciU1QjElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0JTVCJTNBaSU1RCUyMCUyQiUyMCU1Qm1lcmdlJTVEJTIwJTJCJTIwc3BsaXQlNUJpJTIwJTJCJTIwMiUyMCUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0cyU1QmlkeCU1RCUyMCUzRCUyMHNwbGl0JTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKHNwbGl0cyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    splits = [[l <span class="hljs-keyword">for</span> l <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">for</span> pair, merge <span class="hljs-keyword">in</span> merges.items():
        <span class="hljs-keyword">for</span> idx, split <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(splits):
            i = <span class="hljs-number">0</span>
            <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
                <span class="hljs-keyword">if</span> split[i] == pair[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == pair[<span class="hljs-number">1</span>]:
                    split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
                <span class="hljs-keyword">else</span>:
                    i += <span class="hljs-number">1</span>
            splits[idx] = split

    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(splits, [])`,wrap:!1}}),Xs=new U({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwbm90JTIwYSUyMHRva2VuLiUyMik=",highlighted:'tokenize(<span class="hljs-string">&quot;This is not a token.&quot;</span>)',wrap:!1}}),Ds=new U({props:{code:"JTVCJ1RoaXMnJTJDJTIwJyVDNCVBMGlzJyUyQyUyMCclQzQlQTAnJTJDJTIwJ24nJTJDJTIwJ28nJTJDJTIwJ3QnJTJDJTIwJyVDNCVBMGEnJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCcuJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),I=new Ys({props:{warning:!0,$$slots:{default:[Qt]},$$scope:{ctx:m}}}),Rs=new Ct({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter6/5.mdx"}}),{c(){p=j("meta"),w=a(),h=j("p"),T=a(),M(b.$$.fragment),Fs=a(),M(k.$$.fragment),Ls=a(),M($.$$.fragment),Os=a(),q=j("p"),q.textContent=bn,sl=a(),M(Q.$$.fragment),ll=a(),M(g.$$.fragment),nl=a(),M(A.$$.fragment),tl=a(),B=j("p"),B.textContent=kn,al=a(),M(z.$$.fragment),el=a(),V=j("p"),V.innerHTML=$n,pl=a(),M(x.$$.fragment),Ml=a(),v=j("p"),v.innerHTML=qn,il=a(),E=j("p"),E.textContent=Qn,yl=a(),Z=j("p"),Z.textContent=An,rl=a(),M(S.$$.fragment),ol=a(),G=j("p"),G.innerHTML=Bn,cl=a(),M(N.$$.fragment),jl=a(),_=j("p"),_.innerHTML=zn,Jl=a(),H=j("p"),H.innerHTML=Vn,hl=a(),M(X.$$.fragment),ul=a(),D=j("p"),D.innerHTML=vn,Ul=a(),M(W.$$.fragment),wl=a(),R=j("p"),R.innerHTML=En,Tl=a(),M(Y.$$.fragment),ml=a(),P=j("p"),P.textContent=Zn,gl=a(),M(C.$$.fragment),xl=a(),M(K.$$.fragment),Cl=a(),F=j("p"),F.textContent=Sn,dl=a(),L=j("ol"),L.innerHTML=Gn,fl=a(),O=j("p"),O.textContent=Nn,Il=a(),M(ss.$$.fragment),bl=a(),ls=j("p"),ls.innerHTML=_n,kl=a(),M(d.$$.fragment),$l=a(),M(ns.$$.fragment),ql=a(),ts=j("p"),ts.textContent=Hn,Ql=a(),as=j("p"),as.textContent=Xn,Al=a(),M(es.$$.fragment),Bl=a(),ps=j("p"),ps.innerHTML=Dn,zl=a(),M(Ms.$$.fragment),Vl=a(),is=j("p"),is.textContent=Wn,vl=a(),M(ys.$$.fragment),El=a(),M(rs.$$.fragment),Zl=a(),os=j("p"),os.textContent=Rn,Sl=a(),M(cs.$$.fragment),Gl=a(),M(js.$$.fragment),Nl=a(),Js=j("p"),Js.innerHTML=Yn,_l=a(),M(hs.$$.fragment),Hl=a(),us=j("p"),us.textContent=Pn,Xl=a(),M(Us.$$.fragment),Dl=a(),ws=j("p"),ws.textContent=Kn,Wl=a(),M(Ts.$$.fragment),Rl=a(),ms=j("p"),ms.textContent=Fn,Yl=a(),M(gs.$$.fragment),Pl=a(),M(xs.$$.fragment),Kl=a(),Cs=j("p"),Cs.textContent=Ln,Fl=a(),M(ds.$$.fragment),Ll=a(),M(fs.$$.fragment),Ol=a(),Is=j("p"),Is.innerHTML=On,sn=a(),M(bs.$$.fragment),ln=a(),ks=j("p"),ks.innerHTML=st,nn=a(),M($s.$$.fragment),tn=a(),qs=j("p"),qs.textContent=lt,an=a(),M(Qs.$$.fragment),en=a(),M(As.$$.fragment),pn=a(),Bs=j("p"),Bs.textContent=nt,Mn=a(),M(zs.$$.fragment),yn=a(),Vs=j("p"),Vs.textContent=tt,rn=a(),M(vs.$$.fragment),on=a(),M(Es.$$.fragment),cn=a(),Zs=j("p"),Zs.textContent=at,jn=a(),M(Ss.$$.fragment),Jn=a(),M(Gs.$$.fragment),hn=a(),M(f.$$.fragment),un=a(),Ns=j("p"),Ns.textContent=et,Un=a(),M(_s.$$.fragment),wn=a(),Hs=j("p"),Hs.textContent=pt,Tn=a(),M(Xs.$$.fragment),mn=a(),M(Ds.$$.fragment),gn=a(),M(I.$$.fragment),xn=a(),Ws=j("p"),Ws.textContent=Mt,Cn=a(),M(Rs.$$.fragment),dn=a(),Ks=j("p"),this.h()},l(s){const l=mt("svelte-u9bgzb",document.head);p=J(l,"META",{name:!0,content:!0}),l.forEach(n),w=e(s),h=J(s,"P",{}),Jt(h).forEach(n),T=e(s),i(b.$$.fragment,s),Fs=e(s),i(k.$$.fragment,s),Ls=e(s),i($.$$.fragment,s),Os=e(s),q=J(s,"P",{"data-svelte-h":!0}),u(q)!=="svelte-1ys35ik"&&(q.textContent=bn),sl=e(s),i(Q.$$.fragment,s),ll=e(s),i(g.$$.fragment,s),nl=e(s),i(A.$$.fragment,s),tl=e(s),B=J(s,"P",{"data-svelte-h":!0}),u(B)!=="svelte-shk7i3"&&(B.textContent=kn),al=e(s),i(z.$$.fragment,s),el=e(s),V=J(s,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1ld47wc"&&(V.innerHTML=$n),pl=e(s),i(x.$$.fragment,s),Ml=e(s),v=J(s,"P",{"data-svelte-h":!0}),u(v)!=="svelte-dxqp15"&&(v.innerHTML=qn),il=e(s),E=J(s,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1jt9hdc"&&(E.textContent=Qn),yl=e(s),Z=J(s,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-tn0v5v"&&(Z.textContent=An),rl=e(s),i(S.$$.fragment,s),ol=e(s),G=J(s,"P",{"data-svelte-h":!0}),u(G)!=="svelte-253fgn"&&(G.innerHTML=Bn),cl=e(s),i(N.$$.fragment,s),jl=e(s),_=J(s,"P",{"data-svelte-h":!0}),u(_)!=="svelte-tikeus"&&(_.innerHTML=zn),Jl=e(s),H=J(s,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1ba7gki"&&(H.innerHTML=Vn),hl=e(s),i(X.$$.fragment,s),ul=e(s),D=J(s,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1jrr3se"&&(D.innerHTML=vn),Ul=e(s),i(W.$$.fragment,s),wl=e(s),R=J(s,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1r77sw4"&&(R.innerHTML=En),Tl=e(s),i(Y.$$.fragment,s),ml=e(s),P=J(s,"P",{"data-svelte-h":!0}),u(P)!=="svelte-1vbc3ju"&&(P.textContent=Zn),gl=e(s),i(C.$$.fragment,s),xl=e(s),i(K.$$.fragment,s),Cl=e(s),F=J(s,"P",{"data-svelte-h":!0}),u(F)!=="svelte-16041kn"&&(F.textContent=Sn),dl=e(s),L=J(s,"OL",{"data-svelte-h":!0}),u(L)!=="svelte-hczz4s"&&(L.innerHTML=Gn),fl=e(s),O=J(s,"P",{"data-svelte-h":!0}),u(O)!=="svelte-waistw"&&(O.textContent=Nn),Il=e(s),i(ss.$$.fragment,s),bl=e(s),ls=J(s,"P",{"data-svelte-h":!0}),u(ls)!=="svelte-57ne5c"&&(ls.innerHTML=_n),kl=e(s),i(d.$$.fragment,s),$l=e(s),i(ns.$$.fragment,s),ql=e(s),ts=J(s,"P",{"data-svelte-h":!0}),u(ts)!=="svelte-1vmiqby"&&(ts.textContent=Hn),Ql=e(s),as=J(s,"P",{"data-svelte-h":!0}),u(as)!=="svelte-ihocys"&&(as.textContent=Xn),Al=e(s),i(es.$$.fragment,s),Bl=e(s),ps=J(s,"P",{"data-svelte-h":!0}),u(ps)!=="svelte-17swp54"&&(ps.innerHTML=Dn),zl=e(s),i(Ms.$$.fragment,s),Vl=e(s),is=J(s,"P",{"data-svelte-h":!0}),u(is)!=="svelte-1piuede"&&(is.textContent=Wn),vl=e(s),i(ys.$$.fragment,s),El=e(s),i(rs.$$.fragment,s),Zl=e(s),os=J(s,"P",{"data-svelte-h":!0}),u(os)!=="svelte-1n97usn"&&(os.textContent=Rn),Sl=e(s),i(cs.$$.fragment,s),Gl=e(s),i(js.$$.fragment,s),Nl=e(s),Js=J(s,"P",{"data-svelte-h":!0}),u(Js)!=="svelte-bp8or4"&&(Js.innerHTML=Yn),_l=e(s),i(hs.$$.fragment,s),Hl=e(s),us=J(s,"P",{"data-svelte-h":!0}),u(us)!=="svelte-pe9yho"&&(us.textContent=Pn),Xl=e(s),i(Us.$$.fragment,s),Dl=e(s),ws=J(s,"P",{"data-svelte-h":!0}),u(ws)!=="svelte-i39iqv"&&(ws.textContent=Kn),Wl=e(s),i(Ts.$$.fragment,s),Rl=e(s),ms=J(s,"P",{"data-svelte-h":!0}),u(ms)!=="svelte-h8brnl"&&(ms.textContent=Fn),Yl=e(s),i(gs.$$.fragment,s),Pl=e(s),i(xs.$$.fragment,s),Kl=e(s),Cs=J(s,"P",{"data-svelte-h":!0}),u(Cs)!=="svelte-19ljpex"&&(Cs.textContent=Ln),Fl=e(s),i(ds.$$.fragment,s),Ll=e(s),i(fs.$$.fragment,s),Ol=e(s),Is=J(s,"P",{"data-svelte-h":!0}),u(Is)!=="svelte-m36xi"&&(Is.innerHTML=On),sn=e(s),i(bs.$$.fragment,s),ln=e(s),ks=J(s,"P",{"data-svelte-h":!0}),u(ks)!=="svelte-1pmzgqr"&&(ks.innerHTML=st),nn=e(s),i($s.$$.fragment,s),tn=e(s),qs=J(s,"P",{"data-svelte-h":!0}),u(qs)!=="svelte-d7zdjw"&&(qs.textContent=lt),an=e(s),i(Qs.$$.fragment,s),en=e(s),i(As.$$.fragment,s),pn=e(s),Bs=J(s,"P",{"data-svelte-h":!0}),u(Bs)!=="svelte-1vwdf9c"&&(Bs.textContent=nt),Mn=e(s),i(zs.$$.fragment,s),yn=e(s),Vs=J(s,"P",{"data-svelte-h":!0}),u(Vs)!=="svelte-1r8l9ln"&&(Vs.textContent=tt),rn=e(s),i(vs.$$.fragment,s),on=e(s),i(Es.$$.fragment,s),cn=e(s),Zs=J(s,"P",{"data-svelte-h":!0}),u(Zs)!=="svelte-okpg4u"&&(Zs.textContent=at),jn=e(s),i(Ss.$$.fragment,s),Jn=e(s),i(Gs.$$.fragment,s),hn=e(s),i(f.$$.fragment,s),un=e(s),Ns=J(s,"P",{"data-svelte-h":!0}),u(Ns)!=="svelte-15zp2fc"&&(Ns.textContent=et),Un=e(s),i(_s.$$.fragment,s),wn=e(s),Hs=J(s,"P",{"data-svelte-h":!0}),u(Hs)!=="svelte-dgrd5"&&(Hs.textContent=pt),Tn=e(s),i(Xs.$$.fragment,s),mn=e(s),i(Ds.$$.fragment,s),gn=e(s),i(I.$$.fragment,s),xn=e(s),Ws=J(s,"P",{"data-svelte-h":!0}),u(Ws)!=="svelte-b3ofc6"&&(Ws.textContent=Mt),Cn=e(s),i(Rs.$$.fragment,s),dn=e(s),Ks=J(s,"P",{}),Jt(Ks).forEach(n),this.h()},h(){ht(p,"name","hf:doc:metadata"),ht(p,"content",Bt)},m(s,l){gt(document.head,p),t(s,w,l),t(s,h,l),t(s,T,l),y(b,s,l),t(s,Fs,l),y(k,s,l),t(s,Ls,l),y($,s,l),t(s,Os,l),t(s,q,l),t(s,sl,l),y(Q,s,l),t(s,ll,l),y(g,s,l),t(s,nl,l),y(A,s,l),t(s,tl,l),t(s,B,l),t(s,al,l),y(z,s,l),t(s,el,l),t(s,V,l),t(s,pl,l),y(x,s,l),t(s,Ml,l),t(s,v,l),t(s,il,l),t(s,E,l),t(s,yl,l),t(s,Z,l),t(s,rl,l),y(S,s,l),t(s,ol,l),t(s,G,l),t(s,cl,l),y(N,s,l),t(s,jl,l),t(s,_,l),t(s,Jl,l),t(s,H,l),t(s,hl,l),y(X,s,l),t(s,ul,l),t(s,D,l),t(s,Ul,l),y(W,s,l),t(s,wl,l),t(s,R,l),t(s,Tl,l),y(Y,s,l),t(s,ml,l),t(s,P,l),t(s,gl,l),y(C,s,l),t(s,xl,l),y(K,s,l),t(s,Cl,l),t(s,F,l),t(s,dl,l),t(s,L,l),t(s,fl,l),t(s,O,l),t(s,Il,l),y(ss,s,l),t(s,bl,l),t(s,ls,l),t(s,kl,l),y(d,s,l),t(s,$l,l),y(ns,s,l),t(s,ql,l),t(s,ts,l),t(s,Ql,l),t(s,as,l),t(s,Al,l),y(es,s,l),t(s,Bl,l),t(s,ps,l),t(s,zl,l),y(Ms,s,l),t(s,Vl,l),t(s,is,l),t(s,vl,l),y(ys,s,l),t(s,El,l),y(rs,s,l),t(s,Zl,l),t(s,os,l),t(s,Sl,l),y(cs,s,l),t(s,Gl,l),y(js,s,l),t(s,Nl,l),t(s,Js,l),t(s,_l,l),y(hs,s,l),t(s,Hl,l),t(s,us,l),t(s,Xl,l),y(Us,s,l),t(s,Dl,l),t(s,ws,l),t(s,Wl,l),y(Ts,s,l),t(s,Rl,l),t(s,ms,l),t(s,Yl,l),y(gs,s,l),t(s,Pl,l),y(xs,s,l),t(s,Kl,l),t(s,Cs,l),t(s,Fl,l),y(ds,s,l),t(s,Ll,l),y(fs,s,l),t(s,Ol,l),t(s,Is,l),t(s,sn,l),y(bs,s,l),t(s,ln,l),t(s,ks,l),t(s,nn,l),y($s,s,l),t(s,tn,l),t(s,qs,l),t(s,an,l),y(Qs,s,l),t(s,en,l),y(As,s,l),t(s,pn,l),t(s,Bs,l),t(s,Mn,l),y(zs,s,l),t(s,yn,l),t(s,Vs,l),t(s,rn,l),y(vs,s,l),t(s,on,l),y(Es,s,l),t(s,cn,l),t(s,Zs,l),t(s,jn,l),y(Ss,s,l),t(s,Jn,l),y(Gs,s,l),t(s,hn,l),y(f,s,l),t(s,un,l),t(s,Ns,l),t(s,Un,l),y(_s,s,l),t(s,wn,l),t(s,Hs,l),t(s,Tn,l),y(Xs,s,l),t(s,mn,l),y(Ds,s,l),t(s,gn,l),y(I,s,l),t(s,xn,l),t(s,Ws,l),t(s,Cn,l),y(Rs,s,l),t(s,dn,l),t(s,Ks,l),fn=!0},p(s,[l]){const it={};l&2&&(it.$$scope={dirty:l,ctx:s}),g.$set(it);const yt={};l&2&&(yt.$$scope={dirty:l,ctx:s}),x.$set(yt);const rt={};l&2&&(rt.$$scope={dirty:l,ctx:s}),C.$set(rt);const ot={};l&2&&(ot.$$scope={dirty:l,ctx:s}),d.$set(ot);const ct={};l&2&&(ct.$$scope={dirty:l,ctx:s}),f.$set(ct);const jt={};l&2&&(jt.$$scope={dirty:l,ctx:s}),I.$set(jt)},i(s){fn||(r(b.$$.fragment,s),r(k.$$.fragment,s),r($.$$.fragment,s),r(Q.$$.fragment,s),r(g.$$.fragment,s),r(A.$$.fragment,s),r(z.$$.fragment,s),r(x.$$.fragment,s),r(S.$$.fragment,s),r(N.$$.fragment,s),r(X.$$.fragment,s),r(W.$$.fragment,s),r(Y.$$.fragment,s),r(C.$$.fragment,s),r(K.$$.fragment,s),r(ss.$$.fragment,s),r(d.$$.fragment,s),r(ns.$$.fragment,s),r(es.$$.fragment,s),r(Ms.$$.fragment,s),r(ys.$$.fragment,s),r(rs.$$.fragment,s),r(cs.$$.fragment,s),r(js.$$.fragment,s),r(hs.$$.fragment,s),r(Us.$$.fragment,s),r(Ts.$$.fragment,s),r(gs.$$.fragment,s),r(xs.$$.fragment,s),r(ds.$$.fragment,s),r(fs.$$.fragment,s),r(bs.$$.fragment,s),r($s.$$.fragment,s),r(Qs.$$.fragment,s),r(As.$$.fragment,s),r(zs.$$.fragment,s),r(vs.$$.fragment,s),r(Es.$$.fragment,s),r(Ss.$$.fragment,s),r(Gs.$$.fragment,s),r(f.$$.fragment,s),r(_s.$$.fragment,s),r(Xs.$$.fragment,s),r(Ds.$$.fragment,s),r(I.$$.fragment,s),r(Rs.$$.fragment,s),fn=!0)},o(s){o(b.$$.fragment,s),o(k.$$.fragment,s),o($.$$.fragment,s),o(Q.$$.fragment,s),o(g.$$.fragment,s),o(A.$$.fragment,s),o(z.$$.fragment,s),o(x.$$.fragment,s),o(S.$$.fragment,s),o(N.$$.fragment,s),o(X.$$.fragment,s),o(W.$$.fragment,s),o(Y.$$.fragment,s),o(C.$$.fragment,s),o(K.$$.fragment,s),o(ss.$$.fragment,s),o(d.$$.fragment,s),o(ns.$$.fragment,s),o(es.$$.fragment,s),o(Ms.$$.fragment,s),o(ys.$$.fragment,s),o(rs.$$.fragment,s),o(cs.$$.fragment,s),o(js.$$.fragment,s),o(hs.$$.fragment,s),o(Us.$$.fragment,s),o(Ts.$$.fragment,s),o(gs.$$.fragment,s),o(xs.$$.fragment,s),o(ds.$$.fragment,s),o(fs.$$.fragment,s),o(bs.$$.fragment,s),o($s.$$.fragment,s),o(Qs.$$.fragment,s),o(As.$$.fragment,s),o(zs.$$.fragment,s),o(vs.$$.fragment,s),o(Es.$$.fragment,s),o(Ss.$$.fragment,s),o(Gs.$$.fragment,s),o(f.$$.fragment,s),o(_s.$$.fragment,s),o(Xs.$$.fragment,s),o(Ds.$$.fragment,s),o(I.$$.fragment,s),o(Rs.$$.fragment,s),fn=!1},d(s){s&&(n(w),n(h),n(T),n(Fs),n(Ls),n(Os),n(q),n(sl),n(ll),n(nl),n(tl),n(B),n(al),n(el),n(V),n(pl),n(Ml),n(v),n(il),n(E),n(yl),n(Z),n(rl),n(ol),n(G),n(cl),n(jl),n(_),n(Jl),n(H),n(hl),n(ul),n(D),n(Ul),n(wl),n(R),n(Tl),n(ml),n(P),n(gl),n(xl),n(Cl),n(F),n(dl),n(L),n(fl),n(O),n(Il),n(bl),n(ls),n(kl),n($l),n(ql),n(ts),n(Ql),n(as),n(Al),n(Bl),n(ps),n(zl),n(Vl),n(is),n(vl),n(El),n(Zl),n(os),n(Sl),n(Gl),n(Nl),n(Js),n(_l),n(Hl),n(us),n(Xl),n(Dl),n(ws),n(Wl),n(Rl),n(ms),n(Yl),n(Pl),n(Kl),n(Cs),n(Fl),n(Ll),n(Ol),n(Is),n(sn),n(ln),n(ks),n(nn),n(tn),n(qs),n(an),n(en),n(pn),n(Bs),n(Mn),n(yn),n(Vs),n(rn),n(on),n(cn),n(Zs),n(jn),n(Jn),n(hn),n(un),n(Ns),n(Un),n(wn),n(Hs),n(Tn),n(mn),n(gn),n(xn),n(Ws),n(Cn),n(dn),n(Ks)),n(p),c(b,s),c(k,s),c($,s),c(Q,s),c(g,s),c(A,s),c(z,s),c(x,s),c(S,s),c(N,s),c(X,s),c(W,s),c(Y,s),c(C,s),c(K,s),c(ss,s),c(d,s),c(ns,s),c(es,s),c(Ms,s),c(ys,s),c(rs,s),c(cs,s),c(js,s),c(hs,s),c(Us,s),c(Ts,s),c(gs,s),c(xs,s),c(ds,s),c(fs,s),c(bs,s),c($s,s),c(Qs,s),c(As,s),c(zs,s),c(vs,s),c(Es,s),c(Ss,s),c(Gs,s),c(f,s),c(_s,s),c(Xs,s),c(Ds,s),c(I,s),c(Rs,s)}}}const Bt='{"title":"Byte-Pair Encoding tokenization","local":"byte-pair-encoding-tokenization","sections":[{"title":"Training algorithm","local":"training-algorithm","sections":[],"depth":2},{"title":"Tokenization algorithm","local":"tokenization-algorithm","sections":[],"depth":2},{"title":"Implementing BPE","local":"implementing-bpe","sections":[],"depth":2}],"depth":1}';function zt(m){return Ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends wt{constructor(p){super(),Tt(this,p,zt,At,ut,{})}}export{_t as component};
