import{s as Rt,a as ot,n as Qt,o as Xt}from"../chunks/scheduler.cc52f4b9.js";import{S as Yt,i as Vt,e as o,s,c as d,h as Nt,a as i,d as l,b as n,f as ce,g as h,j as p,k as r,l as Pt,m as a,n as y,t as M,o as w,p as f}from"../chunks/index.5b747fde.js";import{C as zt,H as pe,E as Ft}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d38ac5a9.js";import{C as it}from"../chunks/CodeBlock.665bfc37.js";import{C as Kt}from"../chunks/CourseFloatingBanner.b33fcd79.js";function Dt(pt){let T,me,re,de,b,he,J,ye,j,Me,U,rt=`In this section, we will take a closer look at the <code>Interface</code> class, and understand the
main parameters used to create one.`,we,g,fe,v,ut="You’ll notice that the <code>Interface</code> class has 3 required parameters:",Te,I,ct="<code>Interface(fn, inputs, outputs, ...)</code>",be,C,mt="These parameters are:",Je,k,dt="<li><code>fn</code>: the prediction function that is wrapped by the Gradio interface. This function can take one or more parameters and return one or more values</li> <li><code>inputs</code>: the input component type(s). Gradio provides many pre-built components such as<code>&quot;image&quot;</code> or <code>&quot;mic&quot;</code>.</li> <li><code>outputs</code>: the output component type(s). Again, Gradio provides many pre-built components e.g. <code>&quot;image&quot;</code> or <code>&quot;label&quot;</code>.</li>",je,x,ht='For a complete list of components, <a href="https://gradio.app/docs" rel="nofollow">see the Gradio docs </a>. Each pre-built component can be customized by instantiating the class corresponding to the component.',Ue,$,yt=`For example, as we saw in the <a href="/course/chapter9/2">previous section</a>,
instead of passing in <code>&quot;textbox&quot;</code> to the <code>inputs</code> parameter, you can pass in a <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> component to create a textbox with 7 lines and a label.`,ge,q,Mt="Let’s take a look at another example, this time with an <code>Audio</code> component.",ve,_,Ie,A,wt=`As mentioned earlier, Gradio provides many different inputs and outputs.
So let’s build an <code>Interface</code> that works with audio.`,Ce,H,ft=`In this example, we’ll build an audio-to-audio function that takes an
audio file and simply reverses it.`,ke,B,Tt=`We will use for the input the <code>Audio</code> component. When using the <code>Audio</code> component,
you can specify whether you want the <code>source</code> of the audio to be a file that the user
uploads or a microphone that the user records their voice with. In this case, let’s
set it to a <code>&quot;microphone&quot;</code>. Just for fun, we’ll add a label to our <code>Audio</code> that says
“Speak here…“.`,xe,G,bt=`In addition, we’d like to receive the audio as a numpy array so that we can easily
“reverse” it. So we’ll set the <code>&quot;type&quot;</code> to be <code>&quot;numpy&quot;</code>, which passes the input
data as a tuple of (<code>sample_rate</code>, <code>data</code>) into our function.`,$e,L,Jt=`We will also use the <code>Audio</code> output component which can automatically
render a tuple with a sample rate and numpy array of data as a playable audio file.
In this case, we do not need to do any customization, so we will use the string
shortcut <code>&quot;audio&quot;</code>.`,qe,Z,_e,E,jt=`The code above will produce an interface like the one below (if your browser doesn’t
ask you for microphone permissions, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">open the demo in  a separate tab</a>.)`,Ae,u,Ut,He,W,gt="You should now be able to record your voice and hear yourself speaking in reverse - spooky 👻!",Be,S,Ge,R,vt=`Let’s say we had a more complicated function, with multiple inputs and outputs.
In the example below, we have a function that takes a dropdown index, a slider value, and number,
and returns an audio sample of a musical tone.`,Le,Q,It=`Take a look how we pass a list of input and output components,
and see if you can follow along what’s happening.`,Ze,X,Ct="The key here is that when you pass:",Ee,Y,kt="<li>a list of input components, each component corresponds to a parameter in order.</li> <li>a list of output coponents, each component corresponds to a returned value.</li>",We,V,xt="The code snippet below shows how three input components line up with the three arguments of the <code>generate_tone()</code> function:",Se,N,Re,c,$t,Qe,P,Xe,z,qt=`So far, we have used the <code>launch()</code> method to launch the interface, but we
haven’t really discussed what it does.`,Ye,F,_t=`By default, the <code>launch()</code> method will launch the demo in a web server that
is running locally. If you are running your code in a Jupyter or Colab notebook, then
Gradio will embed the demo GUI in the notebook so you can easily use it.`,Ve,K,At="You can customize the behavior of <code>launch()</code> through different parameters:",Ne,D,Ht="<li><code>inline</code> - whether to display the interface inline on Python notebooks.</li> <li><code>inbrowser</code> - whether to automatically launch the interface in a new tab on the default browser.</li> <li><code>share</code> - whether to create a publicly shareable link from your computer for the interface. Kind of like a Google Drive link!</li>",Pe,O,Bt="We’ll cover the <code>share</code> parameter in a lot more detail in the next section!",ze,ee,Fe,te,Gt=`Let’s build an interface that allows you to demo a <strong>speech-recognition</strong> model.
To make it interesting, we will accept <em>either</em> a mic input or an uploaded file.`,Ke,le,Lt=`As usual, we’ll load our speech recognition model using the <code>pipeline()</code> function from 🤗 Transformers.
If you need a quick refresher, you can go back to <a href="/course/chapter1/3">that section in Chapter 1</a>.   Next, we’ll implement a <code>transcribe_audio()</code> function that processes the audio and returns the transcription. Finally, we’ll wrap this function in an <code>Interface</code> with the <code>Audio</code> components for the inputs and just text for the output. Altogether, the code for this application is the following:`,De,ae,Oe,se,Zt='If your browser doesn’t ask you for microphone permissions, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">open the demo in a separate tab</a>.',et,m,Et,tt,ne,Wt=`That’s it! You can now use this interface to transcribe audio. Notice here that
by passing in the <code>optional</code> parameter as <code>True</code>, we allow the user to either
provide a microphone or an audio file (or neither, but that will return an error message).`,lt,oe,St="Keep going to see how to share your interface with others!",at,ie,st,ue,nt;return b=new zt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new pe({props:{title:"Understanding the Interface class",local:"understanding-the-interface-class",headingTag:"h1"}}),j=new Kt({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"}]}}),g=new pe({props:{title:"How to create an Interface",local:"how-to-create-an-interface",headingTag:"h2"}}),_=new pe({props:{title:"A simple example with audio",local:"a-simple-example-with-audio",headingTag:"h2"}}),Z=new it({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),S=new pe({props:{title:"Handling multiple inputs and outputs",local:"handling-multiple-inputs-and-outputs",headingTag:"h2"}}),N=new it({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLk51bWJlcih2YWx1ZSUzRDElMkMlMjBsYWJlbCUzRCUyMkR1cmF0aW9uJTIwaW4lMjBzZWNvbmRzJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvJTIyJTJDJTBBKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Number(value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),P=new pe({props:{title:"The launch() method",local:"the-launch-method",headingTag:"h3"}}),ee=new pe({props:{title:"✏️ Let’s apply it!",local:"lets-apply-it",headingTag:"h2"}}),ae=new it({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKGF1ZGlvKSUzQSUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyh0eXBlJTNEJTIyZmlsZXBhdGglMjIpJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRCUyMnRleHQlMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">audio</span>):
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),ie=new Ft({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter9/3.mdx"}}),{c(){T=o("meta"),me=s(),re=o("p"),de=s(),d(b.$$.fragment),he=s(),d(J.$$.fragment),ye=s(),d(j.$$.fragment),Me=s(),U=o("p"),U.innerHTML=rt,we=s(),d(g.$$.fragment),fe=s(),v=o("p"),v.innerHTML=ut,Te=s(),I=o("p"),I.innerHTML=ct,be=s(),C=o("p"),C.textContent=mt,Je=s(),k=o("ul"),k.innerHTML=dt,je=s(),x=o("p"),x.innerHTML=ht,Ue=s(),$=o("p"),$.innerHTML=yt,ge=s(),q=o("p"),q.innerHTML=Mt,ve=s(),d(_.$$.fragment),Ie=s(),A=o("p"),A.innerHTML=wt,Ce=s(),H=o("p"),H.textContent=ft,ke=s(),B=o("p"),B.innerHTML=Tt,xe=s(),G=o("p"),G.innerHTML=bt,$e=s(),L=o("p"),L.innerHTML=Jt,qe=s(),d(Z.$$.fragment),_e=s(),E=o("p"),E.innerHTML=jt,Ae=s(),u=o("iframe"),He=s(),W=o("p"),W.textContent=gt,Be=s(),d(S.$$.fragment),Ge=s(),R=o("p"),R.textContent=vt,Le=s(),Q=o("p"),Q.textContent=It,Ze=s(),X=o("p"),X.textContent=Ct,Ee=s(),Y=o("ul"),Y.innerHTML=kt,We=s(),V=o("p"),V.innerHTML=xt,Se=s(),d(N.$$.fragment),Re=s(),c=o("iframe"),Qe=s(),d(P.$$.fragment),Xe=s(),z=o("p"),z.innerHTML=qt,Ye=s(),F=o("p"),F.innerHTML=_t,Ve=s(),K=o("p"),K.innerHTML=At,Ne=s(),D=o("ul"),D.innerHTML=Ht,Pe=s(),O=o("p"),O.innerHTML=Bt,ze=s(),d(ee.$$.fragment),Fe=s(),te=o("p"),te.innerHTML=Gt,Ke=s(),le=o("p"),le.innerHTML=Lt,De=s(),d(ae.$$.fragment),Oe=s(),se=o("p"),se.innerHTML=Zt,et=s(),m=o("iframe"),tt=s(),ne=o("p"),ne.innerHTML=Wt,lt=s(),oe=o("p"),oe.textContent=St,at=s(),d(ie.$$.fragment),st=s(),ue=o("p"),this.h()},l(e){const t=Nt("svelte-u9bgzb",document.head);T=i(t,"META",{name:!0,content:!0}),t.forEach(l),me=n(e),re=i(e,"P",{}),ce(re).forEach(l),de=n(e),h(b.$$.fragment,e),he=n(e),h(J.$$.fragment,e),ye=n(e),h(j.$$.fragment,e),Me=n(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-lkknik"&&(U.innerHTML=rt),we=n(e),h(g.$$.fragment,e),fe=n(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1gqpygy"&&(v.innerHTML=ut),Te=n(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-5xxju6"&&(I.innerHTML=ct),be=n(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1srf6cz"&&(C.textContent=mt),Je=n(e),k=i(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-1cwo97x"&&(k.innerHTML=dt),je=n(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-a2tvbr"&&(x.innerHTML=ht),Ue=n(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-fgatqp"&&($.innerHTML=yt),ge=n(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1lphv0c"&&(q.innerHTML=Mt),ve=n(e),h(_.$$.fragment,e),Ie=n(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-ul4i2u"&&(A.innerHTML=wt),Ce=n(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1i37re5"&&(H.textContent=ft),ke=n(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-172zvxz"&&(B.innerHTML=Tt),xe=n(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-4wa24d"&&(G.innerHTML=bt),$e=n(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-13zmab1"&&(L.innerHTML=Jt),qe=n(e),h(Z.$$.fragment,e),_e=n(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-221tzw"&&(E.innerHTML=jt),Ae=n(e),u=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ce(u).forEach(l),He=n(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-12uox4i"&&(W.textContent=gt),Be=n(e),h(S.$$.fragment,e),Ge=n(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-185l475"&&(R.textContent=vt),Le=n(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-wn7sdm"&&(Q.textContent=It),Ze=n(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-15txj5f"&&(X.textContent=Ct),Ee=n(e),Y=i(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-1yoqjoi"&&(Y.innerHTML=kt),We=n(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-rsacrc"&&(V.innerHTML=xt),Se=n(e),h(N.$$.fragment,e),Re=n(e),c=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ce(c).forEach(l),Qe=n(e),h(P.$$.fragment,e),Xe=n(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1drgann"&&(z.innerHTML=qt),Ye=n(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-j2w7rs"&&(F.innerHTML=_t),Ve=n(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-yl79n1"&&(K.innerHTML=At),Ne=n(e),D=i(e,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-f1qyss"&&(D.innerHTML=Ht),Pe=n(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-fugi8a"&&(O.innerHTML=Bt),ze=n(e),h(ee.$$.fragment,e),Fe=n(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-433a1m"&&(te.innerHTML=Gt),Ke=n(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1cy2oyt"&&(le.innerHTML=Lt),De=n(e),h(ae.$$.fragment,e),Oe=n(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-16m1pd5"&&(se.innerHTML=Zt),et=n(e),m=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ce(m).forEach(l),tt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1hnmjbo"&&(ne.innerHTML=Wt),lt=n(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1egous1"&&(oe.textContent=St),at=n(e),h(ie.$$.fragment,e),st=n(e),ue=i(e,"P",{}),ce(ue).forEach(l),this.h()},h(){r(T,"name","hf:doc:metadata"),r(T,"content",Ot),ot(u.src,Ut="https://course-demos-audio-reverse.hf.space")||r(u,"src",Ut),r(u,"frameborder","0"),r(u,"height","250"),r(u,"title","Gradio app"),r(u,"class","container p-0 flex-grow space-iframe"),r(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),ot(c.src,$t="https://course-demos-generate-tone.hf.space")||r(c,"src",$t),r(c,"frameborder","0"),r(c,"height","450"),r(c,"title","Gradio app"),r(c,"class","container p-0 flex-grow space-iframe"),r(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),ot(m.src,Et="https://course-demos-asr.hf.space")||r(m,"src",Et),r(m,"frameborder","0"),r(m,"height","550"),r(m,"title","Gradio app"),r(m,"class","container p-0 flex-grow space-iframe"),r(m,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(m,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Pt(document.head,T),a(e,me,t),a(e,re,t),a(e,de,t),y(b,e,t),a(e,he,t),y(J,e,t),a(e,ye,t),y(j,e,t),a(e,Me,t),a(e,U,t),a(e,we,t),y(g,e,t),a(e,fe,t),a(e,v,t),a(e,Te,t),a(e,I,t),a(e,be,t),a(e,C,t),a(e,Je,t),a(e,k,t),a(e,je,t),a(e,x,t),a(e,Ue,t),a(e,$,t),a(e,ge,t),a(e,q,t),a(e,ve,t),y(_,e,t),a(e,Ie,t),a(e,A,t),a(e,Ce,t),a(e,H,t),a(e,ke,t),a(e,B,t),a(e,xe,t),a(e,G,t),a(e,$e,t),a(e,L,t),a(e,qe,t),y(Z,e,t),a(e,_e,t),a(e,E,t),a(e,Ae,t),a(e,u,t),a(e,He,t),a(e,W,t),a(e,Be,t),y(S,e,t),a(e,Ge,t),a(e,R,t),a(e,Le,t),a(e,Q,t),a(e,Ze,t),a(e,X,t),a(e,Ee,t),a(e,Y,t),a(e,We,t),a(e,V,t),a(e,Se,t),y(N,e,t),a(e,Re,t),a(e,c,t),a(e,Qe,t),y(P,e,t),a(e,Xe,t),a(e,z,t),a(e,Ye,t),a(e,F,t),a(e,Ve,t),a(e,K,t),a(e,Ne,t),a(e,D,t),a(e,Pe,t),a(e,O,t),a(e,ze,t),y(ee,e,t),a(e,Fe,t),a(e,te,t),a(e,Ke,t),a(e,le,t),a(e,De,t),y(ae,e,t),a(e,Oe,t),a(e,se,t),a(e,et,t),a(e,m,t),a(e,tt,t),a(e,ne,t),a(e,lt,t),a(e,oe,t),a(e,at,t),y(ie,e,t),a(e,st,t),a(e,ue,t),nt=!0},p:Qt,i(e){nt||(M(b.$$.fragment,e),M(J.$$.fragment,e),M(j.$$.fragment,e),M(g.$$.fragment,e),M(_.$$.fragment,e),M(Z.$$.fragment,e),M(S.$$.fragment,e),M(N.$$.fragment,e),M(P.$$.fragment,e),M(ee.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),nt=!0)},o(e){w(b.$$.fragment,e),w(J.$$.fragment,e),w(j.$$.fragment,e),w(g.$$.fragment,e),w(_.$$.fragment,e),w(Z.$$.fragment,e),w(S.$$.fragment,e),w(N.$$.fragment,e),w(P.$$.fragment,e),w(ee.$$.fragment,e),w(ae.$$.fragment,e),w(ie.$$.fragment,e),nt=!1},d(e){e&&(l(me),l(re),l(de),l(he),l(ye),l(Me),l(U),l(we),l(fe),l(v),l(Te),l(I),l(be),l(C),l(Je),l(k),l(je),l(x),l(Ue),l($),l(ge),l(q),l(ve),l(Ie),l(A),l(Ce),l(H),l(ke),l(B),l(xe),l(G),l($e),l(L),l(qe),l(_e),l(E),l(Ae),l(u),l(He),l(W),l(Be),l(Ge),l(R),l(Le),l(Q),l(Ze),l(X),l(Ee),l(Y),l(We),l(V),l(Se),l(Re),l(c),l(Qe),l(Xe),l(z),l(Ye),l(F),l(Ve),l(K),l(Ne),l(D),l(Pe),l(O),l(ze),l(Fe),l(te),l(Ke),l(le),l(De),l(Oe),l(se),l(et),l(m),l(tt),l(ne),l(lt),l(oe),l(at),l(st),l(ue)),l(T),f(b,e),f(J,e),f(j,e),f(g,e),f(_,e),f(Z,e),f(S,e),f(N,e),f(P,e),f(ee,e),f(ae,e),f(ie,e)}}}const Ot='{"title":"Understanding the Interface class","local":"understanding-the-interface-class","sections":[{"title":"How to create an Interface","local":"how-to-create-an-interface","sections":[],"depth":2},{"title":"A simple example with audio","local":"a-simple-example-with-audio","sections":[],"depth":2},{"title":"Handling multiple inputs and outputs","local":"handling-multiple-inputs-and-outputs","sections":[{"title":"The launch() method","local":"the-launch-method","sections":[],"depth":3}],"depth":2},{"title":"✏️ Let’s apply it!","local":"lets-apply-it","sections":[],"depth":2}],"depth":1}';function el(pt){return Xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Yt{constructor(T){super(),Vt(this,T,el,Dt,Rt,{})}}export{ol as component};
