# Mastering LLMs[[mastering-llms]]

<CourseFloatingBanner
    chapter={7}
    classNames="absolute z-10 right-0 top-0"
/>

If you've made it this far in the course, congratulations -- you now have all the knowledge and tools you need to tackle (almost) any language task with 🤗 Transformers and the Hugging Face ecosystem!

## From NLP to LLMs

While we've covered many traditional NLP tasks in this course, the field has been revolutionized by Large Language Models (LLMs). These models have dramatically expanded what's possible in language processing:

- They can handle multiple tasks without task-specific fine-tuning
- They excel at following instructions and adapting to different contexts
- They can generate coherent, contextually appropriate text for various applications
- They can perform reasoning and solve complex problems through techniques like chain-of-thought prompting

The foundational NLP skills you've learned are still essential for working with LLMs effectively. Understanding tokenization, model architectures, fine-tuning approaches, and evaluation metrics provides the knowledge needed to leverage LLMs to their full potential.

We have seen a lot of different data collators, so we made this little video to help you find which one to use for each task:

<Youtube id="-RPeakdlHYo"/>

After completing this lightning tour through the core language tasks, you should:

* Know which architectures (encoder, decoder, or encoder-decoder) are best suited for each task
* Understand the difference between pretraining and fine-tuning a language model
* Know how to train Transformer models using either the `Trainer` API and distributed training features of 🤗 Accelerate or TensorFlow and Keras, depending on which track you've been following
* Understand the meaning and limitations of metrics like ROUGE and BLEU for text generation tasks
* Know how to interact with your fine-tuned models, both on the Hub and using the `pipeline` from 🤗 Transformers
* Appreciate how LLMs build upon and extend traditional NLP techniques

Despite all this knowledge, there will come a time when you'll either encounter a difficult bug in your code or have a question about how to solve a particular language processing problem. Fortunately, the Hugging Face community is here to help you! In the final chapter of this part of the course, we'll explore how you can debug your Transformer models and ask for help effectively.

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/en/chapter7/8.mdx" />