# End-of-chapter quiz[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={9}
    classNames="absolute z-10 right-0 top-0"
/>

Let's test what you learned in this chapter!

### 1. What can you use Gradio to do?

<Question
	choices={[
        {
			text: "Create a demo for your machine learning model",
			explain: "With a few lines of python code you can generate a demo for your ML model using our library of pre-built components.",
			correct: true
		},
		{
			text: "Share your machine learning model with others",
			explain: "Using the <code>share=True</code> parameter in the launch method, you can generate a share link to send to anyone.",
            correct: true
		},
		{
			text: "Debug your model",
			explain: "One advantage of a gradio demo is being able to test your model with real data which you can change and observe the model's predictions change in real time, helping you debug your model.",
			correct: true
		},
		{
			text: "Train your model",
			explain: "Gradio is designed to be used for model inference, AFTER your model is trained.",
		}
	]}
/>

### 2. Gradio ONLY works with PyTorch models

<Question
	choices={[
        {
			text: "True",
			explain: "Gradio works with PyTorch models, but also works for any type of machine learning model!"
        },
        {
			text: "False",
			explain: "Gradio is model agnostic, meaning you can create a demo for any type of machine learning model.",
			correct: true
        }
	]}
/>

### 3. Where can you launch a Gradio demo from?

<Question
	choices={[
        {
			text: "Standard python IDEs",
			explain: "Gradio works great with your favorite IDE.",
            correct: true
        },
        {
			text: "Google Colab notebooks",
			explain: "You can create and launch a demo within your Google colab notebook.",
			correct: true
        },
        {
			text: "Jupyter notebooks",
			explain: "Good choice - You can create and launch a demo within your Jupyter notebook.",
			correct: true
        }
	]}
/>

### 4. Gradio is designed primarily for NLP models

<Question
	choices={[
        {
			text: "True",
			explain: "Gradio works with pretty much any data type, not just NLP."
        },
        {
			text: "False",
			explain: "Gradio supplies developers with a library of pre-built components for pretty much all data types.",
            correct: true
        }
	]}
/>

### 5. Which of the following features are supported by Gradio?

<Question
	choices={[
        {
			text: "Multiple inputs and outputs",
			explain: "Multiple inputs and outputs is possible with gradio. All you need to do is pass in a list of inputs and outputs to their corresponding parameters",
            correct: true
        },
        {
			text: "State for data persistance",
			explain: "Gradio is capable of adding state to your interface.",
			correct: true
        },
        {
			text: "Username and passwords authentication",
			explain: "Pass in a list of username/password tuples to the launch method to add authentication.",
			correct: true
        },
        {
			text: "Automatic analytics for who uses your gradio demo",
			explain: "Try again - Gradio does not supply developers analytics on who uses their demos."
        },
        {
			text: "Loading a model from Hugging Face's model hub or Hugging Face Spaces",
			explain: "Absolutely - load any Hugging Face model using the <code>gr.Interface.load()</code> method",
			correct: true
        }
	]}
/>

### 6. Which of the following are valid ways of loading a Hugging Face model from Hub or Spaces?

<Question
	choices={[
        {
			text: "gr.Interface.load('huggingface/{user}/{model_name}')",
			explain: "This is a valid method of loading a Hugging Face model from the Hub",
            correct: true
        },
        {
			text: "gr.Interface.load('model/{user}/{model_name}')",
			explain: "This is a valid method of loading a Hugging Face model from the Hub",
			correct: true
        },
        {
			text: "gr.Interface.load('demos/{user}/{model_name}')",
			explain: "Try again -- you cannot load a model by using the 'demos' prefix."
        },
        {
			text: "gr.Interface.load('spaces/{user}/{model_name}')",
			explain: "This is a valid method of loading a Hugging Face model from Spaces",
			correct: true
        }
	]}
/>

### 7. Select all the steps necessary for adding state to your Gradio interface

<Question
	choices={[
        {
			text: "Pass in an extra parameter into your prediction function, which represents the state of the interface.",
			explain: "An extra parameter storing history or state of your interface is necessary.",
            correct: true
        },
        {
			text: "At the end of the prediction function, return the updated value of the state as an extra return value.",
			explain: "This history or state value needs to be returned by your function.",
            correct: true
        },
        {
			text: "Add the state input and state output components when creating your Interface",
			explain: "Gradio provides a state input and output component to persist data.",
            correct: true
        }
	]}
/>

### 8. Which of the following are components included in the Gradio library?

<Question
	choices={[
        {
			text: "Textbox.",
			explain: "Yes, you can create textboxes with the Textbox component.",
            correct: true
        },
        {
			text: "Graph.",
			explain: "There is currently no Graph component.",
        },
        {
			text: "Image.",
			explain: "Yes, you can create an image upload widget with the Image component.",
            correct: true
        },
        {
			text: "Audio.",
			explain: "Yes, you can create an audio upload widget with the Audio component.",
            correct: true
        },
	]}
/>

### 9. What does Gradio `Blocks` allow you to do?

<Question
	choices={[
        {
			text: "Combine multiple demos into one web app",
			explain: "You can use the `with gradio.Tabs():` to add tabs for multiple demos",
			correct: true
        },
        {
			text: "Assign event triggers such as clicked/changed/etc to `Blocks` components",
			explain: "When you assign an event, you pass in three parameters: fn: the function that should be called, inputs: the (list) of input component(s), and outputs: the (list) of output components that should be called.",
			correct: true
        },
        {
			text: "Automatically determine which `Blocks` component should be interactive vs. static",
			explain: "Based on the event triggers you define, `Blocks` automatically figures out whether a component should accept user input or not.",
			correct: true
        },
		 {
			text: "Create multi-step demos; meaning allowing you to reuse the output of one component as the input to the next",
			explain: "You can use a component for the input of one event trigger but the output of another.",
            correct: true
        },
	]}
/>

### 10. You can share a public link to a `Blocks` demo and host a `Blocks` demo on Hugging Face spaces.

<Question
	choices={[
        {
			text: "True",
			explain: "Just like `Interface`, all of the sharing and hosting capabilities are the same for `Blocks` demos!",
			correct: true
        },
        {
			text: "False",
			explain: "Just like `Interface`, all of the sharing and hosting capabilities are the same for `Blocks` demos!",
			correct: false
        }
	]}
/>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/en/chapter9/9.mdx" />