import{s as ha,o as fa,n as Ca}from"../chunks/scheduler.cc52f4b9.js";import{S as Za,i as Ia,e as M,s as t,c as o,h as $a,a as d,d as a,b as n,f as Ja,g as r,j as u,k as wa,l as Ba,m as s,n as p,t as i,o as c,p as m,u as Ga,v as ga}from"../chunks/index.f7fb5439.js";import{T as Ua}from"../chunks/Tip.c708fc3b.js";import{C as ka,E as Xa}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.4aef24b6.js";import{Y as Ta}from"../chunks/Youtube.5391c1b7.js";import{C as y}from"../chunks/CodeBlock.c4d86f9a.js";import{C as va}from"../chunks/CourseFloatingBanner.9c415528.js";import{H as ke}from"../chunks/Heading.b75cdeb1.js";function Wa(Be){let b,j="✏️ <strong>Inténtalo!</strong> Modifica el bucle de entrenamiento anterior para ajustar tu modelo en el conjunto de datos SST-2.";return{c(){b=M("p"),b.innerHTML=j},l(J){b=d(J,"P",{"data-svelte-h":!0}),u(b)!=="svelte-vsapoy"&&(b.innerHTML=j)},m(J,Ge){s(J,b,Ge)},p:Ca,d(J){J&&a(b)}}}function Ra(Be){let b;return{c(){b=Ga('⚠️ Para obtener el beneficio de la aceleración ofrecida por los TPUs de la\n  nube, recomendamos rellenar las muestras hasta una longitud fija con los\n  argumentos `padding="max_length"` y `max_length` del tokenizador.')},l(j){b=ga(j,'⚠️ Para obtener el beneficio de la aceleración ofrecida por los TPUs de la\n  nube, recomendamos rellenar las muestras hasta una longitud fija con los\n  argumentos `padding="max_length"` y `max_length` del tokenizador.')},m(j,J){s(j,b,J)},d(j){j&&a(b)}}}function _a(Be){let b,j,J,Ge,T,Xe,h,ve,f,We,C,Re,Z,El="Ahora veremos como obtener los mismos resultados de la última sección sin hacer uso de la clase <code>Trainer</code>. De nuevo, asumimos que has hecho el procesamiento de datos en la sección 2. Aquí mostramos un resumen que cubre todo lo que necesitarás.",_e,I,Ye,$,Ae,B,Fl="Antes de escribir nuestro bucle de entrenamiento, necesitaremos definir algunos objetos. Los primeros son los <code>dataloaders</code> (literalmente, “cargadores de datos”) que usaremos para iterar sobre lotes. Pero antes de que podamos definir esos <code>dataloaders</code>, necesitamos aplicar un poquito de preprocesamiento a nuestro <code>tokenized_datasets</code>, para encargarnos de algunas cosas que el <code>Trainer</code> hizo por nosotros de manera automática. Específicamente, necesitamos:",Ve,G,Ql="<li>Remover las columnas correspondientes a valores que el model no espera (como las columnas <code>sentence1</code> y <code>sentence2</code>).</li> <li>Renombrar la columna <code>label</code> con <code>labels</code> (porque el modelo espera el argumento llamado <code>labels</code>).</li> <li>Configurar el formato de los conjuntos de datos para que retornen tensores PyTorch en lugar de listas.</li>",ze,g,Hl="Nuestro <code>tokenized_datasets</code> tiene un método para cada uno de esos pasos:",Ne,k,Ee,X,xl="Ahora podemos verificar que el resultado solo tiene columnas que nuestro modelo aceptará:",Fe,v,Qe,W,Sl="Ahora que esto esta hecho, es fácil definir nuestros <code>dataloaders</code>:",He,R,xe,_,ql="Para verificar rápidamente que no hubo errores en el procesamiento de datos, podemos inspeccionar un lote de la siguiente manera:",Se,Y,qe,A,Le,V,Ll="Nótese que los tamaños serán un poco distintos en tu caso ya que configuramos <code>shuffle=True</code> para el dataloader de entrenamiento y estamos rellenando a la máxima longitud dentro del lote.",Ke,z,Kl="Ahora que hemos completado el preprocesamiento de datos (un objetivo gratificante y al mismo tiempo elusivo para cual cualquier practicante de ML), enfoquémonos en el modelo. Lo vamos a crear exactamente como lo hicimos en la sección anterior.",Pe,N,De,E,Pl="Para asegurarnos de que todo va a salir sin problems durante el entrenamiento, vamos a pasar un lote a este modelo:",Oe,F,el,Q,ll,H,Dl="Todos los modelos 🤗 Transformers van a retornar la pérdida cuando se pasan los <code>labels</code>, y también obtenemos los logits (dos por cada entrada en nuestro lote, asi que es un tensor de tamaño 8 x 2).",al,x,Ol='Estamos casi listos para escribir nuestro bucle de entrenamiento! Nos están faltando dos cosas: un optimizador y un programador de la tasa de aprendizaje. Ya que estamos tratando de replicar a mano lo que el <code>Trainer</code> estaba haciendo, usaremos los mismos valores por defecto. El optimizador usado por el <code>Trainer</code> es <code>AdamW</code>, que es el mismo que Adam, pero con un cambio para la regularización de decremento de los pesos (ver <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">“Decoupled Weight Decay Regularization”</a> por Ilya Loshchilov y Frank Hutter):',sl,S,tl,q,ea="Finalmente, el programador por defecto de la tasa de aprendizaje es un decremento lineal desde al valor máximo (5e-5) hasta 0. Para definirlo apropiadamente, necesitamos saber el número de pasos de entrenamiento que vamos a tener, el cual viene dado por el número de épocas que deseamos correr multiplicado por el número de lotes de entrenamiento (que es el largo de nuestro dataloader de entrenamiento). El <code>Trainer</code> usa tres épocas por defecto, asi que usaremos eso:",nl,L,ol,K,rl,P,pl,D,la="Una última cosa: vamos a querer usar el GPU si tenemos acceso a uno (en un CPU, el entrenamiento puede tomar varias horas en lugar de unos pocos minutos). Para hacer esto, definimos un <code>device</code> sobre el que pondremos nuestro modelo y nuestros lotes:",il,O,cl,ee,ml,le,aa="¡Ya está todo listo para entrenar! Para tener una idea de cuándo va a terminar el entrenamiento, adicionamos una barra de progreso sobre el número de pasos de entrenamiento, usando la librería <code>tqdm</code>:",Ml,ae,dl,se,sa="Puedes ver que la parte central del bucle de entrenamiento luce bastante como el de la introducción. No se incluyó ningún tipo de reportes, asi que este bucle de entrenamiento no va a indicar como se esta desempeñando el modelo. Para eso necesitamos añadir un bucle de evaluación.",ul,te,yl,ne,ta="Como lo hicimos anteriormente, usaremos una métrica ofrecida por la librería 🤗 Evaluate. Ya hemos visto el método <code>metric.compute()</code>, pero de hecho las métricas se pueden acumular sobre los lotes a medida que avanzamos en el bucle de predicción con el método <code>add_batch()</code>. Una vez que hemos acumulado todos los lotes, podemos obtener el resultado final con <code>metric.compute()</code>. Aquí se muestra cómo se puede implementar en un bucle de evaluación:",bl,oe,jl,re,Jl,pe,na="De nuevo, tus resultados serán un tanto diferente debido a la inicialización aleatoria en la cabeza del modelo y el mezclado de los datos, pero deberían tener valores similares.",wl,w,Ul,ie,Tl,ce,hl,me,oa='El bucle de entrenamiento que definimos anteriormente trabaja bien en una sola CPU o GPU. Pero usando la librería <a href="https://github.com/huggingface/accelerate" rel="nofollow">Accelerate 🤗</a>, con solo pocos ajustes podemos habilitar el entrenamiento distribuido en múltiples GPUs o CPUs. Comenzando con la creación de los dataloaders de entrenamiento y validación, aquí se muestra como luce nuestro bucle de entrenamiento:',fl,Me,Cl,de,ra="Y aquí están los cambios:",Zl,ue,Il,ye,pa="La primera línea a agregarse es la línea del <code>import</code>. La segunda línea crea un objeto <code>Accelerator</code> que revisa el ambiente e inicializa la configuración distribuida apropiada. La librería 🤗 Accelerate se encarga de asignarte el dispositivo, para que puedas remover las líneas que ponen el modelo en el dispositivo (o si prefieres, cámbialas para usar el <code>accelerator.device</code> en lugar de <code>device</code>).",$l,be,ia="Ahora la mayor parte del trabajo se hace en la línea que envía los <code>dataloaders</code>, el modelo y el optimizador al <code>accelerator.prepare()</code>. Este va a envolver esos objetos en el contenedor apropiado para asegurarse que tu entrenamiento distribuido funcione como se espera. Los cambios que quedan son remover la línea que coloca el lote en el <code>device</code> (de nuevo, si deseas dejarlo así bastaría con cambiarlo para que use el <code>accelerator.device</code>) y reemplazar <code>loss.backward()</code> con <code>accelerator.backward(loss)</code>.",Bl,U,Gl,je,ca="Si deseas copiarlo y pegarlo para probar, así es como luce el bucle completo de entrenamiento con 🤗 Accelerate:",gl,Je,kl,we,ma="Colocando esto en un script <code>train.py</code> permitirá que el mismo sea ejecutable en cualquier configuración distribuida. Para probarlo en tu configuración distribuida, ejecuta el siguiente comando:",Xl,Ue,vl,Te,Ma="el cual hará algunas preguntas y guardará tus respuestas en un archivo de configuración usado por este comando:",Wl,he,Rl,fe,da="el cual iniciará en entrenamiento distribuido.",_l,Ce,ua="Si deseas ejecutar esto en un Notebook (por ejemplo, para probarlo con TPUs en Colab), solo pega el código en una <code>training_function()</code> y ejecuta la última celda con:",Yl,Ze,Al,Ie,ya='Puedes encontrar más ejemplos en el <a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">repositorio 🤗 Accelerate</a>.',Vl,$e,zl,ge,Nl;return T=new ka({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),h=new ke({props:{title:"Un entrenamiento completo",local:"un-entrenamiento-completo",headingTag:"h1"}}),f=new va({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/es/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/es/chapter3/section4.ipynb"}]}}),C=new Ta({props:{id:"Dh9CL8fyG80"}}),I=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),$=new ke({props:{title:"Prepárate para el entrenamiento",local:"prepárate-para-el-entrenamiento",headingTag:"h3"}}),k=new y({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),v=new y({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),R=new y({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),Y=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),A=new y({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),N=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),F=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),Q=new y({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),S=new y({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),L=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),K=new y({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),P=new ke({props:{title:"El bucle de entrenamiento",local:"el-bucle-de-entrenamiento",headingTag:"h3"}}),O=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),ee=new y({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),ae=new y({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),te=new ke({props:{title:"El bucle de evaluación",local:"el-bucle-de-evaluación",headingTag:"h3"}}),oe=new y({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),re=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),w=new Ua({props:{$$slots:{default:[Wa]},$$scope:{ctx:Be}}}),ie=new ke({props:{title:"Repotencia tu bucle de entrenamiento con Accelerate 🤗",local:"repotencia-tu-bucle-de-entrenamiento-con-accelerate-",headingTag:"h3"}}),ce=new Ta({props:{id:"s7dy8QRgjJ0"}}),Me=new y({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMGdldF9zY2hlZHVsZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTUpJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIpJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTBBbW9kZWwudG8oZGV2aWNlKSUwQSUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBbnVtX3RyYWluaW5nX3N0ZXBzJTIwJTNEJTIwbnVtX2Vwb2NocyUyMColMjBsZW4odHJhaW5fZGF0YWxvYWRlciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),ue=new y({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from torch.optim import AdamW
  from transformers import AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),U=new Ua({props:{$$slots:{default:[Ra]},$$scope:{ctx:Be}}}),Je=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),Ue=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),he=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),Ze=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),$e=new Xa({props:{source:"https://github.com/huggingface/course/blob/main/chapters/es/chapter3/4.mdx"}}),{c(){b=M("meta"),j=t(),J=M("p"),Ge=t(),o(T.$$.fragment),Xe=t(),o(h.$$.fragment),ve=t(),o(f.$$.fragment),We=t(),o(C.$$.fragment),Re=t(),Z=M("p"),Z.innerHTML=El,_e=t(),o(I.$$.fragment),Ye=t(),o($.$$.fragment),Ae=t(),B=M("p"),B.innerHTML=Fl,Ve=t(),G=M("ul"),G.innerHTML=Ql,ze=t(),g=M("p"),g.innerHTML=Hl,Ne=t(),o(k.$$.fragment),Ee=t(),X=M("p"),X.textContent=xl,Fe=t(),o(v.$$.fragment),Qe=t(),W=M("p"),W.innerHTML=Sl,He=t(),o(R.$$.fragment),xe=t(),_=M("p"),_.textContent=ql,Se=t(),o(Y.$$.fragment),qe=t(),o(A.$$.fragment),Le=t(),V=M("p"),V.innerHTML=Ll,Ke=t(),z=M("p"),z.textContent=Kl,Pe=t(),o(N.$$.fragment),De=t(),E=M("p"),E.textContent=Pl,Oe=t(),o(F.$$.fragment),el=t(),o(Q.$$.fragment),ll=t(),H=M("p"),H.innerHTML=Dl,al=t(),x=M("p"),x.innerHTML=Ol,sl=t(),o(S.$$.fragment),tl=t(),q=M("p"),q.innerHTML=ea,nl=t(),o(L.$$.fragment),ol=t(),o(K.$$.fragment),rl=t(),o(P.$$.fragment),pl=t(),D=M("p"),D.innerHTML=la,il=t(),o(O.$$.fragment),cl=t(),o(ee.$$.fragment),ml=t(),le=M("p"),le.innerHTML=aa,Ml=t(),o(ae.$$.fragment),dl=t(),se=M("p"),se.textContent=sa,ul=t(),o(te.$$.fragment),yl=t(),ne=M("p"),ne.innerHTML=ta,bl=t(),o(oe.$$.fragment),jl=t(),o(re.$$.fragment),Jl=t(),pe=M("p"),pe.textContent=na,wl=t(),o(w.$$.fragment),Ul=t(),o(ie.$$.fragment),Tl=t(),o(ce.$$.fragment),hl=t(),me=M("p"),me.innerHTML=oa,fl=t(),o(Me.$$.fragment),Cl=t(),de=M("p"),de.textContent=ra,Zl=t(),o(ue.$$.fragment),Il=t(),ye=M("p"),ye.innerHTML=pa,$l=t(),be=M("p"),be.innerHTML=ia,Bl=t(),o(U.$$.fragment),Gl=t(),je=M("p"),je.textContent=ca,gl=t(),o(Je.$$.fragment),kl=t(),we=M("p"),we.innerHTML=ma,Xl=t(),o(Ue.$$.fragment),vl=t(),Te=M("p"),Te.textContent=Ma,Wl=t(),o(he.$$.fragment),Rl=t(),fe=M("p"),fe.textContent=da,_l=t(),Ce=M("p"),Ce.innerHTML=ua,Yl=t(),o(Ze.$$.fragment),Al=t(),Ie=M("p"),Ie.innerHTML=ya,Vl=t(),o($e.$$.fragment),zl=t(),ge=M("p"),this.h()},l(e){const l=$a("svelte-u9bgzb",document.head);b=d(l,"META",{name:!0,content:!0}),l.forEach(a),j=n(e),J=d(e,"P",{}),Ja(J).forEach(a),Ge=n(e),r(T.$$.fragment,e),Xe=n(e),r(h.$$.fragment,e),ve=n(e),r(f.$$.fragment,e),We=n(e),r(C.$$.fragment,e),Re=n(e),Z=d(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-1ifzt2p"&&(Z.innerHTML=El),_e=n(e),r(I.$$.fragment,e),Ye=n(e),r($.$$.fragment,e),Ae=n(e),B=d(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-22cbaw"&&(B.innerHTML=Fl),Ve=n(e),G=d(e,"UL",{"data-svelte-h":!0}),u(G)!=="svelte-16hg34w"&&(G.innerHTML=Ql),ze=n(e),g=d(e,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1cy77bo"&&(g.innerHTML=Hl),Ne=n(e),r(k.$$.fragment,e),Ee=n(e),X=d(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-8bk5f4"&&(X.textContent=xl),Fe=n(e),r(v.$$.fragment,e),Qe=n(e),W=d(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-18n18t9"&&(W.innerHTML=Sl),He=n(e),r(R.$$.fragment,e),xe=n(e),_=d(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-nt5g3z"&&(_.textContent=ql),Se=n(e),r(Y.$$.fragment,e),qe=n(e),r(A.$$.fragment,e),Le=n(e),V=d(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1yvm52h"&&(V.innerHTML=Ll),Ke=n(e),z=d(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-1954u46"&&(z.textContent=Kl),Pe=n(e),r(N.$$.fragment,e),De=n(e),E=d(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-o48clr"&&(E.textContent=Pl),Oe=n(e),r(F.$$.fragment,e),el=n(e),r(Q.$$.fragment,e),ll=n(e),H=d(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1ozt76r"&&(H.innerHTML=Dl),al=n(e),x=d(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-112fcrr"&&(x.innerHTML=Ol),sl=n(e),r(S.$$.fragment,e),tl=n(e),q=d(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-1qdu95l"&&(q.innerHTML=ea),nl=n(e),r(L.$$.fragment,e),ol=n(e),r(K.$$.fragment,e),rl=n(e),r(P.$$.fragment,e),pl=n(e),D=d(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-zx0gfa"&&(D.innerHTML=la),il=n(e),r(O.$$.fragment,e),cl=n(e),r(ee.$$.fragment,e),ml=n(e),le=d(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-hoxau0"&&(le.innerHTML=aa),Ml=n(e),r(ae.$$.fragment,e),dl=n(e),se=d(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-fku1tj"&&(se.textContent=sa),ul=n(e),r(te.$$.fragment,e),yl=n(e),ne=d(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-hvg8j7"&&(ne.innerHTML=ta),bl=n(e),r(oe.$$.fragment,e),jl=n(e),r(re.$$.fragment,e),Jl=n(e),pe=d(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-10ja0p6"&&(pe.textContent=na),wl=n(e),r(w.$$.fragment,e),Ul=n(e),r(ie.$$.fragment,e),Tl=n(e),r(ce.$$.fragment,e),hl=n(e),me=d(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-p7kfwl"&&(me.innerHTML=oa),fl=n(e),r(Me.$$.fragment,e),Cl=n(e),de=d(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-1sujeb6"&&(de.textContent=ra),Zl=n(e),r(ue.$$.fragment,e),Il=n(e),ye=d(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-pen57s"&&(ye.innerHTML=pa),$l=n(e),be=d(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-1jgz58l"&&(be.innerHTML=ia),Bl=n(e),r(U.$$.fragment,e),Gl=n(e),je=d(e,"P",{"data-svelte-h":!0}),u(je)!=="svelte-1bt6f5g"&&(je.textContent=ca),gl=n(e),r(Je.$$.fragment,e),kl=n(e),we=d(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-19tcwhc"&&(we.innerHTML=ma),Xl=n(e),r(Ue.$$.fragment,e),vl=n(e),Te=d(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-14mqyau"&&(Te.textContent=Ma),Wl=n(e),r(he.$$.fragment,e),Rl=n(e),fe=d(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-hs7y8g"&&(fe.textContent=da),_l=n(e),Ce=d(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-1lpwgeq"&&(Ce.innerHTML=ua),Yl=n(e),r(Ze.$$.fragment,e),Al=n(e),Ie=d(e,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-olr8oz"&&(Ie.innerHTML=ya),Vl=n(e),r($e.$$.fragment,e),zl=n(e),ge=d(e,"P",{}),Ja(ge).forEach(a),this.h()},h(){wa(b,"name","hf:doc:metadata"),wa(b,"content",Ya)},m(e,l){Ba(document.head,b),s(e,j,l),s(e,J,l),s(e,Ge,l),p(T,e,l),s(e,Xe,l),p(h,e,l),s(e,ve,l),p(f,e,l),s(e,We,l),p(C,e,l),s(e,Re,l),s(e,Z,l),s(e,_e,l),p(I,e,l),s(e,Ye,l),p($,e,l),s(e,Ae,l),s(e,B,l),s(e,Ve,l),s(e,G,l),s(e,ze,l),s(e,g,l),s(e,Ne,l),p(k,e,l),s(e,Ee,l),s(e,X,l),s(e,Fe,l),p(v,e,l),s(e,Qe,l),s(e,W,l),s(e,He,l),p(R,e,l),s(e,xe,l),s(e,_,l),s(e,Se,l),p(Y,e,l),s(e,qe,l),p(A,e,l),s(e,Le,l),s(e,V,l),s(e,Ke,l),s(e,z,l),s(e,Pe,l),p(N,e,l),s(e,De,l),s(e,E,l),s(e,Oe,l),p(F,e,l),s(e,el,l),p(Q,e,l),s(e,ll,l),s(e,H,l),s(e,al,l),s(e,x,l),s(e,sl,l),p(S,e,l),s(e,tl,l),s(e,q,l),s(e,nl,l),p(L,e,l),s(e,ol,l),p(K,e,l),s(e,rl,l),p(P,e,l),s(e,pl,l),s(e,D,l),s(e,il,l),p(O,e,l),s(e,cl,l),p(ee,e,l),s(e,ml,l),s(e,le,l),s(e,Ml,l),p(ae,e,l),s(e,dl,l),s(e,se,l),s(e,ul,l),p(te,e,l),s(e,yl,l),s(e,ne,l),s(e,bl,l),p(oe,e,l),s(e,jl,l),p(re,e,l),s(e,Jl,l),s(e,pe,l),s(e,wl,l),p(w,e,l),s(e,Ul,l),p(ie,e,l),s(e,Tl,l),p(ce,e,l),s(e,hl,l),s(e,me,l),s(e,fl,l),p(Me,e,l),s(e,Cl,l),s(e,de,l),s(e,Zl,l),p(ue,e,l),s(e,Il,l),s(e,ye,l),s(e,$l,l),s(e,be,l),s(e,Bl,l),p(U,e,l),s(e,Gl,l),s(e,je,l),s(e,gl,l),p(Je,e,l),s(e,kl,l),s(e,we,l),s(e,Xl,l),p(Ue,e,l),s(e,vl,l),s(e,Te,l),s(e,Wl,l),p(he,e,l),s(e,Rl,l),s(e,fe,l),s(e,_l,l),s(e,Ce,l),s(e,Yl,l),p(Ze,e,l),s(e,Al,l),s(e,Ie,l),s(e,Vl,l),p($e,e,l),s(e,zl,l),s(e,ge,l),Nl=!0},p(e,[l]){const ba={};l&2&&(ba.$$scope={dirty:l,ctx:e}),w.$set(ba);const ja={};l&2&&(ja.$$scope={dirty:l,ctx:e}),U.$set(ja)},i(e){Nl||(i(T.$$.fragment,e),i(h.$$.fragment,e),i(f.$$.fragment,e),i(C.$$.fragment,e),i(I.$$.fragment,e),i($.$$.fragment,e),i(k.$$.fragment,e),i(v.$$.fragment,e),i(R.$$.fragment,e),i(Y.$$.fragment,e),i(A.$$.fragment,e),i(N.$$.fragment,e),i(F.$$.fragment,e),i(Q.$$.fragment,e),i(S.$$.fragment,e),i(L.$$.fragment,e),i(K.$$.fragment,e),i(P.$$.fragment,e),i(O.$$.fragment,e),i(ee.$$.fragment,e),i(ae.$$.fragment,e),i(te.$$.fragment,e),i(oe.$$.fragment,e),i(re.$$.fragment,e),i(w.$$.fragment,e),i(ie.$$.fragment,e),i(ce.$$.fragment,e),i(Me.$$.fragment,e),i(ue.$$.fragment,e),i(U.$$.fragment,e),i(Je.$$.fragment,e),i(Ue.$$.fragment,e),i(he.$$.fragment,e),i(Ze.$$.fragment,e),i($e.$$.fragment,e),Nl=!0)},o(e){c(T.$$.fragment,e),c(h.$$.fragment,e),c(f.$$.fragment,e),c(C.$$.fragment,e),c(I.$$.fragment,e),c($.$$.fragment,e),c(k.$$.fragment,e),c(v.$$.fragment,e),c(R.$$.fragment,e),c(Y.$$.fragment,e),c(A.$$.fragment,e),c(N.$$.fragment,e),c(F.$$.fragment,e),c(Q.$$.fragment,e),c(S.$$.fragment,e),c(L.$$.fragment,e),c(K.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(ae.$$.fragment,e),c(te.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(w.$$.fragment,e),c(ie.$$.fragment,e),c(ce.$$.fragment,e),c(Me.$$.fragment,e),c(ue.$$.fragment,e),c(U.$$.fragment,e),c(Je.$$.fragment,e),c(Ue.$$.fragment,e),c(he.$$.fragment,e),c(Ze.$$.fragment,e),c($e.$$.fragment,e),Nl=!1},d(e){e&&(a(j),a(J),a(Ge),a(Xe),a(ve),a(We),a(Re),a(Z),a(_e),a(Ye),a(Ae),a(B),a(Ve),a(G),a(ze),a(g),a(Ne),a(Ee),a(X),a(Fe),a(Qe),a(W),a(He),a(xe),a(_),a(Se),a(qe),a(Le),a(V),a(Ke),a(z),a(Pe),a(De),a(E),a(Oe),a(el),a(ll),a(H),a(al),a(x),a(sl),a(tl),a(q),a(nl),a(ol),a(rl),a(pl),a(D),a(il),a(cl),a(ml),a(le),a(Ml),a(dl),a(se),a(ul),a(yl),a(ne),a(bl),a(jl),a(Jl),a(pe),a(wl),a(Ul),a(Tl),a(hl),a(me),a(fl),a(Cl),a(de),a(Zl),a(Il),a(ye),a($l),a(be),a(Bl),a(Gl),a(je),a(gl),a(kl),a(we),a(Xl),a(vl),a(Te),a(Wl),a(Rl),a(fe),a(_l),a(Ce),a(Yl),a(Al),a(Ie),a(Vl),a(zl),a(ge)),a(b),m(T,e),m(h,e),m(f,e),m(C,e),m(I,e),m($,e),m(k,e),m(v,e),m(R,e),m(Y,e),m(A,e),m(N,e),m(F,e),m(Q,e),m(S,e),m(L,e),m(K,e),m(P,e),m(O,e),m(ee,e),m(ae,e),m(te,e),m(oe,e),m(re,e),m(w,e),m(ie,e),m(ce,e),m(Me,e),m(ue,e),m(U,e),m(Je,e),m(Ue,e),m(he,e),m(Ze,e),m($e,e)}}}const Ya='{"title":"Un entrenamiento completo","local":"un-entrenamiento-completo","sections":[{"title":"Prepárate para el entrenamiento","local":"prepárate-para-el-entrenamiento","sections":[],"depth":3},{"title":"El bucle de entrenamiento","local":"el-bucle-de-entrenamiento","sections":[],"depth":3},{"title":"El bucle de evaluación","local":"el-bucle-de-evaluación","sections":[],"depth":3},{"title":"Repotencia tu bucle de entrenamiento con Accelerate 🤗","local":"repotencia-tu-bucle-de-entrenamiento-con-accelerate-","sections":[],"depth":3}],"depth":1}';function Aa(Be){return fa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sa extends Za{constructor(b){super(),Ia(this,b,Aa,_a,ha,{})}}export{Sa as component};
