import{s as Un,o as mn,n as Ps}from"../chunks/scheduler.cc52f4b9.js";import{S as Tn,i as hn,e as u,s as e,c as M,h as wn,a as j,d as a,b as t,f as jn,g as i,j as U,k as Jn,l as dn,m as n,n as o,t as r,o as c,p as y}from"../chunks/index.f7fb5439.js";import{T as Ys}from"../chunks/Tip.c708fc3b.js";import{C as gn,E as Cn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.4aef24b6.js";import{Y as xn}from"../chunks/Youtube.5391c1b7.js";import{C as m}from"../chunks/CodeBlock.c4d86f9a.js";import{C as In}from"../chunks/CourseFloatingBanner.9c415528.js";import{H as Ia}from"../chunks/Heading.b75cdeb1.js";function fn(w){let p,T="💡 Esta sección cubre BPE en produndidad, yendo tan lejos como para mostrar una implementación completa. Puedes saltarte hasta el final si sólo quieres una descripción general del algoritmo de tokenización.";return{c(){p=u("p"),p.textContent=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1l9fmnz"&&(p.textContent=T)},m(J,h){n(J,p,h)},p:Ps,d(J){J&&a(p)}}}function bn(w){let p,T="Los tokenizadores de GPT-2 y RoBERTa (que son bastante similares) tienen una manera bien inteligente de lidiar con esto: ellos no miran a las palabras como si estuvieran escritas con caracteres Unicode, sino con bytes. De esa manera el vocabulario base tiene un tamaño pequeño (256), pero cada caracter que te puedas imaginar estará incluido y no terminará convertido en el token “desconocido”. Este truco se llama <em>byte-level BPE</em>.";return{c(){p=u("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1vbdz5"&&(p.innerHTML=T)},m(J,h){n(J,p,h)},p:Ps,d(J){J&&a(p)}}}function qn(w){let p,T="✏️ <strong>Ahora es tu turno!</strong> Cuál crees que será la siguiente regla de fusión?";return{c(){p=u("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1h3ygda"&&(p.innerHTML=T)},m(J,h){n(J,p,h)},p:Ps,d(J){J&&a(p)}}}function $n(w){let p,T="✏️ <strong>Ahora es tu turno!</strong> ¿Cómo crees será tokenizada la palabra <code>&quot;unhug&quot;</code>?";return{c(){p=u("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-iix713"&&(p.innerHTML=T)},m(J,h){n(J,p,h)},p:Ps,d(J){J&&a(p)}}}function kn(w){let p,T="💡 Usar <code>train_new_from_iterator()</code> en el mismo corpus no resultará en exactament el mismo vocabulario. Esto es porque cuando hay una elección del par más frecuente, seleccionamos el primero encontrado, mientras que la librería 🤗 Tokenizers selecciona el primero basado en sus IDs internos.";return{c(){p=u("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-2i5pf2"&&(p.innerHTML=T)},m(J,h){n(J,p,h)},p:Ps,d(J){J&&a(p)}}}function Qn(w){let p,T="⚠️ Nuestra implementación arrojará un error si hay un caracter desconocido dado que no hicimos nada para manejarlos. GPT-2 en realidad no tiene un token desconocido (es imposible obtener un caracter desconocido cuando se usa byte-level BPE), pero esto podría ocurrir acá porque no incluímos todos los posibles bytes en el vocabulario inicial. Este aspectode BPE va más allá del alcance de está sección, por lo que dejaremos los detalles fuera.";return{c(){p=u("p"),p.textContent=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1hld7v5"&&(p.textContent=T)},m(J,h){n(J,p,h)},p:Ps,d(J){J&&a(p)}}}function An(w){let p,T,J,h,b,Fs,q,Ls,$,Os,k,fa="La codificación por pares de byte (Byte-Pair Encoding (BPE)) fue inicialmente desarrollado como un algoritmo para comprimir textos, y luego fue usado por OpenAI para la tokenización al momento de pre-entrenar el modelo GPT. Es usado por un montón de modelos Transformers, incluyendo GPT, GPT-2, RoBERTa, BART, y DeBERTa.",sl,Q,ll,d,al,A,nl,B,ba="El entrenamiento de BPE comienza calculando el conjunto de palabras únicas usada en el corpus (después de completar las etapas de normalización y pre-tokenización), para luego contruir el vocabulario tomando todos los símbolos usados para escribir esas palabras. Como un ejemplo muy simple, digamos que nuestros corpus usa estas cinco palabras:",el,z,tl,E,qa="El vocabulario vase entonces será <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code>. Para casos reales, el vocabulario base contendrá todos los caracteres ASCII, al menos, y probablemente algunos caracteres Unicode también. Si un ejemplo que estás tokenizando usa un caracter que no está en el corpus de entrenamiento, ese caracter será convertido al token “desconocido”. Esa es una razón por la cual muchos modelos de NLP son muy malos analizando contenido con emojis.",pl,g,Ml,v,$a="Luego de obtener el vocabulario base, agregamos nuevos tokens hasta que el tamaño deseado del vocabulario se alcance por medio de aprender <em>fusiones</em> (merges), las cuales son reglas para fusionar dos elementos del vocabulario existente en uno nuevo. Por lo que al inicio de estas fusiones crearemos tokens con dos caracteres, y luego, a medida que el entrenamiento avance, subpalabras más largas.",il,V,ka="En cualquier etapa durante el entrenamiento del tokenizador, el algoritmo BPE buscará pos los pares más frecuentes de los tokens existentes (por “par”, acá nos referimos a dos tokens consecutivos en una palabra). El par más frecuente es el que será fusionado, y enjuagamos y repetimos para la siguiente etapa.",ol,Z,Qa="Volviedo a nuestro ejemplo previo, asumamos que las palabras tenían las siguientes frecuencias:",rl,S,cl,G,Aa="lo que significa que <code>&quot;hug&quot;</code> estuvo presente 10 veces en el corpus, <code>&quot;pug&quot;</code> 5 veces, <code>&quot;pun&quot;</code> 12 veces, <code>&quot;bun&quot;</code> 4 veces, and <code>&quot;hugs&quot;</code> 5 veces. Empezamos el entrenamiento separando cada palabra en caracteres (los que formaron nuestro vocabulario inicial) para que podamos ver cada palabra como una lista de tokens:",yl,_,ul,N,Ba="Luego miramos los pares. El par <code>(&quot;h&quot;, &quot;u&quot;)</code> está presente en las palabras <code>&quot;hug&quot;</code> y <code>&quot;hugs&quot;</code>, 15 veces en el total del corpus. No es el par más frecuente: ese honor le corresponde a <code>(&quot;u&quot;, &quot;g&quot;)</code>, el cual está presente en <code>&quot;hug&quot;</code>, <code>&quot;pug&quot;</code>, y <code>&quot;hugs&quot;</code>, para un gran total de 20 veces en el vocabulario.",jl,H,za="Por lo tanto, la primera regla de fusión aprendida por el tokenizador es <code>(&quot;u&quot;, &quot;g&quot;) -&gt; &quot;ug&quot;</code>, lo que significa que <code>&quot;ug&quot;</code> será agregado al vocabulario, y el par debería ser fusionado en todas las palabras del corpus. Al final de esta etapa, el vocabulario se ve así:",Jl,D,Ul,X,Ea="Ahora tenemos algunos pares que resultan en un token más largo de dos caracteres: por ejemplo el par <code>(&quot;h&quot;, &quot;ug&quot;)</code> (presente 15 veces en el corpus). Sin embargo, el par más frecuente en este punto is <code>(&quot;u&quot;, &quot;n&quot;)</code>, presente 16 veces en el corpus, por lo que la segunda regla de fusión aprendida es <code>(&quot;u&quot;, &quot;n&quot;) -&gt; &quot;un&quot;</code>. Agregando esto y fusionando todas las ocurrencias existentes nos lleva a:",ml,W,Tl,R,va="Ahora el par más frecuente es <code>(&quot;h&quot;, &quot;ug&quot;)</code>, por lo que aprendemos que la regla de fusión es <code>(&quot;h&quot;, &quot;ug&quot;) -&gt; &quot;hug&quot;</code>, lo cual nos da tuestro primer token de tres letras. Luego de la fusión el corpus se ve así:",hl,Y,wl,P,Va="Y continuamos así hasta que alcancemos el tamaño deseado del vocabulario.",dl,C,gl,K,Cl,F,Za="La tokenización sigue el proceso de entrenamiento de cerca, en el sentido que nuevos inputs son tokenizados aplicando los siguientes pasos:",xl,L,Sa="<li>Normalización</li> <li>Pre-tokenización</li> <li>Separar las palabras en caracteres individuales</li> <li>Aplicar las reglas de fusión aprendidas en orden en dichas separaciones.</li>",Il,O,Ga="Tomemos el ejemplo que usamos durante el entrenamiento, con las tres reglas de fusión aprendidas:",fl,ss,bl,ls,_a="La palabra <code>&quot;bug&quot;</code> será tokenizada como <code>[&quot;b&quot;, &quot;ug&quot;]</code>. En cambio, <code>&quot;mug&quot;</code>, será tokenizado como <code>[&quot;[UNK]&quot;, &quot;ug&quot;]</code> dado que la letra <code>&quot;m&quot;</code> no fue parte del vocabulario base. De la misma manera, la palabra <code>&quot;thug&quot;</code> será tokenizada como <code>[&quot;[UNK]&quot;, &quot;hug&quot;]</code>: la letra <code>&quot;t&quot;</code> no está en el vocabulario base, y aplicando las reglas de fusión resulta primero la fusión de <code>&quot;u&quot;</code> y <code>&quot;g&quot;</code> y luego de <code>&quot;hu&quot;</code> and <code>&quot;g&quot;</code>.",ql,x,$l,as,kl,ns,Na="Ahora echemos un vistazo a una implementación el algoritmo BPE. Esta no será una versión optimizada que puedes usar en corpus grande; sólo queremos mostrar el código para que puedas entender el algoritmo un poquito mejor.",Ql,es,Ha="Primero necesitamos un corpus, así que creemos uno simple con algunas oraciones:",Al,ts,Bl,ps,Da="A continuación, necesitamos pre-tokenizar el corpus en palabras. Dado que estamos replicando un tokenizador BPE (como GPT-2), usaremos el tokenizdor <code>gpt2</code> para la pre-tokenización:",zl,Ms,El,is,Xa="Luego calculamos las frecuencias de cada palabra en el corpues mientras hacemos la pre-tokenización:",vl,os,Vl,rs,Zl,cs,Wa="El siguiente paso es calcualar el vocabulario base, formado por todos los caracteres usados en el corpus:",Sl,ys,Gl,us,_l,js,Ra="También agregamos el token especial usado por el modelo al inicio de ese vocabulario. En el caso de GPT-2, el único token especial es <code>&quot;&lt;|endoftext|&gt;&quot;</code>:",Nl,Js,Hl,Us,Ya="Ahora necesitamos separar cada palabra en caracteres individuales, para poder comenzar el entrenamiento:",Dl,ms,Xl,Ts,Pa="Ahora estamos listos para el entrenamiento, escribamos una función que calcule la frecuencia de cada par. Necesitaremos usar esto en cada paso del entrenamiento:",Wl,hs,Rl,ws,Ka="Ahora miremos una parte de ese diccionario después de las separaciones iniciales:",Yl,ds,Pl,gs,Kl,Cs,Fa="Ahora, encontrar el par más frecuenta sólo toma un rápido ciclo:",Fl,xs,Ll,Is,Ol,fs,La="Por lo que la primera fusión a aprender es <code>(&#39;Ġ&#39;, &#39;t&#39;) -&gt; &#39;Ġt&#39;</code>, y luego agregamos <code>&#39;Ġt&#39;</code> al vocabulario:",sa,bs,la,qs,Oa="Para continuar, necesitamos aplicar la fusión en nuestro diccionario de divisiones (<code>splits</code> dictionary). Escribamos otra función para esto:",aa,$s,na,ks,sn="Y podemos echar un vistazo al resultado de nuestra primera fusión:",ea,Qs,ta,As,pa,Bs,ln="Ahora tenemos todo lo que necesitamos para iterar hasta que aprendamos todas las fusiones que queramos. Apuntemos a un tamaño de vocabulario de 50:",Ma,zs,ia,Es,an="Como resultado, hemos aprendido 19 reglas de fusión (el vocabulario inicial tenía un tamaño de 31 — 30 caracteres del alfabeto, más el token especial):",oa,vs,ra,Vs,ca,Zs,nn="And the vocabulary is composed of the special token, the initial alphabet, and all the results of the merges:",ya,Ss,ua,Gs,ja,I,Ja,_s,en="Para tokenizar un nuevo texto lo pre-tokenizamos, lo separamos, luego aplicamos todas las reglas de fusión aprendidas:",Ua,Ns,ma,Hs,tn="Podemos intentar esto con cualquier texto compuesto de de caracteres del alfabeto:",Ta,Ds,ha,Xs,wa,f,da,Ws,pn="Eso es todo para el algoritmo BPE! A continuación echaremos un vistazo a WordPiece.",ga,Rs,Ca,Ks,xa;return b=new gn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),q=new Ia({props:{title:"Tokenización por Codificación Byte-Pair",local:"byte-pair-encoding-tokenization",headingTag:"h1"}}),$=new In({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section5.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section5.ipynb"}]}}),Q=new xn({props:{id:"HEikzVL-lZU"}}),d=new Ys({props:{$$slots:{default:[fn]},$$scope:{ctx:w}}}),A=new Ia({props:{title:"Algoritmo de Entrenamiento",local:"training-algorithm",headingTag:"h2"}}),z=new m({props:{code:"JTIyaHVnJTIyJTJDJTIwJTIycHVnJTIyJTJDJTIwJTIycHVuJTIyJTJDJTIwJTIyYnVuJTIyJTJDJTIwJTIyaHVncyUyMg==",highlighted:'<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;pug&quot;</span>, <span class="hljs-string">&quot;pun&quot;</span>, <span class="hljs-string">&quot;bun&quot;</span>, <span class="hljs-string">&quot;hugs&quot;</span>',wrap:!1}}),g=new Ys({props:{$$slots:{default:[bn]},$$scope:{ctx:w}}}),S=new m({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),_=new m({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),D=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiU1RCUwQUNvcnB1cyUzQSUyMCglMjJoJTIyJTIwJTIydWclMjIlMkMlMjAxMCklMkMlMjAoJTIycCUyMiUyMCUyMnVnJTIyJTJDJTIwNSklMkMlMjAoJTIycCUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwMTIpJTJDJTIwKCUyMmIlMjIlMjAlMjJ1JTIyJTIwJTIybiUyMiUyQyUyMDQpJTJDJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyMCUyMnMlMjIlMkMlMjA1KQ==",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),W=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),Y=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTJDJTIwJTIyaHVnJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),C=new Ys({props:{$$slots:{default:[qn]},$$scope:{ctx:w}}}),K=new Ia({props:{title:"Algoritmo de Tokenización",local:"tokenization-algorithm",headingTag:"h2"}}),ss=new m({props:{code:"KCUyMnUlMjIlMkMlMjAlMjJnJTIyKSUyMC0lM0UlMjAlMjJ1ZyUyMiUwQSglMjJ1JTIyJTJDJTIwJTIybiUyMiklMjAtJTNFJTIwJTIydW4lMjIlMEEoJTIyaCUyMiUyQyUyMCUyMnVnJTIyKSUyMC0lM0UlMjAlMjJodWclMjI=",highlighted:`<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;ug&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;un&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;hug&quot;</span>`,wrap:!1}}),x=new Ys({props:{$$slots:{default:[$n]},$$scope:{ctx:w}}}),as=new Ia({props:{title:"Implementando BPE",local:"implementing-bpe",headingTag:"h2"}}),ts=new m({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),Ms=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),os=new m({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBcHJpbnQod29yZF9mcmVxcyk=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

<span class="hljs-built_in">print</span>(word_freqs)`,wrap:!1}}),rs=new m({props:{code:"ZGVmYXVsdGRpY3QoaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCclQzQlQTBpcyclM0ElMjAyJTJDJTIwJyVDNCVBMHRoZSclM0ElMjAxJTJDJTIwJyVDNCVBMEh1Z2dpbmcnJTNBJTIwMSUyQyUyMCclQzQlQTBGYWNlJyUzQSUyMDElMkMlMjAnJUM0JUEwQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJyVDNCVBMGNoYXB0ZXInJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCclQzQlQTBhYm91dCclM0ElMjAxJTJDJTIwJyVDNCVBMHRva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJyVDNCVBMHNlY3Rpb24nJTNBJTIwMSUyQyUyMCclQzQlQTBzaG93cyclM0ElMjAxJTJDJTIwJyVDNCVBMHNldmVyYWwnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCclQzQlQTBhbGdvcml0aG1zJyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMjAnJTJDJyUzQSUyMDElMkMlMjAnJUM0JUEweW91JyUzQSUyMDElMkMlMjAnJUM0JUEwd2lsbCclM0ElMjAxJTJDJTIwJyVDNCVBMGJlJyUzQSUyMDElMkMlMjAnJUM0JUEwYWJsZSclM0ElMjAxJTJDJTIwJyVDNCVBMHRvJyUzQSUyMDElMkMlMjAnJUM0JUEwdW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJyVDNCVBMGhvdyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJyVDNCVBMHRoZXknJTNBJTIwMSUyQyUyMCclQzQlQTBhcmUnJTNBJTIwMSUyQyUyMCclQzQlQTB0cmFpbmVkJyUzQSUyMDElMkMlMjAnJUM0JUEwYW5kJyUzQSUyMDElMkMlMjAnJUM0JUEwZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(<span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠHugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠFace&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠCourse&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;Ġchapter&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġabout&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġsection&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġshows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġseveral&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġalgorithms&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġyou&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġwill&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġbe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġable&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġunderstand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġhow&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġthey&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġare&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtrained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġgenerate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),ys=new m({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGV0dGVyJTIwbm90JTIwaW4lMjBhbHBoYWJldCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFscGhhYmV0LmFwcGVuZChsZXR0ZXIpJTBBYWxwaGFiZXQuc29ydCgpJTBBJTBBcHJpbnQoYWxwaGFiZXQp",highlighted:`alphabet = []

<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word:
        <span class="hljs-keyword">if</span> letter <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(letter)
alphabet.sort()

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),us=new m({props:{code:"JTVCJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclMkMlMjAnZSclMkMlMjAnZiclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAnayclMkMlMjAnbCclMkMlMjAnbSclMkMlMjAnbiclMkMlMjAnbyclMkMlMjAncCclMkMlMjAnciclMkMlMjAncyclMkMlMEElMjAlMjAndCclMkMlMjAndSclMkMlMjAndiclMkMlMjAndyclMkMlMjAneSclMkMlMjAneiclMkMlMjAnJUM0JUEwJyU1RA==",highlighted:`[ <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>,
  <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>]`,wrap:!1}}),Js=new m({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQlMjAlMkIlMjBhbHBoYWJldC5jb3B5KCk=",highlighted:'vocab = [<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>] + alphabet.copy()',wrap:!1}}),ms=new m({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCd29yZCUzQSUyMCU1QmMlMjBmb3IlMjBjJTIwaW4lMjB3b3JkJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9mcmVxcy5rZXlzKCklN0Q=",highlighted:'splits = {word: [c <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()}',wrap:!1}}),hs=new m({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX2ZyZXFzKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMkMlMjBmcmVxJTIwaW4lMjB3b3JkX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0cyU1QndvcmQlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGxlbihzcGxpdCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlNUJwYWlyJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHBhaXJfZnJlcXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_freqs</span>(<span class="hljs-params">splits</span>):
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            pair_freqs[pair] += freq
    <span class="hljs-keyword">return</span> pair_freqs`,wrap:!1}}),ds=new m({props:{code:"cGFpcl9mcmVxcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9mcmVxcyhzcGxpdHMpJTBBJTBBZm9yJTIwaSUyQyUyMGtleSUyMGluJTIwZW51bWVyYXRlKHBhaXJfZnJlcXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX2ZyZXFzJTVCa2V5JTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUzRCUyMDUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhaw==",highlighted:`pair_freqs = compute_pair_freqs(splits)

<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_freqs.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_freqs[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),gs=new m({props:{code:"KCdUJyUyQyUyMCdoJyklM0ElMjAzJTBBKCdoJyUyQyUyMCdpJyklM0ElMjAzJTBBKCdpJyUyQyUyMCdzJyklM0ElMjA1JTBBKCclQzQlQTAnJTJDJTIwJ2knKSUzQSUyMDIlMEEoJyVDNCVBMCclMkMlMjAndCcpJTNBJTIwNyUwQSgndCclMkMlMjAnaCcpJTNBJTIwMw==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-number">5</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">2</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-number">7</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>`,wrap:!1}}),xs=new m({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X2ZyZXElMjAlM0QlMjBOb25lJTBBJTBBZm9yJTIwcGFpciUyQyUyMGZyZXElMjBpbiUyMHBhaXJfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X2ZyZXElMjBpcyUyME5vbmUlMjBvciUyMG1heF9mcmVxJTIwJTNDJTIwZnJlcSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfZnJlcSUyMCUzRCUyMGZyZXElMEElMEFwcmludChiZXN0X3BhaXIlMkMlMjBtYXhfZnJlcSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_freq = <span class="hljs-literal">None</span>

<span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
    <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
        best_pair = pair
        max_freq = freq

<span class="hljs-built_in">print</span>(best_pair, max_freq)`,wrap:!1}}),Is=new m({props:{code:"KCclQzQlQTAnJTJDJTIwJ3QnKSUyMDc=",highlighted:'(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>) <span class="hljs-number">7</span>',wrap:!1}}),bs=new m({props:{code:"bWVyZ2VzJTIwJTNEJTIwJTdCKCUyMiVDNCVBMCUyMiUyQyUyMCUyMnQlMjIpJTNBJTIwJTIyJUM0JUEwdCUyMiU3RCUwQXZvY2FiLmFwcGVuZCglMjIlQzQlQTB0JTIyKQ==",highlighted:`merges = {(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>): <span class="hljs-string">&quot;Ġt&quot;</span>}
vocab.append(<span class="hljs-string">&quot;Ġt&quot;</span>)`,wrap:!1}}),$s=new m({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCYSUyMCUyQiUyMGIlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>

        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                split = split[:i] + [a + b] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),Qs=new m({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjIlQzQlQTAlMjIlMkMlMjAlMjJ0JTIyJTJDJTIwc3BsaXRzKSUwQXByaW50KHNwbGl0cyU1QiUyMiVDNCVBMHRyYWluZWQlMjIlNUQp",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, splits)
<span class="hljs-built_in">print</span>(splits[<span class="hljs-string">&quot;Ġtrained&quot;</span>])`,wrap:!1}}),As=new m({props:{code:"JTVCJyVDNCVBMHQnJTJDJTIwJ3InJTJDJTIwJ2EnJTJDJTIwJ2knJTJDJTIwJ24nJTJDJTIwJ2UnJTJDJTIwJ2QnJTVE",highlighted:'[<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]',wrap:!1}}),zs=new m({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDUwJTBBJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfZnJlcXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMG1heF9mcmVxJTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG1heF9mcmVxJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfZnJlcSUyMCUzQyUyMGZyZXElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlMjAlM0QlMjBwYWlyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2ZyZXElMjAlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG1lcmdlcyU1QmJlc3RfcGFpciU1RCUyMCUzRCUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwdm9jYWIuYXBwZW5kKGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEKQ==",highlighted:`vocab_size = <span class="hljs-number">50</span>

<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    pair_freqs = compute_pair_freqs(splits)
    best_pair = <span class="hljs-string">&quot;&quot;</span>
    max_freq = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
        <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
            best_pair = pair
            max_freq = freq
    splits = merge_pair(*best_pair, splits)
    merges[best_pair] = best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    vocab.append(best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>])`,wrap:!1}}),vs=new m({props:{code:"cHJpbnQobWVyZ2VzKQ==",highlighted:'<span class="hljs-built_in">print</span>(merges)',wrap:!1}}),Vs=new m({props:{code:"JTdCKCclQzQlQTAnJTJDJTIwJ3QnKSUzQSUyMCclQzQlQTB0JyUyQyUyMCgnaSclMkMlMjAncycpJTNBJTIwJ2lzJyUyQyUyMCgnZSclMkMlMjAncicpJTNBJTIwJ2VyJyUyQyUyMCgnJUM0JUEwJyUyQyUyMCdhJyklM0ElMjAnJUM0JUEwYSclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ28nKSUzQSUyMCclQzQlQTB0byclMkMlMjAoJ2UnJTJDJTIwJ24nKSUzQSUyMCdlbiclMkMlMEElMjAoJ1QnJTJDJTIwJ2gnKSUzQSUyMCdUaCclMkMlMjAoJ1RoJyUyQyUyMCdpcycpJTNBJTIwJ1RoaXMnJTJDJTIwKCdvJyUyQyUyMCd1JyklM0ElMjAnb3UnJTJDJTIwKCdzJyUyQyUyMCdlJyklM0ElMjAnc2UnJTJDJTIwKCclQzQlQTB0byclMkMlMjAnaycpJTNBJTIwJyVDNCVBMHRvayclMkMlMEElMjAoJyVDNCVBMHRvayclMkMlMjAnZW4nKSUzQSUyMCclQzQlQTB0b2tlbiclMkMlMjAoJ24nJTJDJTIwJ2QnKSUzQSUyMCduZCclMkMlMjAoJyVDNCVBMCclMkMlMjAnaXMnKSUzQSUyMCclQzQlQTBpcyclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ2gnKSUzQSUyMCclQzQlQTB0aCclMkMlMjAoJyVDNCVBMHRoJyUyQyUyMCdlJyklM0ElMjAnJUM0JUEwdGhlJyUyQyUwQSUyMCgnaSclMkMlMjAnbicpJTNBJTIwJ2luJyUyQyUyMCgnJUM0JUEwYSclMkMlMjAnYicpJTNBJTIwJyVDNCVBMGFiJyUyQyUyMCgnJUM0JUEwdG9rZW4nJTJDJTIwJ2knKSUzQSUyMCclQzQlQTB0b2tlbmknJTdE",highlighted:`{(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-string">&#x27;Ġt&#x27;</span>, (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-string">&#x27;is&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>): <span class="hljs-string">&#x27;er&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>): <span class="hljs-string">&#x27;Ġa&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>): <span class="hljs-string">&#x27;Ġto&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;en&#x27;</span>,
 (<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Th&#x27;</span>, (<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;This&#x27;</span>, (<span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>): <span class="hljs-string">&#x27;ou&#x27;</span>, (<span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;se&#x27;</span>, (<span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>): <span class="hljs-string">&#x27;Ġtok&#x27;</span>,
 (<span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>): <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, (<span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>): <span class="hljs-string">&#x27;nd&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;Ġis&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Ġth&#x27;</span>, (<span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;Ġthe&#x27;</span>,
 (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;in&#x27;</span>, (<span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>): <span class="hljs-string">&#x27;Ġab&#x27;</span>, (<span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>}`,wrap:!1}}),Ss=new m({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),Gs=new m({props:{code:"JTVCJyUzQyU3Q2VuZG9mdGV4dCU3QyUzRSclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdkJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdrJyUyQyUyMCdsJyUyQyUyMCdtJyUyQyUyMCduJyUyQyUyMCdvJyUyQyUwQSUyMCdwJyUyQyUyMCdyJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd2JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCd6JyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMHQnJTJDJTIwJ2lzJyUyQyUyMCdlciclMkMlMjAnJUM0JUEwYSclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2VuJyUyQyUyMCdUaCclMkMlMjAnVGhpcyclMkMlMjAnb3UnJTJDJTIwJ3NlJyUyQyUwQSUyMCclQzQlQTB0b2snJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCduZCclMkMlMjAnJUM0JUEwaXMnJTJDJTIwJyVDNCVBMHRoJyUyQyUyMCclQzQlQTB0aGUnJTJDJTIwJ2luJyUyQyUyMCclQzQlQTBhYiclMkMlMjAnJUM0JUEwdG9rZW5pJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;&lt;|endoftext|&gt;&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>,
 <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;se&#x27;</span>,
 <span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;nd&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;Ġab&#x27;</span>, <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>]`,wrap:!1}}),I=new Ys({props:{$$slots:{default:[kn]},$$scope:{ctx:w}}}),Ns=new m({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBzcGxpdHMlMjAlM0QlMjAlNUIlNUJsJTIwZm9yJTIwbCUyMGluJTIwd29yZCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHByZV90b2tlbml6ZWRfdGV4dCU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBtZXJnZSUyMGluJTIwbWVyZ2VzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpZHglMkMlMjBzcGxpdCUyMGluJTIwZW51bWVyYXRlKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdoaWxlJTIwaSUyMCUzQyUyMGxlbihzcGxpdCklMjAtJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3BsaXQlNUJpJTVEJTIwJTNEJTNEJTIwcGFpciU1QjAlNUQlMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwcGFpciU1QjElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0JTVCJTNBaSU1RCUyMCUyQiUyMCU1Qm1lcmdlJTVEJTIwJTJCJTIwc3BsaXQlNUJpJTIwJTJCJTIwMiUyMCUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0cyU1QmlkeCU1RCUyMCUzRCUyMHNwbGl0JTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKHNwbGl0cyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    splits = [[l <span class="hljs-keyword">for</span> l <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">for</span> pair, merge <span class="hljs-keyword">in</span> merges.items():
        <span class="hljs-keyword">for</span> idx, split <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(splits):
            i = <span class="hljs-number">0</span>
            <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
                <span class="hljs-keyword">if</span> split[i] == pair[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == pair[<span class="hljs-number">1</span>]:
                    split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
                <span class="hljs-keyword">else</span>:
                    i += <span class="hljs-number">1</span>
            splits[idx] = split

    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(splits, [])`,wrap:!1}}),Ds=new m({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwbm90JTIwYSUyMHRva2VuLiUyMik=",highlighted:'tokenize(<span class="hljs-string">&quot;This is not a token.&quot;</span>)',wrap:!1}}),Xs=new m({props:{code:"JTVCJ1RoaXMnJTJDJTIwJyVDNCVBMGlzJyUyQyUyMCclQzQlQTAnJTJDJTIwJ24nJTJDJTIwJ28nJTJDJTIwJ3QnJTJDJTIwJyVDNCVBMGEnJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCcuJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),f=new Ys({props:{warning:!0,$$slots:{default:[Qn]},$$scope:{ctx:w}}}),Rs=new Cn({props:{source:"https://github.com/huggingface/course/blob/main/chapters/es/chapter6/5.mdx"}}),{c(){p=u("meta"),T=e(),J=u("p"),h=e(),M(b.$$.fragment),Fs=e(),M(q.$$.fragment),Ls=e(),M($.$$.fragment),Os=e(),k=u("p"),k.textContent=fa,sl=e(),M(Q.$$.fragment),ll=e(),M(d.$$.fragment),al=e(),M(A.$$.fragment),nl=e(),B=u("p"),B.textContent=ba,el=e(),M(z.$$.fragment),tl=e(),E=u("p"),E.innerHTML=qa,pl=e(),M(g.$$.fragment),Ml=e(),v=u("p"),v.innerHTML=$a,il=e(),V=u("p"),V.textContent=ka,ol=e(),Z=u("p"),Z.textContent=Qa,rl=e(),M(S.$$.fragment),cl=e(),G=u("p"),G.innerHTML=Aa,yl=e(),M(_.$$.fragment),ul=e(),N=u("p"),N.innerHTML=Ba,jl=e(),H=u("p"),H.innerHTML=za,Jl=e(),M(D.$$.fragment),Ul=e(),X=u("p"),X.innerHTML=Ea,ml=e(),M(W.$$.fragment),Tl=e(),R=u("p"),R.innerHTML=va,hl=e(),M(Y.$$.fragment),wl=e(),P=u("p"),P.textContent=Va,dl=e(),M(C.$$.fragment),gl=e(),M(K.$$.fragment),Cl=e(),F=u("p"),F.textContent=Za,xl=e(),L=u("ol"),L.innerHTML=Sa,Il=e(),O=u("p"),O.textContent=Ga,fl=e(),M(ss.$$.fragment),bl=e(),ls=u("p"),ls.innerHTML=_a,ql=e(),M(x.$$.fragment),$l=e(),M(as.$$.fragment),kl=e(),ns=u("p"),ns.textContent=Na,Ql=e(),es=u("p"),es.textContent=Ha,Al=e(),M(ts.$$.fragment),Bl=e(),ps=u("p"),ps.innerHTML=Da,zl=e(),M(Ms.$$.fragment),El=e(),is=u("p"),is.textContent=Xa,vl=e(),M(os.$$.fragment),Vl=e(),M(rs.$$.fragment),Zl=e(),cs=u("p"),cs.textContent=Wa,Sl=e(),M(ys.$$.fragment),Gl=e(),M(us.$$.fragment),_l=e(),js=u("p"),js.innerHTML=Ra,Nl=e(),M(Js.$$.fragment),Hl=e(),Us=u("p"),Us.textContent=Ya,Dl=e(),M(ms.$$.fragment),Xl=e(),Ts=u("p"),Ts.textContent=Pa,Wl=e(),M(hs.$$.fragment),Rl=e(),ws=u("p"),ws.textContent=Ka,Yl=e(),M(ds.$$.fragment),Pl=e(),M(gs.$$.fragment),Kl=e(),Cs=u("p"),Cs.textContent=Fa,Fl=e(),M(xs.$$.fragment),Ll=e(),M(Is.$$.fragment),Ol=e(),fs=u("p"),fs.innerHTML=La,sa=e(),M(bs.$$.fragment),la=e(),qs=u("p"),qs.innerHTML=Oa,aa=e(),M($s.$$.fragment),na=e(),ks=u("p"),ks.textContent=sn,ea=e(),M(Qs.$$.fragment),ta=e(),M(As.$$.fragment),pa=e(),Bs=u("p"),Bs.textContent=ln,Ma=e(),M(zs.$$.fragment),ia=e(),Es=u("p"),Es.textContent=an,oa=e(),M(vs.$$.fragment),ra=e(),M(Vs.$$.fragment),ca=e(),Zs=u("p"),Zs.textContent=nn,ya=e(),M(Ss.$$.fragment),ua=e(),M(Gs.$$.fragment),ja=e(),M(I.$$.fragment),Ja=e(),_s=u("p"),_s.textContent=en,Ua=e(),M(Ns.$$.fragment),ma=e(),Hs=u("p"),Hs.textContent=tn,Ta=e(),M(Ds.$$.fragment),ha=e(),M(Xs.$$.fragment),wa=e(),M(f.$$.fragment),da=e(),Ws=u("p"),Ws.textContent=pn,ga=e(),M(Rs.$$.fragment),Ca=e(),Ks=u("p"),this.h()},l(s){const l=wn("svelte-u9bgzb",document.head);p=j(l,"META",{name:!0,content:!0}),l.forEach(a),T=t(s),J=j(s,"P",{}),jn(J).forEach(a),h=t(s),i(b.$$.fragment,s),Fs=t(s),i(q.$$.fragment,s),Ls=t(s),i($.$$.fragment,s),Os=t(s),k=j(s,"P",{"data-svelte-h":!0}),U(k)!=="svelte-nlw4yb"&&(k.textContent=fa),sl=t(s),i(Q.$$.fragment,s),ll=t(s),i(d.$$.fragment,s),al=t(s),i(A.$$.fragment,s),nl=t(s),B=j(s,"P",{"data-svelte-h":!0}),U(B)!=="svelte-1ge6ors"&&(B.textContent=ba),el=t(s),i(z.$$.fragment,s),tl=t(s),E=j(s,"P",{"data-svelte-h":!0}),U(E)!=="svelte-12w7uzv"&&(E.innerHTML=qa),pl=t(s),i(g.$$.fragment,s),Ml=t(s),v=j(s,"P",{"data-svelte-h":!0}),U(v)!=="svelte-9h9iwk"&&(v.innerHTML=$a),il=t(s),V=j(s,"P",{"data-svelte-h":!0}),U(V)!=="svelte-1kei5ki"&&(V.textContent=ka),ol=t(s),Z=j(s,"P",{"data-svelte-h":!0}),U(Z)!=="svelte-w4nnp4"&&(Z.textContent=Qa),rl=t(s),i(S.$$.fragment,s),cl=t(s),G=j(s,"P",{"data-svelte-h":!0}),U(G)!=="svelte-hu3c76"&&(G.innerHTML=Aa),yl=t(s),i(_.$$.fragment,s),ul=t(s),N=j(s,"P",{"data-svelte-h":!0}),U(N)!=="svelte-2m2yo1"&&(N.innerHTML=Ba),jl=t(s),H=j(s,"P",{"data-svelte-h":!0}),U(H)!=="svelte-ap5znc"&&(H.innerHTML=za),Jl=t(s),i(D.$$.fragment,s),Ul=t(s),X=j(s,"P",{"data-svelte-h":!0}),U(X)!=="svelte-1i5m5fd"&&(X.innerHTML=Ea),ml=t(s),i(W.$$.fragment,s),Tl=t(s),R=j(s,"P",{"data-svelte-h":!0}),U(R)!=="svelte-17mrt8d"&&(R.innerHTML=va),hl=t(s),i(Y.$$.fragment,s),wl=t(s),P=j(s,"P",{"data-svelte-h":!0}),U(P)!=="svelte-1683jdr"&&(P.textContent=Va),dl=t(s),i(C.$$.fragment,s),gl=t(s),i(K.$$.fragment,s),Cl=t(s),F=j(s,"P",{"data-svelte-h":!0}),U(F)!=="svelte-potlx5"&&(F.textContent=Za),xl=t(s),L=j(s,"OL",{"data-svelte-h":!0}),U(L)!=="svelte-jpgiaq"&&(L.innerHTML=Sa),Il=t(s),O=j(s,"P",{"data-svelte-h":!0}),U(O)!=="svelte-8vvsjz"&&(O.textContent=Ga),fl=t(s),i(ss.$$.fragment,s),bl=t(s),ls=j(s,"P",{"data-svelte-h":!0}),U(ls)!=="svelte-1ukpsru"&&(ls.innerHTML=_a),ql=t(s),i(x.$$.fragment,s),$l=t(s),i(as.$$.fragment,s),kl=t(s),ns=j(s,"P",{"data-svelte-h":!0}),U(ns)!=="svelte-1esepyc"&&(ns.textContent=Na),Ql=t(s),es=j(s,"P",{"data-svelte-h":!0}),U(es)!=="svelte-b2t54"&&(es.textContent=Ha),Al=t(s),i(ts.$$.fragment,s),Bl=t(s),ps=j(s,"P",{"data-svelte-h":!0}),U(ps)!=="svelte-gkz8m0"&&(ps.innerHTML=Da),zl=t(s),i(Ms.$$.fragment,s),El=t(s),is=j(s,"P",{"data-svelte-h":!0}),U(is)!=="svelte-a1kxvi"&&(is.textContent=Xa),vl=t(s),i(os.$$.fragment,s),Vl=t(s),i(rs.$$.fragment,s),Zl=t(s),cs=j(s,"P",{"data-svelte-h":!0}),U(cs)!=="svelte-ohzu6i"&&(cs.textContent=Wa),Sl=t(s),i(ys.$$.fragment,s),Gl=t(s),i(us.$$.fragment,s),_l=t(s),js=j(s,"P",{"data-svelte-h":!0}),U(js)!=="svelte-aiji2y"&&(js.innerHTML=Ra),Nl=t(s),i(Js.$$.fragment,s),Hl=t(s),Us=j(s,"P",{"data-svelte-h":!0}),U(Us)!=="svelte-pq7l32"&&(Us.textContent=Ya),Dl=t(s),i(ms.$$.fragment,s),Xl=t(s),Ts=j(s,"P",{"data-svelte-h":!0}),U(Ts)!=="svelte-19ak7xx"&&(Ts.textContent=Pa),Wl=t(s),i(hs.$$.fragment,s),Rl=t(s),ws=j(s,"P",{"data-svelte-h":!0}),U(ws)!=="svelte-ijk6v3"&&(ws.textContent=Ka),Yl=t(s),i(ds.$$.fragment,s),Pl=t(s),i(gs.$$.fragment,s),Kl=t(s),Cs=j(s,"P",{"data-svelte-h":!0}),U(Cs)!=="svelte-1a4me0z"&&(Cs.textContent=Fa),Fl=t(s),i(xs.$$.fragment,s),Ll=t(s),i(Is.$$.fragment,s),Ol=t(s),fs=j(s,"P",{"data-svelte-h":!0}),U(fs)!=="svelte-1fkmilf"&&(fs.innerHTML=La),sa=t(s),i(bs.$$.fragment,s),la=t(s),qs=j(s,"P",{"data-svelte-h":!0}),U(qs)!=="svelte-1rczgta"&&(qs.innerHTML=Oa),aa=t(s),i($s.$$.fragment,s),na=t(s),ks=j(s,"P",{"data-svelte-h":!0}),U(ks)!=="svelte-139whv7"&&(ks.textContent=sn),ea=t(s),i(Qs.$$.fragment,s),ta=t(s),i(As.$$.fragment,s),pa=t(s),Bs=j(s,"P",{"data-svelte-h":!0}),U(Bs)!=="svelte-16k7mbs"&&(Bs.textContent=ln),Ma=t(s),i(zs.$$.fragment,s),ia=t(s),Es=j(s,"P",{"data-svelte-h":!0}),U(Es)!=="svelte-1d3hrno"&&(Es.textContent=an),oa=t(s),i(vs.$$.fragment,s),ra=t(s),i(Vs.$$.fragment,s),ca=t(s),Zs=j(s,"P",{"data-svelte-h":!0}),U(Zs)!=="svelte-okpg4u"&&(Zs.textContent=nn),ya=t(s),i(Ss.$$.fragment,s),ua=t(s),i(Gs.$$.fragment,s),ja=t(s),i(I.$$.fragment,s),Ja=t(s),_s=j(s,"P",{"data-svelte-h":!0}),U(_s)!=="svelte-ms7due"&&(_s.textContent=en),Ua=t(s),i(Ns.$$.fragment,s),ma=t(s),Hs=j(s,"P",{"data-svelte-h":!0}),U(Hs)!=="svelte-7dx30b"&&(Hs.textContent=tn),Ta=t(s),i(Ds.$$.fragment,s),ha=t(s),i(Xs.$$.fragment,s),wa=t(s),i(f.$$.fragment,s),da=t(s),Ws=j(s,"P",{"data-svelte-h":!0}),U(Ws)!=="svelte-1jk90c"&&(Ws.textContent=pn),ga=t(s),i(Rs.$$.fragment,s),Ca=t(s),Ks=j(s,"P",{}),jn(Ks).forEach(a),this.h()},h(){Jn(p,"name","hf:doc:metadata"),Jn(p,"content",Bn)},m(s,l){dn(document.head,p),n(s,T,l),n(s,J,l),n(s,h,l),o(b,s,l),n(s,Fs,l),o(q,s,l),n(s,Ls,l),o($,s,l),n(s,Os,l),n(s,k,l),n(s,sl,l),o(Q,s,l),n(s,ll,l),o(d,s,l),n(s,al,l),o(A,s,l),n(s,nl,l),n(s,B,l),n(s,el,l),o(z,s,l),n(s,tl,l),n(s,E,l),n(s,pl,l),o(g,s,l),n(s,Ml,l),n(s,v,l),n(s,il,l),n(s,V,l),n(s,ol,l),n(s,Z,l),n(s,rl,l),o(S,s,l),n(s,cl,l),n(s,G,l),n(s,yl,l),o(_,s,l),n(s,ul,l),n(s,N,l),n(s,jl,l),n(s,H,l),n(s,Jl,l),o(D,s,l),n(s,Ul,l),n(s,X,l),n(s,ml,l),o(W,s,l),n(s,Tl,l),n(s,R,l),n(s,hl,l),o(Y,s,l),n(s,wl,l),n(s,P,l),n(s,dl,l),o(C,s,l),n(s,gl,l),o(K,s,l),n(s,Cl,l),n(s,F,l),n(s,xl,l),n(s,L,l),n(s,Il,l),n(s,O,l),n(s,fl,l),o(ss,s,l),n(s,bl,l),n(s,ls,l),n(s,ql,l),o(x,s,l),n(s,$l,l),o(as,s,l),n(s,kl,l),n(s,ns,l),n(s,Ql,l),n(s,es,l),n(s,Al,l),o(ts,s,l),n(s,Bl,l),n(s,ps,l),n(s,zl,l),o(Ms,s,l),n(s,El,l),n(s,is,l),n(s,vl,l),o(os,s,l),n(s,Vl,l),o(rs,s,l),n(s,Zl,l),n(s,cs,l),n(s,Sl,l),o(ys,s,l),n(s,Gl,l),o(us,s,l),n(s,_l,l),n(s,js,l),n(s,Nl,l),o(Js,s,l),n(s,Hl,l),n(s,Us,l),n(s,Dl,l),o(ms,s,l),n(s,Xl,l),n(s,Ts,l),n(s,Wl,l),o(hs,s,l),n(s,Rl,l),n(s,ws,l),n(s,Yl,l),o(ds,s,l),n(s,Pl,l),o(gs,s,l),n(s,Kl,l),n(s,Cs,l),n(s,Fl,l),o(xs,s,l),n(s,Ll,l),o(Is,s,l),n(s,Ol,l),n(s,fs,l),n(s,sa,l),o(bs,s,l),n(s,la,l),n(s,qs,l),n(s,aa,l),o($s,s,l),n(s,na,l),n(s,ks,l),n(s,ea,l),o(Qs,s,l),n(s,ta,l),o(As,s,l),n(s,pa,l),n(s,Bs,l),n(s,Ma,l),o(zs,s,l),n(s,ia,l),n(s,Es,l),n(s,oa,l),o(vs,s,l),n(s,ra,l),o(Vs,s,l),n(s,ca,l),n(s,Zs,l),n(s,ya,l),o(Ss,s,l),n(s,ua,l),o(Gs,s,l),n(s,ja,l),o(I,s,l),n(s,Ja,l),n(s,_s,l),n(s,Ua,l),o(Ns,s,l),n(s,ma,l),n(s,Hs,l),n(s,Ta,l),o(Ds,s,l),n(s,ha,l),o(Xs,s,l),n(s,wa,l),o(f,s,l),n(s,da,l),n(s,Ws,l),n(s,ga,l),o(Rs,s,l),n(s,Ca,l),n(s,Ks,l),xa=!0},p(s,[l]){const Mn={};l&2&&(Mn.$$scope={dirty:l,ctx:s}),d.$set(Mn);const on={};l&2&&(on.$$scope={dirty:l,ctx:s}),g.$set(on);const rn={};l&2&&(rn.$$scope={dirty:l,ctx:s}),C.$set(rn);const cn={};l&2&&(cn.$$scope={dirty:l,ctx:s}),x.$set(cn);const yn={};l&2&&(yn.$$scope={dirty:l,ctx:s}),I.$set(yn);const un={};l&2&&(un.$$scope={dirty:l,ctx:s}),f.$set(un)},i(s){xa||(r(b.$$.fragment,s),r(q.$$.fragment,s),r($.$$.fragment,s),r(Q.$$.fragment,s),r(d.$$.fragment,s),r(A.$$.fragment,s),r(z.$$.fragment,s),r(g.$$.fragment,s),r(S.$$.fragment,s),r(_.$$.fragment,s),r(D.$$.fragment,s),r(W.$$.fragment,s),r(Y.$$.fragment,s),r(C.$$.fragment,s),r(K.$$.fragment,s),r(ss.$$.fragment,s),r(x.$$.fragment,s),r(as.$$.fragment,s),r(ts.$$.fragment,s),r(Ms.$$.fragment,s),r(os.$$.fragment,s),r(rs.$$.fragment,s),r(ys.$$.fragment,s),r(us.$$.fragment,s),r(Js.$$.fragment,s),r(ms.$$.fragment,s),r(hs.$$.fragment,s),r(ds.$$.fragment,s),r(gs.$$.fragment,s),r(xs.$$.fragment,s),r(Is.$$.fragment,s),r(bs.$$.fragment,s),r($s.$$.fragment,s),r(Qs.$$.fragment,s),r(As.$$.fragment,s),r(zs.$$.fragment,s),r(vs.$$.fragment,s),r(Vs.$$.fragment,s),r(Ss.$$.fragment,s),r(Gs.$$.fragment,s),r(I.$$.fragment,s),r(Ns.$$.fragment,s),r(Ds.$$.fragment,s),r(Xs.$$.fragment,s),r(f.$$.fragment,s),r(Rs.$$.fragment,s),xa=!0)},o(s){c(b.$$.fragment,s),c(q.$$.fragment,s),c($.$$.fragment,s),c(Q.$$.fragment,s),c(d.$$.fragment,s),c(A.$$.fragment,s),c(z.$$.fragment,s),c(g.$$.fragment,s),c(S.$$.fragment,s),c(_.$$.fragment,s),c(D.$$.fragment,s),c(W.$$.fragment,s),c(Y.$$.fragment,s),c(C.$$.fragment,s),c(K.$$.fragment,s),c(ss.$$.fragment,s),c(x.$$.fragment,s),c(as.$$.fragment,s),c(ts.$$.fragment,s),c(Ms.$$.fragment,s),c(os.$$.fragment,s),c(rs.$$.fragment,s),c(ys.$$.fragment,s),c(us.$$.fragment,s),c(Js.$$.fragment,s),c(ms.$$.fragment,s),c(hs.$$.fragment,s),c(ds.$$.fragment,s),c(gs.$$.fragment,s),c(xs.$$.fragment,s),c(Is.$$.fragment,s),c(bs.$$.fragment,s),c($s.$$.fragment,s),c(Qs.$$.fragment,s),c(As.$$.fragment,s),c(zs.$$.fragment,s),c(vs.$$.fragment,s),c(Vs.$$.fragment,s),c(Ss.$$.fragment,s),c(Gs.$$.fragment,s),c(I.$$.fragment,s),c(Ns.$$.fragment,s),c(Ds.$$.fragment,s),c(Xs.$$.fragment,s),c(f.$$.fragment,s),c(Rs.$$.fragment,s),xa=!1},d(s){s&&(a(T),a(J),a(h),a(Fs),a(Ls),a(Os),a(k),a(sl),a(ll),a(al),a(nl),a(B),a(el),a(tl),a(E),a(pl),a(Ml),a(v),a(il),a(V),a(ol),a(Z),a(rl),a(cl),a(G),a(yl),a(ul),a(N),a(jl),a(H),a(Jl),a(Ul),a(X),a(ml),a(Tl),a(R),a(hl),a(wl),a(P),a(dl),a(gl),a(Cl),a(F),a(xl),a(L),a(Il),a(O),a(fl),a(bl),a(ls),a(ql),a($l),a(kl),a(ns),a(Ql),a(es),a(Al),a(Bl),a(ps),a(zl),a(El),a(is),a(vl),a(Vl),a(Zl),a(cs),a(Sl),a(Gl),a(_l),a(js),a(Nl),a(Hl),a(Us),a(Dl),a(Xl),a(Ts),a(Wl),a(Rl),a(ws),a(Yl),a(Pl),a(Kl),a(Cs),a(Fl),a(Ll),a(Ol),a(fs),a(sa),a(la),a(qs),a(aa),a(na),a(ks),a(ea),a(ta),a(pa),a(Bs),a(Ma),a(ia),a(Es),a(oa),a(ra),a(ca),a(Zs),a(ya),a(ua),a(ja),a(Ja),a(_s),a(Ua),a(ma),a(Hs),a(Ta),a(ha),a(wa),a(da),a(Ws),a(ga),a(Ca),a(Ks)),a(p),y(b,s),y(q,s),y($,s),y(Q,s),y(d,s),y(A,s),y(z,s),y(g,s),y(S,s),y(_,s),y(D,s),y(W,s),y(Y,s),y(C,s),y(K,s),y(ss,s),y(x,s),y(as,s),y(ts,s),y(Ms,s),y(os,s),y(rs,s),y(ys,s),y(us,s),y(Js,s),y(ms,s),y(hs,s),y(ds,s),y(gs,s),y(xs,s),y(Is,s),y(bs,s),y($s,s),y(Qs,s),y(As,s),y(zs,s),y(vs,s),y(Vs,s),y(Ss,s),y(Gs,s),y(I,s),y(Ns,s),y(Ds,s),y(Xs,s),y(f,s),y(Rs,s)}}}const Bn='{"title":"Tokenización por Codificación Byte-Pair","local":"byte-pair-encoding-tokenization","sections":[{"title":"Algoritmo de Entrenamiento","local":"training-algorithm","sections":[],"depth":2},{"title":"Algoritmo de Tokenización","local":"tokenization-algorithm","sections":[],"depth":2},{"title":"Implementando BPE","local":"implementing-bpe","sections":[],"depth":2}],"depth":1}';function zn(w){return mn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hn extends Tn{constructor(p){super(),hn(this,p,zn,An,Un,{})}}export{Hn as component};
