# Quiz de Final de Capítulo[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={6}
    classNames="absolute z-10 right-0 top-0"
/>

Probemos lo que aprendimos en este capítulo!

### 1. Cuando debería entrenar un nuevo tokenizador?

<Question
	choices={[
		{
			text: "Cuando tu conjunto de datos es similar al usado por un modelo pre-entrenado existente, y tú quieres pre-entrenar un nuevo modelo.",
			explain: "En este caso, para ahorrar tiempo y recursos computacionales, una mejor opción sería usar el mismo tokenizador que el modelo pre-entrenado y hacerle fine-tuning."
		},
		{
			text: "Cuando tu conjunto de datos es similar al usado por un modelo pre-entrenado existente, y quieres hacerle fine-tuning a un nuevo modelo usando este modelo pre-entrenado.",
			explain: "Para hacer fine-tuning a un modelo a partir de un modelo pre-entrenado, deberías siempre usar el mismo tokenizador."
		},
		{
			text: "Cuando tu dataset es diferente del que se utilizó en el modelo pre-entrenado existente, y quieres pre-entrenar un nuevo modelo.",
			explain: "Correcto! En este caso no hay ningúna ventaje en usar el mismo tokenizador.",
            correct: true
		},
        {
			text: "Cuando tu dataset es diferente del que se utilizó en el modelo pre-entrenado existente, pero quieres hacer fine-tuning a un nuevo modelo usando el modelo pre-entrenado.",
			explain: "Para hacer fine-tuning a un modelo a partir de un modelo pre-entrenado, siempre deberías usar el mismo tokenizador."
		}
	]}
/>

### 2. Cuál es la ventaja de usar un generador de listas de textos comparado con una lista de listas de textos al usar `train_new_from_iterator()`?

<Question
	choices={[
		{
			text: "Ese es el único tipo que el método <code>train_new_from_iterator()</code> acepta.",
			explain: "Una lista de listas de textos es un tipo particular de generador de listas de textos, por lo que el método aceptará esto también. Intenta de nuevo!"
		},
		{
			text: "Evitarás cargar todo el conjunto de datos en memoria de una sóla vez.",
			explain: "Correcto! Cada lote de textos será liberado de la memoria al ir iterando, y la ganancia será especialmente visible si usas la librería 🤗 Datasets para almacenar tus textos.",
			correct: true
		},
		{
			text: "Esto permite que la librería 🤗 Tokenizers library use multiprocesamiento.",
			explain: "No, usará multiprocesamiento en ambos casos."
		},
        {
			text: "El tokenizador que entrenarás generará mejores textos.",
			explain: "El tokenizador no genera texto -- estás confundiéndolo con un modelo de lenguaje?"
		}
	]}
/>

### 3. Cuáles son las ventajas de utilizar un tokenizador "rápido"?

<Question
	choices={[
		{
			text: "Puede procesar las entradas/inputs más rápido que un tokenizador lento cuando empaquetas muchas entradas/inputs en lotes.",
			explain: "Correcto! Gracias al paralelismo implementado en Rust, será más rápido en lotes de entradas/inputs. En qué otro beneficio puedes pensar?",
			correct: true
		},
		{
			text: "Los tokenizadores rápidos siempre tokenizan más rápidos que sus contrapartes lentas.",
			explain: "Un tokenizador rápido puede ser en realidad más lento cuando sólo le dás uno o pocos textos, dado que no puede usar paralelismo."
		},
		{
			text: "Puede aplicar relleno (padding) y truncamiento.",
			explain: "Verdadero, pero los tokenizadores lentos también hacen eso."
		},
        {
			text: "Tiene algunas características adicionales que permiten mapear tokens a la porción de texto que los creó.",
			explain: "De hecho -- esos son los offset mappings. Aunque esa no es la única ventaja.",
			correct: true
		}
	]}
/>

### 4. Como hace el pipeline `token-classification` para manejar entidades que se extienden a varios tokens?

<Question
	choices={[
		{
			text: "Las entidades con las mismas etiquetas son fusionadas en una sólo entidad.",
			explain: "Eso es sobresimplificar las cosas un poco. Intenta de nuevo!"
		},
		{
			text: "Hay una etiqueta para el inicio de una entidad y una etiqueta para la continuación de una entidad.",
			explain: "Correcto!",
			correct: true
		},
		{
			text: "En una palabra dada, mientas el primer token tenga una etiquera de entidad, la palabra completa es considerada etiquetada con dicha entidad.",
			explain: "Esa es una estrategia para manipular entidades. Qué otras respuestan aplican acá?",
			correct: true
		},
        {
			text: "Cuando un token tiene la etiqueta de una entidad dada, cualquier otro token consecutivo con la misma etiqueta será considerada parte de la misma entidad, a menos que sea etiquetada como el inicio de una nueva entidad.",
			explain: "Esa es la manera más común de agrupar entidades -- aunque, no es la única respuesta correcta.",
			correct: true
		}
	]}
/>

### 5. Cómo hace el pipeline de `question-answering` para manejar contextos largos?

<Question
	choices={[
		{
			text: "En realidad no lo hace, ya que trunca los contextos largos al largo máximo aceptado por el modelo.",
			explain: "Hay un truco que puedes usar para manejar contextos largos. Te acuerdas cuál es?"
		},
		{
			text: "Separa el contexto en varias partes y promedia los resultados obtenidos.",
			explain: "No, no haría sentido promedias los resultados, ya que algunas partes del contexto no incluirán la respuesta."
		},
		{
			text: "Separa el contexto en varias partes (con traslape) y encuentra el puntaje máximo para una respuesta en cada parte.",
			explain: "Esa es la respuesta correcta!",
			correct: true
		},
        {
			text: "Separa el contexto en varias partes (sin traslape, por eficiencia) y encuentra el puntaje máximo para una respuesta en cada parte.",
			explain: "No, incluye algo de traslape entre las partes para evitar la situación donde la respuesta estaría separada entre las partes."
		}
	]}
/>

### 6. Qué es la normalización?

<Question
	choices={[
		{
			text: "Es cualquier limpieza que el tokenizador realiza en los extos en las etapas iniciales.",
			explain: "Eso es correcto -- por ejemplo, podría incolucrar la remoción de acentos o espacios en blancos, o transformar a minúsculas las entradas/inputs.",
			correct: true
		},
		{
			text: "Es una técnica de aumento de datos que involucra hacer el texto más normal removiendo palabras raras.",
			explain: "Eso es incorrecto! Intenta de nuevo."
		},
		{
			text: "Es el paso final de post-procesamiento donde el tokenizador agrega los tokens especiales.",
			explain: "Esa etapa se llama simplemente post-procesamiento."
		},
        {
			text: "Es cuando los embeddings se llevan a media 0 y desviación estándar 1, restando la media y dividiendo la desviación estándar.",
			explain: "Ese proceso es comúnmente llamado normalización cuando se aplica a valores de píxel en visión computacional, pero no es lo que significa normalizacion en el contexto de NLP."
		}
	]}
/>

### 7. Qué es la pre-tokenización para un tokenizador de subpalabra?

<Question
	choices={[
		{
			text: "Es un paso antes de la tokenización, donde se aplica aumento de datos (como enmascaramiento aleatorio (random masking)).",
			explain: "No, ese paso es parte del pre-procesamiento."
		},
		{
			text: "Es el paso antes de la tokenización, donde las operaciones de limpieza deseada son aplicados al texto.",
			explain: "No, ese es el paso de normalización."
		},
		{
			text: "Es el paso antes que el modelo de tokenización sea aplicado para separar la entrada/input en palabras.",
			explain: "Esa es la respuesta correcta!",
			correct: true
		},
        {
			text: "Es el paso antes de que el tokenizador se aplique para separar el input en tokens.",
			explain: "No, separar en tokens es parte del trabajo del modelo de tokenización."
		}
	]}
/>

### 8. Selecciona las afirmaciones que aplican para el modelo de tokenización BPE.

<Question
	choices={[
		{
			text: "BPE es un algoritmo de tokenización por subpalabras que comienza con un vocabulario pequeño y aprende reglas de fusión.",
			explain: "Ese es de hecho el caso!",
			correct: true
		},
		{
			text: "BPE es un algoritmo de tokenización que comienza con un vocabulario grande y de manera progresiva remueve tokens de él.",
			explain: "No, ese es el método que siguien un algoritmo de tokenización diferente."
		},
		{
			text: "El tokenizador BPE aprende reglas de fusión fusionando el parte de tokens que es el más frecuente.",
			explain: "Eso es correcto!",
			correct: true
		},
		{
			text: "Un tokenizador BPE aprende una regla de fusión fusionando el par de tokens que maximiza un puntaje que privilegia pares frecuentes con partes individuales menos frecuentes.",
			explain: "No, esa es la estrategia aplicada por otro algoritmo de tokenización."
		},
		{
			text: "BPE tokeniza palabras en subpalabras separándolas en caracteres y luego aplicando reglas de fusión.",
			explain: "Eso es correcto!",
			correct: true
		},
		{
			text: "BPE tokeniza palabras en subpalabras encontrando la subpalabra más larga partiendo desde el inicio que está en el vocabulario, luego repite el proceso para el resto del texto.",
			explain: "No, esa es la manera en que otro algoritmo de tokenización hace las cosas."
		},
	]}
/>

### 9. Selecciona las afirmaciones que aplican para el modelo de tokenizacion WordPiece.

<Question
	choices={[
		{
			text: "WordPiece es un algoritmo de tokenización de subpalabras que comienza con un vocabulario pequeño y aprende reglas de fusión.",
			explain: "Este es el caso de hecho!",
			correct: true
		},
		{
			text: "WordPiece un algoritmo de tokenización de subpalabras que comienza con un vocabulario grande y de manera progresiva remueve tokens de él.",
			explain: "No, ese el método tomado por un algoritmo de tokenización diferente."
		},
		{
			text: "Los tokenizadores WordPiece aprenden reglas de fusión fusionando el par de tokens más frecuentes.",
			explain: "No, esa es la estrategia aplicada por otro algoritmo de tokenización."
		},
		{
			text: "Un tokenizador WordPiece aprende una regla de fusión fusionando el par de tokens que maximiza un puntaje que privilegia pares frecuentes con partes individuales menos frecuentes.",
			explain: "Eso es correcto!",
			correct: true
		},
		{
			text: "WordPiece tokeniza palabras en subpalabras encontrando la segmentación en tokens más probable, de acuerdo al modelo.",
			explain: "No, así es como otro algoritmo de tokenización funciona."
		},
		{
			text: "WordPiece tokeniza palabras en subpalabras encontrando la subpalabra máas larga partiendo desde el inicio que está en el vocabularoi, luego repite el proceso para el resto del texto.",
			explain: "Sí, así es como WordPiece procede para la codificación.",
			correct: true
		},
	]}
/>

### 10. Selecciona las afirmaciones que aplican para el modelo de tokenización Unigram.

<Question
	choices={[
		{
			text: "Unigram es un algoritmo de tokenización que comienza con un vocabulario pequeño y aprende reglas de fusión.",
			explain: "No, ese el método tomado por otro algoritmo de tokenización."
		},
		{
			text: "Unigram es un algoritmo de tokenización que comienza con un vocabulario grande y progresivamente remueve tokens de él.",
			explain: "Eso es correcto!",
			correct: true
		},
		{
			text: "Unigram adapta su vocabulario minimizando una pérdia calculada sobre el corpus completo.",
			explain: "Eso está correcto!",
			correct: true
		},
		{
			text: "Unigram adapta su vocabularo manteneiendo las subpalabras más frecuentes.",
			explain: "No, esto es incorrecto."
		},
		{
			text: "Unigram tokeniza palabras en subpalabras encontrando la segmentación en tokens más probable, de acuerdo al modelo.",
			explain: "Eso es correcto!",
			correct: true
		},
		{
			text: "Unigram tokeniza palabras en subpalabras separandolas en caracteres, luego aplicando caracteres, luego aplicando reglas de fusión.",
			explain: "No, así es como funciona otro algoritmo de tokenización."
		},
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/es/chapter6/10.mdx" />