import{s as Vl,o as vl,n as Xe}from"../chunks/scheduler.cc52f4b9.js";import{S as Wl,i as kl,e as c,s as t,c as p,h as zl,a as J,d as l,b as a,f as Gl,g as r,j as y,k as $l,l as Xl,m as n,n as o,t as u,o as d,p as m}from"../chunks/index.9480bb2b.js";import{T as ze}from"../chunks/Tip.f7b80743.js";import{C as Rl,H as Ps,E as Cl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.04d617be.js";import{Y as Ql}from"../chunks/Youtube.7b12d9e8.js";import{C as T}from"../chunks/CodeBlock.f4148b32.js";import{C as Nl}from"../chunks/CourseFloatingBanner.cdc38ef1.js";function El(b){let i,h='✎ Par défaut, 🤗 <em>Datasets</em> décompresse les fichiers nécessaires pour charger un jeu de données. Si vous souhaitez conserver de l’espace sur le disque dur, vous pouvez passer <code>DownloadConfig(delete_extracted=True)</code> à l’argument <code>download_config</code> de <code>load_dataset()</code>. Voir la <a href="https://huggingface.co/docs/datasets/package_reference/builder_classes#datasets.DownloadConfig" rel="nofollow">documentation</a> pour plus de détails.';return{c(){i=c("p"),i.innerHTML=h},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1v02m"&&(i.innerHTML=h)},m(M,j){n(M,i,j)},p:Xe,d(M){M&&l(i)}}}function Yl(b){let i,h='✏️ <strong>Essayez !</strong> Choisissez l’un des <a href="https://the-eye.eu/public/AI/pile_preliminary_components/" rel="nofollow">sous-ensembles</a> de <em>The Pile</em> qui est plus grand que la RAM de votre ordinateur portable ou de bureau. Chargez-le avec 🤗 <em>Datasets</em> et mesurez la quantité de RAM utilisée. Notez que pour obtenir une mesure précise, vous devrez le faire dans un nouveau processus. Vous pouvez trouver les tailles décompressées de chaque sous-ensemble dans le tableau 1 du papier de <a href="https://arxiv.org/abs/2101.00027" rel="nofollow"><em>The Pile</em></a>.';return{c(){i=c("p"),i.innerHTML=h},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1osdilj"&&(i.innerHTML=h)},m(M,j){n(M,i,j)},p:Xe,d(M){M&&l(i)}}}function Hl(b){let i,h='💡 Dans les <em>notebooks</em> Jupyter, vous pouvez également chronométrer les cellules à l’aide de la fonction magique <a href="https://ipython.readthedocs.io/en/stable/interactive/magics.html#magic-timeit" rel="nofollow"><code>%%timeit</code></a>.';return{c(){i=c("p"),i.innerHTML=h},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-38kpfm"&&(i.innerHTML=h)},m(M,j){n(M,i,j)},p:Xe,d(M){M&&l(i)}}}function _l(b){let i,h="💡 Pour accélérer la tokenisation avec le streaming, vous pouvez passer <code>batched=True</code>, comme nous l’avons vu dans la dernière section. Il traitera les exemples batch par batch. La taille de batch par défaut est de 1 000 et peut être spécifiée avec l’argument <code>batch_size</code>.";return{c(){i=c("p"),i.innerHTML=h},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1ej2rqj"&&(i.innerHTML=h)},m(M,j){n(M,i,j)},p:Xe,d(M){M&&l(i)}}}function Sl(b){let i,h='✏️ <strong>Essayez !</strong> Utilisez l’un des grands corpus Common Crawl comme <a href="https://huggingface.co/datasets/mc4" rel="nofollow"><code>mc4</code></a> ou <a href="https://huggingface.co/datasets/oscar" rel="nofollow"><code>oscar</code></a> pour créer en streaming un jeu de données multilingue représentant les proportions de langues parlées dans un pays de votre choix. Par exemple, les quatre langues nationales en Suisse sont l’allemand, le français, l’italien et le romanche. Vous pouvez donc essayer de créer un corpus suisse en échantillonnant les sous-ensembles Oscar en fonction de leur proportion parlée.';return{c(){i=c("p"),i.innerHTML=h},l(M){i=J(M,"P",{"data-svelte-h":!0}),y(i)!=="svelte-of2k18"&&(i.innerHTML=h)},m(M,j){n(M,i,j)},p:Xe,d(M){M&&l(i)}}}function Fl(b){let i,h,M,j,x,Re,Z,Ce,B,Qe,G,Os="De nos jours, il n’est pas rare de travailler avec des jeux de données de plusieurs gigaoctets surtout si vous envisagez de pré-entraîner un <em>transformer</em> comme BERT ou GPT-2 à partir de zéro. Dans ces cas, même <em>charger</em> les données peut être un défi. Par exemple, le corpus WebText utilisé pour pré-entraîner GPT-2 se compose de plus de 8 millions de documents et de 40 Go de texte. Le charger dans la RAM de votre ordinateur portable est susceptible de lui donner une crise cardiaque !",Ne,$,Ks="Heureusement, 🤗 <em>Datasets</em> a été conçu pour surmonter ces limitations. Il vous libère des problèmes de gestion de la mémoire en traitant les jeux de données comme des fichiers <em>mappés en mémoire</em>, ainsi que des limites du disque dur en faisant du <em>streaming</em> sur les entrées dans un corpus.",Ee,V,Ye,v,el='Dans cette section, nous allons explorer ces fonctionnalités de 🤗 <em>Datasets</em> avec un énorme corpus de 825 Go connu sous le nom de <a href="https://pile.eleuther.ai" rel="nofollow"><em>The Pile</em></a>. Commençons !',He,W,_e,k,sl='<em>The Pile</em> est un corpus de texte en anglais créé par <a href="https://www.eleuther.ai" rel="nofollow">EleutherAI</a> pour entraîner des modèles de langage à grande échelle. Il comprend une gamme variée de jeux de données, couvrant des articles scientifiques, des référentiels de code GitHub et du texte Web filtré. Le corpus d’entraînement est disponible en <a href="https://the-eye.eu/public/AI/pile/" rel="nofollow">morceaux de 14 Go</a> et vous pouvez aussi télécharger plusieurs des <a href="https://the-eye.eu/public/AI/pile_preliminary_components/" rel="nofollow">composants individuels</a>. Commençons par jeter un coup d’œil au jeu de données <em>PubMed Abstracts</em>, qui est un corpus de résumés de 15 millions de publications biomédicales sur <a href="https://pubmed.ncbi.nlm.nih.gov/" rel="nofollow">PubMed</a>. Le jeu de données est au <a href="https://jsonlines.org" rel="nofollow">format JSON Lines</a> et est compressé à l’aide de la bibliothèque <code>zstandard</code>. Nous devons donc d’abord installer cette bibliothèque :',Se,z,Fe,X,ll='Ensuite, nous pouvons charger le jeu de données en utilisant la méthode pour les fichiers distants que nous avons apprise dans <a href="/course/fr/chapter5/2">section 2</a> :',Ae,R,De,C,Le,Q,nl="Nous pouvons voir qu’il y a 15 518 009 lignes et 2 colonnes dans notre jeu de données. C’est beaucoup !",qe,U,Pe,N,tl="Inspectons le contenu du premier exemple :",Oe,E,Ke,Y,es,H,al="Cela ressemble au résumé d’un article médical. Voyons maintenant combien de RAM nous avons utilisé pour charger le jeu de données !",ss,_,ls,S,il='Un moyen simple de mesurer l’utilisation de la mémoire dans Python consiste à utiliser la bibliothèque <a href="https://psutil.readthedocs.io/en/latest/" rel="nofollow"><code>psutil</code></a> qui peut être installée avec <code>pip</code> comme suit :',ns,F,ts,A,pl="Elle fournit une classe <code>Process</code> qui permet de vérifier l’utilisation de la mémoire du processus en cours :",as,D,is,L,ps,q,rl="Ici, l’attribut <code>rss</code> fait référence à la <em>taille de l’ensemble résident</em>, qui est la fraction de mémoire qu’un processus occupe dans la RAM. Cette mesure inclut également la mémoire utilisée par l’interpréteur Python et les bibliothèques que nous avons chargées, de sorte que la quantité réelle de mémoire utilisée pour charger le jeu de données est un peu plus petite. À titre de comparaison, voyons la taille du jeu de données sur le disque en utilisant l’attribut <code>dataset_size</code>. Comme le résultat est exprimé en octets comme précédemment, nous devons le convertir manuellement en gigaoctets :",rs,P,os,O,us,K,ol="Malgré sa taille de près de 20 Go, nous pouvons charger et accéder au jeu de données avec beaucoup moins de RAM !",ds,f,ms,ee,ul='Si vous êtes familier avec Pandas, ce résultat pourrait surprendre en raison de la célèbre <a href="https://wesmckinney.com/blog/apache-arrow-pandas-internals/" rel="nofollow">règle d’or</a> de Wes Kinney selon laquelle vous avez généralement besoin de 5 à 10 fois plus de RAM que la taille de votre jeu de données. Alors, comment 🤗 <em>Datasets</em> résout-il ce problème de gestion de la mémoire ? 🤗 <em>Datasets</em> traite chaque jeu de données comme un <a href="https://en.wikipedia.org/wiki/Memory-mapped_file" rel="nofollow">fichier mappé en mémoire</a>. Cela fournit un mappage entre la RAM et le stockage du système de fichiers permettant à la bibliothèque d’accéder et d’opérer sur des éléments du jeu de données sans avoir besoin de le charger entièrement en mémoire.',Ms,se,dl='Les fichiers mappés en mémoire peuvent également être partagés entre plusieurs processus ce qui permet de paralléliser des méthodes telles que <code>Dataset.map()</code> sans avoir à déplacer ou copier le jeu de données. Sous le capot, ces capacités sont toutes réalisées par le format de mémoire <a href="https://arrow.apache.org" rel="nofollow">Apache Arrow</a> et <a href="https://arrow.apache.org/docs/python/index.html" rel="nofollow"><code>pyarrow</code></a>, qui accélèrent le chargement et le traitement des données. (Pour plus de détails sur Apache Arrow et les comparaisons avec Pandas, consultez <a href="https://towardsdatascience.com/apache-arrow-read-dataframe-with-zero-memory-69634092b1a" rel="nofollow">l’article de blog de Dejan Simic</a>). Pour voir ceci en action, effectuons un petit test de vitesse en itérant sur tous les éléments du jeu de données <em>PubMed Abstracts</em> :',cs,le,Js,ne,ys,te,ml="Ici, nous avons utilisé le module <code>timeit</code> de Python pour mesurer le temps d’exécution pris par <code>code_snippet</code>. Vous pourrez généralement itérer sur un jeu de données à une vitesse de quelques dixièmes de Go/s à plusieurs Go/s. Cela fonctionne très bien pour la grande majorité des applications, mais vous devrez parfois travailler avec un jeu de données trop volumineux pour être même stocké sur le disque dur de votre ordinateur portable. Par exemple, si nous essayions de télécharger <em>The Pile</em> dans son intégralité, nous aurions besoin de 825 Go d’espace disque libre ! Pour gérer ces cas, 🤗 <em>Datasets</em> fournit une fonctionnalité de streaming qui nous permet de télécharger et d’accéder aux éléments à la volée, sans avoir besoin de télécharger l’intégralité du jeu de données. Voyons comment cela fonctionne.",Ts,w,hs,ae,js,ie,Ml="Pour activer le streaming du jeu de données, il vous suffit de passer l’argument <code>streaming=True</code> à la fonction <code>load_dataset()</code>. Par exemple, chargeons à nouveau le jeu de données <em>PubMed Abstracts</em> mais en mode streaming :",bs,pe,Us,re,cl="Au lieu du familier <code>Dataset</code> que nous avons rencontré ailleurs dans ce chapitre, l’objet retourné avec <code>streaming=True</code> est un <code>IterableDataset</code>. Comme son nom l’indique, pour accéder aux éléments d’un <code>IterableDataset</code>, nous devons parcourir celui-ci. Nous pouvons accéder au premier élément de notre jeu de données diffusé comme suit :",fs,oe,ws,ue,gs,de,Jl='Les éléments d’un jeu de données diffusé en continu peuvent être traités à la volée à l’aide de <code>IterableDataset.map()</code>, ce qui est utile pendant l’entraînement si vous avez besoin de tokeniser les entrées. Le processus est exactement le même que celui que nous avons utilisé pour tokeniser notre jeu de données dans le <a href="/course/fr/chapter3">chapitre 3</a>, à la seule différence que les sorties sont renvoyées une par une :',Is,me,xs,Me,Zs,g,Bs,ce,yl="Vous pouvez également mélanger un jeu de données diffusé en continu à l’aide de <code>IterableDataset.shuffle()</code>, mais contrairement à <code>Dataset.shuffle()</code>, cela ne mélange que les éléments dans un <code>buffer_size</code> prédéfini :",Gs,Je,$s,ye,Vs,Te,Tl="Dans cet exemple, nous avons sélectionné un exemple aléatoire parmi les 10 000 premiers exemples du tampon. Une fois qu’un exemple est accédé, sa place dans le tampon est remplie avec l’exemple suivant dans le corpus (c’est-à-dire le 10 001e exemple dans le cas ci-dessus). Vous pouvez également sélectionner des éléments d’un jeu de données diffusé en continu à l’aide des fonctions <code>IterableDataset.take()</code> et <code>IterableDataset.skip()</code>, qui agissent de la même manière que <code>Dataset.select()</code>. Par exemple, pour sélectionner les 5 premiers exemples dans le jeu de données <em>PubMed Abstracts</em>, nous pouvons procéder comme suit :",vs,he,Ws,je,ks,be,hl="De même, vous pouvez utiliser la fonction <code>IterableDataset.skip()</code> pour créer des fractionnements d’entraînement et de validation à partir d’un jeu de données mélangé comme suit :",zs,Ue,Xs,fe,jl="Terminons notre exploration du streaming des jeux de données avec une application commune : combiner plusieurs jeux de données pour créer un seul corpus. 🤗 <em>Datasets</em> fournit une fonction <code>interleave_datasets()</code> qui convertit une liste d’objets <code>IterableDataset</code> en un seul <code>IterableDataset</code>, où les éléments du nouveau jeu de données sont obtenus en alternant entre les exemples source. Cette fonction est particulièrement utile lorsque vous essayez de combiner de grands jeux de données. Par exemple, streamons FreeLaw, un sous-ensemble de <em>The Pile</em> et qui est un jeu de données de 51 Go d’avis juridiques de tribunaux américains :",Rs,we,Cs,ge,Qs,Ie,bl="Ce jeu de données est suffisamment volumineux pour solliciter la RAM de la plupart des ordinateurs portables, mais nous avons pu le charger et y accéder sans transpirer ! Combinons maintenant les jeux de données FreeLaw et <em>PubMed Abstracts</em> avec la fonction <code>interleave_datasets()</code> :",Ns,xe,Es,Ze,Ys,Be,Ul="Ici, nous avons utilisé la fonction <code>islice()</code> du module <code>itertools</code> de Python pour sélectionner les deux premiers exemples du jeu de données combiné. Nous pouvons voir qu’ils correspondent aux premiers exemples de chacun des deux jeux de données source.",Hs,Ge,fl="Enfin, si vous souhaitez streamer <em>The Pile</em> dans son intégralité de 825 Go, vous pouvez récupérer tous les fichiers préparés comme suit :",_s,$e,Ss,Ve,Fs,I,As,ve,wl="Vous disposez maintenant de tous les outils dont vous avez besoin pour charger et traiter des jeux de données de toutes formes et tailles. Cependant à moins que vous ne soyez exceptionnellement chanceux, il arrivera un moment dans votre cheminement en traitement du langage naturel où vous devrez réellement créer un jeu de données pour résoudre un problème donné. C’est le sujet de la section suivante !",Ds,We,Ls,ke,qs;return x=new Rl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),Z=new Ps({props:{title:"Données massives ? 🤗 <i> Datasets </i> à la rescousse !",local:"données-massives---i-datasets-i-à-la-rescousse-",headingTag:"h1"}}),B=new Nl({props:{chapter:5,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter5/section4.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter5/section4.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter5/section4.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter5/section4.ipynb"}]}}),V=new Ql({props:{id:"JwISwTCPPWo"}}),W=new Ps({props:{title:"Qu’est-ce que <i> The Pile </i> ?",local:"quest-ce-que-i-the-pile-i-",headingTag:"h2"}}),z=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjB6c3RhbmRhcmQ=",highlighted:"!pip install zstandard",wrap:!1}}),R=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwQ2VsYSUyMHByZW5kJTIwcXVlbHF1ZXMlMjBtaW51dGVzJTIwJUMzJUEwJTIwZXglQzMlQTljdXRlciUyQyUyMGFsb3JzJTIwYWxsZXolMjBwcmVuZHJlJTIwdW4lMjB0aCVDMyVBOSUyMG91JTIwdW4lMjBjYWYlQzMlQTklMjBlbiUyMGF0dGVuZGFudCUyMCUzQSklMEFkYXRhX2ZpbGVzJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ0aGUtZXllLmV1JTJGcHVibGljJTJGQUklMkZwaWxlX3ByZWxpbWluYXJ5X2NvbXBvbmVudHMlMkZQVUJNRURfdGl0bGVfYWJzdHJhY3RzXzIwMTlfYmFzZWxpbmUuanNvbmwuenN0JTIyJTBBcHVibWVkX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyanNvbiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFwdWJtZWRfZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Cela prend quelques minutes à exécuter, alors allez prendre un thé ou un café en attendant :)</span>
data_files = <span class="hljs-string">&quot;https://the-eye.eu/public/AI/pile_preliminary_components/PUBMED_title_abstracts_2019_baseline.jsonl.zst&quot;</span>
pubmed_dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>)
pubmed_dataset`,wrap:!1}}),C=new T({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidtZXRhJyUyQyUyMCd0ZXh0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMTU1MTgwMDklMEElN0Qp",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;meta&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>],
    num_rows: <span class="hljs-number">15518009</span>
})`,wrap:!1}}),U=new ze({props:{$$slots:{default:[El]},$$scope:{ctx:b}}}),E=new T({props:{code:"cHVibWVkX2RhdGFzZXQlNUIwJTVE",highlighted:'pubmed_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),Y=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24uJTVDblRvJTIwZGV0ZXJtaW5lJTIwdGhlJTIwcHJldmFsZW5jZSUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjBhZ2VkJTIwdW5kZXIlMjA1JTIweWVhcnMlMjBzdWZmZXJpbmclMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb25zJTIwKEFMUkkpJTJDJTIwdGhlJTIwcmlzayUyMGZhY3RvcnMlMjBmb3IlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHVuZGVyJTIwNSUyMHllYXJzJTIwb2YlMjBhZ2UlMjB3aXRoJTIwQUxSSSUyQyUyMGFuZCUyMHRoZSUyMGFzc29jaWF0aW9uJTIwb2YlMjBoeXBveGFlbWlhJTIwd2l0aCUyMGFuJTIwaW5jcmVhc2VkJTIwcmlzayUyMG9mJTIwZHlpbmclMjBpbiUyMGNoaWxkcmVuJTIwb2YlMjB0aGUlMjBzYW1lJTIwYWdlJTIwLi4uJyUwQSUyMyUyMCVDMyU4OXBpZCVDMyVBOW1pb2xvZ2llJTIwZGUlMjBsJ2h5cG94JUMzJUE5bWllJTIwY2hleiUyMGxlcyUyMGVuZmFudHMlMjBzb3VmZnJhbnQlMjBkJ3VuZSUyMGluZmVjdGlvbiUyMGFpZ3UlQzMlQUIlMjBkZXMlMjB2b2llcyUyMHJlc3BpcmF0b2lyZXMlMjBpbmYlQzMlQTlyaWV1cmVzLiUyMEQlQzMlQTl0ZXJtaW5lciUyMGxhJTIwcHIlQzMlQTl2YWxlbmNlJTIwZGUlMjBsJ2h5cG94JUMzJUE5bWllJTIwY2hleiUyMGxlcyUyMGVuZmFudHMlMjBkZSUyMG1vaW5zJTIwZGUlMjA1JTIwYW5zJTIwc291ZmZyYW50JTIwZCd1bmUlMjBpbmZlY3Rpb24lMjBhaWd1JUMzJUFCJTIwZGVzJTIwdm9pZXMlMjByZXNwaXJhdG9pcmVzJTIwaW5mJUMzJUE5cmlldXJlcyUyMChJQVZJKSUyQyUyMGxlcyUyMGZhY3RldXJzJTIwZGUlMjByaXNxdWUlMjBkZSUyMGwnaHlwb3glQzMlQTltaWUlMjBjaGV6JTIwbGVzJTIwZW5mYW50cyUyMGRlJTIwbW9pbnMlMjBkZSUyMDUlMjBhbnMlMjBzb3VmZnJhbnQlMjBkJ3VuZSUyMElBVkklMkMlMjBldCUyMGwnYXNzb2NpYXRpb24lMjBkZSUyMGwnaHlwb3glQzMlQTltaWUlMjAlQzMlQTAlMjB1biUyMHJpc3F1ZSUyMGFjY3J1JTIwZGUlMjBkJUMzJUE5YyVDMyVBOHMlMjBjaGV6JTIwbGVzJTIwZW5mYW50cyUyMGR1JTIwbSVDMyVBQW1lJTIwJUMzJUEyZ2UlMjAuLi4lMEElN0Q=",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection.\\nTo determine the prevalence of hypoxaemia in children aged under 5 years suffering acute lower respiratory infections (ALRI), the risk factors for hypoxaemia in children under 5 years of age with ALRI, and the association of hypoxaemia with an increased risk of dying in children of the same age ...&#x27;</span>
<span class="hljs-comment"># Épidémiologie de l&#x27;hypoxémie chez les enfants souffrant d&#x27;une infection aiguë des voies respiratoires inférieures. Déterminer la prévalence de l&#x27;hypoxémie chez les enfants de moins de 5 ans souffrant d&#x27;une infection aiguë des voies respiratoires inférieures (IAVI), les facteurs de risque de l&#x27;hypoxémie chez les enfants de moins de 5 ans souffrant d&#x27;une IAVI, et l&#x27;association de l&#x27;hypoxémie à un risque accru de décès chez les enfants du même âge ...</span>
}`,wrap:!1}}),_=new Ps({props:{title:"La magie du <i> memory mapping </i>",local:"la-magie-du-i-memory-mapping-i",headingTag:"h2"}}),F=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjBwc3V0aWw=",highlighted:"!pip install psutil",wrap:!1}}),D=new T({props:{code:"aW1wb3J0JTIwcHN1dGlsJTBBJTBBJTIzJTIwUHJvY2Vzcy5tZW1vcnlfaW5mbyUyMGVzdCUyMGV4cHJpbSVDMyVBOSUyMGVuJTIwb2N0ZXRzJTJDJTIwZG9uYyUyMGNvbnZlcnRpciUyMGVuJTIwbSVDMyVBOWdhb2N0ZXRzJTBBcHJpbnQoZiUyMlJBTSUyMHVzZWQlM0ElMjAlN0Jwc3V0aWwuUHJvY2VzcygpLm1lbW9yeV9pbmZvKCkucnNzJTIwJTJGJTIwKDEwMjQlMjAqJTIwMTAyNCklM0EuMmYlN0QlMjBNQiUyMik=",highlighted:`<span class="hljs-keyword">import</span> psutil

<span class="hljs-comment"># Process.memory_info est exprimé en octets, donc convertir en mégaoctets</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;RAM used: <span class="hljs-subst">{psutil.Process().memory_info().rss / (<span class="hljs-number">1024</span> * <span class="hljs-number">1024</span>):<span class="hljs-number">.2</span>f}</span> MB&quot;</span>)`,wrap:!1}}),L=new T({props:{code:"UkFNJTIwdXNlZCUzQSUyMDU2NzguMzMlMjBNQg==",highlighted:'RAM used: <span class="hljs-number">5678.33</span> MB',wrap:!1}}),P=new T({props:{code:"cHJpbnQoZiUyMk51bWJlciUyMG9mJTIwZmlsZXMlMjBpbiUyMGRhdGFzZXQlMjAlM0ElMjAlN0JwdWJtZWRfZGF0YXNldC5kYXRhc2V0X3NpemUlN0QlMjIpJTBBc2l6ZV9nYiUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0LmRhdGFzZXRfc2l6ZSUyMCUyRiUyMCgxMDI0KiozKSUwQXByaW50KGYlMjJEYXRhc2V0JTIwc2l6ZSUyMChjYWNoZSUyMGZpbGUpJTIwJTNBJTIwJTdCc2l6ZV9nYiUzQS4yZiU3RCUyMEdCJTIyKQ==",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Number of files in dataset : <span class="hljs-subst">{pubmed_dataset.dataset_size}</span>&quot;</span>)
size_gb = pubmed_dataset.dataset_size / (<span class="hljs-number">1024</span>**<span class="hljs-number">3</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Dataset size (cache file) : <span class="hljs-subst">{size_gb:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),O=new T({props:{code:"TnVtYmVyJTIwb2YlMjBmaWxlcyUyMGluJTIwZGF0YXNldCUyMCUzQSUyMDIwOTc5NDM3MDUxJTBBRGF0YXNldCUyMHNpemUlMjAoY2FjaGUlMjBmaWxlKSUyMCUzQSUyMDE5LjU0JTIwR0I=",highlighted:`Number of files <span class="hljs-keyword">in</span> dataset : <span class="hljs-number">20979437051</span>
Dataset size (cache file) : <span class="hljs-number">19.54</span> GB`,wrap:!1}}),f=new ze({props:{$$slots:{default:[Yl]},$$scope:{ctx:b}}}),le=new T({props:{code:"aW1wb3J0JTIwdGltZWl0JTBBJTBBY29kZV9zbmlwcGV0JTIwJTNEJTIwJTIyJTIyJTIyYmF0Y2hfc2l6ZSUyMCUzRCUyMDEwMDAlMEElMEFmb3IlMjBpZHglMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4ocHVibWVkX2RhdGFzZXQpJTJDJTIwYmF0Y2hfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBfJTIwJTNEJTIwcHVibWVkX2RhdGFzZXQlNUJpZHglM0FpZHglMjAlMkIlMjBiYXRjaF9zaXplJTVEJTBBJTIyJTIyJTIyJTBBJTBBdGltZSUyMCUzRCUyMHRpbWVpdC50aW1laXQoc3RtdCUzRGNvZGVfc25pcHBldCUyQyUyMG51bWJlciUzRDElMkMlMjBnbG9iYWxzJTNEZ2xvYmFscygpKSUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJJdGVyYXRlZCUyMG92ZXIlMjAlN0JsZW4ocHVibWVkX2RhdGFzZXQpJTdEJTIwZXhhbXBsZXMlMjAoYWJvdXQlMjAlN0JzaXplX2diJTNBLjFmJTdEJTIwR0IpJTIwaW4lMjAlMjIlMEElMjAlMjAlMjAlMjBmJTIyJTdCdGltZSUzQS4xZiU3RHMlMkMlMjBpLmUuJTIwJTdCc2l6ZV9nYiUyRnRpbWUlM0EuM2YlN0QlMjBHQiUyRnMlMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> timeit

code_snippet = <span class="hljs-string">&quot;&quot;&quot;batch_size = 1000

for idx in range(0, len(pubmed_dataset), batch_size):
    _ = pubmed_dataset[idx:idx + batch_size]
&quot;&quot;&quot;</span>

time = timeit.timeit(stmt=code_snippet, number=<span class="hljs-number">1</span>, <span class="hljs-built_in">globals</span>=<span class="hljs-built_in">globals</span>())
<span class="hljs-built_in">print</span>(
    <span class="hljs-string">f&quot;Iterated over <span class="hljs-subst">{<span class="hljs-built_in">len</span>(pubmed_dataset)}</span> examples (about <span class="hljs-subst">{size_gb:<span class="hljs-number">.1</span>f}</span> GB) in &quot;</span>
    <span class="hljs-string">f&quot;<span class="hljs-subst">{time:<span class="hljs-number">.1</span>f}</span>s, i.e. <span class="hljs-subst">{size_gb/time:<span class="hljs-number">.3</span>f}</span> GB/s&quot;</span>
)`,wrap:!1}}),ne=new T({props:{code:"J0l0ZXJhdGVkJTIwb3ZlciUyMDE1NTE4MDA5JTIwZXhhbXBsZXMlMjAoYWJvdXQlMjAxOS41JTIwR0IpJTIwaW4lMjA2NC4ycyUyQyUyMGkuZS4lMjAwLjMwNCUyMEdCJTJGcyc=",highlighted:'<span class="hljs-string">&#x27;Iterated over 15518009 examples (about 19.5 GB) in 64.2s, i.e. 0.304 GB/s&#x27;</span>',wrap:!1}}),w=new ze({props:{$$slots:{default:[Hl]},$$scope:{ctx:b}}}),ae=new Ps({props:{title:"Jeux de données en continu",local:"jeux-de-données-en-continu",headingTag:"h2"}}),pe=new T({props:{code:"cHVibWVkX2RhdGFzZXRfc3RyZWFtZWQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyanNvbiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUlMEEp",highlighted:`pubmed_dataset_streamed = load_dataset(
    <span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>
)`,wrap:!1}}),oe=new T({props:{code:"bmV4dChpdGVyKHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkKSk=",highlighted:'<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(pubmed_dataset_streamed))',wrap:!1}}),ue=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24uJTVDblRvJTIwZGV0ZXJtaW5lJTIwdGhlJTIwcHJldmFsZW5jZSUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjBhZ2VkJTIwdW5kZXIlMjA1JTIweWVhcnMlMjBzdWZmZXJpbmclMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb25zJTIwKEFMUkkpJTJDJTIwdGhlJTIwcmlzayUyMGZhY3RvcnMlMjBmb3IlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHVuZGVyJTIwNSUyMHllYXJzJTIwb2YlMjBhZ2UlMjB3aXRoJTIwQUxSSSUyQyUyMGFuZCUyMHRoZSUyMGFzc29jaWF0aW9uJTIwb2YlMjBoeXBveGFlbWlhJTIwd2l0aCUyMGFuJTIwaW5jcmVhc2VkJTIwcmlzayUyMG9mJTIwZHlpbmclMjBpbiUyMGNoaWxkcmVuJTIwb2YlMjB0aGUlMjBzYW1lJTIwYWdlJTIwLi4uJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection.\\nTo determine the prevalence of hypoxaemia in children aged under 5 years suffering acute lower respiratory infections (ALRI), the risk factors for hypoxaemia in children under 5 years of age with ALRI, and the association of hypoxaemia with an increased risk of dying in children of the same age ...&#x27;</span>}`,wrap:!1}}),me=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldCUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkLm1hcChsYW1iZGElMjB4JTNBJTIwdG9rZW5pemVyKHglNUIlMjJ0ZXh0JTIyJTVEKSklMEFuZXh0KGl0ZXIodG9rZW5pemVkX2RhdGFzZXQpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>)
tokenized_dataset = pubmed_dataset_streamed.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: tokenizer(x[<span class="hljs-string">&quot;text&quot;</span>]))
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(tokenized_dataset))`,wrap:!1}}),Me=new T({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjAlNUIxMDElMkMlMjA0OTU4JTJDJTIwNTE3OCUyQyUyMDQzMjglMkMlMjA2Nzc5JTJDJTIwLi4uJTVEJTJDJTIwJ2F0dGVudGlvbl9tYXNrJyUzQSUyMCU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwLi4uJTVEJTdE",highlighted:'{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">4958</span>, <span class="hljs-number">5178</span>, <span class="hljs-number">4328</span>, <span class="hljs-number">6779</span>, ...], <span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ...]}',wrap:!1}}),g=new ze({props:{$$slots:{default:[_l]},$$scope:{ctx:b}}}),Je=new T({props:{code:"c2h1ZmZsZWRfZGF0YXNldCUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkLnNodWZmbGUoYnVmZmVyX3NpemUlM0QxMF8wMDAlMkMlMjBzZWVkJTNENDIpJTBBbmV4dChpdGVyKHNodWZmbGVkX2RhdGFzZXQpKQ==",highlighted:`shuffled_dataset = pubmed_dataset_streamed.shuffle(buffer_size=<span class="hljs-number">10_000</span>, seed=<span class="hljs-number">42</span>)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(shuffled_dataset))`,wrap:!1}}),ye=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MTA3OTklMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnUmFuZG9taXplZCUyMHN0dWR5JTIwb2YlMjBkb3NlJTIwb3IlMjBzY2hlZHVsZSUyMG1vZGlmaWNhdGlvbiUyMG9mJTIwZ3JhbnVsb2N5dGUlMjBjb2xvbnktc3RpbXVsYXRpbmclMjBmYWN0b3IlMjBpbiUyMHBsYXRpbnVtLWJhc2VkJTIwY2hlbW90aGVyYXB5JTIwZm9yJTIwZWxkZXJseSUyMHBhdGllbnRzJTIwd2l0aCUyMGx1bmclMjBjYW5jZXIlMjAuLi4nJTBBJTIzJTIwJUMzJTg5dHVkZSUyMHJhbmRvbWlzJUMzJUE5ZSUyMHN1ciUyMGxhJTIwbW9kaWZpY2F0aW9uJTIwZGUlMjBsYSUyMGRvc2UlMjBvdSUyMGR1JTIwY2FsZW5kcmllciUyMGQnYWRtaW5pc3RyYXRpb24lMjBkdSUyMGZhY3RldXIlMjBkZSUyMHN0aW11bGF0aW9uJTIwZGVzJTIwY29sb25pZXMlMjBkZSUyMGdyYW51bG9jeXRlcyUyMGRhbnMlMjBsZSUyMGNhZHJlJTIwZCd1bmUlMjBjaGltaW90aCVDMyVBOXJhcGllJTIwJUMzJUEwJTIwYmFzZSUyMGRlJTIwcGxhdGluZSUyMGNoZXolMjBsZXMlMjBwYXRpZW50cyUyMCVDMyVBMmclQzMlQTlzJTIwYXR0ZWludHMlMjBkZSUyMGNhbmNlciUyMGR1JTIwcG91bW9uJTIwLi4uJTBBJTdE",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11410799</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Randomized study of dose or schedule modification of granulocyte colony-stimulating factor in platinum-based chemotherapy for elderly patients with lung cancer ...&#x27;</span>
<span class="hljs-comment"># Étude randomisée sur la modification de la dose ou du calendrier d&#x27;administration du facteur de stimulation des colonies de granulocytes dans le cadre d&#x27;une chimiothérapie à base de platine chez les patients âgés atteints de cancer du poumon ...</span>
}`,wrap:!1}}),he=new T({props:{code:"ZGF0YXNldF9oZWFkJTIwJTNEJTIwcHVibWVkX2RhdGFzZXRfc3RyZWFtZWQudGFrZSg1KSUwQWxpc3QoZGF0YXNldF9oZWFkKQ==",highlighted:`dataset_head = pubmed_dataset_streamed.take(<span class="hljs-number">5</span>)
<span class="hljs-built_in">list</span>(dataset_head)`,wrap:!1}}),je=new T({props:{code:"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",highlighted:`[{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection ...&#x27;</span>
<span class="hljs-comment"># Épidémiologie de l&#x27;hypoxémie chez les enfants atteints d&#x27;une infection aiguë des voies respiratoires inférieures ...},</span>
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409575</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Clinical signs of hypoxaemia in children with acute lower respiratory infection: indicators of oxygen therapy ...&#x27;</span>
<span class="hljs-comment"># Signes cliniques d&#x27;hypoxémie chez les enfants atteints d&#x27;une infection aiguë des voies respiratoires inférieures : indicateurs de l&#x27;oxygénothérapie ...},</span>
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409576</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot;Hypoxaemia in children with severe pneumonia in Papua New Guinea ...&quot;</span>
<span class="hljs-comment"># Hypoxémie chez les enfants atteints de pneumonie grave en Papouasie-Nouvelle-Guinée ...},</span>
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409577</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Oxygen concentrators and cylinders ...&#x27;</span>
<span class="hljs-comment"># Concentrateurs et bouteilles d&#x27;oxygène...},</span>
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409578</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Oxygen supply in rural africa: a personal experience ...&#x27;</span>
<span class="hljs-comment"># L&#x27;approvisionnement en oxygène dans les zones rurales africaines : une expérience personnelle ...}]</span>`,wrap:!1}}),Ue=new T({props:{code:"JTIzJTIwSWdub3JlciUyMGxlcyUyMDElMjAwMDAlMjBwcmVtaWVycyUyMGV4ZW1wbGVzJTIwZXQlMjBpbmNsdXJlJTIwbGUlMjByZXN0ZSUyMGRhbnMlMjBsJ2Vuc2VtYmxlJTIwZCdhcHByZW50aXNzYWdlLiUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBzaHVmZmxlZF9kYXRhc2V0LnNraXAoMTAwMCklMEElMjMlMjBQcmVuZHJlJTIwbGVzJTIwMSUyMDAwMCUyMHByZW1pZXJzJTIwZXhlbXBsZXMlMjBwb3VyJTIwbCdlbnNlbWJsZSUyMGRlJTIwdmFsaWRhdGlvbi4lMEF2YWxpZGF0aW9uX2RhdGFzZXQlMjAlM0QlMjBzaHVmZmxlZF9kYXRhc2V0LnRha2UoMTAwMCk=",highlighted:`<span class="hljs-comment"># Ignorer les 1 000 premiers exemples et inclure le reste dans l&#x27;ensemble d&#x27;apprentissage.</span>
train_dataset = shuffled_dataset.skip(<span class="hljs-number">1000</span>)
<span class="hljs-comment"># Prendre les 1 000 premiers exemples pour l&#x27;ensemble de validation.</span>
validation_dataset = shuffled_dataset.take(<span class="hljs-number">1000</span>)`,wrap:!1}}),we=new T({props:{code:"bGF3X2RhdGFzZXRfc3RyZWFtZWQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyanNvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfZmlsZXMlM0QlMjJodHRwcyUzQSUyRiUyRnRoZS1leWUuZXUlMkZwdWJsaWMlMkZBSSUyRnBpbGVfcHJlbGltaW5hcnlfY29tcG9uZW50cyUyRkZyZWVMYXdfT3BpbmlvbnMuanNvbmwuenN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbWluZyUzRFRydWUlMkMlMEEpJTBBbmV4dChpdGVyKGxhd19kYXRhc2V0X3N0cmVhbWVkKSk=",highlighted:`law_dataset_streamed = load_dataset(
    <span class="hljs-string">&quot;json&quot;</span>,
    data_files=<span class="hljs-string">&quot;https://the-eye.eu/public/AI/pile_preliminary_components/FreeLaw_Opinions.jsonl.zst&quot;</span>,
    split=<span class="hljs-string">&quot;train&quot;</span>,
    streaming=<span class="hljs-literal">True</span>,
)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(law_dataset_streamed))`,wrap:!1}}),ge=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ2Nhc2VfSUQnJTNBJTIwJzExMDkyMS5qc29uJyUyQyUwQSUyMCUyMCdjYXNlX2p1cmlzZGljdGlvbiclM0ElMjAnc2NvdHVzLnRhci5neiclMkMlMEElMjAlMjAnZGF0ZV9jcmVhdGVkJyUzQSUyMCcyMDEwLTA0LTI4VDE3JTNBMTIlM0E0OVonJTdEJTJDJTBBJTIwJ3RleHQnJTNBJTIwJyU1Q240NjElMjBVLlMuJTIwMjM4JTIwKDE5ODMpJTVDbk9MSU0lMjBFVCUyMEFMLiU1Q252LiU1Q25XQUtJTkVLT05BJTVDbk5vLiUyMDgxLTE1ODEuJTVDblN1cHJlbWUlMjBDb3VydCUyMG9mJTIwVW5pdGVkJTIwU3RhdGVzLiU1Q25Bcmd1ZWQlMjBKYW51YXJ5JTIwMTklMkMlMjAxOTgzLiU1Q25EZWNpZGVkJTIwQXByaWwlMjAyNiUyQyUyMDE5ODMuJTVDbkNFUlRJT1JBUkklMjBUTyUyMFRIRSUyMFVOSVRFRCUyMFNUQVRFUyUyMENPVVJUJTIwT0YlMjBBUFBFQUxTJTIwRk9SJTIwVEhFJTIwTklOVEglMjBDSVJDVUlUJTVDbioyMzklMjBNaWNoYWVsJTIwQS4lMjBMaWxseSUyQyUyMEZpcnN0JTIwRGVwdXR5JTIwQXR0b3JuZXklMjBHZW5lcmFsJTIwb2YlMjBIYXdhaWklMkMlMjBhcmd1ZWQlMjB0aGUlMjBjYXVzZSUyMGZvciUyMHBldGl0aW9uZXJzLiUyMFdpdGglMjBoaW0lMjBvbiUyMHRoZSUyMGJyaWVmJTIwd2FzJTIwSmFtZXMlMjBILiUyMERhbm5lbmJlcmclMkMlMjBEZXB1dHklMjBBdHRvcm5leSUyMEdlbmVyYWwuLi4nJTdE",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;case_ID&#x27;</span>: <span class="hljs-string">&#x27;110921.json&#x27;</span>,
  <span class="hljs-string">&#x27;case_jurisdiction&#x27;</span>: <span class="hljs-string">&#x27;scotus.tar.gz&#x27;</span>,
  <span class="hljs-string">&#x27;date_created&#x27;</span>: <span class="hljs-string">&#x27;2010-04-28T17:12:49Z&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;\\n461 U.S. 238 (1983)\\nOLIM ET AL.\\nv.\\nWAKINEKONA\\nNo. 81-1581.\\nSupreme Court of United States.\\nArgued January 19, 1983.\\nDecided April 26, 1983.\\nCERTIORARI TO THE UNITED STATES COURT OF APPEALS FOR THE NINTH CIRCUIT\\n*239 Michael A. Lilly, First Deputy Attorney General of Hawaii, argued the cause for petitioners. With him on the brief was James H. Dannenberg, Deputy Attorney General...&#x27;</span>}`,wrap:!1}}),xe=new T({props:{code:"ZnJvbSUyMGl0ZXJ0b29scyUyMGltcG9ydCUyMGlzbGljZSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGludGVybGVhdmVfZGF0YXNldHMlMEElMEFjb21iaW5lZF9kYXRhc2V0JTIwJTNEJTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyglNUJwdWJtZWRfZGF0YXNldF9zdHJlYW1lZCUyQyUyMGxhd19kYXRhc2V0X3N0cmVhbWVkJTVEKSUwQWxpc3QoaXNsaWNlKGNvbWJpbmVkX2RhdGFzZXQlMkMlMjAyKSk=",highlighted:`<span class="hljs-keyword">from</span> itertools <span class="hljs-keyword">import</span> islice
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> interleave_datasets

combined_dataset = interleave_datasets([pubmed_dataset_streamed, law_dataset_streamed])
<span class="hljs-built_in">list</span>(islice(combined_dataset, <span class="hljs-number">2</span>))`,wrap:!1}}),Ze=new T({props:{code:"JTVCJTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAlMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24lMjAuLi4nJTdEJTJDJTBBJTIwJTdCJ21ldGEnJTNBJTIwJTdCJ2Nhc2VfSUQnJTNBJTIwJzExMDkyMS5qc29uJyUyQyUwQSUyMCUyMCUyMCdjYXNlX2p1cmlzZGljdGlvbiclM0ElMjAnc2NvdHVzLnRhci5neiclMkMlMEElMjAlMjAlMjAnZGF0ZV9jcmVhdGVkJyUzQSUyMCcyMDEwLTA0LTI4VDE3JTNBMTIlM0E0OVonJTdEJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyU1Q240NjElMjBVLlMuJTIwMjM4JTIwKDE5ODMpJTVDbk9MSU0lMjBFVCUyMEFMLiU1Q252LiU1Q25XQUtJTkVLT05BJTVDbk5vLiUyMDgxLTE1ODEuJTVDblN1cHJlbWUlMjBDb3VydCUyMG9mJTIwVW5pdGVkJTIwU3RhdGVzLiU1Q25Bcmd1ZWQlMjBKYW51YXJ5JTIwMTklMkMlMjAxOTgzLiU1Q25EZWNpZGVkJTIwQXByaWwlMjAyNiUyQyUyMDE5ODMuJTVDbkNFUlRJT1JBUkklMjBUTyUyMFRIRSUyMFVOSVRFRCUyMFNUQVRFUyUyMENPVVJUJTIwT0YlMjBBUFBFQUxTJTIwRk9SJTIwVEhFJTIwTklOVEglMjBDSVJDVUlUJTVDbioyMzklMjBNaWNoYWVsJTIwQS4lMjBMaWxseSUyQyUyMEZpcnN0JTIwRGVwdXR5JTIwQXR0b3JuZXklMjBHZW5lcmFsJTIwb2YlMjBIYXdhaWklMkMlMjBhcmd1ZWQlMjB0aGUlMjBjYXVzZSUyMGZvciUyMHBldGl0aW9uZXJzLiUyMFdpdGglMjBoaW0lMjBvbiUyMHRoZSUyMGJyaWVmJTIwd2FzJTIwSmFtZXMlMjBILiUyMERhbm5lbmJlcmclMkMlMjBEZXB1dHklMjBBdHRvcm5leSUyMEdlbmVyYWwuLi4nJTdEJTVE",highlighted:`[{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;case_ID&#x27;</span>: <span class="hljs-string">&#x27;110921.json&#x27;</span>,
   <span class="hljs-string">&#x27;case_jurisdiction&#x27;</span>: <span class="hljs-string">&#x27;scotus.tar.gz&#x27;</span>,
   <span class="hljs-string">&#x27;date_created&#x27;</span>: <span class="hljs-string">&#x27;2010-04-28T17:12:49Z&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;\\n461 U.S. 238 (1983)\\nOLIM ET AL.\\nv.\\nWAKINEKONA\\nNo. 81-1581.\\nSupreme Court of United States.\\nArgued January 19, 1983.\\nDecided April 26, 1983.\\nCERTIORARI TO THE UNITED STATES COURT OF APPEALS FOR THE NINTH CIRCUIT\\n*239 Michael A. Lilly, First Deputy Attorney General of Hawaii, argued the cause for petitioners. With him on the brief was James H. Dannenberg, Deputy Attorney General...&#x27;</span>}]`,wrap:!1}}),$e=new T({props:{code:"YmFzZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnRoZS1leWUuZXUlMkZwdWJsaWMlMkZBSSUyRnBpbGUlMkYlMjIlMEFkYXRhX2ZpbGVzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHJhaW4lMjIlM0ElMjAlNUJiYXNlX3VybCUyMCUyQiUyMCUyMnRyYWluJTJGJTIyJTIwJTJCJTIwZiUyMiU3QmlkeCUzQTAyZCU3RC5qc29ubC56c3QlMjIlMjBmb3IlMjBpZHglMjBpbiUyMHJhbmdlKDMwKSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZhbGlkYXRpb24lMjIlM0ElMjBiYXNlX3VybCUyMCUyQiUyMCUyMnZhbC5qc29ubC56c3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZXN0JTIyJTNBJTIwYmFzZV91cmwlMjAlMkIlMjAlMjJ0ZXN0Lmpzb25sLnpzdCUyMiUyQyUwQSU3RCUwQXBpbGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJqc29uJTIyJTJDJTIwZGF0YV9maWxlcyUzRGRhdGFfZmlsZXMlMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQW5leHQoaXRlcihwaWxlX2RhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCkp",highlighted:`base_url = <span class="hljs-string">&quot;https://the-eye.eu/public/AI/pile/&quot;</span>
data_files = {
    <span class="hljs-string">&quot;train&quot;</span>: [base_url + <span class="hljs-string">&quot;train/&quot;</span> + <span class="hljs-string">f&quot;<span class="hljs-subst">{idx:02d}</span>.jsonl.zst&quot;</span> <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">30</span>)],
    <span class="hljs-string">&quot;validation&quot;</span>: base_url + <span class="hljs-string">&quot;val.jsonl.zst&quot;</span>,
    <span class="hljs-string">&quot;test&quot;</span>: base_url + <span class="hljs-string">&quot;test.jsonl.zst&quot;</span>,
}
pile_dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(pile_dataset[<span class="hljs-string">&quot;train&quot;</span>]))`,wrap:!1}}),Ve=new T({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BpbGVfc2V0X25hbWUnJTNBJTIwJ1BpbGUtQ0MnJTdEJTJDJTBBJTIwJ3RleHQnJTNBJTIwJ0l0JTIwaXMlMjBkb25lJTJDJTIwYW5kJTIwc3VibWl0dGVkLiUyMFlvdSUyMGNhbiUyMHBsYXklMjAlRTIlODAlOUNTdXJ2aXZhbCUyMG9mJTIwdGhlJTIwVGFzdGllc3QlRTIlODAlOUQlMjBvbiUyMEFuZHJvaWQlMkMlMjBhbmQlMjBvbiUyMHRoZSUyMHdlYi4uLiclN0Q=",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pile_set_name&#x27;</span>: <span class="hljs-string">&#x27;Pile-CC&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;It is done, and submitted. You can play “Survival of the Tastiest” on Android, and on the web...&#x27;</span>}`,wrap:!1}}),I=new ze({props:{$$slots:{default:[Sl]},$$scope:{ctx:b}}}),We=new Cl({props:{source:"https://github.com/huggingface/course/blob/main/chapters/fr/chapter5/4.mdx"}}),{c(){i=c("meta"),h=t(),M=c("p"),j=t(),p(x.$$.fragment),Re=t(),p(Z.$$.fragment),Ce=t(),p(B.$$.fragment),Qe=t(),G=c("p"),G.innerHTML=Os,Ne=t(),$=c("p"),$.innerHTML=Ks,Ee=t(),p(V.$$.fragment),Ye=t(),v=c("p"),v.innerHTML=el,He=t(),p(W.$$.fragment),_e=t(),k=c("p"),k.innerHTML=sl,Se=t(),p(z.$$.fragment),Fe=t(),X=c("p"),X.innerHTML=ll,Ae=t(),p(R.$$.fragment),De=t(),p(C.$$.fragment),Le=t(),Q=c("p"),Q.textContent=nl,qe=t(),p(U.$$.fragment),Pe=t(),N=c("p"),N.textContent=tl,Oe=t(),p(E.$$.fragment),Ke=t(),p(Y.$$.fragment),es=t(),H=c("p"),H.textContent=al,ss=t(),p(_.$$.fragment),ls=t(),S=c("p"),S.innerHTML=il,ns=t(),p(F.$$.fragment),ts=t(),A=c("p"),A.innerHTML=pl,as=t(),p(D.$$.fragment),is=t(),p(L.$$.fragment),ps=t(),q=c("p"),q.innerHTML=rl,rs=t(),p(P.$$.fragment),os=t(),p(O.$$.fragment),us=t(),K=c("p"),K.textContent=ol,ds=t(),p(f.$$.fragment),ms=t(),ee=c("p"),ee.innerHTML=ul,Ms=t(),se=c("p"),se.innerHTML=dl,cs=t(),p(le.$$.fragment),Js=t(),p(ne.$$.fragment),ys=t(),te=c("p"),te.innerHTML=ml,Ts=t(),p(w.$$.fragment),hs=t(),p(ae.$$.fragment),js=t(),ie=c("p"),ie.innerHTML=Ml,bs=t(),p(pe.$$.fragment),Us=t(),re=c("p"),re.innerHTML=cl,fs=t(),p(oe.$$.fragment),ws=t(),p(ue.$$.fragment),gs=t(),de=c("p"),de.innerHTML=Jl,Is=t(),p(me.$$.fragment),xs=t(),p(Me.$$.fragment),Zs=t(),p(g.$$.fragment),Bs=t(),ce=c("p"),ce.innerHTML=yl,Gs=t(),p(Je.$$.fragment),$s=t(),p(ye.$$.fragment),Vs=t(),Te=c("p"),Te.innerHTML=Tl,vs=t(),p(he.$$.fragment),Ws=t(),p(je.$$.fragment),ks=t(),be=c("p"),be.innerHTML=hl,zs=t(),p(Ue.$$.fragment),Xs=t(),fe=c("p"),fe.innerHTML=jl,Rs=t(),p(we.$$.fragment),Cs=t(),p(ge.$$.fragment),Qs=t(),Ie=c("p"),Ie.innerHTML=bl,Ns=t(),p(xe.$$.fragment),Es=t(),p(Ze.$$.fragment),Ys=t(),Be=c("p"),Be.innerHTML=Ul,Hs=t(),Ge=c("p"),Ge.innerHTML=fl,_s=t(),p($e.$$.fragment),Ss=t(),p(Ve.$$.fragment),Fs=t(),p(I.$$.fragment),As=t(),ve=c("p"),ve.textContent=wl,Ds=t(),p(We.$$.fragment),Ls=t(),ke=c("p"),this.h()},l(e){const s=zl("svelte-u9bgzb",document.head);i=J(s,"META",{name:!0,content:!0}),s.forEach(l),h=a(e),M=J(e,"P",{}),Gl(M).forEach(l),j=a(e),r(x.$$.fragment,e),Re=a(e),r(Z.$$.fragment,e),Ce=a(e),r(B.$$.fragment,e),Qe=a(e),G=J(e,"P",{"data-svelte-h":!0}),y(G)!=="svelte-1n0aq50"&&(G.innerHTML=Os),Ne=a(e),$=J(e,"P",{"data-svelte-h":!0}),y($)!=="svelte-z4dff3"&&($.innerHTML=Ks),Ee=a(e),r(V.$$.fragment,e),Ye=a(e),v=J(e,"P",{"data-svelte-h":!0}),y(v)!=="svelte-1ey6jlq"&&(v.innerHTML=el),He=a(e),r(W.$$.fragment,e),_e=a(e),k=J(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-xwkwxb"&&(k.innerHTML=sl),Se=a(e),r(z.$$.fragment,e),Fe=a(e),X=J(e,"P",{"data-svelte-h":!0}),y(X)!=="svelte-1djvo8q"&&(X.innerHTML=ll),Ae=a(e),r(R.$$.fragment,e),De=a(e),r(C.$$.fragment,e),Le=a(e),Q=J(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-jgiig2"&&(Q.textContent=nl),qe=a(e),r(U.$$.fragment,e),Pe=a(e),N=J(e,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1jodsbq"&&(N.textContent=tl),Oe=a(e),r(E.$$.fragment,e),Ke=a(e),r(Y.$$.fragment,e),es=a(e),H=J(e,"P",{"data-svelte-h":!0}),y(H)!=="svelte-qvjcta"&&(H.textContent=al),ss=a(e),r(_.$$.fragment,e),ls=a(e),S=J(e,"P",{"data-svelte-h":!0}),y(S)!=="svelte-1e4dhll"&&(S.innerHTML=il),ns=a(e),r(F.$$.fragment,e),ts=a(e),A=J(e,"P",{"data-svelte-h":!0}),y(A)!=="svelte-e6epbe"&&(A.innerHTML=pl),as=a(e),r(D.$$.fragment,e),is=a(e),r(L.$$.fragment,e),ps=a(e),q=J(e,"P",{"data-svelte-h":!0}),y(q)!=="svelte-13cvybs"&&(q.innerHTML=rl),rs=a(e),r(P.$$.fragment,e),os=a(e),r(O.$$.fragment,e),us=a(e),K=J(e,"P",{"data-svelte-h":!0}),y(K)!=="svelte-1807tcn"&&(K.textContent=ol),ds=a(e),r(f.$$.fragment,e),ms=a(e),ee=J(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-17s56pe"&&(ee.innerHTML=ul),Ms=a(e),se=J(e,"P",{"data-svelte-h":!0}),y(se)!=="svelte-q5ckcr"&&(se.innerHTML=dl),cs=a(e),r(le.$$.fragment,e),Js=a(e),r(ne.$$.fragment,e),ys=a(e),te=J(e,"P",{"data-svelte-h":!0}),y(te)!=="svelte-1qf5v39"&&(te.innerHTML=ml),Ts=a(e),r(w.$$.fragment,e),hs=a(e),r(ae.$$.fragment,e),js=a(e),ie=J(e,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-qgureo"&&(ie.innerHTML=Ml),bs=a(e),r(pe.$$.fragment,e),Us=a(e),re=J(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-ooenp6"&&(re.innerHTML=cl),fs=a(e),r(oe.$$.fragment,e),ws=a(e),r(ue.$$.fragment,e),gs=a(e),de=J(e,"P",{"data-svelte-h":!0}),y(de)!=="svelte-1aulibg"&&(de.innerHTML=Jl),Is=a(e),r(me.$$.fragment,e),xs=a(e),r(Me.$$.fragment,e),Zs=a(e),r(g.$$.fragment,e),Bs=a(e),ce=J(e,"P",{"data-svelte-h":!0}),y(ce)!=="svelte-1936jdb"&&(ce.innerHTML=yl),Gs=a(e),r(Je.$$.fragment,e),$s=a(e),r(ye.$$.fragment,e),Vs=a(e),Te=J(e,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-13iarxl"&&(Te.innerHTML=Tl),vs=a(e),r(he.$$.fragment,e),Ws=a(e),r(je.$$.fragment,e),ks=a(e),be=J(e,"P",{"data-svelte-h":!0}),y(be)!=="svelte-1axizdx"&&(be.innerHTML=hl),zs=a(e),r(Ue.$$.fragment,e),Xs=a(e),fe=J(e,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-1303a2x"&&(fe.innerHTML=jl),Rs=a(e),r(we.$$.fragment,e),Cs=a(e),r(ge.$$.fragment,e),Qs=a(e),Ie=J(e,"P",{"data-svelte-h":!0}),y(Ie)!=="svelte-o783i4"&&(Ie.innerHTML=bl),Ns=a(e),r(xe.$$.fragment,e),Es=a(e),r(Ze.$$.fragment,e),Ys=a(e),Be=J(e,"P",{"data-svelte-h":!0}),y(Be)!=="svelte-tlls1x"&&(Be.innerHTML=Ul),Hs=a(e),Ge=J(e,"P",{"data-svelte-h":!0}),y(Ge)!=="svelte-1lk2l6b"&&(Ge.innerHTML=fl),_s=a(e),r($e.$$.fragment,e),Ss=a(e),r(Ve.$$.fragment,e),Fs=a(e),r(I.$$.fragment,e),As=a(e),ve=J(e,"P",{"data-svelte-h":!0}),y(ve)!=="svelte-9kylg4"&&(ve.textContent=wl),Ds=a(e),r(We.$$.fragment,e),Ls=a(e),ke=J(e,"P",{}),Gl(ke).forEach(l),this.h()},h(){$l(i,"name","hf:doc:metadata"),$l(i,"content",Al)},m(e,s){Xl(document.head,i),n(e,h,s),n(e,M,s),n(e,j,s),o(x,e,s),n(e,Re,s),o(Z,e,s),n(e,Ce,s),o(B,e,s),n(e,Qe,s),n(e,G,s),n(e,Ne,s),n(e,$,s),n(e,Ee,s),o(V,e,s),n(e,Ye,s),n(e,v,s),n(e,He,s),o(W,e,s),n(e,_e,s),n(e,k,s),n(e,Se,s),o(z,e,s),n(e,Fe,s),n(e,X,s),n(e,Ae,s),o(R,e,s),n(e,De,s),o(C,e,s),n(e,Le,s),n(e,Q,s),n(e,qe,s),o(U,e,s),n(e,Pe,s),n(e,N,s),n(e,Oe,s),o(E,e,s),n(e,Ke,s),o(Y,e,s),n(e,es,s),n(e,H,s),n(e,ss,s),o(_,e,s),n(e,ls,s),n(e,S,s),n(e,ns,s),o(F,e,s),n(e,ts,s),n(e,A,s),n(e,as,s),o(D,e,s),n(e,is,s),o(L,e,s),n(e,ps,s),n(e,q,s),n(e,rs,s),o(P,e,s),n(e,os,s),o(O,e,s),n(e,us,s),n(e,K,s),n(e,ds,s),o(f,e,s),n(e,ms,s),n(e,ee,s),n(e,Ms,s),n(e,se,s),n(e,cs,s),o(le,e,s),n(e,Js,s),o(ne,e,s),n(e,ys,s),n(e,te,s),n(e,Ts,s),o(w,e,s),n(e,hs,s),o(ae,e,s),n(e,js,s),n(e,ie,s),n(e,bs,s),o(pe,e,s),n(e,Us,s),n(e,re,s),n(e,fs,s),o(oe,e,s),n(e,ws,s),o(ue,e,s),n(e,gs,s),n(e,de,s),n(e,Is,s),o(me,e,s),n(e,xs,s),o(Me,e,s),n(e,Zs,s),o(g,e,s),n(e,Bs,s),n(e,ce,s),n(e,Gs,s),o(Je,e,s),n(e,$s,s),o(ye,e,s),n(e,Vs,s),n(e,Te,s),n(e,vs,s),o(he,e,s),n(e,Ws,s),o(je,e,s),n(e,ks,s),n(e,be,s),n(e,zs,s),o(Ue,e,s),n(e,Xs,s),n(e,fe,s),n(e,Rs,s),o(we,e,s),n(e,Cs,s),o(ge,e,s),n(e,Qs,s),n(e,Ie,s),n(e,Ns,s),o(xe,e,s),n(e,Es,s),o(Ze,e,s),n(e,Ys,s),n(e,Be,s),n(e,Hs,s),n(e,Ge,s),n(e,_s,s),o($e,e,s),n(e,Ss,s),o(Ve,e,s),n(e,Fs,s),o(I,e,s),n(e,As,s),n(e,ve,s),n(e,Ds,s),o(We,e,s),n(e,Ls,s),n(e,ke,s),qs=!0},p(e,[s]){const gl={};s&2&&(gl.$$scope={dirty:s,ctx:e}),U.$set(gl);const Il={};s&2&&(Il.$$scope={dirty:s,ctx:e}),f.$set(Il);const xl={};s&2&&(xl.$$scope={dirty:s,ctx:e}),w.$set(xl);const Zl={};s&2&&(Zl.$$scope={dirty:s,ctx:e}),g.$set(Zl);const Bl={};s&2&&(Bl.$$scope={dirty:s,ctx:e}),I.$set(Bl)},i(e){qs||(u(x.$$.fragment,e),u(Z.$$.fragment,e),u(B.$$.fragment,e),u(V.$$.fragment,e),u(W.$$.fragment,e),u(z.$$.fragment,e),u(R.$$.fragment,e),u(C.$$.fragment,e),u(U.$$.fragment,e),u(E.$$.fragment,e),u(Y.$$.fragment,e),u(_.$$.fragment,e),u(F.$$.fragment,e),u(D.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(f.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(w.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(oe.$$.fragment,e),u(ue.$$.fragment,e),u(me.$$.fragment,e),u(Me.$$.fragment,e),u(g.$$.fragment,e),u(Je.$$.fragment,e),u(ye.$$.fragment,e),u(he.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(we.$$.fragment,e),u(ge.$$.fragment,e),u(xe.$$.fragment,e),u(Ze.$$.fragment,e),u($e.$$.fragment,e),u(Ve.$$.fragment,e),u(I.$$.fragment,e),u(We.$$.fragment,e),qs=!0)},o(e){d(x.$$.fragment,e),d(Z.$$.fragment,e),d(B.$$.fragment,e),d(V.$$.fragment,e),d(W.$$.fragment,e),d(z.$$.fragment,e),d(R.$$.fragment,e),d(C.$$.fragment,e),d(U.$$.fragment,e),d(E.$$.fragment,e),d(Y.$$.fragment,e),d(_.$$.fragment,e),d(F.$$.fragment,e),d(D.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(f.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(w.$$.fragment,e),d(ae.$$.fragment,e),d(pe.$$.fragment,e),d(oe.$$.fragment,e),d(ue.$$.fragment,e),d(me.$$.fragment,e),d(Me.$$.fragment,e),d(g.$$.fragment,e),d(Je.$$.fragment,e),d(ye.$$.fragment,e),d(he.$$.fragment,e),d(je.$$.fragment,e),d(Ue.$$.fragment,e),d(we.$$.fragment,e),d(ge.$$.fragment,e),d(xe.$$.fragment,e),d(Ze.$$.fragment,e),d($e.$$.fragment,e),d(Ve.$$.fragment,e),d(I.$$.fragment,e),d(We.$$.fragment,e),qs=!1},d(e){e&&(l(h),l(M),l(j),l(Re),l(Ce),l(Qe),l(G),l(Ne),l($),l(Ee),l(Ye),l(v),l(He),l(_e),l(k),l(Se),l(Fe),l(X),l(Ae),l(De),l(Le),l(Q),l(qe),l(Pe),l(N),l(Oe),l(Ke),l(es),l(H),l(ss),l(ls),l(S),l(ns),l(ts),l(A),l(as),l(is),l(ps),l(q),l(rs),l(os),l(us),l(K),l(ds),l(ms),l(ee),l(Ms),l(se),l(cs),l(Js),l(ys),l(te),l(Ts),l(hs),l(js),l(ie),l(bs),l(Us),l(re),l(fs),l(ws),l(gs),l(de),l(Is),l(xs),l(Zs),l(Bs),l(ce),l(Gs),l($s),l(Vs),l(Te),l(vs),l(Ws),l(ks),l(be),l(zs),l(Xs),l(fe),l(Rs),l(Cs),l(Qs),l(Ie),l(Ns),l(Es),l(Ys),l(Be),l(Hs),l(Ge),l(_s),l(Ss),l(Fs),l(As),l(ve),l(Ds),l(Ls),l(ke)),l(i),m(x,e),m(Z,e),m(B,e),m(V,e),m(W,e),m(z,e),m(R,e),m(C,e),m(U,e),m(E,e),m(Y,e),m(_,e),m(F,e),m(D,e),m(L,e),m(P,e),m(O,e),m(f,e),m(le,e),m(ne,e),m(w,e),m(ae,e),m(pe,e),m(oe,e),m(ue,e),m(me,e),m(Me,e),m(g,e),m(Je,e),m(ye,e),m(he,e),m(je,e),m(Ue,e),m(we,e),m(ge,e),m(xe,e),m(Ze,e),m($e,e),m(Ve,e),m(I,e),m(We,e)}}}const Al='{"title":"Données massives ? 🤗 <i> Datasets </i> à la rescousse !","local":"données-massives---i-datasets-i-à-la-rescousse-","sections":[{"title":"Qu’est-ce que <i> The Pile </i> ?","local":"quest-ce-que-i-the-pile-i-","sections":[],"depth":2},{"title":"La magie du <i> memory mapping </i>","local":"la-magie-du-i-memory-mapping-i","sections":[],"depth":2},{"title":"Jeux de données en continu","local":"jeux-de-données-en-continu","sections":[],"depth":2}],"depth":1}';function Dl(b){return vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ln extends Wl{constructor(i){super(),kl(this,i,Dl,Fl,Vl,{})}}export{ln as component};
