import{s as Bi,o as _i,n as Wi}from"../chunks/scheduler.cc52f4b9.js";import{S as Qi,i as Ni,e as i,s as n,c as o,h as Xi,a as p,d as t,b as a,f as qi,g as u,j as r,k as oa,l as Ri,m as l,n as m,t as c,o as M,p as d}from"../chunks/index.9480bb2b.js";import{T as Li}from"../chunks/Tip.f7b80743.js";import{C as Ai,H as Mt,E as Hi}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.04d617be.js";import{Y as Gi}from"../chunks/Youtube.7b12d9e8.js";import{C as J}from"../chunks/CodeBlock.f4148b32.js";import{C as Ei}from"../chunks/CourseFloatingBanner.cdc38ef1.js";function Di(dt){let y,k=`<strong>Pour aller plus loin</strong> Si vous testez les deux versions des normaliseurs précédents sur une chaîne contenant le caractère unicode <code>u&quot;\\u0085&quot;</code> vous remarquerez sûrement qu’ils ne sont pas exactement équivalents.
Pour ne pas trop compliquer la version avec <code>normalizers.Sequence</code>, nous n’avons pas inclus les Regex que le <code>BertNormalizer</code> requiert quand l’argument <code>clean_text</code> est mis à <code>True</code> ce qui est le comportement par défaut. Mais ne vous inquiétez pas : il est possible d’obtenir exactement la même normalisation sans utiliser le très pratique <code>BertNormalizer</code> en ajoutant deux <code>normalizers.Replace</code> à la séquence de normalisation.`;return{c(){y=i("p"),y.innerHTML=k},l(j){y=p(j,"P",{"data-svelte-h":!0}),r(y)!=="svelte-5i2npl"&&(y.innerHTML=k)},m(j,mt){l(j,y,mt)},p:Wi,d(j){j&&t(y)}}}function Si(dt){let y,k,j,mt,b,Jt,$,yt,U,jt,w,ua="Comme nous l’avons vu dans les sections précédentes, la tokenisation comprend plusieurs étapes :",Tt,g,ma="<li>normalisation (tout nettoyage du texte jugé nécessaire, comme la suppression des espaces ou des accents, la normalisation Unicode, etc.),</li> <li>prétokénisation (division de l’entrée en mots),</li> <li>passage de l’entrée dans le modèle (utilisation des mots prétokénisés pour produire une séquence de <em>tokens</em>),</li> <li>post-traitement (ajout des <em>tokens</em> spéciaux du <em>tokenizer</em>, génération du masque d’attention et des identifiants du type de <em>token</em>).</li>",ft,h,ca="Pour mémoire, voici un autre aperçu du processus global :",kt,T,Ma='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline.svg" alt="The tokenization pipeline."/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline-dark.svg" alt="The tokenization pipeline."/>',bt,x,da='La bibliothèque 🤗 <em>Tokenizers</em> a été construite pour fournir plusieurs options pour chacune de ces étapes. Vous pouvez les mélanger et assortir ensemble. Dans cette section, nous verrons comment nous pouvons construire un <em>tokenizer</em> à partir de zéro, par opposition à entraîner un nouveau <em>tokenizer</em> à partir d’un ancien, comme nous l’avons fait dans <a href="/course/fr/chapter6/2">section 2</a>. Vous serez alors en mesure de construire n’importe quel type de <em>tokenizer</em> auquel vous pouvez penser !',$t,z,Ut,v,Ja="Plus précisément, la bibliothèque est construite autour d’une classe centrale <code>Tokenizer</code> avec les blocs de construction regroupés en sous-modules :",wt,I,ya='<li><code>normalizers</code> contient tous les types de <code>Normalizer</code> que vous pouvez utiliser (liste complète <a href="https://huggingface.co/docs/tokenizers/api/normalizers" rel="nofollow">ici</a>),</li> <li><code>pre_tokenizers</code> contient tous les types de <code>PreTokenizer</code> que vous pouvez utiliser (liste complète <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">ici</a>),</li> <li><code>models</code> contient les différents types de <code>Model</code> que vous pouvez utiliser, comme <code>BPE</code>, <code>WordPiece</code>, et <code>Unigram</code> (liste complète <a href="https://huggingface.co/docs/tokenizers/api/models" rel="nofollow">ici</a>),</li> <li><code>trainers</code> contient tous les différents types de <code>Trainer</code> que vous pouvez utiliser pour entraîner votre modèle sur un corpus (un par type de modèle ; liste complète <a href="https://huggingface.co/docs/tokenizers/api/trainers" rel="nofollow">ici</a>),</li> <li><code>post_processors</code> contient les différents types de <code>PostProcessor</code> que vous pouvez utiliser (liste complète <a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">ici</a>),</li> <li><code>decoders</code> contient les différents types de <code>Decoder</code> que vous pouvez utiliser pour décoder les sorties de tokenization (liste complète <a href="https://huggingface.co/docs/tokenizers/components#decoders" rel="nofollow">ici</a>).</li>',gt,C,ja='Vous pouvez trouver la liste complète des blocs de construction <a href="https://huggingface.co/docs/tokenizers/components" rel="nofollow">ici</a>.',ht,Z,xt,V,Ta='Pour entraîner notre nouveau <em>tokenizer</em>, nous utiliserons un petit corpus de texte (pour que les exemples soient rapides). Les étapes pour acquérir ce corpus sont similaires à celles que nous avons suivies au <a href="/course/fr/chapter6/2">début du chapitre</a>, mais cette fois nous utiliserons le jeu de données <a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText-2</a> :',zt,q,vt,B,fa="La fonction <code>get_training_corpus()</code> est un générateur qui donne des batchs de 1 000 textes, que nous utiliserons pour entraîner le <em>tokenizer</em>.",It,_,ka="🤗 <em>Tokenizers</em> peut aussi être entraîné directement sur des fichiers texte. Voici comment nous pouvons générer un fichier texte contenant tous les textes de WikiText-2 que nous pourrons ensuite utilisé en local :",Ct,W,Zt,Q,ba="Ensuite, nous vous montrerons comment construire vos propres <em>tokenizers</em> pour BERT, GPT-2 et XLNet, bloc par bloc. Cela vous donnera un exemple de chacun des trois principaux algorithmes de tokenisation : <em>WordPiece</em>, BPE et <em>Unigram</em>. Commençons par BERT !",Vt,N,qt,X,$a="Pour construire un <em>tokenizer</em> avec la bibliothèque 🤗 <em>Tokenizers</em>, nous commençons par instancier un objet <code>Tokenizer</code> avec un <code>model</code>. Puis nous définissons ses attributs <code>normalizer</code>, <code>pre_tokenizer</code>, <code>post_processor</code> et <code>decoder</code> aux valeurs que nous voulons.",Bt,R,Ua="Pour cet exemple, nous allons créer un <code>Tokenizer</code> avec un modèle <em>WordPiece</em> :",_t,L,Wt,A,wa="Nous devons spécifier le <code>unk_token</code> pour que le modèle sache quoi retourner lorsqu’il rencontre des caractères qu’il n’a pas vu auparavant. D’autres arguments que nous pouvons définir ici incluent le <code>vocab</code> de notre modèle (nous allons entraîner le modèle, donc nous n’avons pas besoin de le définir) et <code>max_input_chars_per_word</code>, qui spécifie une longueur maximale pour chaque mot (les mots plus longs que la valeur passée seront séparés).",Qt,H,ga="La première étape de la tokénisation est la normalisation. Puisque BERT est largement utilisé, une fonction <code>BertNormalizer</code> a été créée avec les options classiques que nous pouvons définir pour BERT : <code>lowercase</code> pour mettre le texte en minuscule, <code>strip_accents</code> qui enlève les accents, <code>clean_text</code> pour enlever tous les caractères de contrôle et fusionner des espaces répétés par un seul, et <code>handle_chinese_chars</code> qui place des espaces autour des caractères chinois. Pour reproduire le <em>tokenizer</em> <code>bert-base-uncased</code>, nous pouvons simplement définir ce <em>normalizer</em> :",Nt,G,Xt,E,ha="Cependant, généralement, lorsque vous construisez un nouveau <em>tokenizer</em>, vous n’avez pas accès à un normaliseur aussi pratique déjà implémenté dans la bibliothèque 🤗 <em>Tokenizers</em>. Donc voyons comment créer le normaliseur de BERT manuellement. La bibliothèque fournit un normaliseur <code>Lowercase</code> et un normaliseur <code>StripAccents</code>. Il est possible de composer plusieurs normaliseurs en utilisant une <code>Sequence</code> :",Rt,D,Lt,S,xa="Nous utilisons également un normaliseur Unicode <code>NFD</code>, car sinon <code>StripAccents</code> ne reconnaîtra pas correctement les caractères accentués et ne les supprimera donc pas.",At,P,za="Comme nous l’avons vu précédemment, nous pouvons utiliser la méthode <code>normalize_str()</code> du <code>normalizer</code> pour vérifier les effets qu’il a sur un texte donné :",Ht,F,Gt,Y,Et,f,Dt,K,va="L’étape suivante est la prétokenisation. Encore une fois, il y a un <code>BertPreTokenizer</code> préconstruit que nous pouvons utiliser :",St,O,Pt,ee,Ia="Ou nous pouvons le construire à partir de zéro :",Ft,se,Yt,te,Ca="Notez que le <code>Whitespace</code> divise sur les espaces et tous les caractères qui ne sont pas des lettres, des chiffres ou le caractère de soulignement. Donc techniquement il divise sur les espaces et la ponctuation :",Kt,le,Ot,ne,el,ae,Za="Si vous voulez seulement séparer sur les espaces, vous devez utiliser <code>WhitespaceSplit</code> à la place :",sl,ie,tl,pe,ll,re,Va="Comme pour les normaliseurs, vous pouvez utiliser une <code>Sequence</code> pour composer plusieurs prétokenizers :",nl,oe,al,ue,il,me,qa="L’étape suivante dans le pipeline de tokénisation est de faire passer les entrées par le modèle. Nous avons déjà spécifié notre modèle dans l’initialisation, mais nous devons encore l’entraîner, ce qui nécessitera un <code>WordPieceTrainer</code>. La principale chose à retenir lors de l’instanciation d’un entraîneur dans 🤗 <em>Tokenizers</em> est que vous devez lui passer tous les <em>tokens</em> spéciaux que vous avez l’intention d’utiliser. Sinon il ne les ajoutera pas au vocabulaire puisqu’ils ne sont pas dans le corpus d’entraînement :",pl,ce,rl,Me,Ba="En plus de spécifier la <code>vocab_size</code> et les <code>special_tokens</code>, nous pouvons définir la <code>min_frequency</code> (le nombre de fois qu’un <em>token</em> doit apparaître pour être inclus dans le vocabulaire) ou changer le <code>continuing_subword_prefix</code> (si nous voulons utiliser quelque chose de différent de <code>##</code>).",ol,de,_a="Pour entraîner notre modèle en utilisant l’itérateur que nous avons défini plus tôt, il suffit d’exécuter cette commande :",ul,Je,ml,ye,Wa="Nous pouvons également utiliser des fichiers texte pour entraîner notre <em>tokenizer</em> qui ressemblerait alors à ceci (nous réinitialisons le modèle avec un <code>WordPiece</code> vide au préalable) :",cl,je,Ml,Te,Qa="Dans les deux cas, nous pouvons ensuite tester le <em>tokenizer</em> sur un texte en appelant la méthode <code>encode()</code> :",dl,fe,Jl,ke,yl,be,Na="L’encodage obtenu est un <code>Encoding</code> contenant toutes les sorties nécessaires du <em>tokenizer</em> dans ses différents attributs : <code>ids</code>, <code>type_ids</code>, <code>tokens</code>, <code>offsets</code>, <code>attention_mask</code>, <code>special_tokens_mask</code> et <code>overflowing</code>.",jl,$e,Xa="La dernière étape du pipeline de tokénisation est le post-traitement. Nous devons ajouter le <em>token</em> <code>[CLS]</code> au début et le <em>token</em> <code>[SEP]</code> à la fin (ou après chaque phrase si nous avons une paire de phrases). Nous utiliserons <code>TemplateProcessor</code> pour cela, mais d’abord nous devons connaître les identifiants des <em>tokens</em> <code>[CLS]</code> et <code>[SEP]</code> dans le vocabulaire :",Tl,Ue,fl,we,kl,ge,Ra="Pour écrire le gabarit pour <code>TemplateProcessor</code>, nous devons spécifier comment traiter une seule phrase et une paire de phrases. Pour les deux, nous écrivons les <em>tokens</em> spéciaux que nous voulons utiliser. La première (ou unique) phrase est représentée par <code>$A</code>, alors que la deuxième phrase (si on code une paire) est représentée par <code>$B</code>. Pour chacun de ces éléments (<em>tokens</em> spéciaux et phrases), nous spécifions également l’identifiant du <em>token</em> correspondant après un deux-points.",bl,he,La="Le gabarit classique de BERT est donc défini comme suit :",$l,xe,Ul,ze,Aa="Notez que nous devons transmettre les identifiants des <em>tokens</em> spéciaux afin que le <em>tokenizer</em> puisse les convertir correctement.",wl,ve,Ha="Une fois cela ajouté, revenons à notre exemple précédent donnera :",gl,Ie,hl,Ce,xl,Ze,Ga="Et sur une paire de phrases, on obtient le bon résultat :",zl,Ve,vl,qe,Il,Be,Ea="Nous avons presque fini de construire ce <em>tokenizer</em> à partir de zéro. La dernière étape consiste à inclure un décodeur :",Cl,_e,Zl,We,Da="Testons-le sur notre précédent <code>encoding</code> :",Vl,Qe,ql,Ne,Bl,Xe,Sa="Génial ! Nous pouvons enregistrer notre <em>tokenizer</em> dans un seul fichier JSON comme ceci :",_l,Re,Wl,Le,Pa="Nous pouvons alors recharger ce fichier dans un objet <code>Tokenizer</code> avec la méthode <code>from_file()</code> :",Ql,Ae,Nl,He,Fa="Pour utiliser ce <em>tokenizer</em> dans 🤗 <em>Transformers</em>, nous devons l’envelopper dans un <code>PreTrainedTokenizerFast</code>. Nous pouvons soit utiliser la classe générique, soit, si notre <em>tokenizer</em> correspond à un modèle existant, utiliser cette classe (ici, <code>BertTokenizerFast</code>). Si vous appliquez cette logique pour construire un tout nouveau <em>tokenizer</em>, vous devrez utiliser la première option.",Xl,Ge,Ya="Pour envelopper le <em>tokenizer</em> dans un <code>PreTrainedTokenizerFast</code>, nous pouvons soit passer le <em>tokenizer</em> que nous avons construit comme un <code>tokenizer_object</code>, soit passer le fichier de <em>tokenizer</em> que nous avons sauvegardé comme <code>tokenizer_file</code>. Ce qu’il faut retenir, c’est que nous devons définir manuellement tous les <em>tokens</em> spéciaux car cette classe ne peut pas déduire de l’objet <code>tokenizer</code> quel <em>token</em> est le <em>token</em> de masque, quel est le <em>token</em><code>[CLS]</code>, etc :",Rl,Ee,Ll,De,Ka="Si vous utilisez une classe de <em>tokenizer</em> spécifique (comme <code>BertTokenizerFast</code>), vous aurez seulement besoin de spécifier les <em>tokens</em> spéciaux qui sont différents de ceux par défaut (ici, aucun) :",Al,Se,Hl,Pe,Oa="Vous pouvez ensuite utiliser ce <em>tokenizer</em> comme n’importe quel autre <em>tokenizer</em> de 🤗 <em>Transformers</em>. Vous pouvez le sauvegarder avec la méthode <code>save_pretrained()</code> ou le télécharger sur le <em>Hub</em> avec la méthode <code>push_to_hub()</code>.",Gl,Fe,ei="Maintenant que nous avons vu comment construire un <em>tokenizer WordPiece</em>, faisons de même pour un <em>tokenizer</em> BPE. Nous irons un peu plus vite puisque vous connaissez toutes les étapes. Nous ne soulignerons que les différences.",El,Ye,Dl,Ke,si="Construisons maintenant un <em>tokenizer</em> BPE. Comme pour le <em>tokenizer</em> BERT, nous commençons par initialiser un <code>Tokenizer</code> avec un modèle BPE :",Sl,Oe,Pl,es,ti="Comme pour BERT, nous pourrions initialiser ce modèle avec un vocabulaire si nous en avions un (nous aurions besoin de passer le <code>vocab</code> et le <code>merges</code> dans ce cas), mais puisque nous allons nous entraîner à partir de zéro, nous n’avons pas besoin de le faire. Nous n’avons pas non plus besoin de spécifier un <code>unk_token</code> parce que le GPT-2 utilise un BPE au niveau de l’octet.",Fl,ss,li="GPT-2 n’utilise pas de normaliseur, donc nous sautons cette étape et allons directement à la prétokénisation :",Yl,ts,Kl,ls,ni="L’option que nous avons ajoutée à <code>ByteLevel</code> ici est de ne pas ajouter d’espace en début de phrase (ce qui est le cas par défaut). Nous pouvons jeter un coup d’oeil à la prétokénisation d’un texte d’exemple comme avant :",Ol,ns,en,as,sn,is,ai="Vient ensuite le modèle, qui doit être entraîné. Pour le GPT-2, le seul <em>token</em> spécial est le <em>token</em> de fin de texte :",tn,ps,ln,rs,ii="Comme avec le <code>WordPieceTrainer</code>, ainsi que le <code>vocab_size</code> et le <code>special_tokens</code>, nous pouvons spécifier la <code>min_frequency</code> si nous le voulons, ou si nous avons un suffixe de fin de mot (comme <code>&lt;/w&gt;</code>), nous pouvons le définir avec <code>end_of_word_suffix</code>.",nn,os,pi="Ce <em>tokenizer</em> peut aussi être entraîné sur des fichiers texte :",an,us,pn,ms,ri="Regardons la tokenisation d’un exemple de texte :",rn,cs,on,Ms,un,ds,oi="Nous appliquons le post-traitement au niveau de l’octet pour le <em>tokenizer</em> du GPT-2 comme suit :",mn,Js,cn,ys,ui="L’option <code>trim_offsets = False</code> indique au post-processeur que nous devons laisser les <em>offsets</em> des <em>tokens</em> qui commencent par ‘Ġ’ tels quels : de cette façon, le début des <em>offsets</em> pointera sur l’espace avant le mot, et non sur le premier caractère du mot (puisque l’espace fait techniquement partie du <em>token</em>). Regardons le résultat avec le texte que nous venons de coder, où <code>&#39;Ġtest&#39;</code> est le <em>token</em> à l’index 4 :",Mn,js,dn,Ts,Jn,fs,mi="Enfin, nous ajoutons un décodeur au niveau de l’octet :",yn,ks,jn,bs,ci="et nous pouvons vérifier qu’il fonctionne correctement :",Tn,$s,fn,Us,kn,ws,Mi="Super ! Maintenant que nous avons terminé, nous pouvons sauvegarder le tokenizer comme avant, et l’envelopper dans un <code>PreTrainedTokenizerFast</code> ou un <code>GPT2TokenizerFast</code> si nous voulons l’utiliser dans 🤗 <em>Transformers</em> :",bn,gs,$n,hs,di="ou :",Un,xs,wn,zs,Ji="Comme dernier exemple, nous allons vous montrer comment construire un <em>tokenizer</em> <em>Unigram</em> à partir de zéro.",gn,vs,hn,Is,yi="Construisons maintenant un <em>tokenizer</em> XLNet. Comme pour les <em>tokenizers</em> précédents, nous commençons par initialiser un <code>Tokenizer</code> avec un modèle <em>Unigram</em> :",xn,Cs,zn,Zs,ji="Encore une fois, nous pourrions initialiser ce modèle avec un vocabulaire si nous en avions un.",vn,Vs,Ti="Pour la normalisation, XLNet utilise quelques remplacements (qui proviennent de <em>SentencePiece</em>) :",In,qs,Cn,Bs,fi="Il remplace <code>“</code> et <code>”</code> par <code>”</code> et toute séquence de deux espaces ou plus par un seul espace, de plus il supprime les accents.",Zn,_s,ki="Le prétokenizer à utiliser pour tout <em>tokenizer SentencePiece</em> est <code>Metaspace</code> :",Vn,Ws,qn,Qs,bi="Nous pouvons jeter un coup d’oeil à la prétokénisation sur le même exemple de texte que précédemment :",Bn,Ns,_n,Xs,Wn,Rs,$i="Vient ensuite le modèle, qui doit être entraîné. XLNet possède un certain nombre de <em>tokens</em> spéciaux :",Qn,Ls,Nn,As,Ui="Un argument très important à ne pas oublier pour le <code>UnigramTrainer</code> est le <code>unk_token</code>. Nous pouvons aussi passer d’autres arguments spécifiques à l’algorithme <em>Unigram</em>, comme le <code>shrinking_factor</code> pour chaque étape où nous enlevons des <em>tokens</em> (par défaut 0.75) ou le <code>max_piece_length</code> pour spécifier la longueur maximale d’un <em>token</em> donné (par défaut 16).",Xn,Hs,wi="Ce <em>tokenizer</em> peut aussi être entraîné sur des fichiers texte :",Rn,Gs,Ln,Es,gi="Regardons la tokenisation de notre exemple :",An,Ds,Hn,Ss,Gn,Ps,hi="Une particularité de XLNet est qu’il place le <em>token</em> <code>&lt;cls&gt;</code> à la fin de la phrase, avec un identifiant de 2 (pour le distinguer des autres <em>tokens</em>). Le résultat est un remplissage à gauche. Nous pouvons traiter tous les <em>tokens</em> spéciaux et les types d’identifiant de <em>token</em> avec un modèle, comme pour BERT. Mais d’abord nous devons obtenir les identifiants des <em>tokens</em> <code>&lt;cls&gt;</code> et <code>&lt;sep&gt;</code> :",En,Fs,Dn,Ys,Sn,Ks,xi="Le modèle ressemble à ceci :",Pn,Os,Fn,et,zi="Et nous pouvons tester son fonctionnement en codant une paire de phrases :",Yn,st,Kn,tt,On,lt,vi="Enfin, nous ajoutons un décodeur <code>Metaspace</code> :",ea,nt,sa,at,Ii="et on en a fini avec ce <em>tokenizer</em> ! On peut le sauvegarder et l’envelopper dans un <code>PreTrainedTokenizerFast</code> ou <code>XLNetTokenizerFast</code> si on veut l’utiliser dans 🤗 <em>Transformers</em>. Une chose à noter lors de l’utilisation de <code>PreTrainedTokenizerFast</code> est qu’en plus des <em>tokens</em> spéciaux, nous devons dire à la bibliothèque 🤗 <em>Transformers</em> de rembourrer à gauche :",ta,it,la,pt,Ci="Ou alternativement :",na,rt,aa,ot,Zi="Maintenant que vous avez vu comment les différentes briques sont utilisées pour construire des <em>tokenizers</em> existants, vous devriez être capable d’écrire n’importe quel <em>tokenizer</em> que vous voulez avec la bibliothèque 🤗 <em>Tokenizers</em> et pouvoir l’utiliser dans 🤗 <em>Transformers</em>.",ia,ut,pa,ct,ra;return b=new Ai({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),$=new Mt({props:{title:"Construction d’un <i> tokenizer </i> , bloc par bloc",local:"construction-dun-i-tokenizer-i--bloc-par-bloc",headingTag:"h1"}}),U=new Ei({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter6/section8.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter6/section8.ipynb"}]}}),z=new Gi({props:{id:"MR8tZm5ViWU"}}),Z=new Mt({props:{title:"Acquisition d’un corpus",local:"acquisition-dun-corpus",headingTag:"h2"}}),q=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMG5hbWUlM0QlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTBBZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihkYXRhc2V0KSUyQyUyMDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBkYXRhc2V0JTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, name=<span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> dataset[i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),W=new J({props:{code:"d2l0aCUyMG9wZW4oJTIyd2lraXRleHQtMi50eHQlMjIlMkMlMjAlMjJ3JTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGYtOCUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZGF0YXNldCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShkYXRhc2V0JTVCaSU1RCU1QiUyMnRleHQlMjIlNUQlMjAlMkIlMjAlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
        f.write(dataset[i][<span class="hljs-string">&quot;text&quot;</span>] + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),N=new Mt({props:{title:"Construire un <i> tokenizer WordPiece </i> à partir de zéro",local:"construire-un-i-tokenizer-wordpiece-i-à-partir-de-zéro",headingTag:"h2"}}),L=new J({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwZGVjb2RlcnMlMkMlMEElMjAlMjAlMjAlMjBtb2RlbHMlMkMlMEElMjAlMjAlMjAlMjBub3JtYWxpemVycyUyQyUwQSUyMCUyMCUyMCUyMHByZV90b2tlbml6ZXJzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29ycyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluZXJzJTJDJTBBJTIwJTIwJTIwJTIwVG9rZW5pemVyJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuV29yZFBpZWNlKHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMikp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> (
    decoders,
    models,
    normalizers,
    pre_tokenizers,
    processors,
    trainers,
    Tokenizer,
)

tokenizer = Tokenizer(models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>))`,wrap:!1}}),G=new J({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5CZXJ0Tm9ybWFsaXplcihsb3dlcmNhc2UlM0RUcnVlKQ==",highlighted:'tokenizer.normalizer = normalizers.BertNormalizer(lowercase=<span class="hljs-literal">True</span>)',wrap:!1}}),D=new J({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5TZXF1ZW5jZSglMEElMjAlMjAlMjAlMjAlNUJub3JtYWxpemVycy5ORkQoKSUyQyUyMG5vcm1hbGl6ZXJzLkxvd2VyY2FzZSgpJTJDJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklNUQlMEEp",highlighted:`tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [normalizers.NFD(), normalizers.Lowercase(), normalizers.StripAccents()]
)`,wrap:!1}}),F=new J({props:{code:"cHJpbnQodG9rZW5pemVyLm5vcm1hbGl6ZXIubm9ybWFsaXplX3N0ciglMjJIJUMzJUE5bGwlQzMlQjIlMjBoJUMzJUI0dyUyMGFyZSUyMCVDMyVCQyUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(tokenizer.normalizer.normalize_str(<span class="hljs-string">&quot;Héllò hôw are ü?&quot;</span>))',wrap:!1}}),Y=new J({props:{code:"aGVsbG8lMjBob3clMjBhcmUlMjB1JTNG",highlighted:"hello how are u?",wrap:!1}}),f=new Li({props:{$$slots:{default:[Di]},$$scope:{ctx:dt}}}),O=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CZXJ0UHJlVG9rZW5pemVyKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.BertPreTokenizer()",wrap:!1}}),se=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5XaGl0ZXNwYWNlKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Whitespace()",wrap:!1}}),le=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBteSUyMHByZS10b2tlbml6ZXIuJTIyKQ==",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)',wrap:!1}}),ne=new J({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ie=new J({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTBBcHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKCUyMkxldCdzJTIwdGVzdCUyMG15JTIwcHJlLXRva2VuaXplci4lMjIp",highlighted:`pre_tokenizer = pre_tokenizers.WhitespaceSplit()
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),pe=new J({props:{code:"JTVCKCUyMkxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJ3Rlc3QnJTJDJTIwKDYlMkMlMjAxMCkpJTJDJTIwKCdteSclMkMlMjAoMTElMkMlMjAxMykpJTJDJTIwKCdwcmUtdG9rZW5pemVyLiclMkMlMjAoMTQlMkMlMjAyOCkpJTVE",highlighted:'[(<span class="hljs-string">&quot;Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre-tokenizer.&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">28</span>))]',wrap:!1}}),oe=new J({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLlNlcXVlbmNlKCUwQSUyMCUyMCUyMCUyMCU1QnByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTJDJTIwcHJlX3Rva2VuaXplcnMuUHVuY3R1YXRpb24oKSU1RCUwQSklMEFwcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIoJTIyTGV0J3MlMjB0ZXN0JTIwbXklMjBwcmUtdG9rZW5pemVyLiUyMik=",highlighted:`pre_tokenizer = pre_tokenizers.<span class="hljs-type">Sequence</span>(
    [pre_tokenizers.WhitespaceSplit(), pre_tokenizers.Punctuation()]
)
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),ue=new J({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ce=new J({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTBBdHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLldvcmRQaWVjZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2Vucyk=",highlighted:`special_tokens = [<span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>]
trainer = trainers.WordPieceTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens)`,wrap:!1}}),Je=new J({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:"tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)",wrap:!1}}),je=new J({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLldvcmRQaWVjZSh1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>)
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),fe=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),ke=new J({props:{code:"JTVCJ2xldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJ3Rlc3QnJTJDJTIwJ3RoaXMnJTJDJTIwJ3RvayclMkMlMjAnJTIzJTIzZW5pJyUyQyUyMCclMjMlMjN6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Ue=new J({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiU1QkNMUyU1RCUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTVCU0VQJTVEJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[CLS]&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[SEP]&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),we=new J({props:{code:"KDIlMkMlMjAzKQ==",highlighted:'(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>)',wrap:!1}}),xe=new J({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWlyJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjAlMjRCJTNBMSUyMCU1QlNFUCU1RCUzQTElMjIlMkMlMEElMjAlMjAlMjAlMjBzcGVjaWFsX3Rva2VucyUzRCU1QiglMjIlNUJDTFMlNUQlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTJDJTIwKCUyMiU1QlNFUCU1RCUyMiUyQyUyMHNlcF90b2tlbl9pZCklNUQlMkMlMEEp",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0&quot;</span>,
    pair=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0 $B:1 [SEP]:1&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;[CLS]&quot;</span>, cls_token_id), (<span class="hljs-string">&quot;[SEP]&quot;</span>, sep_token_id)],
)`,wrap:!1}}),Ie=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ce=new J({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLiclMkMlMjAnJTVCU0VQJTVEJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]',wrap:!1}}),Ve=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),qe=new J({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLi4uJyUyQyUyMCclNUJTRVAlNUQnJTJDJTIwJ29uJyUyQyUyMCdhJyUyQyUyMCdwYWlyJyUyQyUyMCdvZiclMkMlMjAnc2VudGVuY2VzJyUyQyUyMCcuJyUyQyUyMCclNUJTRVAlNUQnJTVEJTBBJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVE",highlighted:`[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;...&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;pair&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;sentences&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),_e=new J({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5Xb3JkUGllY2UocHJlZml4JTNEJTIyJTIzJTIzJTIyKQ==",highlighted:'tokenizer.decoder = decoders.WordPiece(prefix=<span class="hljs-string">&quot;##&quot;</span>)',wrap:!1}}),Qe=new J({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Ne=new J({props:{code:"JTIybGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4uLiUyMG9uJTIwYSUyMHBhaXIlMjBvZiUyMHNlbnRlbmNlcy4lMjIlMjAlMjMlMjBUZXN0b25zJTIwY2UlMjB0b2tlbml6ZXIuLi4lMjBzdXIlMjB1bmUlMjBwYWlyZSUyMGRlJTIwcGhyYXNlcy4=",highlighted:'<span class="hljs-string">&quot;let&#x27;s test this tokenizer... on a pair of sentences.&quot;</span> <span class="hljs-comment"># Testons ce tokenizer... sur une paire de phrases.</span>',wrap:!1}}),Re=new J({props:{code:"dG9rZW5pemVyLnNhdmUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'tokenizer.save(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Ae=new J({props:{code:"bmV3X3Rva2VuaXplciUyMCUzRCUyMFRva2VuaXplci5mcm9tX2ZpbGUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'new_tokenizer = Tokenizer.from_file(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Ee=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwdG9rZW5pemVyX2ZpbGUlM0QlMjJ0b2tlbml6ZXIuanNvbiUyMiUyQyUyMCUyMyUyMFZvdXMlMjBwb3V2ZXolMjBjaGFyZ2VyJTIwJUMzJUEwJTIwcGFydGlyJTIwZHUlMjBmaWNoaWVyJTIwZHUlMjB0b2tlbml6ZXIlMkMlMjBhbHRlcm5hdGl2ZW1lbnQlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlNUJQQUQlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlNUJDTFMlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlNUJTRVAlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTVCTUFTSyU1RCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    <span class="hljs-comment"># tokenizer_file=&quot;tokenizer.json&quot;, # Vous pouvez charger à partir du fichier du tokenizer, alternativement</span>
    unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>,
    pad_token=<span class="hljs-string">&quot;[PAD]&quot;</span>,
    cls_token=<span class="hljs-string">&quot;[CLS]&quot;</span>,
    sep_token=<span class="hljs-string">&quot;[SEP]&quot;</span>,
    mask_token=<span class="hljs-string">&quot;[MASK]&quot;</span>,
)`,wrap:!1}}),Se=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizerFast

wrapped_tokenizer = BertTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Ye=new Mt({props:{title:"Construire un <i> tokenizer </i> BPE à partir de zéro",local:"construire-un-i-tokenizer-i-bpe-à-partir-de-zéro",headingTag:"h2"}}),Oe=new J({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5CUEUoKSk=",highlighted:"tokenizer = Tokenizer(models.BPE())",wrap:!1}}),ts=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoYWRkX3ByZWZpeF9zcGFjZSUzREZhbHNlKQ==",highlighted:'tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel(add_prefix_space=<span class="hljs-literal">False</span>)',wrap:!1}}),ns=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBwcmUtdG9rZW5pemF0aW9uISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test pre-tokenization!&quot;</span>)',wrap:!1}}),as=new J({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJ3MlMjIlMkMlMjAoMyUyQyUyMDUpKSUyQyUyMCgnJUM0JUEwdGVzdCclMkMlMjAoNSUyQyUyMDEwKSklMkMlMjAoJyVDNCVBMHByZSclMkMlMjAoMTAlMkMlMjAxNCkpJTJDJTIwKCctJyUyQyUyMCgxNCUyQyUyMDE1KSklMkMlMEElMjAoJ3Rva2VuaXphdGlvbiclMkMlMjAoMTUlMkMlMjAyNykpJTJDJTIwKCchJyUyQyUyMCgyNyUyQyUyMDI4KSklNUQ=",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;s&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;Ġtest&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;Ġpre&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">15</span>)),
 (<span class="hljs-string">&#x27;tokenization&#x27;</span>, (<span class="hljs-number">15</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;!&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ps=new J({props:{code:"dHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLkJwZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQpJTBBdG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`trainer = trainers.BpeTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=[<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>])
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),us=new J({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLkJQRSgpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.BPE()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),cs=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ms=new J({props:{code:"JTVCJ0wnJTJDJTIwJ2V0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAnJUM0JUEwdGVzdCclMkMlMjAnJUM0JUEwdGhpcyclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2tlbiclMkMlMjAnaXplciclMkMlMjAnLiclNUQ=",highlighted:'[<span class="hljs-string">&#x27;L&#x27;</span>, <span class="hljs-string">&#x27;et&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;Ġtest&#x27;</span>, <span class="hljs-string">&#x27;Ġthis&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Js=new J({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5CeXRlTGV2ZWwodHJpbV9vZmZzZXRzJTNERmFsc2Up",highlighted:'tokenizer.post_processor = processors.ByteLevel(trim_offsets=<span class="hljs-literal">False</span>)',wrap:!1}}),js=new J({props:{code:"c2VudGVuY2UlMjAlM0QlMjAlMjJMZXQncyUyMHRlc3QlMjB0aGlzJTIwdG9rZW5pemVyLiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShzZW50ZW5jZSklMEFzdGFydCUyQyUyMGVuZCUyMCUzRCUyMGVuY29kaW5nLm9mZnNldHMlNUI0JTVEJTBBc2VudGVuY2UlNUJzdGFydCUzQWVuZCU1RA==",highlighted:`sentence = <span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>
encoding = tokenizer.encode(sentence)
start, end = encoding.offsets[<span class="hljs-number">4</span>]
sentence[start:end]`,wrap:!1}}),Ts=new J({props:{code:"JyUyMHRlc3Qn",highlighted:'<span class="hljs-string">&#x27; test&#x27;</span>',wrap:!1}}),ks=new J({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5CeXRlTGV2ZWwoKQ==",highlighted:"tokenizer.decoder = decoders.ByteLevel()",wrap:!1}}),$s=new J({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Us=new J({props:{code:"JTIyTGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4lMjIlMjAlMjMlMjBUZXN0b25zJTIwY2UlMjB0b2tlbml6ZXI=",highlighted:'<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span> <span class="hljs-comment"># Testons ce tokenizer</span>',wrap:!1}}),gs=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
)`,wrap:!1}}),xs=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2TokenizerFast

wrapped_tokenizer = GPT2TokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),vs=new Mt({props:{title:"Construire un <i> tokenizer Unigram </i> à partir de zéro",local:"construire-un-i-tokenizer-unigram-i-à-partir-de-zéro",headingTag:"h2"}}),Cs=new J({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5VbmlncmFtKCkp",highlighted:"tokenizer = Tokenizer(models.Unigram())",wrap:!1}}),qs=new J({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBSZWdleCUwQSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuUmVwbGFjZSglMjIlNjAlNjAlMjIlMkMlMjAnJTIyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKCUyMicnJTIyJTJDJTIwJyUyMicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuTkZLRCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKFJlZ2V4KCUyMiUyMCU3QjIlMkMlN0QlMjIpJTJDJTIwJTIyJTIwJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Regex

tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [
        normalizers.Replace(<span class="hljs-string">&quot;\`\`&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.Replace(<span class="hljs-string">&quot;&#x27;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.NFKD(),
        normalizers.StripAccents(),
        normalizers.Replace(Regex(<span class="hljs-string">&quot; {2,}&quot;</span>), <span class="hljs-string">&quot; &quot;</span>),
    ]
)`,wrap:!1}}),Ws=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Metaspace()",wrap:!1}}),Ns=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjB0aGUlMjBwcmUtdG9rZW5pemVyISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test the pre-tokenizer!&quot;</span>)',wrap:!1}}),Xs=new J({props:{code:"JTVCKCUyMiVFMiU5NiU4MUxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJyVFMiU5NiU4MXRlc3QnJTJDJTIwKDUlMkMlMjAxMCkpJTJDJTIwKCclRTIlOTYlODF0aGUnJTJDJTIwKDEwJTJDJTIwMTQpKSUyQyUyMCgnJUUyJTk2JTgxcHJlLXRva2VuaXplciEnJTJDJTIwKDE0JTJDJTIwMjkpKSU1RA==",highlighted:'[(<span class="hljs-string">&quot;▁Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;▁test&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;▁the&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;▁pre-tokenizer!&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">29</span>))]',wrap:!1}}),Ls=new J({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlM0NjbHMlM0UlMjIlMkMlMjAlMjIlM0NzZXAlM0UlMjIlMkMlMjAlMjIlM0N1bmslM0UlMjIlMkMlMjAlMjIlM0NwYWQlM0UlMjIlMkMlMjAlMjIlM0NtYXNrJTNFJTIyJTJDJTIwJTIyJTNDcyUzRSUyMiUyQyUyMCUyMiUzQyUyRnMlM0UlMjIlNUQlMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2VucyUyQyUyMHVua190b2tlbiUzRCUyMiUzQ3VuayUzRSUyMiUwQSklMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnZXRfdHJhaW5pbmdfY29ycHVzKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`special_tokens = [<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;s&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>]
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens, unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>
)
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),Gs=new J({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLlVuaWdyYW0oKSUwQXRva2VuaXplci50cmFpbiglNUIlMjJ3aWtpdGV4dC0yLnR4dCUyMiU1RCUyQyUyMHRyYWluZXIlM0R0cmFpbmVyKQ==",highlighted:`tokenizer.model = models.Unigram()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Ds=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ss=new J({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Fs=new J({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiUzQ2NscyUzRSUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTNDc2VwJTNFJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),Ys=new J({props:{code:"MCUyMDE=",highlighted:'<span class="hljs-number">0</span> <span class="hljs-number">1</span>',wrap:!1}}),Os=new J({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEJTIyJTI0QSUzQTAlMjAlM0NzZXAlM0UlM0EwJTIwJTNDY2xzJTNFJTNBMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhaXIlM0QlMjIlMjRBJTNBMCUyMCUzQ3NlcCUzRSUzQTAlMjAlMjRCJTNBMSUyMCUzQ3NlcCUzRSUzQTElMjAlM0NjbHMlM0UlM0EyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIoJTIyJTNDc2VwJTNFJTIyJTJDJTIwc2VwX3Rva2VuX2lkKSUyQyUyMCglMjIlM0NjbHMlM0UlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTVEJTJDJTBBKQ==",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 &lt;cls&gt;:2&quot;</span>,
    pair=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 $B:1 &lt;sep&gt;:1 &lt;cls&gt;:2&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, sep_token_id), (<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, cls_token_id)],
)`,wrap:!1}}),st=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMhJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences!&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),tt=new J({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdvbiclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdhJyUyQyUyMCclRTIlOTYlODFwYWlyJyUyQyUyMCUwQSUyMCUyMCclRTIlOTYlODFvZiclMkMlMjAnJUUyJTk2JTgxc2VudGVuY2UnJTJDJTIwJ3MnJTJDJTIwJyEnJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJTNDY2xzJTNFJyU1RCUwQSU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAyJTVE",highlighted:`[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;▁pair&#x27;</span>, 
  <span class="hljs-string">&#x27;▁of&#x27;</span>, <span class="hljs-string">&#x27;▁sentence&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;!&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;cls&gt;&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),nt=new J({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.decoder = decoders.Metaspace()",wrap:!1}}),it=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDcyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVvc190b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlM0N1bmslM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlM0NwYWQlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlM0NjbHMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlM0NzZXAlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTNDbWFzayUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;s&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>,
    unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>,
    pad_token=<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>,
    cls_token=<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>,
    sep_token=<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>,
    mask_token=<span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>,
    padding_side=<span class="hljs-string">&quot;left&quot;</span>,
)`,wrap:!1}}),rt=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyRmFzdCUwQSUwQXdyYXBwZWRfdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXJGYXN0KHRva2VuaXplcl9vYmplY3QlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizerFast

wrapped_tokenizer = XLNetTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),ut=new Hi({props:{source:"https://github.com/huggingface/course/blob/main/chapters/fr/chapter6/8.mdx"}}),{c(){y=i("meta"),k=n(),j=i("p"),mt=n(),o(b.$$.fragment),Jt=n(),o($.$$.fragment),yt=n(),o(U.$$.fragment),jt=n(),w=i("p"),w.textContent=ua,Tt=n(),g=i("ul"),g.innerHTML=ma,ft=n(),h=i("p"),h.textContent=ca,kt=n(),T=i("div"),T.innerHTML=Ma,bt=n(),x=i("p"),x.innerHTML=da,$t=n(),o(z.$$.fragment),Ut=n(),v=i("p"),v.innerHTML=Ja,wt=n(),I=i("ul"),I.innerHTML=ya,gt=n(),C=i("p"),C.innerHTML=ja,ht=n(),o(Z.$$.fragment),xt=n(),V=i("p"),V.innerHTML=Ta,zt=n(),o(q.$$.fragment),vt=n(),B=i("p"),B.innerHTML=fa,It=n(),_=i("p"),_.innerHTML=ka,Ct=n(),o(W.$$.fragment),Zt=n(),Q=i("p"),Q.innerHTML=ba,Vt=n(),o(N.$$.fragment),qt=n(),X=i("p"),X.innerHTML=$a,Bt=n(),R=i("p"),R.innerHTML=Ua,_t=n(),o(L.$$.fragment),Wt=n(),A=i("p"),A.innerHTML=wa,Qt=n(),H=i("p"),H.innerHTML=ga,Nt=n(),o(G.$$.fragment),Xt=n(),E=i("p"),E.innerHTML=ha,Rt=n(),o(D.$$.fragment),Lt=n(),S=i("p"),S.innerHTML=xa,At=n(),P=i("p"),P.innerHTML=za,Ht=n(),o(F.$$.fragment),Gt=n(),o(Y.$$.fragment),Et=n(),o(f.$$.fragment),Dt=n(),K=i("p"),K.innerHTML=va,St=n(),o(O.$$.fragment),Pt=n(),ee=i("p"),ee.textContent=Ia,Ft=n(),o(se.$$.fragment),Yt=n(),te=i("p"),te.innerHTML=Ca,Kt=n(),o(le.$$.fragment),Ot=n(),o(ne.$$.fragment),el=n(),ae=i("p"),ae.innerHTML=Za,sl=n(),o(ie.$$.fragment),tl=n(),o(pe.$$.fragment),ll=n(),re=i("p"),re.innerHTML=Va,nl=n(),o(oe.$$.fragment),al=n(),o(ue.$$.fragment),il=n(),me=i("p"),me.innerHTML=qa,pl=n(),o(ce.$$.fragment),rl=n(),Me=i("p"),Me.innerHTML=Ba,ol=n(),de=i("p"),de.textContent=_a,ul=n(),o(Je.$$.fragment),ml=n(),ye=i("p"),ye.innerHTML=Wa,cl=n(),o(je.$$.fragment),Ml=n(),Te=i("p"),Te.innerHTML=Qa,dl=n(),o(fe.$$.fragment),Jl=n(),o(ke.$$.fragment),yl=n(),be=i("p"),be.innerHTML=Na,jl=n(),$e=i("p"),$e.innerHTML=Xa,Tl=n(),o(Ue.$$.fragment),fl=n(),o(we.$$.fragment),kl=n(),ge=i("p"),ge.innerHTML=Ra,bl=n(),he=i("p"),he.textContent=La,$l=n(),o(xe.$$.fragment),Ul=n(),ze=i("p"),ze.innerHTML=Aa,wl=n(),ve=i("p"),ve.textContent=Ha,gl=n(),o(Ie.$$.fragment),hl=n(),o(Ce.$$.fragment),xl=n(),Ze=i("p"),Ze.textContent=Ga,zl=n(),o(Ve.$$.fragment),vl=n(),o(qe.$$.fragment),Il=n(),Be=i("p"),Be.innerHTML=Ea,Cl=n(),o(_e.$$.fragment),Zl=n(),We=i("p"),We.innerHTML=Da,Vl=n(),o(Qe.$$.fragment),ql=n(),o(Ne.$$.fragment),Bl=n(),Xe=i("p"),Xe.innerHTML=Sa,_l=n(),o(Re.$$.fragment),Wl=n(),Le=i("p"),Le.innerHTML=Pa,Ql=n(),o(Ae.$$.fragment),Nl=n(),He=i("p"),He.innerHTML=Fa,Xl=n(),Ge=i("p"),Ge.innerHTML=Ya,Rl=n(),o(Ee.$$.fragment),Ll=n(),De=i("p"),De.innerHTML=Ka,Al=n(),o(Se.$$.fragment),Hl=n(),Pe=i("p"),Pe.innerHTML=Oa,Gl=n(),Fe=i("p"),Fe.innerHTML=ei,El=n(),o(Ye.$$.fragment),Dl=n(),Ke=i("p"),Ke.innerHTML=si,Sl=n(),o(Oe.$$.fragment),Pl=n(),es=i("p"),es.innerHTML=ti,Fl=n(),ss=i("p"),ss.textContent=li,Yl=n(),o(ts.$$.fragment),Kl=n(),ls=i("p"),ls.innerHTML=ni,Ol=n(),o(ns.$$.fragment),en=n(),o(as.$$.fragment),sn=n(),is=i("p"),is.innerHTML=ai,tn=n(),o(ps.$$.fragment),ln=n(),rs=i("p"),rs.innerHTML=ii,nn=n(),os=i("p"),os.innerHTML=pi,an=n(),o(us.$$.fragment),pn=n(),ms=i("p"),ms.textContent=ri,rn=n(),o(cs.$$.fragment),on=n(),o(Ms.$$.fragment),un=n(),ds=i("p"),ds.innerHTML=oi,mn=n(),o(Js.$$.fragment),cn=n(),ys=i("p"),ys.innerHTML=ui,Mn=n(),o(js.$$.fragment),dn=n(),o(Ts.$$.fragment),Jn=n(),fs=i("p"),fs.textContent=mi,yn=n(),o(ks.$$.fragment),jn=n(),bs=i("p"),bs.textContent=ci,Tn=n(),o($s.$$.fragment),fn=n(),o(Us.$$.fragment),kn=n(),ws=i("p"),ws.innerHTML=Mi,bn=n(),o(gs.$$.fragment),$n=n(),hs=i("p"),hs.textContent=di,Un=n(),o(xs.$$.fragment),wn=n(),zs=i("p"),zs.innerHTML=Ji,gn=n(),o(vs.$$.fragment),hn=n(),Is=i("p"),Is.innerHTML=yi,xn=n(),o(Cs.$$.fragment),zn=n(),Zs=i("p"),Zs.textContent=ji,vn=n(),Vs=i("p"),Vs.innerHTML=Ti,In=n(),o(qs.$$.fragment),Cn=n(),Bs=i("p"),Bs.innerHTML=fi,Zn=n(),_s=i("p"),_s.innerHTML=ki,Vn=n(),o(Ws.$$.fragment),qn=n(),Qs=i("p"),Qs.textContent=bi,Bn=n(),o(Ns.$$.fragment),_n=n(),o(Xs.$$.fragment),Wn=n(),Rs=i("p"),Rs.innerHTML=$i,Qn=n(),o(Ls.$$.fragment),Nn=n(),As=i("p"),As.innerHTML=Ui,Xn=n(),Hs=i("p"),Hs.innerHTML=wi,Rn=n(),o(Gs.$$.fragment),Ln=n(),Es=i("p"),Es.textContent=gi,An=n(),o(Ds.$$.fragment),Hn=n(),o(Ss.$$.fragment),Gn=n(),Ps=i("p"),Ps.innerHTML=hi,En=n(),o(Fs.$$.fragment),Dn=n(),o(Ys.$$.fragment),Sn=n(),Ks=i("p"),Ks.textContent=xi,Pn=n(),o(Os.$$.fragment),Fn=n(),et=i("p"),et.textContent=zi,Yn=n(),o(st.$$.fragment),Kn=n(),o(tt.$$.fragment),On=n(),lt=i("p"),lt.innerHTML=vi,ea=n(),o(nt.$$.fragment),sa=n(),at=i("p"),at.innerHTML=Ii,ta=n(),o(it.$$.fragment),la=n(),pt=i("p"),pt.textContent=Ci,na=n(),o(rt.$$.fragment),aa=n(),ot=i("p"),ot.innerHTML=Zi,ia=n(),o(ut.$$.fragment),pa=n(),ct=i("p"),this.h()},l(e){const s=Xi("svelte-u9bgzb",document.head);y=p(s,"META",{name:!0,content:!0}),s.forEach(t),k=a(e),j=p(e,"P",{}),qi(j).forEach(t),mt=a(e),u(b.$$.fragment,e),Jt=a(e),u($.$$.fragment,e),yt=a(e),u(U.$$.fragment,e),jt=a(e),w=p(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-oyei3k"&&(w.textContent=ua),Tt=a(e),g=p(e,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-5anut5"&&(g.innerHTML=ma),ft=a(e),h=p(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1f3bknh"&&(h.textContent=ca),kt=a(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-oxfng3"&&(T.innerHTML=Ma),bt=a(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1kynzbk"&&(x.innerHTML=da),$t=a(e),u(z.$$.fragment,e),Ut=a(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-5p1dxj"&&(v.innerHTML=Ja),wt=a(e),I=p(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-1j4jxyk"&&(I.innerHTML=ya),gt=a(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1pt23pv"&&(C.innerHTML=ja),ht=a(e),u(Z.$$.fragment,e),xt=a(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-17c1e08"&&(V.innerHTML=Ta),zt=a(e),u(q.$$.fragment,e),vt=a(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1b2mrqy"&&(B.innerHTML=fa),It=a(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1iw8f3y"&&(_.innerHTML=ka),Ct=a(e),u(W.$$.fragment,e),Zt=a(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1nye8ho"&&(Q.innerHTML=ba),Vt=a(e),u(N.$$.fragment,e),qt=a(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1qlbya"&&(X.innerHTML=$a),Bt=a(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1bcasjg"&&(R.innerHTML=Ua),_t=a(e),u(L.$$.fragment,e),Wt=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1i725qn"&&(A.innerHTML=wa),Qt=a(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-17fukp3"&&(H.innerHTML=ga),Nt=a(e),u(G.$$.fragment,e),Xt=a(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1fejf0b"&&(E.innerHTML=ha),Rt=a(e),u(D.$$.fragment,e),Lt=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-okx1fu"&&(S.innerHTML=xa),At=a(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1gwij1w"&&(P.innerHTML=za),Ht=a(e),u(F.$$.fragment,e),Gt=a(e),u(Y.$$.fragment,e),Et=a(e),u(f.$$.fragment,e),Dt=a(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-19f16tj"&&(K.innerHTML=va),St=a(e),u(O.$$.fragment,e),Pt=a(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-159e3ir"&&(ee.textContent=Ia),Ft=a(e),u(se.$$.fragment,e),Yt=a(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-y4t8zr"&&(te.innerHTML=Ca),Kt=a(e),u(le.$$.fragment,e),Ot=a(e),u(ne.$$.fragment,e),el=a(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-fvtgu0"&&(ae.innerHTML=Za),sl=a(e),u(ie.$$.fragment,e),tl=a(e),u(pe.$$.fragment,e),ll=a(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-cs3b0n"&&(re.innerHTML=Va),nl=a(e),u(oe.$$.fragment,e),al=a(e),u(ue.$$.fragment,e),il=a(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-zfspxd"&&(me.innerHTML=qa),pl=a(e),u(ce.$$.fragment,e),rl=a(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1arwrfz"&&(Me.innerHTML=Ba),ol=a(e),de=p(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-5lxhpv"&&(de.textContent=_a),ul=a(e),u(Je.$$.fragment,e),ml=a(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-xg4lg6"&&(ye.innerHTML=Wa),cl=a(e),u(je.$$.fragment,e),Ml=a(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1i0wlz3"&&(Te.innerHTML=Qa),dl=a(e),u(fe.$$.fragment,e),Jl=a(e),u(ke.$$.fragment,e),yl=a(e),be=p(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1s495vi"&&(be.innerHTML=Na),jl=a(e),$e=p(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-eg12gz"&&($e.innerHTML=Xa),Tl=a(e),u(Ue.$$.fragment,e),fl=a(e),u(we.$$.fragment,e),kl=a(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1kio2jq"&&(ge.innerHTML=Ra),bl=a(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-zo512q"&&(he.textContent=La),$l=a(e),u(xe.$$.fragment,e),Ul=a(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1sagyrz"&&(ze.innerHTML=Aa),wl=a(e),ve=p(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-e0zi7j"&&(ve.textContent=Ha),gl=a(e),u(Ie.$$.fragment,e),hl=a(e),u(Ce.$$.fragment,e),xl=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-4c2egr"&&(Ze.textContent=Ga),zl=a(e),u(Ve.$$.fragment,e),vl=a(e),u(qe.$$.fragment,e),Il=a(e),Be=p(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-qsb42a"&&(Be.innerHTML=Ea),Cl=a(e),u(_e.$$.fragment,e),Zl=a(e),We=p(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-116zp44"&&(We.innerHTML=Da),Vl=a(e),u(Qe.$$.fragment,e),ql=a(e),u(Ne.$$.fragment,e),Bl=a(e),Xe=p(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-67o763"&&(Xe.innerHTML=Sa),_l=a(e),u(Re.$$.fragment,e),Wl=a(e),Le=p(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-kfjmjn"&&(Le.innerHTML=Pa),Ql=a(e),u(Ae.$$.fragment,e),Nl=a(e),He=p(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-ychh5o"&&(He.innerHTML=Fa),Xl=a(e),Ge=p(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-vdya8f"&&(Ge.innerHTML=Ya),Rl=a(e),u(Ee.$$.fragment,e),Ll=a(e),De=p(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-awkqmq"&&(De.innerHTML=Ka),Al=a(e),u(Se.$$.fragment,e),Hl=a(e),Pe=p(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1ndzyah"&&(Pe.innerHTML=Oa),Gl=a(e),Fe=p(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1rarvjc"&&(Fe.innerHTML=ei),El=a(e),u(Ye.$$.fragment,e),Dl=a(e),Ke=p(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-ix9zak"&&(Ke.innerHTML=si),Sl=a(e),u(Oe.$$.fragment,e),Pl=a(e),es=p(e,"P",{"data-svelte-h":!0}),r(es)!=="svelte-d2bplb"&&(es.innerHTML=ti),Fl=a(e),ss=p(e,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-lcqq2e"&&(ss.textContent=li),Yl=a(e),u(ts.$$.fragment,e),Kl=a(e),ls=p(e,"P",{"data-svelte-h":!0}),r(ls)!=="svelte-pjtgp6"&&(ls.innerHTML=ni),Ol=a(e),u(ns.$$.fragment,e),en=a(e),u(as.$$.fragment,e),sn=a(e),is=p(e,"P",{"data-svelte-h":!0}),r(is)!=="svelte-thl8v2"&&(is.innerHTML=ai),tn=a(e),u(ps.$$.fragment,e),ln=a(e),rs=p(e,"P",{"data-svelte-h":!0}),r(rs)!=="svelte-zu5iz"&&(rs.innerHTML=ii),nn=a(e),os=p(e,"P",{"data-svelte-h":!0}),r(os)!=="svelte-z3sga0"&&(os.innerHTML=pi),an=a(e),u(us.$$.fragment,e),pn=a(e),ms=p(e,"P",{"data-svelte-h":!0}),r(ms)!=="svelte-18twlvh"&&(ms.textContent=ri),rn=a(e),u(cs.$$.fragment,e),on=a(e),u(Ms.$$.fragment,e),un=a(e),ds=p(e,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-16mr1f9"&&(ds.innerHTML=oi),mn=a(e),u(Js.$$.fragment,e),cn=a(e),ys=p(e,"P",{"data-svelte-h":!0}),r(ys)!=="svelte-m9lq9f"&&(ys.innerHTML=ui),Mn=a(e),u(js.$$.fragment,e),dn=a(e),u(Ts.$$.fragment,e),Jn=a(e),fs=p(e,"P",{"data-svelte-h":!0}),r(fs)!=="svelte-1lij06j"&&(fs.textContent=mi),yn=a(e),u(ks.$$.fragment,e),jn=a(e),bs=p(e,"P",{"data-svelte-h":!0}),r(bs)!=="svelte-4071k0"&&(bs.textContent=ci),Tn=a(e),u($s.$$.fragment,e),fn=a(e),u(Us.$$.fragment,e),kn=a(e),ws=p(e,"P",{"data-svelte-h":!0}),r(ws)!=="svelte-y86eft"&&(ws.innerHTML=Mi),bn=a(e),u(gs.$$.fragment,e),$n=a(e),hs=p(e,"P",{"data-svelte-h":!0}),r(hs)!=="svelte-13b090a"&&(hs.textContent=di),Un=a(e),u(xs.$$.fragment,e),wn=a(e),zs=p(e,"P",{"data-svelte-h":!0}),r(zs)!=="svelte-1w4hpgt"&&(zs.innerHTML=Ji),gn=a(e),u(vs.$$.fragment,e),hn=a(e),Is=p(e,"P",{"data-svelte-h":!0}),r(Is)!=="svelte-58ts27"&&(Is.innerHTML=yi),xn=a(e),u(Cs.$$.fragment,e),zn=a(e),Zs=p(e,"P",{"data-svelte-h":!0}),r(Zs)!=="svelte-14pp70f"&&(Zs.textContent=ji),vn=a(e),Vs=p(e,"P",{"data-svelte-h":!0}),r(Vs)!=="svelte-st1rcn"&&(Vs.innerHTML=Ti),In=a(e),u(qs.$$.fragment,e),Cn=a(e),Bs=p(e,"P",{"data-svelte-h":!0}),r(Bs)!=="svelte-13xok8v"&&(Bs.innerHTML=fi),Zn=a(e),_s=p(e,"P",{"data-svelte-h":!0}),r(_s)!=="svelte-167wifx"&&(_s.innerHTML=ki),Vn=a(e),u(Ws.$$.fragment,e),qn=a(e),Qs=p(e,"P",{"data-svelte-h":!0}),r(Qs)!=="svelte-1o14whc"&&(Qs.textContent=bi),Bn=a(e),u(Ns.$$.fragment,e),_n=a(e),u(Xs.$$.fragment,e),Wn=a(e),Rs=p(e,"P",{"data-svelte-h":!0}),r(Rs)!=="svelte-13jka1z"&&(Rs.innerHTML=$i),Qn=a(e),u(Ls.$$.fragment,e),Nn=a(e),As=p(e,"P",{"data-svelte-h":!0}),r(As)!=="svelte-3xrd6e"&&(As.innerHTML=Ui),Xn=a(e),Hs=p(e,"P",{"data-svelte-h":!0}),r(Hs)!=="svelte-z3sga0"&&(Hs.innerHTML=wi),Rn=a(e),u(Gs.$$.fragment,e),Ln=a(e),Es=p(e,"P",{"data-svelte-h":!0}),r(Es)!=="svelte-1y9tqut"&&(Es.textContent=gi),An=a(e),u(Ds.$$.fragment,e),Hn=a(e),u(Ss.$$.fragment,e),Gn=a(e),Ps=p(e,"P",{"data-svelte-h":!0}),r(Ps)!=="svelte-1fjzee2"&&(Ps.innerHTML=hi),En=a(e),u(Fs.$$.fragment,e),Dn=a(e),u(Ys.$$.fragment,e),Sn=a(e),Ks=p(e,"P",{"data-svelte-h":!0}),r(Ks)!=="svelte-1g309vi"&&(Ks.textContent=xi),Pn=a(e),u(Os.$$.fragment,e),Fn=a(e),et=p(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-w6fgfg"&&(et.textContent=zi),Yn=a(e),u(st.$$.fragment,e),Kn=a(e),u(tt.$$.fragment,e),On=a(e),lt=p(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-ztu276"&&(lt.innerHTML=vi),ea=a(e),u(nt.$$.fragment,e),sa=a(e),at=p(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1wp6ni3"&&(at.innerHTML=Ii),ta=a(e),u(it.$$.fragment,e),la=a(e),pt=p(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-rruroj"&&(pt.textContent=Ci),na=a(e),u(rt.$$.fragment,e),aa=a(e),ot=p(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-j719xk"&&(ot.innerHTML=Zi),ia=a(e),u(ut.$$.fragment,e),pa=a(e),ct=p(e,"P",{}),qi(ct).forEach(t),this.h()},h(){oa(y,"name","hf:doc:metadata"),oa(y,"content",Pi),oa(T,"class","flex justify-center")},m(e,s){Ri(document.head,y),l(e,k,s),l(e,j,s),l(e,mt,s),m(b,e,s),l(e,Jt,s),m($,e,s),l(e,yt,s),m(U,e,s),l(e,jt,s),l(e,w,s),l(e,Tt,s),l(e,g,s),l(e,ft,s),l(e,h,s),l(e,kt,s),l(e,T,s),l(e,bt,s),l(e,x,s),l(e,$t,s),m(z,e,s),l(e,Ut,s),l(e,v,s),l(e,wt,s),l(e,I,s),l(e,gt,s),l(e,C,s),l(e,ht,s),m(Z,e,s),l(e,xt,s),l(e,V,s),l(e,zt,s),m(q,e,s),l(e,vt,s),l(e,B,s),l(e,It,s),l(e,_,s),l(e,Ct,s),m(W,e,s),l(e,Zt,s),l(e,Q,s),l(e,Vt,s),m(N,e,s),l(e,qt,s),l(e,X,s),l(e,Bt,s),l(e,R,s),l(e,_t,s),m(L,e,s),l(e,Wt,s),l(e,A,s),l(e,Qt,s),l(e,H,s),l(e,Nt,s),m(G,e,s),l(e,Xt,s),l(e,E,s),l(e,Rt,s),m(D,e,s),l(e,Lt,s),l(e,S,s),l(e,At,s),l(e,P,s),l(e,Ht,s),m(F,e,s),l(e,Gt,s),m(Y,e,s),l(e,Et,s),m(f,e,s),l(e,Dt,s),l(e,K,s),l(e,St,s),m(O,e,s),l(e,Pt,s),l(e,ee,s),l(e,Ft,s),m(se,e,s),l(e,Yt,s),l(e,te,s),l(e,Kt,s),m(le,e,s),l(e,Ot,s),m(ne,e,s),l(e,el,s),l(e,ae,s),l(e,sl,s),m(ie,e,s),l(e,tl,s),m(pe,e,s),l(e,ll,s),l(e,re,s),l(e,nl,s),m(oe,e,s),l(e,al,s),m(ue,e,s),l(e,il,s),l(e,me,s),l(e,pl,s),m(ce,e,s),l(e,rl,s),l(e,Me,s),l(e,ol,s),l(e,de,s),l(e,ul,s),m(Je,e,s),l(e,ml,s),l(e,ye,s),l(e,cl,s),m(je,e,s),l(e,Ml,s),l(e,Te,s),l(e,dl,s),m(fe,e,s),l(e,Jl,s),m(ke,e,s),l(e,yl,s),l(e,be,s),l(e,jl,s),l(e,$e,s),l(e,Tl,s),m(Ue,e,s),l(e,fl,s),m(we,e,s),l(e,kl,s),l(e,ge,s),l(e,bl,s),l(e,he,s),l(e,$l,s),m(xe,e,s),l(e,Ul,s),l(e,ze,s),l(e,wl,s),l(e,ve,s),l(e,gl,s),m(Ie,e,s),l(e,hl,s),m(Ce,e,s),l(e,xl,s),l(e,Ze,s),l(e,zl,s),m(Ve,e,s),l(e,vl,s),m(qe,e,s),l(e,Il,s),l(e,Be,s),l(e,Cl,s),m(_e,e,s),l(e,Zl,s),l(e,We,s),l(e,Vl,s),m(Qe,e,s),l(e,ql,s),m(Ne,e,s),l(e,Bl,s),l(e,Xe,s),l(e,_l,s),m(Re,e,s),l(e,Wl,s),l(e,Le,s),l(e,Ql,s),m(Ae,e,s),l(e,Nl,s),l(e,He,s),l(e,Xl,s),l(e,Ge,s),l(e,Rl,s),m(Ee,e,s),l(e,Ll,s),l(e,De,s),l(e,Al,s),m(Se,e,s),l(e,Hl,s),l(e,Pe,s),l(e,Gl,s),l(e,Fe,s),l(e,El,s),m(Ye,e,s),l(e,Dl,s),l(e,Ke,s),l(e,Sl,s),m(Oe,e,s),l(e,Pl,s),l(e,es,s),l(e,Fl,s),l(e,ss,s),l(e,Yl,s),m(ts,e,s),l(e,Kl,s),l(e,ls,s),l(e,Ol,s),m(ns,e,s),l(e,en,s),m(as,e,s),l(e,sn,s),l(e,is,s),l(e,tn,s),m(ps,e,s),l(e,ln,s),l(e,rs,s),l(e,nn,s),l(e,os,s),l(e,an,s),m(us,e,s),l(e,pn,s),l(e,ms,s),l(e,rn,s),m(cs,e,s),l(e,on,s),m(Ms,e,s),l(e,un,s),l(e,ds,s),l(e,mn,s),m(Js,e,s),l(e,cn,s),l(e,ys,s),l(e,Mn,s),m(js,e,s),l(e,dn,s),m(Ts,e,s),l(e,Jn,s),l(e,fs,s),l(e,yn,s),m(ks,e,s),l(e,jn,s),l(e,bs,s),l(e,Tn,s),m($s,e,s),l(e,fn,s),m(Us,e,s),l(e,kn,s),l(e,ws,s),l(e,bn,s),m(gs,e,s),l(e,$n,s),l(e,hs,s),l(e,Un,s),m(xs,e,s),l(e,wn,s),l(e,zs,s),l(e,gn,s),m(vs,e,s),l(e,hn,s),l(e,Is,s),l(e,xn,s),m(Cs,e,s),l(e,zn,s),l(e,Zs,s),l(e,vn,s),l(e,Vs,s),l(e,In,s),m(qs,e,s),l(e,Cn,s),l(e,Bs,s),l(e,Zn,s),l(e,_s,s),l(e,Vn,s),m(Ws,e,s),l(e,qn,s),l(e,Qs,s),l(e,Bn,s),m(Ns,e,s),l(e,_n,s),m(Xs,e,s),l(e,Wn,s),l(e,Rs,s),l(e,Qn,s),m(Ls,e,s),l(e,Nn,s),l(e,As,s),l(e,Xn,s),l(e,Hs,s),l(e,Rn,s),m(Gs,e,s),l(e,Ln,s),l(e,Es,s),l(e,An,s),m(Ds,e,s),l(e,Hn,s),m(Ss,e,s),l(e,Gn,s),l(e,Ps,s),l(e,En,s),m(Fs,e,s),l(e,Dn,s),m(Ys,e,s),l(e,Sn,s),l(e,Ks,s),l(e,Pn,s),m(Os,e,s),l(e,Fn,s),l(e,et,s),l(e,Yn,s),m(st,e,s),l(e,Kn,s),m(tt,e,s),l(e,On,s),l(e,lt,s),l(e,ea,s),m(nt,e,s),l(e,sa,s),l(e,at,s),l(e,ta,s),m(it,e,s),l(e,la,s),l(e,pt,s),l(e,na,s),m(rt,e,s),l(e,aa,s),l(e,ot,s),l(e,ia,s),m(ut,e,s),l(e,pa,s),l(e,ct,s),ra=!0},p(e,[s]){const Vi={};s&2&&(Vi.$$scope={dirty:s,ctx:e}),f.$set(Vi)},i(e){ra||(c(b.$$.fragment,e),c($.$$.fragment,e),c(U.$$.fragment,e),c(z.$$.fragment,e),c(Z.$$.fragment,e),c(q.$$.fragment,e),c(W.$$.fragment,e),c(N.$$.fragment,e),c(L.$$.fragment,e),c(G.$$.fragment,e),c(D.$$.fragment,e),c(F.$$.fragment,e),c(Y.$$.fragment,e),c(f.$$.fragment,e),c(O.$$.fragment,e),c(se.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(oe.$$.fragment,e),c(ue.$$.fragment,e),c(ce.$$.fragment,e),c(Je.$$.fragment,e),c(je.$$.fragment,e),c(fe.$$.fragment,e),c(ke.$$.fragment,e),c(Ue.$$.fragment,e),c(we.$$.fragment,e),c(xe.$$.fragment,e),c(Ie.$$.fragment,e),c(Ce.$$.fragment,e),c(Ve.$$.fragment,e),c(qe.$$.fragment,e),c(_e.$$.fragment,e),c(Qe.$$.fragment,e),c(Ne.$$.fragment,e),c(Re.$$.fragment,e),c(Ae.$$.fragment,e),c(Ee.$$.fragment,e),c(Se.$$.fragment,e),c(Ye.$$.fragment,e),c(Oe.$$.fragment,e),c(ts.$$.fragment,e),c(ns.$$.fragment,e),c(as.$$.fragment,e),c(ps.$$.fragment,e),c(us.$$.fragment,e),c(cs.$$.fragment,e),c(Ms.$$.fragment,e),c(Js.$$.fragment,e),c(js.$$.fragment,e),c(Ts.$$.fragment,e),c(ks.$$.fragment,e),c($s.$$.fragment,e),c(Us.$$.fragment,e),c(gs.$$.fragment,e),c(xs.$$.fragment,e),c(vs.$$.fragment,e),c(Cs.$$.fragment,e),c(qs.$$.fragment,e),c(Ws.$$.fragment,e),c(Ns.$$.fragment,e),c(Xs.$$.fragment,e),c(Ls.$$.fragment,e),c(Gs.$$.fragment,e),c(Ds.$$.fragment,e),c(Ss.$$.fragment,e),c(Fs.$$.fragment,e),c(Ys.$$.fragment,e),c(Os.$$.fragment,e),c(st.$$.fragment,e),c(tt.$$.fragment,e),c(nt.$$.fragment,e),c(it.$$.fragment,e),c(rt.$$.fragment,e),c(ut.$$.fragment,e),ra=!0)},o(e){M(b.$$.fragment,e),M($.$$.fragment,e),M(U.$$.fragment,e),M(z.$$.fragment,e),M(Z.$$.fragment,e),M(q.$$.fragment,e),M(W.$$.fragment,e),M(N.$$.fragment,e),M(L.$$.fragment,e),M(G.$$.fragment,e),M(D.$$.fragment,e),M(F.$$.fragment,e),M(Y.$$.fragment,e),M(f.$$.fragment,e),M(O.$$.fragment,e),M(se.$$.fragment,e),M(le.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(pe.$$.fragment,e),M(oe.$$.fragment,e),M(ue.$$.fragment,e),M(ce.$$.fragment,e),M(Je.$$.fragment,e),M(je.$$.fragment,e),M(fe.$$.fragment,e),M(ke.$$.fragment,e),M(Ue.$$.fragment,e),M(we.$$.fragment,e),M(xe.$$.fragment,e),M(Ie.$$.fragment,e),M(Ce.$$.fragment,e),M(Ve.$$.fragment,e),M(qe.$$.fragment,e),M(_e.$$.fragment,e),M(Qe.$$.fragment,e),M(Ne.$$.fragment,e),M(Re.$$.fragment,e),M(Ae.$$.fragment,e),M(Ee.$$.fragment,e),M(Se.$$.fragment,e),M(Ye.$$.fragment,e),M(Oe.$$.fragment,e),M(ts.$$.fragment,e),M(ns.$$.fragment,e),M(as.$$.fragment,e),M(ps.$$.fragment,e),M(us.$$.fragment,e),M(cs.$$.fragment,e),M(Ms.$$.fragment,e),M(Js.$$.fragment,e),M(js.$$.fragment,e),M(Ts.$$.fragment,e),M(ks.$$.fragment,e),M($s.$$.fragment,e),M(Us.$$.fragment,e),M(gs.$$.fragment,e),M(xs.$$.fragment,e),M(vs.$$.fragment,e),M(Cs.$$.fragment,e),M(qs.$$.fragment,e),M(Ws.$$.fragment,e),M(Ns.$$.fragment,e),M(Xs.$$.fragment,e),M(Ls.$$.fragment,e),M(Gs.$$.fragment,e),M(Ds.$$.fragment,e),M(Ss.$$.fragment,e),M(Fs.$$.fragment,e),M(Ys.$$.fragment,e),M(Os.$$.fragment,e),M(st.$$.fragment,e),M(tt.$$.fragment,e),M(nt.$$.fragment,e),M(it.$$.fragment,e),M(rt.$$.fragment,e),M(ut.$$.fragment,e),ra=!1},d(e){e&&(t(k),t(j),t(mt),t(Jt),t(yt),t(jt),t(w),t(Tt),t(g),t(ft),t(h),t(kt),t(T),t(bt),t(x),t($t),t(Ut),t(v),t(wt),t(I),t(gt),t(C),t(ht),t(xt),t(V),t(zt),t(vt),t(B),t(It),t(_),t(Ct),t(Zt),t(Q),t(Vt),t(qt),t(X),t(Bt),t(R),t(_t),t(Wt),t(A),t(Qt),t(H),t(Nt),t(Xt),t(E),t(Rt),t(Lt),t(S),t(At),t(P),t(Ht),t(Gt),t(Et),t(Dt),t(K),t(St),t(Pt),t(ee),t(Ft),t(Yt),t(te),t(Kt),t(Ot),t(el),t(ae),t(sl),t(tl),t(ll),t(re),t(nl),t(al),t(il),t(me),t(pl),t(rl),t(Me),t(ol),t(de),t(ul),t(ml),t(ye),t(cl),t(Ml),t(Te),t(dl),t(Jl),t(yl),t(be),t(jl),t($e),t(Tl),t(fl),t(kl),t(ge),t(bl),t(he),t($l),t(Ul),t(ze),t(wl),t(ve),t(gl),t(hl),t(xl),t(Ze),t(zl),t(vl),t(Il),t(Be),t(Cl),t(Zl),t(We),t(Vl),t(ql),t(Bl),t(Xe),t(_l),t(Wl),t(Le),t(Ql),t(Nl),t(He),t(Xl),t(Ge),t(Rl),t(Ll),t(De),t(Al),t(Hl),t(Pe),t(Gl),t(Fe),t(El),t(Dl),t(Ke),t(Sl),t(Pl),t(es),t(Fl),t(ss),t(Yl),t(Kl),t(ls),t(Ol),t(en),t(sn),t(is),t(tn),t(ln),t(rs),t(nn),t(os),t(an),t(pn),t(ms),t(rn),t(on),t(un),t(ds),t(mn),t(cn),t(ys),t(Mn),t(dn),t(Jn),t(fs),t(yn),t(jn),t(bs),t(Tn),t(fn),t(kn),t(ws),t(bn),t($n),t(hs),t(Un),t(wn),t(zs),t(gn),t(hn),t(Is),t(xn),t(zn),t(Zs),t(vn),t(Vs),t(In),t(Cn),t(Bs),t(Zn),t(_s),t(Vn),t(qn),t(Qs),t(Bn),t(_n),t(Wn),t(Rs),t(Qn),t(Nn),t(As),t(Xn),t(Hs),t(Rn),t(Ln),t(Es),t(An),t(Hn),t(Gn),t(Ps),t(En),t(Dn),t(Sn),t(Ks),t(Pn),t(Fn),t(et),t(Yn),t(Kn),t(On),t(lt),t(ea),t(sa),t(at),t(ta),t(la),t(pt),t(na),t(aa),t(ot),t(ia),t(pa),t(ct)),t(y),d(b,e),d($,e),d(U,e),d(z,e),d(Z,e),d(q,e),d(W,e),d(N,e),d(L,e),d(G,e),d(D,e),d(F,e),d(Y,e),d(f,e),d(O,e),d(se,e),d(le,e),d(ne,e),d(ie,e),d(pe,e),d(oe,e),d(ue,e),d(ce,e),d(Je,e),d(je,e),d(fe,e),d(ke,e),d(Ue,e),d(we,e),d(xe,e),d(Ie,e),d(Ce,e),d(Ve,e),d(qe,e),d(_e,e),d(Qe,e),d(Ne,e),d(Re,e),d(Ae,e),d(Ee,e),d(Se,e),d(Ye,e),d(Oe,e),d(ts,e),d(ns,e),d(as,e),d(ps,e),d(us,e),d(cs,e),d(Ms,e),d(Js,e),d(js,e),d(Ts,e),d(ks,e),d($s,e),d(Us,e),d(gs,e),d(xs,e),d(vs,e),d(Cs,e),d(qs,e),d(Ws,e),d(Ns,e),d(Xs,e),d(Ls,e),d(Gs,e),d(Ds,e),d(Ss,e),d(Fs,e),d(Ys,e),d(Os,e),d(st,e),d(tt,e),d(nt,e),d(it,e),d(rt,e),d(ut,e)}}}const Pi='{"title":"Construction d’un <i> tokenizer </i> , bloc par bloc","local":"construction-dun-i-tokenizer-i--bloc-par-bloc","sections":[{"title":"Acquisition d’un corpus","local":"acquisition-dun-corpus","sections":[],"depth":2},{"title":"Construire un <i> tokenizer WordPiece </i> à partir de zéro","local":"construire-un-i-tokenizer-wordpiece-i-à-partir-de-zéro","sections":[],"depth":2},{"title":"Construire un <i> tokenizer </i> BPE à partir de zéro","local":"construire-un-i-tokenizer-i-bpe-à-partir-de-zéro","sections":[],"depth":2},{"title":"Construire un <i> tokenizer Unigram </i> à partir de zéro","local":"construire-un-i-tokenizer-unigram-i-à-partir-de-zéro","sections":[],"depth":2}],"depth":1}';function Fi(dt){return _i(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class np extends Qi{constructor(y){super(),Ni(this,y,Fi,Si,Bi,{})}}export{np as component};
