import{s as Wt,a as ot,n as St,o as zt}from"../chunks/scheduler.cc52f4b9.js";import{S as Qt,i as Nt,e as o,s as n,c as d,h as Xt,a as i,d as s,b as a,f as ce,g as M,j as r,k as u,l as Yt,m as l,n as y,t as f,o as T,p as w}from"../chunks/index.9480bb2b.js";import{C as Pt,H as re,E as Ft}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.04d617be.js";import{C as it}from"../chunks/CodeBlock.f4148b32.js";import{C as Dt}from"../chunks/CourseFloatingBanner.cdc38ef1.js";function Kt(rt){let h,me,ue,de,j,Me,J,ye,b,fe,v,ut="Dans cette section, nous allons examiner de plus près la classe <code>Interface</code>, et comprendre les principaux paramètres utilisés pour en créer une.",Te,U,we,I,pt="Vous remarquerez que la classe <code>Interface</code> a 3 paramètres obligatoires :",he,g,ct="<code>Interface(fn, inputs, outputs, ...)</code>",je,C,mt="Ces paramètres sont :",Je,q,dt="<li><code>fn</code>: la fonction de prédiction qui est enveloppée par l’interface <em>Gradio</em>. Cette fonction peut prendre un ou plusieurs paramètres et retourner une ou plusieurs valeurs.</li> <li><code>inputs</code>: le(s) type(s) de composant(s) d’entrée. <em>Gradio</em> fournit de nombreux composants préconstruits tels que<code>&quot;image&quot;</code> ou <code>&quot;mic&quot;</code>.</li> <li><code>outputs</code>: le(s) type(s) de composant(s) de sortie. Encore une fois, <em>Gradio</em> fournit de nombreux composants pré-construits, par ex. <code>&quot;image&quot;</code> ou <code>&quot;label&quot;</code>.</li>",be,x,Mt='Pour une liste complète des composants, <a href="https://gradio.app/docs" rel="nofollow">jetez un coup d’œil à la documentation de <em>Gradio</em></a>. Chaque composant préconstruit peut être personnalisé en instanciant la classe correspondant au composant.',ve,k,yt='Par exemple, comme nous l’avons vu dans la <a href="/course/fr/chapter9/2">section précédente</a>, au lieu de passer le paramètre <code>inputs</code> par <code>&quot;textbox&quot;</code>, vous pouvez passer un composant <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> pour créer une zone de texte avec 7 lignes et un label.',Ue,$,ft="Voyons un autre exemple, cette fois avec un composant <code>Audio</code>.",Ie,A,ge,G,Tt=`Comme mentionné précédemment, <em>Gradio</em> fournit de nombreuses entrées et sorties différentes.
Construisons donc une <code>Interface</code> qui fonctionne avec l’audio.`,Ce,B,wt="Dans cet exemple, nous allons construire une fonction audio-vers-audio qui prend un fichier audio et l’inverse simplement.",qe,E,ht="Nous utiliserons comme entrée le composant <code>Audio</code>. Lorsque vous utilisez le composant <code>Audio</code>, vous pouvez spécifier si vous voulez que la <code>source</code> de l’audio soit un fichier que l’utilisateur télécharge ou un microphone avec lequel l’utilisateur enregistre sa voix. Dans ce cas, nous allons choisir un microphone. Juste pour le plaisir, nous allons ajouter une étiquette à notre <code>Audio</code> qui dit « <em>Speak here…</em> » (Parler ici).",xe,_,jt="De plus, nous aimerions recevoir l’audio sous la forme d’un tableau numpy afin de pouvoir facilement l’inverser. Nous allons donc définir le <code>&quot;type&quot;</code> comme étant <code>&quot;numpy&quot;</code>, ce qui permet de passer les données d’entrée comme un <em>tuple</em> de (<code>sample_rate</code>, <code>data</code>) dans notre fonction.",ke,Z,Jt=`Nous utiliserons également le composant de sortie <code>Audio</code> qui peut automatiquement rendre un <em>tuple</em> avec un taux d’échantillonnage et un tableau numpy de données comme un fichier audio lisible.
Dans ce cas, nous n’avons pas besoin de faire de personnalisation, donc nous utiliserons le raccourci de la chaîne <code>&quot;audio&quot;</code>.`,$e,H,Ae,L,bt='Le code ci-dessus produira une interface comme celle qui suit (si votre navigateur ne vous demande pas l’autorisation pour accéder au microphone, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">ouvrez la démo dans un onglet séparé</a>).',Ge,p,vt,Be,R,Ut="Vous devriez maintenant être capable d’enregistrer votre voix et de vous entendre parler à l’envers. Effrayant 👻 !",Ee,V,_e,W,It=`Imaginons que nous ayons une fonction plus compliquée, avec plusieurs entrées et sorties.
Dans l’exemple ci-dessous, nous avons une fonction qui prend un index de liste déroulante, une valeur de curseur et un nombre, et renvoie un échantillon audio d’une tonalité musicale.`,Ze,S,gt="Regardez comment nous passons une liste de composants d’entrée et de sortie, et voyez si vous pouvez suivre ce qui se passe.",He,z,Ct="La clé ici est que lorsque vous passez :",Le,Q,qt="<li>une liste de composants d’entrée, chaque composant correspond à un paramètre dans l’ordre.</li> <li>une liste de composants de sortie, chaque composant correspond à une valeur retournée.</li>",Re,N,xt="L’extrait de code ci-dessous montre comment trois composants d’entrée correspondent aux trois arguments de la fonction <code>generate_tone()</code> :",Ve,X,We,c,kt,Se,Y,ze,P,$t="Jusqu’à présent, nous avons utilisé la méthode <code>launch()</code> pour lancer l’interface, mais nous n’avons pas vraiment discuté de ce qu’elle fait.",Qe,F,At="Par défaut, la méthode <code>launch()</code> lancera la démo dans un serveur web qui tourne localement. Si vous exécutez votre code dans un <em>notebook</em> Jupyter ou Colab, <em>Gradio</em> va intégrer l’interface graphique de la démo dans le <em>notebook</em> afin que vous puissiez l’utiliser facilement.",Ne,D,Gt="Vous pouvez personnaliser le comportement de <code>launch()</code> à travers différents paramètres :",Xe,K,Bt="<li><code>inline</code> : si vous voulez afficher l’interface en ligne sur les <em>notebooks</em> Python.</li> <li><code>inbrowser</code> : pour lancer automatiquement l’interface dans un nouvel onglet du navigateur par défaut.</li> <li><code>share</code> : si vous voulez créer un lien public partageable depuis votre ordinateur pour l’interface. Un peu comme un lien Google Drive !</li>",Ye,O,Et="Nous couvrirons le paramètre <code>share</code> plus en détail dans la section suivante !",Pe,ee,Fe,te,_t=`Construisons une interface qui vous permette de faire la démonstration d’un modèle de <strong>reconnaissance vocale</strong>.
Pour rendre la chose intéressante, nous accepterons <em>soit</em> une entrée micro, soit un fichier téléchargé.`,De,se,Zt=`Comme d’habitude, nous allons charger notre modèle de reconnaissance vocale en utilisant la fonction <code>pipeline()</code> de 🤗 <em>Transformers</em>.
Si vous avez besoin d’un rafraîchissement rapide, vous pouvez revenir à <a href="/course/fr/chapter1/3">cette section du chapitre 1</a>. Ensuite, nous allons implémenter une fonction <code>transcribe_audio()</code> qui traite l’audio et retourne la transcription (en anglais). Enfin, nous allons envelopper cette fonction dans une <code>Interface</code> avec les composants <code>Audio</code> pour les entrées et juste le texte pour la sortie. Au total, le code de cette application est le suivant :`,Ke,le,Oe,ne,Ht='Si votre navigateur ne vous demande pas l’autorisation pour accéder au microphone, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">ouvrez la démo dans un onglet séparé</a>.',et,m,Lt,tt,ae,Rt="Voilà, c’est fait ! Vous pouvez maintenant utiliser cette interface pour transcrire de l’audio. Remarquez ici qu’en passant le paramètre <code>optional</code> à <code>True</code>, nous permettons à l’utilisateur de soit fournir un microphone ou un fichier audio (ou aucun des deux, mais cela retournera un message d’erreur).",st,oe,Vt="Continuez pour voir comment partager votre interface avec d’autres !",lt,ie,nt,pe,at;return j=new Pt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new re({props:{title:"Comprendre la classe <i> Interface </i>",local:"comprendre-la-classe-i-interface-i",headingTag:"h1"}}),b=new Dt({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter9/section3.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter9/section3.ipynb"}]}}),U=new re({props:{title:"Comment créer une interface",local:"comment-créer-une-interface",headingTag:"h2"}}),A=new re({props:{title:"Un exemple simple avec audio",local:"un-exemple-simple-avec-audio",headingTag:"h2"}}),H=new it({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),V=new re({props:{title:"Gérer les entrées et sorties multiples",local:"gérer-les-entrées-et-sorties-multiples",headingTag:"h2"}}),X=new it({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godHlwZSUzRCUyMm51bWJlciUyMiUyQyUyMHZhbHVlJTNEMSUyQyUyMGxhYmVsJTNEJTIyRHVyYXRpb24lMjBpbiUyMHNlY29uZHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8lMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;number&quot;</span>, value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),Y=new re({props:{title:"La méthode launch()",local:"la-méthode-launch",headingTag:"h3"}}),ee=new re({props:{title:"✏️ Appliquons ça !",local:"-appliquons-ça-",headingTag:"h2"}}),le=new it({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyJTJDJTIwb3B0aW9uYWwlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiUyQyUyMG9wdGlvbmFsJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIydGV4dCUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
        gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),ie=new Ft({props:{source:"https://github.com/huggingface/course/blob/main/chapters/fr/chapter9/3.mdx"}}),{c(){h=o("meta"),me=n(),ue=o("p"),de=n(),d(j.$$.fragment),Me=n(),d(J.$$.fragment),ye=n(),d(b.$$.fragment),fe=n(),v=o("p"),v.innerHTML=ut,Te=n(),d(U.$$.fragment),we=n(),I=o("p"),I.innerHTML=pt,he=n(),g=o("p"),g.innerHTML=ct,je=n(),C=o("p"),C.textContent=mt,Je=n(),q=o("ul"),q.innerHTML=dt,be=n(),x=o("p"),x.innerHTML=Mt,ve=n(),k=o("p"),k.innerHTML=yt,Ue=n(),$=o("p"),$.innerHTML=ft,Ie=n(),d(A.$$.fragment),ge=n(),G=o("p"),G.innerHTML=Tt,Ce=n(),B=o("p"),B.textContent=wt,qe=n(),E=o("p"),E.innerHTML=ht,xe=n(),_=o("p"),_.innerHTML=jt,ke=n(),Z=o("p"),Z.innerHTML=Jt,$e=n(),d(H.$$.fragment),Ae=n(),L=o("p"),L.innerHTML=bt,Ge=n(),p=o("iframe"),Be=n(),R=o("p"),R.textContent=Ut,Ee=n(),d(V.$$.fragment),_e=n(),W=o("p"),W.textContent=It,Ze=n(),S=o("p"),S.textContent=gt,He=n(),z=o("p"),z.textContent=Ct,Le=n(),Q=o("ul"),Q.innerHTML=qt,Re=n(),N=o("p"),N.innerHTML=xt,Ve=n(),d(X.$$.fragment),We=n(),c=o("iframe"),Se=n(),d(Y.$$.fragment),ze=n(),P=o("p"),P.innerHTML=$t,Qe=n(),F=o("p"),F.innerHTML=At,Ne=n(),D=o("p"),D.innerHTML=Gt,Xe=n(),K=o("ul"),K.innerHTML=Bt,Ye=n(),O=o("p"),O.innerHTML=Et,Pe=n(),d(ee.$$.fragment),Fe=n(),te=o("p"),te.innerHTML=_t,De=n(),se=o("p"),se.innerHTML=Zt,Ke=n(),d(le.$$.fragment),Oe=n(),ne=o("p"),ne.innerHTML=Ht,et=n(),m=o("iframe"),tt=n(),ae=o("p"),ae.innerHTML=Rt,st=n(),oe=o("p"),oe.textContent=Vt,lt=n(),d(ie.$$.fragment),nt=n(),pe=o("p"),this.h()},l(e){const t=Xt("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(s),me=a(e),ue=i(e,"P",{}),ce(ue).forEach(s),de=a(e),M(j.$$.fragment,e),Me=a(e),M(J.$$.fragment,e),ye=a(e),M(b.$$.fragment,e),fe=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-pnhlej"&&(v.innerHTML=ut),Te=a(e),M(U.$$.fragment,e),we=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-i8pl6i"&&(I.innerHTML=pt),he=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-5xxju6"&&(g.innerHTML=ct),je=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1go2sl4"&&(C.textContent=mt),Je=a(e),q=i(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-jfynuh"&&(q.innerHTML=dt),be=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-s6boen"&&(x.innerHTML=Mt),ve=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-op7vtp"&&(k.innerHTML=yt),Ue=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1e28b11"&&($.innerHTML=ft),Ie=a(e),M(A.$$.fragment,e),ge=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1b5p006"&&(G.innerHTML=Tt),Ce=a(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-13jci01"&&(B.textContent=wt),qe=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1r7h0mb"&&(E.innerHTML=ht),xe=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-ke7a4j"&&(_.innerHTML=jt),ke=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-elipx6"&&(Z.innerHTML=Jt),$e=a(e),M(H.$$.fragment,e),Ae=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-bdrl7v"&&(L.innerHTML=bt),Ge=a(e),p=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ce(p).forEach(s),Be=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1pkferk"&&(R.textContent=Ut),Ee=a(e),M(V.$$.fragment,e),_e=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-15yf0pp"&&(W.textContent=It),Ze=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1qox5wf"&&(S.textContent=gt),He=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1buha6f"&&(z.textContent=Ct),Le=a(e),Q=i(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-1u77mhf"&&(Q.innerHTML=qt),Re=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1y8qj54"&&(N.innerHTML=xt),Ve=a(e),M(X.$$.fragment,e),We=a(e),c=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ce(c).forEach(s),Se=a(e),M(Y.$$.fragment,e),ze=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-8ys7zg"&&(P.innerHTML=$t),Qe=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-h5bu5b"&&(F.innerHTML=At),Ne=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1n3rxi3"&&(D.innerHTML=Gt),Xe=a(e),K=i(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-fqr9m7"&&(K.innerHTML=Bt),Ye=a(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1egkbda"&&(O.innerHTML=Et),Pe=a(e),M(ee.$$.fragment,e),Fe=a(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-89td6r"&&(te.innerHTML=_t),De=a(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1x985e1"&&(se.innerHTML=Zt),Ke=a(e),M(le.$$.fragment,e),Oe=a(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-14izswp"&&(ne.innerHTML=Ht),et=a(e),m=i(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ce(m).forEach(s),tt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1b6901k"&&(ae.innerHTML=Rt),st=a(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-rm725e"&&(oe.textContent=Vt),lt=a(e),M(ie.$$.fragment,e),nt=a(e),pe=i(e,"P",{}),ce(pe).forEach(s),this.h()},h(){u(h,"name","hf:doc:metadata"),u(h,"content",Ot),ot(p.src,vt="https://course-demos-audio-reverse.hf.space")||u(p,"src",vt),u(p,"frameborder","0"),u(p,"height","250"),u(p,"title","Gradio app"),u(p,"class","container p-0 flex-grow space-iframe"),u(p,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),u(p,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),ot(c.src,kt="https://course-demos-generate-tone.hf.space")||u(c,"src",kt),u(c,"frameborder","0"),u(c,"height","450"),u(c,"title","Gradio app"),u(c,"class","container p-0 flex-grow space-iframe"),u(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),u(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),ot(m.src,Lt="https://course-demos-asr.hf.space")||u(m,"src",Lt),u(m,"frameborder","0"),u(m,"height","550"),u(m,"title","Gradio app"),u(m,"class","container p-0 flex-grow space-iframe"),u(m,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),u(m,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Yt(document.head,h),l(e,me,t),l(e,ue,t),l(e,de,t),y(j,e,t),l(e,Me,t),y(J,e,t),l(e,ye,t),y(b,e,t),l(e,fe,t),l(e,v,t),l(e,Te,t),y(U,e,t),l(e,we,t),l(e,I,t),l(e,he,t),l(e,g,t),l(e,je,t),l(e,C,t),l(e,Je,t),l(e,q,t),l(e,be,t),l(e,x,t),l(e,ve,t),l(e,k,t),l(e,Ue,t),l(e,$,t),l(e,Ie,t),y(A,e,t),l(e,ge,t),l(e,G,t),l(e,Ce,t),l(e,B,t),l(e,qe,t),l(e,E,t),l(e,xe,t),l(e,_,t),l(e,ke,t),l(e,Z,t),l(e,$e,t),y(H,e,t),l(e,Ae,t),l(e,L,t),l(e,Ge,t),l(e,p,t),l(e,Be,t),l(e,R,t),l(e,Ee,t),y(V,e,t),l(e,_e,t),l(e,W,t),l(e,Ze,t),l(e,S,t),l(e,He,t),l(e,z,t),l(e,Le,t),l(e,Q,t),l(e,Re,t),l(e,N,t),l(e,Ve,t),y(X,e,t),l(e,We,t),l(e,c,t),l(e,Se,t),y(Y,e,t),l(e,ze,t),l(e,P,t),l(e,Qe,t),l(e,F,t),l(e,Ne,t),l(e,D,t),l(e,Xe,t),l(e,K,t),l(e,Ye,t),l(e,O,t),l(e,Pe,t),y(ee,e,t),l(e,Fe,t),l(e,te,t),l(e,De,t),l(e,se,t),l(e,Ke,t),y(le,e,t),l(e,Oe,t),l(e,ne,t),l(e,et,t),l(e,m,t),l(e,tt,t),l(e,ae,t),l(e,st,t),l(e,oe,t),l(e,lt,t),y(ie,e,t),l(e,nt,t),l(e,pe,t),at=!0},p:St,i(e){at||(f(j.$$.fragment,e),f(J.$$.fragment,e),f(b.$$.fragment,e),f(U.$$.fragment,e),f(A.$$.fragment,e),f(H.$$.fragment,e),f(V.$$.fragment,e),f(X.$$.fragment,e),f(Y.$$.fragment,e),f(ee.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),at=!0)},o(e){T(j.$$.fragment,e),T(J.$$.fragment,e),T(b.$$.fragment,e),T(U.$$.fragment,e),T(A.$$.fragment,e),T(H.$$.fragment,e),T(V.$$.fragment,e),T(X.$$.fragment,e),T(Y.$$.fragment,e),T(ee.$$.fragment,e),T(le.$$.fragment,e),T(ie.$$.fragment,e),at=!1},d(e){e&&(s(me),s(ue),s(de),s(Me),s(ye),s(fe),s(v),s(Te),s(we),s(I),s(he),s(g),s(je),s(C),s(Je),s(q),s(be),s(x),s(ve),s(k),s(Ue),s($),s(Ie),s(ge),s(G),s(Ce),s(B),s(qe),s(E),s(xe),s(_),s(ke),s(Z),s($e),s(Ae),s(L),s(Ge),s(p),s(Be),s(R),s(Ee),s(_e),s(W),s(Ze),s(S),s(He),s(z),s(Le),s(Q),s(Re),s(N),s(Ve),s(We),s(c),s(Se),s(ze),s(P),s(Qe),s(F),s(Ne),s(D),s(Xe),s(K),s(Ye),s(O),s(Pe),s(Fe),s(te),s(De),s(se),s(Ke),s(Oe),s(ne),s(et),s(m),s(tt),s(ae),s(st),s(oe),s(lt),s(nt),s(pe)),s(h),w(j,e),w(J,e),w(b,e),w(U,e),w(A,e),w(H,e),w(V,e),w(X,e),w(Y,e),w(ee,e),w(le,e),w(ie,e)}}}const Ot='{"title":"Comprendre la classe <i> Interface </i>","local":"comprendre-la-classe-i-interface-i","sections":[{"title":"Comment créer une interface","local":"comment-créer-une-interface","sections":[],"depth":2},{"title":"Un exemple simple avec audio","local":"un-exemple-simple-avec-audio","sections":[],"depth":2},{"title":"Gérer les entrées et sorties multiples","local":"gérer-les-entrées-et-sorties-multiples","sections":[{"title":"La méthode launch()","local":"la-méthode-launch","sections":[],"depth":3}],"depth":2},{"title":"✏️ Appliquons ça !","local":"-appliquons-ça-","sections":[],"depth":2}],"depth":1}';function es(rt){return zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class os extends Qt{constructor(h){super(),Nt(this,h,es,Kt,Wt,{})}}export{os as component};
