# Quiz de fin de chapitre

<CourseFloatingBanner
    chapter={9}
    classNames="absolute z-10 right-0 top-0"
/>

Testons ce que vous avez appris dans ce chapitre !

### 1. Que pouvez-vous faire avec <i>Gradio</i> ?

<Question
	choices={[
        {
			text: "Créez une démo pour votre modèle d'apprentissage automatique.",
			explain: "Avec quelques lignes de code python, vous pouvez générer une démo pour votre modèle d'apprentissage automatique en utilisant notre bibliothèque de composants préconstruits.",
			correct: true
		},
		{
			text: "Partagez votre modèle d'apprentissage automatique avec d'autres personnes.",
			explain: "En utilisant le paramètre <code>share=True</code> dans la méthode de lancement, vous pouvez générer un lien de partage à envoyer à tout le monde.",
            correct: true
		},
		{
			text: "Déboguez votre modèle.",
			explain: "L'un des avantages d'une démo <i>Gradio</i> est de pouvoir tester votre modèle avec des données réelles que vous pouvez modifier et observer les prédictions du modèle changer en temps réel, ce qui vous aide à déboguer votre modèle.",
			correct: true
		},
		{
			text: "Entraîner votre modèle.",
			explain: "<i>Gradio</i> est conçu pour être utilisé pour l'inférence, APRÈS que votre modèle a été entraîné.",
		}
	]}
/>

### 2. <i>Gradio</i> fonctionne UNIQUEMENT avec les modèles en PyTorch

<Question
	choices={[
        {
			text: "Vrai",
			explain: "<i>Gradio</i> fonctionne avec les modèles Pytorch mais aussi pour tout type de modèle d'apprentissage automatique !"
        },
        {
			text: "Faux",
			explain: "<i>Gradio</i> est indifférent au modèle ce qui signifie que vous pouvez créer une démo pour tout type de modèle d'apprentissage automatique.",
			correct: true
        }
	]}
/>

### 3. D'où pouvez-vous lancer une démo <i>Gradio</i> ?

<Question
	choices={[
        {
			text: "D'un IDE Python standard",
			explain: "<i>Gradio</i> fonctionne parfaitement avec votre IDE préféré.",
            correct: true
        },
        {
			text: "De <i>notebooks</i> Google Colab",
			explain: "Vous pouvez créer et lancer une démo dans votre <i>notebook</i> Google Colab.",
			correct: true
        },
        {
			text: "De <i>notebooks</i> Jupyter",
			explain: "Vous pouvez créer et lancer une démo dans votre <i>notebook</i> Jupyter.",
			correct: true
        }
	]}
/>

### 4. <i>Gradio</i> est conçu principalement pour les modèles de NLP

<Question
	choices={[
        {
			text: "Vrai",
			explain: "<i>Gradio</i> fonctionne avec pratiquement tous les types de données, pas seulement avec le NLP."
        },
        {
			text: "Faux",
			explain: "<i>Gradio</i> fournit aux développeurs une bibliothèque de composants préconstruits pour pratiquement tous les types de données.",
            correct: true
        }
	]}
/>

### 5. Parmi les fonctionnalités suivantes, lesquelles sont prises en charge par <i>Gradio</i> ?

<Question
	choices={[
        {
			text: "Entrées et sorties multiples.",
			explain: "Les entrées et sorties multiples sont possibles avec <i>Gradio</i>. Tout ce que vous devez faire est de passer une liste d'entrées et de sorties à leurs paramètres correspondants.",
            correct: true
        },
        {
			text: "État pour la persistance des données.",
			explain: "<i>Gradio</i> est capable d'ajouter un état à votre interface.",
			correct: true
        },
        {
			text: "Authentification par nom d'utilisateur et mot de passe.",
			explain: "Passez une liste de <i>tuples</i> de nom d'utilisateur/mot de passe à la méthode de lancement pour ajouter l'authentification.",
			correct: true
        },
        {
			text: "Analyse automatique de l'utilisation de votre démo <i>Gradio</i>.",
			explain: "<i>Gradio</i> ne fournit pas aux développeurs des analyses sur les personnes qui utilisent leurs démos."
        },
        {
			text: "Chargement d'un modèle à partir du <i>Hub</i> ou de <i>Space</i>.",
			explain: "Charger n'importe quel modèle de <i>Hugging Face</i> en utilisant la méthode <code>gr.Interface.load()</code>.",
			correct: true
        }
	]}
/>

### 6. Lesquelles des méthodes suivantes sont valides pour charger un modèle à partir du <i>Hub</i> ou de <i>Space</i> ?

<Question
	choices={[
        {
			text: "<code>gr.Interface.load('huggingface/{user}/{model_name}')</code>",
			explain: "Il s'agit d'une méthode valide de chargement d'un modèle à partir du <i>Hub</i>.",
            correct: true
        },
        {
			text: "<code>gr.Interface.load('model/{user}/{model_name}')</code>",
			explain: "Il s'agit d'une méthode valide de chargement d'un modèle à partir du <i>Hub</i>.",
			correct: true
        },
        {
			text: "<code>gr.Interface.load('demos/{user}/{model_name}')</code>",
			explain: "Vous ne pouvez pas charger un modèle en utilisant le préfixe <code>demos</code>."
        },
        {
			text: "<code>gr.Interface.load('spaces/{user}/{model_name}')</code>",
			explain: "Il s'agit d'une méthode valide de chargement d'un modèle à partir de <i>Space</i>.",
			correct: true
        }
	]}
/>

### 7. Sélectionnez toutes les étapes nécessaires pour ajouter un état à votre interface <i>Gradio</i>

<Question
	choices={[
        {
			text: "Passez un paramètre supplémentaire dans votre fonction de prédiction, qui représente l'état de l'interface.",
			explain: "Un paramètre supplémentaire stockant l'historique ou l'état de votre interface est nécessaire.",
            correct: true
        },
        {
			text: "À la fin de la fonction de prédiction, renvoyer la valeur mise à jour de l'état comme une valeur de retour supplémentaire.",
			explain: "Cette valeur d'historique ou d'état doit être retournée par votre fonction.",
            correct: true
        },
        {
			text: "Ajoutez les composants d'entrée et de sortie d'état lors de la création de votre interface.",
			explain: "<i>Gradio</i> fournit un composant d'entrée et de sortie d'état pour persister les données.",
            correct: true
        }
	]}
/>

### 8. Lesquels des éléments suivants sont des composants inclus dans la bibliothèque <i>Gradio</i> ?

<Question
	choices={[
        {
			text: "<code>Textbox</code>.",
			explain: "Oui, vous pouvez créer des zones de texte avec le composant <code>Textbox</code>.",
            correct: true
        },
        {
			text: "<code>Graph</code>.",
			explain: "Il n'y a actuellement aucun composant <code>Graph</code>.",
        },
        {
			text: "<code>Image</code>.",
			explain: "Oui, vous pouvez créer un <i>widget</i> de téléchargement d'images avec le composant <code>Image</code>.",
            correct: true
        },
        {
			text: "<code>Audio</code>.",
			explain: "Oui, vous pouvez créer un <i>widget</i> de téléchargement audio avec le composant <code>Audio</code>.",
            correct: true
        },
	]}
/>

### 9. Qu'est-ce que les `Blocks` vous permet de faire ?

<Question
	choices={[
        {
			text: "Combiner plusieurs démos en une seule application web.",
			explain: "Vous pouvez utiliser la fonction <code>with gradio.Tabs():</code> pour ajouter des onglets pour plusieurs démos.",
			correct: true
        },
        {
			text: "Attribuer des déclencheurs d'événements tels que clicked/changed/etc aux composants <code>Blocks</code>.",
			explain: "Lorsque vous assignez un événement, vous passez trois paramètres : <code>fn</code> qui est la fonction qui doit être appelée, <code>inputs</code> qui est la (liste) des composants d'entrée, et <code>outputs</code> qui est la (liste) des composants de sortie qui doivent être appelés.",
			correct: true
        },
        {
			text: "Déterminer automatiquement quel composant <code>Blocks</code> doit être interactif ou statique.",
			explain: "En fonction des déclencheurs d'événements que vous définissez, <code>Blocks</code> détermine automatiquement si un composant doit accepter ou non les entrées de l'utilisateur..",
			correct: true
        },
		 {
			text: "Créer des démos en plusieurs étapes, c'est-à-dire vous permettre de réutiliser la sortie d'un composant comme entrée pour le suivant.",
			explain: "Vous pouvez utiliser un composant pour l'entrée d'un déclencheur d'événement mais la sortie d'un autre.",
            correct: true
        },
	]}
/>

### 10. Vous pouvez partager un lien public vers une démo <code>Blocks</code> et accueillir une démo <code>Blocks</code> sur <i>Space</i>

<Question
	choices={[
        {
			text: "Vrai",
			explain: "Tout comme <code>Interface</code>, toutes les capacités de partage et d'hébergement sont les mêmes pour les démos basées sur <code>Blocks</code> !",
			correct: true
        },
        {
			text: "Faux",
			explain: "Tout comme <code>Interface</code>, toutes les capacités de partage et d'hébergement sont les mêmes pour les démos basées sur <code>Blocks</code> !",
        }
	]}
/>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/fr/chapter9/9.mdx" />