# ट्रांसफार्मर, वे क्या कर सकते हैं?

<CourseFloatingBanner chapter={1}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/hi/chapter1/section3.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/hi/chapter1/section3.ipynb"},
]} />

इस खंड में, हम देखेंगे कि ट्रांसफॉर्मर मॉडल क्या कर सकते हैं और 🤗 ट्रांसफॉर्मर्स लाइब्रेरी: `पाइपलाइन ()` फ़ंक्शन से हमारे पहले टूल का उपयोग कर सकते हैं।

<Tip>

👀 ऊपर दाईं ओर *Colab में खोलें* बटन देखें? इस अनुभाग के सभी कोड नमूनों के साथ Google Colab नोटबुक खोलने के लिए उस पर क्लिक करें। यह बटन कोड उदाहरणों वाले किसी भी अनुभाग में मौजूद होगा।

यदि आप उदाहरणों को स्थानीय रूप से चलाना चाहते हैं, तो हम <a href="/course/chapter0">सेटअप</a> पर एक नज़र डालने की अनुशंसा करते हैं।

</Tip>

## ट्रांसफॉर्मर हर जगह हैं!

पिछले अनुभाग में उल्लिखित सभी प्रकार के एनएलपी कार्यों को हल करने के लिए ट्रांसफार्मर मॉडल का उपयोग किया जाता है। हगिंग फेस और ट्रांसफॉर्मर मॉडल का उपयोग करने वाली कुछ कंपनियां और संगठन यहां दिए गए हैं, जो अपने मॉडल साझा करके समुदाय में वापस योगदान करते हैं:

<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/companies.PNG" alt="Companies using Hugging Face" width="100%">

[🤗 ट्रांसफॉर्मर्स लाइब्रेरी](https://github.com/huggingface/transformers) उन साझा मॉडलों को बनाने और उपयोग करने की कार्यक्षमता प्रदान करती है। [मॉडल हब](https://huggingface.co/models) में हजारों पूर्व-प्रशिक्षित मॉडल हैं जिन्हें कोई भी डाउनलोड और उपयोग कर सकता है। आप हब पर अपने स्वयं के मॉडल भी अपलोड कर सकते हैं!

<Tip>
 ⚠️ हगिंग फेस हब ट्रांसफॉर्मर मॉडल तक सीमित नहीं है। कोई भी किसी भी प्रकार के मॉडल या डेटासेट साझा कर सकता है! सभी उपलब्ध सुविधाओं का लाभ उठाने के लिए एक <a href="https://huggingface.co/join">हगिंगफेस खाता बनाएं!</a>
  </Tip>

ट्रांसफॉर्मर मॉडल हुड के तहत कैसे काम करते हैं, यह जानने से पहले, आइए कुछ उदाहरण देखें कि कुछ दिलचस्प प्राकृतिक भाषा प्रसंस्करण समस्याओं को हल करने के लिए उनका उपयोग कैसे किया जा सकता है।

## पाइपलाइनों के साथ काम करना

<Youtube id="tiZFewofSLM" />

🤗 ट्रान्सफ़ॉर्मर्स लाइब्रेरी में सबसे बुनियादी वस्तु `पाइपलाइन ()` फ़ंक्शन है। यह एक मॉडल को इसके आवश्यक प्रीप्रोसेसिंग और पोस्टप्रोसेसिंग चरणों से जोड़ता है, जिससे हम किसी भी टेक्स्ट को सीधे इनपुट कर सकते हैं और एक समझदार उत्तर प्राप्त कर सकते हैं:

```python
from transformers import pipeline

classifier = pipeline("sentiment-analysis")
classifier("I've been waiting for a HuggingFace course my whole life.")
```

```python out
[{'label': 'POSITIVE', 'score': 0.9598047137260437}]
```

हम कई वाक्य भी पास कर सकते हैं!

```python
classifier(
    ["I've been waiting for a HuggingFace course my whole life.", "I hate this so much!"]
)
```

```python out
[{'label': 'POSITIVE', 'score': 0.9598047137260437},
 {'label': 'NEGATIVE', 'score': 0.9994558095932007}]
```

डिफ़ॉल्ट रूप से, यह पाइपलाइन एक विशेष पूर्व-प्रशिक्षित मॉडल का चयन करती है जिसे अंग्रेजी में भावना विश्लेषण के लिए ठीक किया गया है। जब आप `क्लासिफायर` ऑब्जेक्ट बनाते हैं तो मॉडल डाउनलोड और कैश किया जाता है। यदि आप कमांड को फिर से चलाते हैं, तो इसके बजाय कैश्ड मॉडल का उपयोग किया जाएगा और मॉडल को फिर से डाउनलोड करने की कोई आवश्यकता नहीं है।

जब आप किसी टेक्स्ट को पाइपलाइन में पास करते हैं तो इसमें तीन मुख्य चरण शामिल होते हैं:

1. पाठ को एक प्रारूप में पूर्वसंसाधित किया जाता है जिसे मॉडल समझ सकता है।
2. प्रीप्रोसेस्ड इनपुट मॉडल को पास कर दिए जाते हैं।
3. मॉडल की भविष्यवाणियां पोस्ट-प्रोसेस की जाती हैं, इसलिए आप उन्हें समझ सकते हैं।


वर्तमान में कुछ [उपलब्ध पाइपलाइन](https://huggingface.co/transformers/main_classes/pipelines.html) हैं:

- `feature-extraction` (पाठ का वेक्टर प्रतिनिधित्व प्राप्त करें)
- `fill-mask`
- `ner` (नामित इकाई मान्यता)
- `question-answering`
- `sentiment-analysis`
- `summarization`
- `text-generation`
- `translation`
- `zero-shot-classification`

आइए इनमें से कुछ पर एक नजर डालते हैं!

## जीरो-शॉट वर्गीकरण

हम एक अधिक चुनौतीपूर्ण कार्य से निपटने के साथ शुरू करेंगे जहां हमें उन ग्रंथों को वर्गीकृत करने की आवश्यकता है जिन्हें लेबल नहीं किया गया है। वास्तविक दुनिया की परियोजनाओं में यह एक सामान्य परिदृश्य है क्योंकि व्याख्या पाठ आमतौर पर समय लेने वाला होता है और इसके लिए डोमेन विशेषज्ञता की आवश्यकता होती है। इस उपयोग के मामले के लिए, 'शून्य-शॉट-वर्गीकरण' पाइपलाइन बहुत शक्तिशाली है: यह आपको यह निर्दिष्ट करने की अनुमति देती है कि वर्गीकरण के लिए कौन से लेबल का उपयोग करना है, इसलिए आपको पूर्व-प्रशिक्षित मॉडल के लेबल पर भरोसा करने की आवश्यकता नहीं है। आप पहले ही देख चुके हैं कि कैसे मॉडल उन दो लेबलों का उपयोग करके एक वाक्य को सकारात्मक या नकारात्मक के रूप में वर्गीकृत कर सकता है - लेकिन यह आपके द्वारा पसंद किए जाने वाले लेबल के किसी अन्य सेट का उपयोग करके टेक्स्ट को वर्गीकृत भी कर सकता है।

```python
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
classifier(
    "This is a course about the Transformers library",
    candidate_labels=["education", "politics", "business"],
)
```

```python out
{'sequence': 'This is a course about the Transformers library',
 'labels': ['education', 'business', 'politics'],
 'scores': [0.8445963859558105, 0.111976258456707, 0.043427448719739914]}
```

```python
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
classifier(
    "This is a course about the Transformers library",
    candidate_labels=["education", "politics", "business"],
)
```

```python out
{'sequence': 'This is a course about the Transformers library',
 'labels': ['education', 'business', 'politics'],
 'scores': [0.8445963859558105, 0.111976258456707, 0.043427448719739914]}
```

इस पाइपलाइन को _शून्य-शॉट_ कहा जाता है क्योंकि इसका उपयोग करने के लिए आपको अपने डेटा पर मॉडल को फ़ाइन-ट्यून करने की आवश्यकता नहीं है। यह आपके इच्छित लेबल की किसी भी सूची के लिए सीधे संभाव्यता स्कोर लौटा सकता है!

<Tip>
  
 ✏️ **कोशिश करके देखो!** अपने स्वयं के अनुक्रमों और लेबलों के साथ खेलें और देखें कि मॉडल कैसा व्यवहार करता है।
  
</Tip>

## पाठ निर्माण

अब देखते हैं कि कुछ पाठ उत्पन्न करने के लिए पाइपलाइन का उपयोग कैसे करें। यहां मुख्य विचार यह है कि आप एक संकेत प्रदान करते हैं और शेष पाठ उत्पन्न करके मॉडल इसे स्वतः पूर्ण कर देगा। यह प्रेडिक्टिव टेक्स्ट फीचर के समान है जो कई फोन पर पाया जाता है। पाठ निर्माण में यादृच्छिकता शामिल है, इसलिए यदि आपको नीचे दिखाए गए अनुसार समान परिणाम नहीं मिलते हैं तो यह सामान्य है।

```python
from transformers import pipeline

generator = pipeline("text-generation")
generator("In this course, we will teach you how to")
```

```python out
[{'generated_text': 'In this course, we will teach you how to understand and use '
                    'data flow and data interchange when handling user data. We '
                    'will be working with one or more of the most commonly used '
                    'data flows — data flows of various types, as seen by the '
                    'HTTP'}]
```

आप यह नियंत्रित कर सकते हैं कि `num_return_sequences` तर्क और `max_length` तर्क के साथ आउटपुट टेक्स्ट की कुल लंबाई के साथ कितने अलग-अलग क्रम उत्पन्न होते हैं।

<Tip>
  
✏️ **कोशिश करके देखो!** 15 शब्दों के दो वाक्य बनाने के लिए `num_return_sequences` और `max_length` तर्कों का उपयोग करें।
  
</Tip>

## हब से पाइपलाइन में किसी भी मॉडल का उपयोग करना

पिछले उदाहरणों में कार्य के लिए डिफ़ॉल्ट मॉडल का उपयोग किया गया था, लेकिन आप किसी विशिष्ट कार्य के लिए पाइपलाइन में उपयोग करने के लिए हब से एक विशेष मॉडल भी चुन सकते हैं - जैसे, टेक्स्ट जनरेशन। [मॉडल हब](https://huggingface.co/models) पर जाएं और उस कार्य के लिए केवल समर्थित मॉडल प्रदर्शित करने के लिए बाईं ओर संबंधित टैग पर क्लिक करें। आपको [इस](https://huggingface.co/models?pipeline_tag=text-generation) जैसे पेज पर पहुंचना चाहिए।

आइए [`distilgpt2`](https://huggingface.co/distilgpt2) मॉडल को आज़माएं! इसे पहले की तरह उसी पाइपलाइन में लोड करने का तरीका यहां दिया गया है:

```python
from transformers import pipeline

generator = pipeline("text-generation", model="distilgpt2")
generator(
    "In this course, we will teach you how to",
    max_length=30,
    num_return_sequences=2,
)
```

```python out
[{'generated_text': 'In this course, we will teach you how to manipulate the world and '
                    'move your mental and physical capabilities to your advantage.'},
 {'generated_text': 'In this course, we will teach you how to become an expert and '
                    'practice realtime, and with a hands on experience on both real '
                    'time and real'}]
```

आप भाषा टैग पर क्लिक करके और किसी अन्य भाषा में पाठ उत्पन्न करने वाला मॉडल चुनकर मॉडल के लिए अपनी खोज को परिष्कृत कर सकते हैं। मॉडल हब में बहुभाषी मॉडल के लिए चौकियां भी शामिल हैं जो कई भाषाओं का समर्थन करती हैं।

एक बार जब आप उस पर क्लिक करके एक मॉडल का चयन करते हैं, तो आप देखेंगे कि एक विजेट है जो आपको इसे सीधे ऑनलाइन आज़माने में सक्षम बनाता है। इस प्रकार आप मॉडल को डाउनलोड करने से पहले उसकी क्षमताओं का शीघ्रता से परीक्षण कर सकते हैं।

<Tip>
  
 ✏️ **कोशिश करके देखो!** किसी अन्य भाषा के लिए टेक्स्ट जनरेशन मॉडल खोजने के लिए फ़िल्टर का उपयोग करें। विजेट के साथ खेलने के लिए स्वतंत्र महसूस करें और इसे पाइपलाइन में उपयोग करें!
  
</Tip>

## अनुमान एपीआई

हगिंग फेस [वेबसाइट](https://huggingface.co/) पर उपलब्ध इनफरेंस एपीआई का उपयोग करके सभी मॉडलों का सीधे आपके ब्राउज़र के माध्यम से परीक्षण किया जा सकता है। आप कस्टम टेक्स्ट इनपुट करके और इनपुट डेटा की मॉडल प्रक्रिया को देखकर सीधे इस पृष्ठ पर मॉडल के साथ खेल सकते हैं।

विजेट को शक्ति प्रदान करने वाला अनुमान एपीआई एक सशुल्क उत्पाद के रूप में भी उपलब्ध है, जो आपके वर्कफ़्लो के लिए ज़रूरत पड़ने पर काम आता है। अधिक विवरण के लिए [मूल्य निर्धारण पृष्ठ](https://huggingface.co/pricing) देखें।

## मास्क भरना

अगली पाइपलाइन जो आप आजमाएंगे वह है `फिल-मास्क`। इस कार्य का विचार किसी दिए गए पाठ में रिक्त स्थान को भरना है:

```python
from transformers import pipeline

unmasker = pipeline("fill-mask")
unmasker("This course will teach you all about <mask> models.", top_k=2)
```

```python out
[{'sequence': 'This course will teach you all about mathematical models.',
  'score': 0.19619831442832947,
  'token': 30412,
  'token_str': ' mathematical'},
 {'sequence': 'This course will teach you all about computational models.',
  'score': 0.04052725434303284,
  'token': 38163,
  'token_str': ' computational'}]
```

`top_k` तर्क नियंत्रित करता है कि आप कितनी संभावनाएं प्रदर्शित करना चाहते हैं। ध्यान दें कि यहां मॉडल विशेष `<mask>` शब्द भरता है, जिसे अक्सर *मास्क टोकन* के रूप में संदर्भित किया जाता है। अन्य मुखौटा-भरने वाले मॉडलों में अलग-अलग मुखौटा टोकन हो सकते हैं, इसलिए अन्य मॉडलों की खोज करते समय उचित मुखौटा शब्द को सत्यापित करना हमेशा अच्छा होता है। इसे जांचने का एक तरीका विजेट में प्रयुक्त मुखौटा शब्द को देखकर है।

<Tip>

 ✏️ **कोशिश करके देखो!** हब पर `बर्ट-बेस-केस्ड` मॉडल खोजें और अनुमान एपीआई विजेट में इसके मुखौटा शब्द की पहचान करें। यह मॉडल उपरोक्त हमारे `पाइपलाइन` उदाहरण में वाक्य के लिए क्या भविष्यवाणी करता है?
  
</Tip>

## नामित इकाई मान्यता

नामांकित इकाई पहचान (एनईआर) एक ऐसा कार्य है जहां मॉडल को यह पता लगाना होता है कि इनपुट टेक्स्ट के कौन से हिस्से व्यक्तियों, स्थानों या संगठनों जैसी संस्थाओं से मेल खाते हैं। आइए एक उदाहरण देखें:

```python
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```

```python out
[{'entity_group': 'PER', 'score': 0.99816, 'word': 'Sylvain', 'start': 11, 'end': 18}, 
 {'entity_group': 'ORG', 'score': 0.97960, 'word': 'Hugging Face', 'start': 33, 'end': 45}, 
 {'entity_group': 'LOC', 'score': 0.99321, 'word': 'Brooklyn', 'start': 49, 'end': 57}
]
```

यहां मॉडल ने सही ढंग से पहचाना कि सिल्वेन एक व्यक्ति (पीईआर), हगिंग फेस एक संगठन (ओआरजी), और ब्रुकलिन एक स्थान (एलओसी) है।

हम पाइपलाइन निर्माण फ़ंक्शन में विकल्प `grouped_entities=True` पास करते हैं ताकि पाइपलाइन को एक ही इकाई के अनुरूप वाक्य के हिस्सों को एक साथ फिर से समूहित करने के लिए कहा जा सके: यहां मॉडल ने एक ही संगठन के रूप में "हगिंग" और "फेस" को सही ढंग से समूहीकृत किया है, भले ही नाम में कई शब्द हों। वास्तव में, जैसा कि हम अगले अध्याय में देखेंगे, प्रीप्रोसेसिंग कुछ शब्दों को छोटे भागों में भी विभाजित करता है। उदाहरण के लिए, `सिल्वेन` को चार भागों में बांटा गया है: `S`, `##yl`, `##va`, और `##in`। प्रसंस्करण के बाद के चरण में, पाइपलाइन ने उन टुकड़ों को सफलतापूर्वक पुन: समूहित किया।

<Tip>
  
 ✏️ **कोशिश करके देखो!** अंग्रेजी में पार्ट-ऑफ-स्पीच टैगिंग (आमतौर पर पीओएस के रूप में संक्षिप्त) करने में सक्षम मॉडल के लिए मॉडल हब खोजें। यह मॉडल उपरोक्त उदाहरण में वाक्य के लिए क्या भविष्यवाणी करता है?
  
</Tip>

## प्रश्न उत्तर

'प्रश्न-उत्तर' पाइपलाइन किसी दिए गए संदर्भ से जानकारी का उपयोग करके प्रश्नों का उत्तर देती है:

```python
from transformers import pipeline

question_answerer = pipeline("question-answering")
question_answerer(
    question="Where do I work?",
    context="My name is Sylvain and I work at Hugging Face in Brooklyn",
)
```

```python out
{'score': 0.6385916471481323, 'start': 33, 'end': 45, 'answer': 'Hugging Face'}
```

ध्यान दें कि यह पाइपलाइन दिए गए संदर्भ से जानकारी निकालकर काम करती है; यह उत्तर उत्पन्न नहीं करता है।

## संक्षिप्तीकरण

पाठ में संदर्भित महत्वपूर्ण पहलुओं के सभी (या अधिकतर) को रखते हुए पाठ को छोटे पाठ में कम करने का कार्य सारांशीकरण है। यहाँ एक उदाहरण है:

```python
from transformers import pipeline

summarizer = pipeline("summarization")
summarizer(
    """
    America has changed dramatically during recent years. Not only has the number of 
    graduates in traditional engineering disciplines such as mechanical, civil, 
    electrical, chemical, and aeronautical engineering declined, but in most of 
    the premier American universities engineering curricula now concentrate on 
    and encourage largely the study of engineering science. As a result, there 
    are declining offerings in engineering subjects dealing with infrastructure, 
    the environment, and related issues, and greater concentration on high 
    technology subjects, largely supporting increasingly complex scientific 
    developments. While the latter is important, it should not be at the expense 
    of more traditional engineering.

    Rapidly developing economies such as China and India, as well as other 
    industrial countries in Europe and Asia, continue to encourage and advance 
    the teaching of engineering. Both China and India, respectively, graduate 
    six and eight times as many traditional engineers as does the United States. 
    Other industrial countries at minimum maintain their output, while America 
    suffers an increasingly serious decline in the number of engineering graduates 
    and a lack of well-educated engineers.
"""
)
```

```python out
[{'summary_text': ' America has changed dramatically during recent years . The '
                  'number of engineering graduates in the U.S. has declined in '
                  'traditional engineering disciplines such as mechanical, civil '
                  ', electrical, chemical, and aeronautical engineering . Rapidly '
                  'developing economies such as China and India, as well as other '
                  'industrial countries in Europe and Asia, continue to encourage '
                  'and advance engineering .'}]
```

टेक्स्ट जनरेशन की तरह, आप परिणाम के लिए `max_length` या `min_length` निर्दिष्ट कर सकते हैं।

## अनुवाद

अनुवाद के लिए, आप एक डिफ़ॉल्ट मॉडल का उपयोग कर सकते हैं यदि आप कार्य नाम में एक भाषा युग्म प्रदान करते हैं (जैसे `"translation_en_to_fr"`), लेकिन सबसे आसान तरीका है उस मॉडल को चुनना जिसे आप [मॉडल हब](https://huggingface.co/models) पर उपयोग करना चाहते हैं। यहाँ हम फ़्रेंच से अंग्रेज़ी में अनुवाद करने का प्रयास करेंगे:

```python
from transformers import pipeline

translator = pipeline("translation", model="Helsinki-NLP/opus-mt-fr-en")
translator("Ce cours est produit par Hugging Face.")
```

```python out
[{'translation_text': 'This course is produced by Hugging Face.'}]
```

पाठ निर्माण और संक्षेपण की तरह, आप परिणाम के लिए `max_length` या `min_length` निर्दिष्ट कर सकते हैं।

<Tip>
  
✏️ **कोशिश करके देखो!** अन्य भाषाओं में अनुवाद मॉडल खोजें और पिछले वाक्य का कुछ भिन्न भाषाओं में अनुवाद करने का प्रयास करें।
  
</Tip>

अब तक दिखाई गई पाइपलाइनें ज्यादातर प्रदर्शनकारी उद्देश्यों के लिए हैं। वे विशिष्ट कार्यों के लिए प्रोग्राम किए गए थे और उनमें से विविधताएं नहीं कर सकते। अगले अध्याय में, आप सीखेंगे कि 'पाइपलाइन ()' फ़ंक्शन के अंदर क्या है और इसके व्यवहार को कैसे अनुकूलित किया जाए।


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/hi/chapter1/3.mdx" />