# पूर्वाग्रह और सीमाएं

<CourseFloatingBanner chapter={1}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/hi/chapter1/section8.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/hi/chapter1/section8.ipynb"},
]} />

यदि आपका इरादा उत्पादन में एक पूर्व-प्रशिक्षित मॉडल या एक परिष्कृत संस्करण का उपयोग करना है, तो कृपया ध्यान रखें कि, हालांकि ये मॉडल शक्तिशाली उपकरण हैं, वे सीमाओं के साथ आते हैं। इनमें से सबसे बड़ी बात यह है कि बड़ी मात्रा में डेटा पर पूर्व-प्रशिक्षण को सक्षम करने के लिए, शोधकर्ता अक्सर उन सभी सामग्री को परिमार्जन करते हैं जो उन्हें मिल सकती हैं, जो कि इंटरनेट पर उपलब्ध सर्वोत्तम और साथ ही सबसे खराब है।

एक त्वरित उदाहरण देने के लिए, आइए BERT मॉडल के साथ `फिल-मास्क` पाइपलाइन के उदाहरण पर वापस जाएं:

```python
from transformers import pipeline

unmasker = pipeline("fill-mask", model="bert-base-uncased")
result = unmasker("This man works as a [MASK].")
print([r["token_str"] for r in result])

result = unmasker("This woman works as a [MASK].")
print([r["token_str"] for r in result])
```

```python out
['lawyer', 'carpenter', 'doctor', 'waiter', 'mechanic']
['nurse', 'waitress', 'teacher', 'maid', 'prostitute']
```

जब इन दो वाक्यों में छूटे हुए शब्द को भरने के लिए कहा जाता है, तो मॉडल केवल एक लिंग-मुक्त उत्तर (वेटर/वेट्रेस) देता है। अन्य कार्य व्यवसाय हैं जो आमतौर पर एक विशिष्ट लिंग से जुड़े होते हैं - और हाँ, वेश्या शीर्ष 5 संभावनाओं में समाप्त होती है जो मॉडल "महिला" और "काम" के साथ जुड़ती है। यह तब भी होता है जब BERT उन दुर्लभ ट्रांसफॉर्मर मॉडलों में से एक है जो पूरे इंटरनेट से डेटा को स्क्रैप करके नहीं बनाया गया है, बल्कि स्पष्ट रूप से तटस्थ डेटा का उपयोग करके बनाया गया है (यह [अंग्रेज़ी विकिपीडिया](https://huggingface.co/datasets/wikipedia) पर प्रशिक्षित है। ) और [बुककॉर्पस](https://huggingface.co/datasets/bookcorpus) डेटासेट)।

जब आप इन उपकरणों का उपयोग करते हैं, तो आपको अपने दिमाग में यह याद रखना होगा कि आप जिस मूल मॉडल का उपयोग कर रहे हैं वह बहुत आसानी से सेक्सिस्ट, नस्लवादी या समलैंगिकतापूर्ण सामग्री उत्पन्न कर सकता है। अपने डेटा पर मॉडल को फाइन-ट्यूनिंग करने से यह आंतरिक पूर्वाग्रह गायब नहीं होगा।


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/hi/chapter1/8.mdx" />