import{s as Qt,a as st,n as Wt,o as Rt}from"../chunks/scheduler.cc52f4b9.js";import{S as Vt,i as Nt,e as s,s as i,c as d,h as Xt,a as o,d as l,b as n,f as ue,g as M,j as p,k as r,l as Yt,m as a,n as y,t as f,o as w,p as T}from"../chunks/index.d2856393.js";import{C as Pt,H as pe,E as Ft}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8ffb7edb.js";import{C as ot}from"../chunks/CodeBlock.5f8dc025.js";import{C as Dt}from"../chunks/CourseFloatingBanner.59eb3fdc.js";function Kt(pt){let j,me,re,de,h,Me,J,ye,b,fe,U,rt=`In questa sezione, daremo un’occhiata più da vicino alla classe <code>Interface</code> e scopriremo i
parametri principali che si usano per crearne una.`,we,v,Te,I,ct="Si può notare che la classe <code>Interface</code> (<em>interfaccia</em>) ha 3 parametri necessari:",je,C,ut="<code>Interface(fn, inputs, outputs, ...)</code>",he,g,mt="Questi parametri sono:",Je,q,dt="<li><code>fn</code>: la funzione per le predizione chi viene utilizzata dall’interfaccia di Gradio. Questa funzione può accettare uno o più parametri e restituire uno o più valori</li> <li><code>inputs</code>: il/i tipo/i dei componenti in input. Gradio fornisce molti componenti predefiniti, come <code>&quot;image&quot;</code>(<em>immagine</em>) o <code>&quot;mic&quot;</code>(<em>microfono</em>).</li> <li><code>outputs</code>: il/i tipo/i dei componenti in output. Anche in questo caso, Gradio fornisce molti componenti predefiniti, come <code>&quot;image&quot;</code> o <code>&quot;label&quot;</code>.</li>",be,k,Mt='Per un elenco completo dei componenti, <a href="https://gradio.app/docs" rel="nofollow">consultare la documentazione di Gradio</a>. Ogni componente predefinito può essere personalizzato istanziando la classe corrispondente al componente.',Ue,A,yt=`Ad esempio, come abbiamo visto nella <a href="/course/chapter9/2">sezione precedente</a>,
invece di passare <code>&quot;textbox&quot;</code> al parametro <code>inputs</code>, si può passare un componente <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> per creare una casella di testo con 7 righe e un’etichetta.`,ve,$,ft="Diamo un’occhiata a un altro esempio, questa volta con un componente <code>Audio</code>.",Ie,x,Ce,G,wt=`Come detto in precedenza, Gradio fornisce molti input e output differenti.
Costruiamo perciò una <code>Interface</code> che funziona con l’audio.`,ge,B,Tt=`In questo esempio, svilupperemo una funzione da audio ad audio che prende un
file audio e semplicemente lo inverte.`,qe,_,jt=`Per l’input utilizzeremo il componente <code>Audio</code>. Quando si usa il componente <code>Audio</code>,
si può specificare se si vuole che la <code>source</code> (<em>sorgente</em>) dell’audio sia un file
caricato dall’utente o un microfono con cui l’utente può registrare la propria voce. In questo caso,
impostiamo <code>&quot;microphone&quot;</code>. Per divertimento, aggiungeremo un’etichetta al nostro <code>Audio</code> che dice
“Speak here…” (<em>“Parla qui…”</em>).`,ke,Z,ht=`Inoltre, vorremmo ricevere l’audio come un numpy array, in modo da poterlo facilmente
“invertire”. Impostiamo quindi il <code>&quot;type&quot;</code> come <code>&quot;numpy&quot;</code>, che passa i dati in input
come una tupla di (<code>sample_rate</code>, <code>data</code>) alla nostra funzione.`,Ae,H,Jt=`Utilizzeremo anche il componente di output <code>Audio</code>, il quale può convertire automaticamente
una tupla formata da una frequenza di campionamento e un numpy array di dati in un file audio riproducibile.
In questo caso, non abbiamo bisogno di fare alcuna personalizzazione, quindi useremo la stringa
<code>&quot;audio&quot;</code>.`,$e,E,xe,z,bt=`Il codice precedente produrrà un’interfaccia come quella qui sotto (se il tuo browser non
chiede il premesso per usare il microfono, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">apri il demo in una tab diversa</a>.)`,Ge,c,Ut,Be,L,vt="A questo punto potresti registrare la tua voce e di sentirti parlare al contrario - spaventoso 👻!",_e,S,Ze,Q,It=`Supponiamo di avere una funzione più complicata, con più input e output.
Nell’esempio seguente, abbiamo una funzione che richiede un elenco a tendina, il valore di uno slider e un numero,
e restituisce il campione audio di una nota musicale.`,He,W,Ct=`Osserva come si passa un elenco di componenti di input e di output,
e vedi se riesci a seguire quello che succede.`,Ee,R,gt="La questione fondamentale è che quando si passa:",ze,V,qt="<li>un elenco di componenti di input, ogni componente corrisponde in ordine a un parametro.</li> <li>un elenco di componenti di output, ogni componente corrisponde a un valore restituito.</li>",Le,N,kt="Lo snippet di codice qui sotto mostra come tre componenti di input si abbinano ai tre argomenti della funzione <code>generate_tone()</code>:",Se,X,Qe,u,At,We,Y,Re,P,$t=`Per ora, abbiamo utilizzato il metodo <code>launch()</code> per avviare l’interfaccia, ma
non abbiamo discusso realmente cosa fa.`,Ve,F,xt=`Di default, il metodo <code>launch()</code> avvia la demo in un web server che
che viene eseguito in locale. Se si esegue il codice in un Jupyter o Colab notebook,
Gradio incorporerà l’interfaccia grafica della demo nel notebook, così da poterla usare facilmente.`,Ne,D,Gt="È possibile modificare il comportamento di <code>launch()</code> attraverso diversi parametri:",Xe,K,Bt="<li><code>inline</code> - per visualizzare l’interfaccia <em>inline</em> sui notebook di Python.</li> <li><code>inbrowser</code> - per avviare automaticamente l’interfaccia in una nuova scheda del browser di default.</li> <li><code>share</code> - per create un link pubblico per l’interfaccia da condividere dal proprio computer. Un po’ come un link di Google Drive!</li>",Ye,O,_t="Il parametro <code>share</code> sarà trattato in modo molto più dettagliato nella prossima sezione!",Pe,ee,Fe,te,Zt=`Costruiamo un’interfaccia che permetta di provare un modello di <strong>riconoscimento vocale</strong>.
Per renderlo interessante, accetteremo un input <em>qualisiasi</em> tra un microfono o un file caricato.`,De,le,Ht=`Come al solito, caricheremo il nostro modello di riconoscimento vocale usando la funzione <code>pipeline()</code> da 🤗 Transformers.
Se si ha bisogno di un ripasso veloce, si può tornare a <a href="/course/chapter1/3">quella sezione nel Capitolo 1</a>.     Quindi, implementeremo una funzione <code>transcribe_audio()</code> che elabora l’audio e restituisce la sua trascrizione. Infine, avvolgeremo questa funzione in una <code>Interface</code> con i componenti <code>Audio</code> per gli input e solo testo per l’output. Il codice completo per questa applicazione è il seguente:`,Ke,ae,Oe,ie,Et='Se il tuo browser non ti chiede i permessi per il microfono, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">apri la demo in una scheda separata</a>.',et,m,zt,tt,ne,Lt=`Ecco fatto! Ora è possibile utilizzare questa interfaccia per trascrivere l’audio. Si osservi che
passando il parametro <code>optional</code> come <code>True</code>, si permette all’utente di
fornire o un microfono o un file audio (o nessuno dei due, ma questo restituirà un messaggio di errore).`,lt,se,St="Continua a leggere per scoprire come condividere la tua interfaccia con gli altri!",at,oe,it,ce,nt;return h=new Pt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new pe({props:{title:"Capire la classe Interface",local:"capire-la-classe-interface",headingTag:"h1"}}),b=new Dt({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter9/section3.ipynb"}]}}),v=new pe({props:{title:"Come creare una Interface",local:"come-creare-una-interface",headingTag:"h2"}}),x=new pe({props:{title:"Un semplice esempio con l’audio",local:"un-semplice-esempio-con-laudio",headingTag:"h2"}}),E=new ot({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),S=new pe({props:{title:"Lavorare con più input e output",local:"lavorare-con-più-input-e-output",headingTag:"h2"}}),X=new ot({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godHlwZSUzRCUyMm51bWJlciUyMiUyQyUyMHZhbHVlJTNEMSUyQyUyMGxhYmVsJTNEJTIyRHVyYXRpb24lMjBpbiUyMHNlY29uZHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8lMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;number&quot;</span>, value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),Y=new pe({props:{title:"Il metodo launch()",local:"il-metodo-launch",headingTag:"h3"}}),ee=new pe({props:{title:"✏️ Mettiamolo in pratica!",local:"-mettiamolo-in-pratica",headingTag:"h2"}}),ae=new ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyJTJDJTIwb3B0aW9uYWwlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiUyQyUyMG9wdGlvbmFsJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIydGV4dCUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
        gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),oe=new Ft({props:{source:"https://github.com/huggingface/course/blob/main/chapters/it/chapter9/3.mdx"}}),{c(){j=s("meta"),me=i(),re=s("p"),de=i(),d(h.$$.fragment),Me=i(),d(J.$$.fragment),ye=i(),d(b.$$.fragment),fe=i(),U=s("p"),U.innerHTML=rt,we=i(),d(v.$$.fragment),Te=i(),I=s("p"),I.innerHTML=ct,je=i(),C=s("p"),C.innerHTML=ut,he=i(),g=s("p"),g.textContent=mt,Je=i(),q=s("ul"),q.innerHTML=dt,be=i(),k=s("p"),k.innerHTML=Mt,Ue=i(),A=s("p"),A.innerHTML=yt,ve=i(),$=s("p"),$.innerHTML=ft,Ie=i(),d(x.$$.fragment),Ce=i(),G=s("p"),G.innerHTML=wt,ge=i(),B=s("p"),B.textContent=Tt,qe=i(),_=s("p"),_.innerHTML=jt,ke=i(),Z=s("p"),Z.innerHTML=ht,Ae=i(),H=s("p"),H.innerHTML=Jt,$e=i(),d(E.$$.fragment),xe=i(),z=s("p"),z.innerHTML=bt,Ge=i(),c=s("iframe"),Be=i(),L=s("p"),L.textContent=vt,_e=i(),d(S.$$.fragment),Ze=i(),Q=s("p"),Q.textContent=It,He=i(),W=s("p"),W.textContent=Ct,Ee=i(),R=s("p"),R.textContent=gt,ze=i(),V=s("ul"),V.innerHTML=qt,Le=i(),N=s("p"),N.innerHTML=kt,Se=i(),d(X.$$.fragment),Qe=i(),u=s("iframe"),We=i(),d(Y.$$.fragment),Re=i(),P=s("p"),P.innerHTML=$t,Ve=i(),F=s("p"),F.innerHTML=xt,Ne=i(),D=s("p"),D.innerHTML=Gt,Xe=i(),K=s("ul"),K.innerHTML=Bt,Ye=i(),O=s("p"),O.innerHTML=_t,Pe=i(),d(ee.$$.fragment),Fe=i(),te=s("p"),te.innerHTML=Zt,De=i(),le=s("p"),le.innerHTML=Ht,Ke=i(),d(ae.$$.fragment),Oe=i(),ie=s("p"),ie.innerHTML=Et,et=i(),m=s("iframe"),tt=i(),ne=s("p"),ne.innerHTML=Lt,lt=i(),se=s("p"),se.textContent=St,at=i(),d(oe.$$.fragment),it=i(),ce=s("p"),this.h()},l(e){const t=Xt("svelte-u9bgzb",document.head);j=o(t,"META",{name:!0,content:!0}),t.forEach(l),me=n(e),re=o(e,"P",{}),ue(re).forEach(l),de=n(e),M(h.$$.fragment,e),Me=n(e),M(J.$$.fragment,e),ye=n(e),M(b.$$.fragment,e),fe=n(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-14ztba5"&&(U.innerHTML=rt),we=n(e),M(v.$$.fragment,e),Te=n(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-mdq459"&&(I.innerHTML=ct),je=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-5xxju6"&&(C.innerHTML=ut),he=n(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-6irjuj"&&(g.textContent=mt),Je=n(e),q=o(e,"UL",{"data-svelte-h":!0}),p(q)!=="svelte-1j8hlms"&&(q.innerHTML=dt),be=n(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1jw46aq"&&(k.innerHTML=Mt),Ue=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-19f2t2g"&&(A.innerHTML=yt),ve=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-typm67"&&($.innerHTML=ft),Ie=n(e),M(x.$$.fragment,e),Ce=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-rpkqe"&&(G.innerHTML=wt),ge=n(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-a1nhl0"&&(B.textContent=Tt),qe=n(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-bhgks4"&&(_.innerHTML=jt),ke=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-y2m3ta"&&(Z.innerHTML=ht),Ae=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1ixtdpr"&&(H.innerHTML=Jt),$e=n(e),M(E.$$.fragment,e),xe=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-awt8h6"&&(z.innerHTML=bt),Ge=n(e),c=o(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(c).forEach(l),Be=n(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-tpp1gz"&&(L.textContent=vt),_e=n(e),M(S.$$.fragment,e),Ze=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1vk6lhf"&&(Q.textContent=It),He=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-dck3w8"&&(W.textContent=Ct),Ee=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1nrtmto"&&(R.textContent=gt),ze=n(e),V=o(e,"UL",{"data-svelte-h":!0}),p(V)!=="svelte-1p8dh6b"&&(V.innerHTML=qt),Le=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-lpxldx"&&(N.innerHTML=kt),Se=n(e),M(X.$$.fragment,e),Qe=n(e),u=o(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(u).forEach(l),We=n(e),M(Y.$$.fragment,e),Re=n(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1m4lcun"&&(P.innerHTML=$t),Ve=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1khz6t"&&(F.innerHTML=xt),Ne=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1m47pf2"&&(D.innerHTML=Gt),Xe=n(e),K=o(e,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-1x8aicu"&&(K.innerHTML=Bt),Ye=n(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-ozzr76"&&(O.innerHTML=_t),Pe=n(e),M(ee.$$.fragment,e),Fe=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-24bysq"&&(te.innerHTML=Zt),De=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1o4vjjv"&&(le.innerHTML=Ht),Ke=n(e),M(ae.$$.fragment,e),Oe=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-55fg8a"&&(ie.innerHTML=Et),et=n(e),m=o(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(m).forEach(l),tt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1c0ove0"&&(ne.innerHTML=Lt),lt=n(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1rwz6wq"&&(se.textContent=St),at=n(e),M(oe.$$.fragment,e),it=n(e),ce=o(e,"P",{}),ue(ce).forEach(l),this.h()},h(){r(j,"name","hf:doc:metadata"),r(j,"content",Ot),st(c.src,Ut="https://course-demos-audio-reverse.hf.space")||r(c,"src",Ut),r(c,"frameborder","0"),r(c,"height","250"),r(c,"title","Gradio app"),r(c,"class","container p-0 flex-grow space-iframe"),r(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),st(u.src,At="https://course-demos-generate-tone.hf.space")||r(u,"src",At),r(u,"frameborder","0"),r(u,"height","450"),r(u,"title","Gradio app"),r(u,"class","container p-0 flex-grow space-iframe"),r(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),st(m.src,zt="https://course-demos-asr.hf.space")||r(m,"src",zt),r(m,"frameborder","0"),r(m,"height","550"),r(m,"title","Gradio app"),r(m,"class","container p-0 flex-grow space-iframe"),r(m,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(m,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Yt(document.head,j),a(e,me,t),a(e,re,t),a(e,de,t),y(h,e,t),a(e,Me,t),y(J,e,t),a(e,ye,t),y(b,e,t),a(e,fe,t),a(e,U,t),a(e,we,t),y(v,e,t),a(e,Te,t),a(e,I,t),a(e,je,t),a(e,C,t),a(e,he,t),a(e,g,t),a(e,Je,t),a(e,q,t),a(e,be,t),a(e,k,t),a(e,Ue,t),a(e,A,t),a(e,ve,t),a(e,$,t),a(e,Ie,t),y(x,e,t),a(e,Ce,t),a(e,G,t),a(e,ge,t),a(e,B,t),a(e,qe,t),a(e,_,t),a(e,ke,t),a(e,Z,t),a(e,Ae,t),a(e,H,t),a(e,$e,t),y(E,e,t),a(e,xe,t),a(e,z,t),a(e,Ge,t),a(e,c,t),a(e,Be,t),a(e,L,t),a(e,_e,t),y(S,e,t),a(e,Ze,t),a(e,Q,t),a(e,He,t),a(e,W,t),a(e,Ee,t),a(e,R,t),a(e,ze,t),a(e,V,t),a(e,Le,t),a(e,N,t),a(e,Se,t),y(X,e,t),a(e,Qe,t),a(e,u,t),a(e,We,t),y(Y,e,t),a(e,Re,t),a(e,P,t),a(e,Ve,t),a(e,F,t),a(e,Ne,t),a(e,D,t),a(e,Xe,t),a(e,K,t),a(e,Ye,t),a(e,O,t),a(e,Pe,t),y(ee,e,t),a(e,Fe,t),a(e,te,t),a(e,De,t),a(e,le,t),a(e,Ke,t),y(ae,e,t),a(e,Oe,t),a(e,ie,t),a(e,et,t),a(e,m,t),a(e,tt,t),a(e,ne,t),a(e,lt,t),a(e,se,t),a(e,at,t),y(oe,e,t),a(e,it,t),a(e,ce,t),nt=!0},p:Wt,i(e){nt||(f(h.$$.fragment,e),f(J.$$.fragment,e),f(b.$$.fragment,e),f(v.$$.fragment,e),f(x.$$.fragment,e),f(E.$$.fragment,e),f(S.$$.fragment,e),f(X.$$.fragment,e),f(Y.$$.fragment,e),f(ee.$$.fragment,e),f(ae.$$.fragment,e),f(oe.$$.fragment,e),nt=!0)},o(e){w(h.$$.fragment,e),w(J.$$.fragment,e),w(b.$$.fragment,e),w(v.$$.fragment,e),w(x.$$.fragment,e),w(E.$$.fragment,e),w(S.$$.fragment,e),w(X.$$.fragment,e),w(Y.$$.fragment,e),w(ee.$$.fragment,e),w(ae.$$.fragment,e),w(oe.$$.fragment,e),nt=!1},d(e){e&&(l(me),l(re),l(de),l(Me),l(ye),l(fe),l(U),l(we),l(Te),l(I),l(je),l(C),l(he),l(g),l(Je),l(q),l(be),l(k),l(Ue),l(A),l(ve),l($),l(Ie),l(Ce),l(G),l(ge),l(B),l(qe),l(_),l(ke),l(Z),l(Ae),l(H),l($e),l(xe),l(z),l(Ge),l(c),l(Be),l(L),l(_e),l(Ze),l(Q),l(He),l(W),l(Ee),l(R),l(ze),l(V),l(Le),l(N),l(Se),l(Qe),l(u),l(We),l(Re),l(P),l(Ve),l(F),l(Ne),l(D),l(Xe),l(K),l(Ye),l(O),l(Pe),l(Fe),l(te),l(De),l(le),l(Ke),l(Oe),l(ie),l(et),l(m),l(tt),l(ne),l(lt),l(se),l(at),l(it),l(ce)),l(j),T(h,e),T(J,e),T(b,e),T(v,e),T(x,e),T(E,e),T(S,e),T(X,e),T(Y,e),T(ee,e),T(ae,e),T(oe,e)}}}const Ot='{"title":"Capire la classe Interface","local":"capire-la-classe-interface","sections":[{"title":"Come creare una Interface","local":"come-creare-una-interface","sections":[],"depth":2},{"title":"Un semplice esempio con l’audio","local":"un-semplice-esempio-con-laudio","sections":[],"depth":2},{"title":"Lavorare con più input e output","local":"lavorare-con-più-input-e-output","sections":[{"title":"Il metodo launch()","local":"il-metodo-launch","sections":[],"depth":3}],"depth":2},{"title":"✏️ Mettiamolo in pratica!","local":"-mettiamolo-in-pratica","sections":[],"depth":2}],"depth":1}';function el(pt){return Rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sl extends Vt{constructor(j){super(),Nt(this,j,el,Kt,Qt,{})}}export{sl as component};
