# Introduzione

Benvenuto/a al corso di Hugging Face! In questo capitolo introduttivo, ti aiuteremo a configurare il tuo ambiente di lavoro. Se non hai ancora cominciato il corso, ti consigliamo di dare prima un occhio al [Capitolo 1](/course/chapter1), per poi tornare qui a creare il tuo ambiente e cominciare a lavorare al codice.

Tutte le librerie che useremo in questo corso sono disponibili come pacchetti Python. Qui ti mostreremo dapprima come configurare un ambiente Python e in seguito come installare le librerie di cui avrai bisogno.

Copriremo due modi per configurare un ambiente di lavoro: usando un blocco note Colab, oppure un ambiente virtuale in Python. Sentiti libero/a di scegliere quello che ti sembra più adatto a te. Se sei un/a principiante, ti consigliamo vivamente di cominciare a lavorare con un blocco note Colab.

Nota che non copriremo Windows. Se utilizzi Windows come sistema operativo, il nostro consiglio è di seguire il corso utilizzando un blocco note Colab. Se invece utilizzi Linux oppure macOS, puoi scegliere uno qualsiasi degli approcci descritti qui in seguito.

Buona parte del corso richiede un profilo di Hugging Face. Ti consigliamo dunque di crearne uno al più presto: [Crea un profilo](https://huggingface.co/join).

## Come usare un blocco note Colab di Google

Il modo più semplice di configurare il tuo ambiente di lavoro è utilizzando Google Colab: una volta avviato un blocco note nel browser, puoi iniziare immediatamente a programmare! 

Se non conosci bene Colab, ti raccomandiamo di iniziare dalla seguente [introduzione](https://colab.research.google.com/notebooks/intro.ipynb). Colab permette di utilizzare accelerazioni hardware come GPU o TPU, ed è gratuito per i carichi di lavoro più piccoli.

Quando ti sentirai a tuo agio con Colab, crea un nuovo blocco note e inizia la configurazione:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="An empty colab notebook" width="80%"/>
</div>

Il passo successivo consiste nell'installare le librerie che utilizzerai in questo corso. Per l'installazione, useremo `pip`, ossia il gestore di pacchetti di Python. In Google Colab, puoi inizializzare i tuoi comandi di sistema facendone precedere il nome dal carattere `!`. La libreria 🤗 Transformers verrà quindi installata come segue:

```
!pip install transformers
```

Puoi assicurarti che il pacchetto sia stato installato correttamente importandolo in Python:

```
import transformers
```

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>

Quest'operazione installa una versione molto leggera degli 🤗 Transformers che non importa nessun framework (*quadro strutturale*) di machine learning (*apprendimento automatico*), come ad esempio PyTorch o TensorFlow. Dato che useremo numerose features (*caratteristiche*) della libreria, ti raccomandiamo l'installazione della versione per sviluppatori. Questa contiene praticamente tutte le dipendenze possibili e immaginabili:

```
!pip install transformers[sentencepiece]
```

L'operazione richiederà un po' di tempo, ma poi sarai pronto/a per il tutto resto del corso!

## Come usare un ambiente virtuale in Python

Se preferisci utilizzare un ambiente virtuale in Python, il primo passo consiste nell'installazione di Python nel tuo sistema. Ti raccomandiamo di aiutarti con [questa guida](https://realpython.com/installing-python/).

Quando avrai installato Python, dovresti riuscire a eseguire qualsiasi comando in Python sul terminale. Prima di procedere ai passi successivi, prova a eseguire il seguente comando per assicurarti che Python sia installato correttamente: `python --version`. Il comando dovrebbe stampare il nome della versione di Python installata nella tua macchina.

Quando esegui un comando in Python dal terminale, come ad esempio `python --version`, ti consigliamo di considerare il programma che esegue il tuo comando come l'installazione "principale" di Python del tuo sistema. La nostra raccomandazione è di tenere quest'installazione principale libera da pacchetti di ogni tipo, e di usarla per creare ambienti diversi per ogni applicazione alla quale lavorerai. In questo modo, ogni applicazione avrà le proprie dipendenze e i propri pacchetti, e non dovrai preoccuparti di eventuali problemi di compatibilità con altre applicazioni.

In Python, quest'operazione si effettua utilizzando i [virtual environments](https://docs.python.org/3/tutorial/venv.html) (*ambienti virtuali*). Questi ultimi sono degli alberi di directory autonomi che contengono installazioni di Python diverse, ossia particolari versioni di Python unite a tutti i pacchetti richiesti da una certa applicazione. La creazione di ambienti virtuali di questo tipo si può attuare a mezzo di strumenti diversi, anche se qui useremo esclusivamente il pacchetto ufficiale di Python, [`venv`](https://docs.python.org/3/library/venv.html#module-venv).

Innanzitutto, crea la cartella che ospiterà l'applicazione in questione, come ad esempio una cartella di nome *transformer-course* alla radice della tua home directory:

```
mkdir ~/transformer-course
cd ~/transformer-course
```

All'interno di questa cartella, crea un ambiente virtuale utilizzando il modulo `venv` di Python:

```
python -m venv .env
```

A questo punto, dovresti avere una cartella chiamata *.env* in quella che era la tua cartella vuota:

```
ls -a
```

```out
.      ..    .env
```

Puoi entrare e uscire dall'ambiente virtuale utilizzando gli script `activate` e `deactivate`:

```
# Activate the virtual environment
source .env/bin/activate

# Deactivate the virtual environment
deactivate
```

Assicurati che l'ambiente sia configurato correttamente eseguendo il comando `which python`: se come risposta ottieni l'ambiente virtuale, significa che l'hai attivato bene!

```
which python
```

```out
/home/<user>/transformer-course/.env/bin/python
```

### Installazione dipendenze

Come già menzionato nella sezione su Google Colab, il passo successivo consiste nell'installazione dei pacchetti richiesti dal corso. Ancora una volta, ti chiediamo di installare la versione per sviluppatori degli 🤗 Transformers utilizzando il gestore di pacchetti `pip`:

```
pip install "transformers[sentencepiece]"
```

Abbiamo finito con le installazioni! Ora sei pronto/a a iniziare.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter0/1.mdx" />