# Introduzione

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

Come si è visto nel [Capitolo 1](/course/chapter1),  I modelli Transformers sono solitamente molto grandi.
Con milioni o decine di *miliardi* di parametri, l'addestramento e la distribuzione di questi modelli è un'impresa complicata.
Inoltre, con i nuovi modelli che vengono rilasciati quasi ogni giorno e ognuno dei quali ha una propria implementazione, provarli tutti non è un lavoro facile.

La libreria 🤗 Transformers è stata creata per risolvere questo problema. Il suo obiettivo è fornire un'unica API attraverso la quale caricare, addestrare e salvare qualsiasi modello Transformer. Le caratteristiche principali della libreria sono:

- **Facilità d'uso**: È possibile scaricare, caricare ed utilizzare un modello NLP all'avanguardia per fare inferenza con appena due righe di codice.
- **Flessibilità**: Al loro interno, tutti i modelli sono semplici classi PyTorch `nn.Module` o TensorFlow `tf.keras.Model` e possono essere gestiti come qualsiasi altro modello nei rispettivi framework di apprendimento automatico (ML).
- **Semplicità**: La libreria non contiene quasi nessuna astrazione. Il concetto di "All in one file" è fondamentale: il forward pass di un modello è interamente definito in un singolo file, in modo che il codice stesso sia comprensibile e violabile.

Quest'ultima caratteristica rende 🤗 Transformers molto diversi da altre librerie ML. I modelli non sono costruiti su moduli condivisi tra i file, ma ogni modello ha i propri layers. Oltre a rendere i modelli più accessibili e comprensibili, questo permette di sperimentare facilmente su un modello senza influenzare gli altri.

Questo capitolo inizierà con un esempio in cui usiamo un modello e un tokenizer insieme per replicare la funzione `pipeline()` introdotta nel [Capitolo 1](/course/chapter1). Successivamente, parleremo dell'API del modello: ci immergeremo nelle classi del modello e della configurazione e mostreremo come caricare un modello e come esso elabora gli input numerici per produrre previsioni.

Successivamente vedremo l'API del tokenizer, che è l'altro componente principale della funzione `pipeline()`. I tokenizer si occupano della prima e dell'ultima fase di elaborazione, gestendo la conversione da testo a input numerici per la rete neurale e la conversione di nuovo in testo quando è necessario. Infine, mostreremo come gestire l'invio di più frasi a un modello in un batch preparato, per poi concludere il tutto con un'analisi più approfondita della funzione di alto livello `tokenizer()`.

<Tip>
⚠️ Per poter usufruire di tutte le funzioni disponibili con il Model Hub e i 🤗 Transformers, si consiglia di <a href="https://huggingface.co/join">creare un account</a>.
</Tip>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter2/1.mdx" />