# Usare modelli pre-addestrati

{#if fw === 'pt'}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/it/chapter4/section2_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/it/chapter4/section2_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/it/chapter4/section2_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/it/chapter4/section2_tf.ipynb"},
]} />

{/if}

Usando l'Hub diventa molto facile selzionare il modello appropriato, così da poterlo usare in qualsiasi altro framework con solo poche righe di codice. Vediamo ora come usare un di questi modelli, e come contribuire allo sviluppo della comunità.

Ad esempio assumiamo di stare cercando un modello francese sviluppato per ricostruire token mancanti (mask filling).

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/camembert.gif" alt="Selecting the Camembert model." width="80%"/>
</div>

Selezioniamo il checkpoint `camembert-base` per provarlo. L'identificatore `camembert-base` è tutto quello che serve per inizializzarlo! Come si è visto in precedenti capitoli, è possibile istanziare il modello usando la funzione `pipeline()`:

```py
from transformers import pipeline

camembert_fill_mask = pipeline("fill-mask", model="camembert-base")
results = camembert_fill_mask("Le camembert est <mask> :)")
```

```python out
[
  {'sequence': 'Le camembert est délicieux :)', 'score': 0.49091005325317383, 'token': 7200, 'token_str': 'délicieux'}, 
  {'sequence': 'Le camembert est excellent :)', 'score': 0.1055697426199913, 'token': 2183, 'token_str': 'excellent'}, 
  {'sequence': 'Le camembert est succulent :)', 'score': 0.03453313186764717, 'token': 26202, 'token_str': 'succulent'}, 
  {'sequence': 'Le camembert est meilleur :)', 'score': 0.0330314114689827, 'token': 528, 'token_str': 'meilleur'}, 
  {'sequence': 'Le camembert est parfait :)', 'score': 0.03007650189101696, 'token': 1654, 'token_str': 'parfait'}
]
```

Come potete vedere, caricare un modello all'interno di una pipeline è molto semplice. L'unico elemento da tenere in considerazione è che il checkpoint scelto sia adatto all'utilizzo che intendete farne. Ad esempio, noi abbiamo caricato il checkpoint `camembert-base` all'interno del pipeline `fill-mask`, che è corretto. Ma se dovessimo caricare questo checkpoint in un pipeline di classificazione del testo (`text-classification`), i risultati non avrebbero senso perché l'head di `camembert-base` non è adatto per questo obiettivo! Si consiglia di usare il filtro per obiettivi nell'interfaccia dell'Hub di Hugging Face per selezionare il checkpoint appropriato:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/tasks.png" alt="The task selector on the web interface." width="80%"/>
</div>

Potete anche istanziare il checkpoint usando direttamente l'architettura del modello:

{#if fw === 'pt'}
```py
from transformers import CamembertTokenizer, CamembertForMaskedLM

tokenizer = CamembertTokenizer.from_pretrained("camembert-base")
model = CamembertForMaskedLM.from_pretrained("camembert-base")
```

Tuttavia, noi consigliamo di usare le [classi `Auto*`](https://huggingface.co/transformers/model_doc/auto.html?highlight=auto#auto-classes) quando possibile, poiché sono progettate per essere agnostiche rispetto al tipo di architettura del modello. Mentre il codice di esempio precedente limita gli utenti a caricare i checkpoint supportati dall'architettura CamemBERT, usare le classi `Auto*` rende facile il passaggio da un checkpoint ad un altro:

```py
from transformers import AutoTokenizer, AutoModelForMaskedLM

tokenizer = AutoTokenizer.from_pretrained("camembert-base")
model = AutoModelForMaskedLM.from_pretrained("camembert-base")
```
{:else}
```py
from transformers import CamembertTokenizer, TFCamembertForMaskedLM

tokenizer = CamembertTokenizer.from_pretrained("camembert-base")
model = TFCamembertForMaskedLM.from_pretrained("camembert-base")
```

Tuttavia, noi consigliamo di usare le [classi `TFAuto*`](https://huggingface.co/transformers/model_doc/auto.html?highlight=auto#auto-classes) quando possibile, poiché sono progettate per essere agnostiche rispetto al tipo di architettura del modello. Mentre il codice di esempio precedente limita gli utenti a caricare i checkpoint supportati dall'architettura CamemBERT, usare le classi `TFAuto*` rende facile il passaggio da un checkpoint ad un altro:

```py
from transformers import AutoTokenizer, TFAutoModelForMaskedLM

tokenizer = AutoTokenizer.from_pretrained("camembert-base")
model = TFAutoModelForMaskedLM.from_pretrained("camembert-base")
```
{/if}

<Tip>
Quando usate un modello pre-addestrato, assicuratevi di controllare come è stato addestrato, su quali dataset, i suoi limiti e i suoi bias. Tutte queste informazioni dovrebbero essere indicate sul cartellino del modello.
</Tip>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter4/2.mdx" />