# Introduzione a Gradio

<CourseFloatingBanner
    chapter={9}
    classNames="absolute z-10 right-0 top-0"
/>

In questo capitolo scopriremo come creare delle **demo interattive** per i tuoi modelli di machine learning.

Perché costruire una demo o una GUI per il tuo modello di machine learning? Le demo permettono:

- agli **sviluppatori di machine learning** di presentare facilmente il proprio lavoro ad un pubblico più ampio, tra cui i team non tecnici o i clienti
- ai **ricercatori** di riprodurre più facilmente i modelli di machine learning e i loro comportamenti 
- ai **quality tester** o **utenti finali**  per individuare e fare il debug dei difetti dei modelli con maggiore facilità
- a **utenti vari** per scoprire i bias degli algoritmi nei modelli

Utilizzeremo la libreria Gradio per costruire le demo dei nostri modelli. Gradio consente di creare, personalizzare e condividere demo sul web per qualsiasi modello di machine learning, interamente in Python.

Ecco alcuni esempi di demo di machine learning costruite con Gradio:

* Un modello di **riconoscimento di disegni** che riceve uno schizzo di un disegno e restituisce il nome di ciò che pensa sia stato disegnato:

<iframe src="https://course-demos-draw2.hf.space" frameBorder="0" height="450" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

* Un modello che estrae **risposte alle domande** che prende in considerazione un contesto e una domanda e produce una risposta e la sua probabilità (abbiamo discusso questo tipo di modello [nel capitolo 7](/course/chapter7/7)):

<iframe src="https://course-demos-question-answering-simple.hf.space" frameBorder="0" height="640" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

* Un modello di **rimozione dello sfondo** che riceve un'immagine e la restituisce con lo sfondo rimosso:

<iframe src="https://course-demos-remove-bg-original.hf.space" frameBorder="0" height="640" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Questo capitolo è suddiviso in sezioni che comprendono sia _concetti_ che _applicazioni_. Dopo aver appreso il concetto in ogni sezione, lo applicherai per creare un particolare tipo di demo, dalla classificazione delle immagini al riconoscimento vocale. Al termine di questo capitolo, sarete in grado di creare queste demo (e molte altre!) con poche righe di Python.

<Tip>
👀 Dai un'occhiata a <a href="https://huggingface.co/spaces" target="_blank">Hugging Face Spaces</a> per vedere molti esempi recenti di demo di machine learning costruite dalla community!
</Tip>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter9/1.mdx" />