# Transformersの仕組みについて

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

このセクションでは、Transformerモデルのアーキテクチャをざっくりと見ていきます。

## Transformerの歴史を簡単に

Transformerモデルの（短い）歴史の中で、参考となるポイントをいくつか紹介します。

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_chrono.svg" alt="A brief chronology of Transformers models.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_chrono-dark.svg" alt="A brief chronology of Transformers models.">
</div>

[Transformerのアーキテクチャ](https://arxiv.org/abs/1706.03762)は2017年6月に登場しました。 当初の研究は翻訳タスクに焦点を置いていましたが、これに続くようにして以下のような影響力のあるモデルがいくつか登場します。

- **2018/6** [GPT](https://cdn.openai.com/research-covers/language-unsupervised/language_understanding_paper.pdf): 様々な自然言語処理タスクに対してfine-tuningすることでSoTAを達成した、史上初の事前学習済みモデルです。

- **2018/10** [BERT](https://arxiv.org/abs/1810.04805): これも大規模な事前学習済みモデルで、文についてのより良い要約を生成するように設計されています。（こちらについては次の章で詳しく説明します！）

- **2019/2** [GPT-2](https://cdn.openai.com/better-language-models/language_models_are_unsupervised_multitask_learners.pdf): これはGPTを改良 & 大規模化したものですが、倫理的な問題から一般公開までには時間がかかったモデルです。

- **2019/10** [DistilBERT](https://arxiv.org/abs/1910.01108): これはBERTを60%高速化し40%のメモリ軽量化をしながら、97%の性能を維持した蒸留モデルです。

- **2019/10** [BART](https://arxiv.org/abs/1910.13461), [T5](https://arxiv.org/abs/1910.10683): オリジナルのTransformerモデルと同じアーキテクチャを採用した大規模な事前学習済みモデルです。

- **2020/5** [GPT-3](https://arxiv.org/abs/2005.14165): GPT-2をさらに大規模化したもので、fine-tuningなし（_zero-shot学習_）で様々なタスクを解くことができるようにしたモデルです。

このリストは決して包括的なものではなく、Transformerのモデルの種類をざっくり分けることを意図しています。種類については大きく以下の3つのカテゴリーに分類することができます。

- GPT型 (_auto-regressive_ Transformerモデルとも呼ばれます)
- BERT型 (_auto-encoding_ Transformerモデルとも呼ばれます) 
- BART/T5型 (_sequence-to-sequence_ Transformerモデルとも呼ばれます)

これらの種類についてこれから深掘りしていきます。

## Transformers = 言語モデル

GPT、BERT、T5などの上記の全てのモデルは*言語モデル*として学習されています。これは大量の生文に対して自己教師あり学習を行ったことを意味しています。自己教師あり学習は、学習の目的となるものを、モデルに入力するデータから自動で算出する学習方法です。つまりデータに対する人手のラベル付が必要ないことを意味します。

このタイプのモデルは、学習させた言語に対する統計的な理解を深めることができますが、特定のタスクにはあまり役に立ちません。従って、一般的な事前学習済みモデルは、この後に*転移学習*と呼ばれるプロセスを経ます。このプロセスでは人手でラベル付されたデータを用いた教師あり学習を行なって、特定のタスクに対してfine-tuningされます。

タスク例の1つに、前のいくつかの単語を読んで、それに続く次の単語を予測するものがあります。これは出力が過去と現在の入力にのみ依存し、将来の入力には依存しないため、 *Causal Language Modeling (CLM)* と呼ばれます。

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/causal_modeling.svg" alt="Example of causal language modeling in which the next word from a sentence is predicted.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/causal_modeling-dark.svg" alt="Example of causal language modeling in which the next word from a sentence is predicted.">
</div>

他の例としては *Masked Language Modeling (MLM)* があり、これは文中のマスクされた（隠された）単語が何かを予測するタスクになっています。

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/masked_modeling.svg" alt="Example of masked language modeling in which a masked word from a sentence is predicted.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/masked_modeling-dark.svg" alt="Example of masked language modeling in which a masked word from a sentence is predicted.">
</div>

## Transformers = 大規模モデル

前述のDistilBERTなどの例外を除けば、より良いパフォーマンスを達成するための一般的な戦略として、モデルサイズと学習データ量を大きくするというものがあります。

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/model_parameters.png" alt="Number of parameters of recent Transformers models" width="90%">
</div>

残念ながらモデルの学習（特に大規模なモデルの学習）には大量のデータが必要になります。これは時間と計算資源の面で非常にコストがかかります。また、以下のグラフから分かるように、環境にも影響を及ぼすものになります。

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/carbon_footprint.svg" alt="The carbon footprint of a large language model.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/carbon_footprint-dark.svg" alt="The carbon footprint of a large language model.">
</div>

<Youtube id="ftWlj4FBHTg"/>

そしてこの図は、事前学習の環境負荷を意識的に減らすことを目的とするチームが率いる、（超大規模）モデルのプロジェクトを示しています。最適なハイパーパラメータを得るための多くの試行による環境負荷は、より大きなものになると考えられます。

もし研究チームや学生団体、企業がその度にモデルを一から学習していたらどうでしょうか。これでは膨大で不必要なコストがかかってしまいます。

従って、学習済み言語モデルの重みを共有しそれを利用することで、コミュニティ全体の計算コストや環境負荷を削減することができるのです。

## 転移学習

<Youtube id="BqqfQnyjmgg" />

*事前学習*とはモデルを一から学習することです。重みはランダムに初期化され、事前知識なしに学習が開始されます。

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/pretraining.svg" alt="The pretraining of a language model is costly in both time and money.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/pretraining-dark.svg" alt="The pretraining of a language model is costly in both time and money.">
</div>

事前学習は大量のデータを使って行われます。よって、非常に大きなデータコーパスを必要とし、学習には数週間かかることがあります。

一方で*ファインチューニング*は事前学習の**後に**行われるものです。ファインチューニングを行うには、まず最初に事前学習済みモデルを取得し、次にタスクに応じたデータセットを用いて追加の学習を行います。ここで、「（事前学習を行わずに）初めからこのタスクに対して学習を行えば良いのでは？」と思った方がいるかもしれませんが、これにはいくつかの理由があります。

*  事前学習済みモデルは、ファインチューニング用のデータセットと何らかの類似性を持ったデータで既に学習が行われています。このため、ファインチューニングの過程において、事前学習済みモデルが既に獲得した知識を利用することができます。（例えば自然言語処理の問題では、事前学習済みのモデルは言語に対する何らかの統計的な理解をしているはずです。）
*  また事前学習済みモデルは大量のデータを使って学習されているので、ファインチューニングでははるかに少ないデータで適切な結果を得ることが可能になります。
*  これと同じ理由で、良い結果を得るために必要な時間や資源を大きく削減することができます。

例えば、英語で訓練された事前学習済みモデルをarXivコーパスでファインチューニングすることで、科学/研究ベースのモデルを作ることができます。ファインチューニングは少ないデータで実施できます。これは事前学習済みモデルが獲得していた知識が「転移」しているためで、この特徴から「*転移学習*」と呼ばれているという訳です。

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/finetuning.svg" alt="The fine-tuning of a language model is cheaper than pretraining in both time and money.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/finetuning-dark.svg" alt="The fine-tuning of a language model is cheaper than pretraining in both time and money.">
</div>

従って、モデルのファインチューニングに必要な時間、データ、経済的/環境的コストは少なく済みます。また事前学習よりも制約が少ないため、様々なファインチューニングのスキームを素早く簡単に試すことができます。

このプロセスは（大量のデータがある場合を除いて）ゼロから学習するよりも良い結果をもたらします。だからこそ（目的のタスクにできるだけ近い）事前学習済みモデルを活用し、それをファインチューニングするべきだと言えます。

## 一般的なアーキテクチャ

このセクションでは、Transformerモデルの一般的なアーキテクチャについて見ていきます。各構成要素については後ほど詳しく説明するので、理解できない部分があっても心配ありません！

<Youtube id="H39Z_720T5s" />

## イントロダクション

モデルは主に2つの要素で構成されます。

* **エンコーダー （左）**: エンコーダーは入力を受け取り、その特徴量を生成します。これは入力から理解を得るためにモデルが最適化されることを意味します。
* **デコーダー　（右）**: デコーダーではエンコーダーが生成した特徴量とその他の入力を受け取って、目的の系列を生成します。これは出力を生成するためにモデルが最適化されることを意味します。

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_blocks.svg" alt="Architecture of a Transformers models">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_blocks-dark.svg" alt="Architecture of a Transformers models">
</div>

これらの構成要素はタスクに応じてそれぞれ別々に使用することができます。

* **Encoder-only モデル**: 文章分類や固有表現抽出など入力に対する理解が必要となるタスクに適しています。
* **Decoder-only モデル**: 文生成などの生成タスクに適しています。
* **Encoder-Decoder(sequence-to-sequence) モデル**: 翻訳や要約など、入力を要する生成タスクに適しています。

これらのアーキテクチャについてはのちのセクションで個別に紹介します。


## アテンション層

Transformerモデルは*アテンション層*と呼ばれる特殊な層で構築されていることが大きな特徴となっています。実際にTransformerが登場した論文のタイトルも["Attention Is All You Need"](https://arxiv.org/abs/1706.03762)というものでした！ アテンション層については後ほど詳しく説明します。現段階においては、モデルが各単語の特徴量を扱う際に、入力されたテキストのどの単語に注目すべきかをアテンション層が指示してくれる（多かれ少なかれその他の単語は無視される）ということだけ知っておいてもらえれば十分です。

このことを理解するために、英語からフランス語への翻訳タスクを考えてみます。"You like this course" という入力があるとき、翻訳モデルは "like" という単語を適切に翻訳するために "You" という隣接する単語に注目する必要があります。これはフランス語の動詞 "like" は主語によって異なる活用がされるためです。ただこのとき、"like" の翻訳に他の単語の情報は役に立ちません。同じように、モデルは "this" という単語を翻訳する際に "course" という単語に注意を払う必要があり、これは "this" という単語の翻訳が関連する名詞が男性か女性かによって変化するためです。この場合においてもその他の単語は "this" の翻訳には関係ありません。より複雑な文（および文法規則）では、モデルは各単語を適切に翻訳するために、文中のより離れた位置に出現する可能性のある単語に対して特別な注意を払う必要があります。

単語はそれ自体で意味を持ちますが、その意味は文脈（前後に現れるその他の単語）に大きな影響を受けます。このため、翻訳タスクと同じ考え方が自然言語に関する色々なタスクに対して当てはまります。

さて、アテンション層がどのようなものかを理解頂いた上で、Transformerのアーキテクチャをより詳しく見ていきましょう！

## オリジナルのアーキテクチャ

Transformerのアーキテクチャは翻訳用に設計されました。学習過程において、エンコーダーはある言語の入力（文章）を受け取り、デコーダーは別言語で書かれた同じ文章を受け取ります。エンコーダーのアテンション層は文中の全ての単語を使うことができます。（先ほど見たように、、ある単語を翻訳するためにはその前後の単語に注意を払う必要があるためです。）一方でデコーダーは逐次的に動作します。このため既に翻訳して生成した単語にしか注意を向けることができません。（言い換えればこれから翻訳して生成される単語に対しては注意が張られないということです。）例えば、翻訳対象の最初の3単語を予測したらそれをデコーダーに渡すことで、デコーダーはエンコーダーに入力された情報を全て使いながら4単語目を予測します。

モデルの学習中、学習速度を上げるためにデコーダーには答えとなる翻訳文（ターゲット文）全体が与えられていますが、処理対象となる単語の後に続く単語を使うことは許されていません。例えば、4番目の単語を予測する際、アテンション層はターゲット文の1〜3番目の位置にある単語にしかアクセスすることができません。

Transformerのオリジナルのアーキテクチャの概観は、このように左側のエンコーダーと右側のデコーダーからなります。

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers.svg" alt="Architecture of a Transformers models">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers-dark.svg" alt="Architecture of a Transformers models">
</div>

デコーダーブロックの最初のアテンション層は、デコーダーに対する全ての入力を使うことができますが、2番目のアテンション層はエンコーダーの出力を利用します。従って、入力文全体にアクセスすることで現在の単語の最適な予測が可能になるという訳です。これは言語によって単語の登場順が異なるような文法規則があったり、文の後半で提供される文脈情報が、現在の単語の翻訳に役立つ場合があるので、非常に便利なものとなっています。

*attentionマスク*はエンコーダー・デコーダーで、ある特別な単語に注目しないようにするために使用されます。（例えば、文をまとめて入力するときに、全ての文を同じ長さに揃えるために使われるpadding tokenなどです。）

##  アーキテクチャ vs. チェックポイント

このコースでTransformerモデルについて掘り下げていくと、*モデル*と同様に*アーキテクチャ*や*チェックポイント*という単語についても言及されていることがわかります。これらの用語はそれぞれ少しずつ異なる意味を持っています。


* **アーキテクチャ**: これはモデルの骨格を意味し、モデル内の各層と内部で起こる操作を定義したものになります。
* **チェックポイント**: これは与えられたアーキテクチャに対して読み込まれる重みを意味します。
* **モデル**: これは「アーキテクチャ」や「チェックポイント」ほど正確ではない、より包括的な用語で両方を意味することがあります。このコースでは曖昧さを回避するために、重要な場合は*アーキテクチャ*や*チェックポイント*を使うことにします。

例えばBERTはアーキテクチャを指し、`bert-base-cased`はGoogleの開発チームがBERTの最初のリリースのために用意した重みを指したチェックポイントとなります。しかしながら"BERTモデル"や"`bert-base-cased`モデル"と呼ぶこともできます。


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ja/chapter1/4.mdx" />