# バイアスと限界

<CourseFloatingBanner chapter={1}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter1/section8.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter1/section8.ipynb"},
]} />

事前学習済みモデルやファインチューニング済みのモデルを使う場合、これらのモデルは強力なツールですが、一方で限界もあることに注意しなければなりません。
その代表例は、大量のデータによる事前学習を行うために、研究者はインターネット上にある利用可能なデータを良いものから悪いものまで手当たりしだいに集めてしまうことです。

簡単に説明するために、BERTによる`fill-mask`パイプラインの例に戻りましょう:


```python
from transformers import pipeline

unmasker = pipeline("fill-mask", model="bert-base-uncased")
result = unmasker("This man works as a [MASK].")
print([r["token_str"] for r in result])

result = unmasker("This woman works as a [MASK].")
print([r["token_str"] for r in result])
```

```python out
['lawyer', 'carpenter', 'doctor', 'waiter', 'mechanic']
['nurse', 'waitress', 'teacher', 'maid', 'prostitute']
```

これらの２つの文の欠落した単語を埋めさせたときに、モデルはジェンダーフリーの回答を一つだけしか与えません(waiter/waitress)。他はたいていの場合、特定の性別と関連付けられる職業です。そして、モデルは「女性」と「仕事」から連想される可能性のある職業としてトップ５に「売春婦（prostitute）」を上げています。
BERTはインターネット上のあらゆるところからデータをかき集めて構築されたのではなく、中立的なデータ([English Wikipedia](https://huggingface.co/datasets/wikipedia)と[BookCorpus](https://huggingface.co/datasets/bookcorpus)を用いて学習されています) を用いて構築されためずらしいTransformerモデルであるにも関わらず、このような現象が発生してしまいます。

したがって、これらのツールを使用する際は、オリジナルのモデルがとても簡単に性的、差別的、あるいは同性愛嫌悪のコンテンツを生成してしまうことを念頭に置く必要があります。この本質的なバイアスは、あるデータでファインチューニングしても消えることはありません。

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ja/chapter1/8.mdx" />