# 학습 곡선 이해하기[[understanding-learning-curves]]

<CourseFloatingBanner chapter={3}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section7.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section7.ipynb"},
]} />

이제 `Trainer` API와 사용자 정의 훈련 루프를 모두 사용하여 미세 조정을 구현하는 방법을 배웠으므로, 결과를 해석하는 방법을 이해하는 것이 중요합니다. 학습 곡선은 훈련 중 모델의 성능을 평가하고 성능 저하를 일으킬 수 있는 잠재적 문제를 미리 식별하는 데 도움이 되는 매우 유용한 도구입니다.

이 섹션에서는 정확도와 손실 곡선을 읽고 해석하는 방법을 탐구하고, 다양한 곡선 패턴이 모델 동작에 대해 무엇을 의미하는지 파악하며, 일반적인 훈련 문제를 해결하는 방법을 배웁니다.

## 학습 곡선이란 무엇인가요?[[what-are-learning-curves]]

학습 곡선은 훈련 중에 시간에 따른 모델의 성능 지표를 시각적으로 나타낸 것입니다. 모니터링해야 할 가장 중요한 두 곡선은 다음과 같습니다.

- **손실 곡선**: 훈련 단계나 에폭에 따라 모델의 오류(손실)가 어떻게 변하는지 보여줍니다.
- **정확도 곡선**: 훈련 단계나 에폭에 따른 정확한 예측의 백분율을 보여줍니다.

이러한 곡선을 통해 모델의 학습 효과를 파악하고, 성능 향상을 위한 조정 방향을 제시할 수 있습니다. Transformers에서는 이러한 지표가 각 배치에 대해 개별적으로 계산된 다음 디스크에 기록됩니다. 그런 다음 [Weights & Biases](https://wandb.ai/)와 같은 라이브러리를 사용하여 이러한 곡선을 시각화하고 시간에 따른 모델의 성능을 추적할 수 있습니다.

### 손실 곡선[[loss-curves]]

손실 곡선은 시간에 따라 모델의 오류가 어떻게 감소하는지 보여줍니다. 성공적인 훈련에서는 보통 다음과 같은 곡선 패턴을 관찰할 수 있습니다.

![Loss Curve](https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter3/1.png)

- **높은 초기 손실**: 모델이 최적화 없이 시작하므로 초기 예측이 좋지 않습니다.
- **감소하는 손실**: 훈련이 진행됨에 따라 손실이 일반적으로 감소해야 합니다.
- **수렴**: 최종적으로 손실이 낮은 수준에서 안정되면서 모델이 데이터 패턴을 성공적으로 학습했음을 보여줍니다.

이전 챕터에서와 같이 `Trainer` API를 사용하여 이러한 지표를 추적하고 대시보드에서 시각화할 수 있습니다. 다음은 Weights & Biases로 이를 수행하는 예시입니다.

```python
# Trainer로 훈련 중 손실을 추적하는 예시
from transformers import Trainer, TrainingArguments
import wandb

# 실험 추적을 위해 Weights & Biases 초기화
wandb.init(project="transformer-fine-tuning", name="bert-mrpc-analysis")

training_args = TrainingArguments(
    output_dir="./results",
    eval_strategy="steps",
    eval_steps=50,
    save_steps=100,
    logging_steps=10,  # 10단계마다 지표 로그
    num_train_epochs=3,
    per_device_train_batch_size=16,
    per_device_eval_batch_size=16,
    report_to="wandb",  # Weights & Biases로 로그 전송
)

trainer = Trainer(
    model=model,
    args=training_args,
    train_dataset=tokenized_datasets["train"],
    eval_dataset=tokenized_datasets["validation"],
    data_collator=data_collator,
    processing_class=tokenizer,
    compute_metrics=compute_metrics,
)

# 훈련 및 자동 지표 로그
trainer.train()
```

### 정확도 곡선[[accuracy-curves]]

정확도 곡선은 시간에 따른 정확한 예측의 백분율을 보여줍니다. 손실 곡선과 달리 정확도 곡선은 모델이 학습함에 따라 일반적으로 증가해야 하며, 손실 곡선보다 더 많은 단계를 포함할 수 있습니다.

![Accuracy Curve](https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter3/2.png)

- **낮게 시작**: 모델이 아직 데이터의 패턴을 학습하지 않았으므로 초기 정확도는 낮아야 합니다.
- **훈련과 함께 증가**: 모델이 데이터의 패턴을 학습할 수 있다면 학습함에 따라 정확도가 일반적으로 향상되어야 합니다.
- **고원 현상을 보일 수 있음**: 모델이 실제 레이블에 가까운 예측을 만들어내므로, 정확도는 부드럽게 상승하기보다는 계단식으로 점프하는 경우가 많습니다. 

<Tip>

💡 **정확도 곡선이 "계단식"인 이유**: 연속적인 손실과 달리 정확도는 이산적인 예측을 실제 레이블과 비교하여 계산됩니다. 모델 신뢰도의 작은 개선은 최종 예측을 변경하지 않을 수 있어서 임계값을 넘을 때까지 정확도가 평평하게 유지됩니다.

</Tip>

### 수렴[[convergence]]

수렴은 모델의 성능이 안정화되고 손실 및 정확도 곡선이 평평해질 때 발생합니다. 이는 모델이 데이터의 패턴을 학습했으며 사용할 준비가 되었다는 신호입니다. 간단히 말해서, 우리는 모델을 훈련할 때마다 안정적인 성능으로 수렴하는 것을 목표로 합니다.

![Convergence](https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter3/4.png)

모델이 수렴하면 새로운 데이터에 대한 예측을 만들고 평가 지표를 참조하여 모델의 성능을 이해할 수 있습니다.

## 학습 곡선 패턴 해석하기[[interpreting-learning-curve-patterns]]

곡선의 다양한 패턴은 모델 훈련의 여러 측면을 보여줍니다. 가장 일반적인 패턴과 그 의미를 살펴보겠습니다.

### 건전한 학습 곡선[[healthy-learning-curves]]

잘 작동하는 훈련 실행은 일반적으로 아래와 같은 곡선 모양을 보여줍니다.

![Healthy Loss Curve](https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter3/5.png)

위의 그림은 손실 곡선(왼쪽)과 해당 정확도 곡선(오른쪽)을 함께 보여줍니다. 두 곡선은 뚜렷한 특성을 가지고 있습니다.

손실 곡선은 시간에 따른 모델 손실의 값을 보여줍니다. 처음에는 손실이 높다가 점차 감소하여 모델이 개선되고 있음을 나타냅니다. 손실 값의 감소는 손실이 예측된 출력과 실제 출력 간의 오류를 나타내므로 모델이 더 나은 예측을 하고 있음을 시사합니다.

다음으로 정확도 곡선을 살펴보겠습니다. 이는 시간에 따른 모델의 정확도를 나타냅니다. 정확도 곡선은 낮은 값에서 시작하여 훈련이 진행됨에 따라 증가합니다. 정확도는 올바르게 분류된 인스턴스의 비율을 측정합니다. 따라서 정확도 곡선이 상승함에 따라 모델이 더 정확한 예측을 하고 있음을 의미합니다.

곡선 간의 주목할 만한 차이점 중 하나는 정확도 곡선의 부드러움과 "고원"의 존재입니다. 손실이 부드럽게 감소하는 동안 정확도 곡선의 고원은 연속적인 증가 대신 정확도의 이산적인 점프를 나타냅니다. 이러한 현상은 정확도 측정 방식의 특성 때문입니다. 최종 예측이 여전히 틀렸더라도 모델의 출력이 목표에 가까워지면 손실이 개선될 수 있습니다. 그러나 정확도는 예측이 정확한 임계값을 넘어야만 향상됩니다.

예를 들어, 고양이(0)와 개(1)를 구별하는 이진 분류기에서 모델이 개 이미지(실제 값 1)에 대해 0.3을 예측하면 이는 0으로 반올림되어 잘못된 분류입니다. 다음 단계에서 0.4를 예측하면 여전히 틀렸습니다. 0.4가 0.3보다 1에 더 가깝기 때문에 손실은 감소했지만 정확도는 변하지 않아 고원을 만듭니다. 정확도는 모델이 0.5보다 큰 값을 예측하여 1로 반올림될 때만 점프합니다.

<Tip>

**건전한 곡선의 특성**
- **손실의 부드러운 감소**: 훈련 및 검증 손실이 모두 꾸준히 감소
- **훈련/검증 성능이 근접**: 훈련 및 검증 지표 간의 작은 격차
- **수렴**: 곡선이 평평해져서 모델이 패턴을 학습했음을 나타냄

</Tip>

### 실용적인 예시[[practical-examples]]

학습 곡선의 몇 가지 실용적인 예시를 살펴보겠습니다. 먼저 훈련 중 학습 곡선을 모니터링하는 몇 가지 접근 방식을 강조하겠습니다. 아래에서는 학습 곡선에서 관찰할 수 있는 다양한 패턴을 살펴보겠습니다.

#### 훈련 중[[during-training]]

훈련 과정 중(`trainer.train()`을 실행한 후) 다음과 같은 주요 지표를 모니터링할 수 있습니다.

1. **손실 수렴**: 손실이 여전히 감소하고 있는가, 아니면 고원에 도달했는가?
2. **과적합 신호**: 훈련 손실은 감소하는 동안 검증 손실이 증가하기 시작하는가?
3. **학습률**: 곡선이 너무 불안정한가(LR이 너무 높음) 아니면 너무 평평한가(LR이 너무 낮음)?
4. **안정성**: 문제를 나타내는 급격한 스파이크나 드롭이 있는가?

#### 훈련 후[[after-training]]

훈련 과정이 완료된 후 전체 곡선을 분석하여 모델의 성능을 이해할 수 있습니다.

1. **최종 성능**: 모델이 허용 가능한 성능 수준에 도달했는가?
2. **효율성**: 더 적은 에폭으로 동일한 성능을 달성할 수 있었는가?
3. **일반화**: 훈련과 검증 성능이 얼마나 가까운가?
4. **경향**: 추가 훈련이 성능을 향상시킬 가능성이 있는가?

<Tip>

🔍 **W&B 대시보드 기능**: Weights & Biases를 사용하면 학습 곡선을 보기 좋고 상호작용 가능한 그래프로 자동으로 만들 수 있습니다.
- 여러 실행을 나란히 비교
- 사용자 정의 지표 및 시각화 추가
- 이상 동작에 대한 알림 설정
- 팀과 결과 공유

[Weights & Biases 문서](https://docs.wandb.ai/)에서 자세히 알아보세요.
</Tip>

#### 과적합[[overfitting]]

과적합은 모델이 훈련 데이터에서 너무 많이 학습하여 다른 데이터(검증 세트로 표현됨)로 일반화할 수 없을 때 발생합니다.

![Overfitting](https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter3/10.png)

**증상**

- 훈련 손실은 계속 감소하지만 검증 손실은 증가하거나 고원에 머무름
- 훈련과 검증 정확도 간의 큰 격차
- 훈련 정확도가 검증 정확도보다 훨씬 높음

**과적합 해결책**
- **정규화**: 드롭아웃, 가중치 감쇠 또는 기타 정규화 기법 추가
- **조기 중단**: 검증 성능이 개선을 멈출 때 훈련 중단
- **데이터 증강**: 훈련 데이터 다양성 증가
- **모델 복잡도 감소**: 더 작은 모델이나 더 적은 매개변수 사용

아래 샘플에서는 과적합을 방지하기 위해 조기 중단을 사용합니다. `early_stopping_patience`를 3으로 설정하여 검증 손실이 3번의 연속적인 에폭 동안 개선되지 않으면 훈련이 중단됩니다.

```python
# 조기 중단으로 과적합을 감지하는 예시
from transformers import EarlyStoppingCallback

training_args = TrainingArguments(
    output_dir="./results",
    eval_strategy="steps",
    eval_steps=100,
    save_strategy="steps",
    save_steps=100,
    load_best_model_at_end=True,
    metric_for_best_model="eval_loss",
    greater_is_better=False,
    num_train_epochs=10,  # 높게 설정하지만 조기에 중단할 예정
)

# 과적합을 방지하기 위해 조기 중단 추가
trainer = Trainer(
    model=model,
    args=training_args,
    train_dataset=tokenized_datasets["train"],
    eval_dataset=tokenized_datasets["validation"],
    data_collator=data_collator,
    processing_class=tokenizer,
    compute_metrics=compute_metrics,
    callbacks=[EarlyStoppingCallback(early_stopping_patience=3)],
)
```

#### 2. 과소적합[[underfitting]]

과소적합은 모델이 데이터의 기본 패턴을 포착하기에는 너무 단순할 때 발생합니다. 이는 여러 가지 이유로 발생할 수 있습니다.

- 모델이 너무 작거나 패턴을 학습할 용량이 부족함
- 학습률이 너무 낮아서 학습이 느림
- 데이터 세트가 너무 작거나 문제를 대표하지 못함
- 모델이 제대로 정규화되지 않음

![Underfitting](https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter3/7.png)

**증상**
- 훈련 및 검증 손실이 모두 높게 유지됨
- 모델 성능이 훈련 초기에 고원에 도달
- 훈련 정확도가 예상보다 낮음

**과소적합 해결책**
- **모델 용량 증가**: 더 큰 모델이나 더 많은 매개변수 사용
- **더 오래 훈련**: 에폭 수 증가
- **학습률 조정**: 다른 학습률 시도
- **데이터 품질 확인**: 데이터가 적절히 전처리되었는지 확인

아래 샘플에서는 모델이 데이터의 패턴을 학습할 수 있는지 확인하기 위해 더 많은 에폭 동안 훈련합니다.

```python
from transformers import TrainingArguments

training_args = TrainingArguments(
    output_dir="./results",
    -num_train_epochs=5,
    +num_train_epochs=10,
)
```

#### 3. 불안정한 학습 곡선[[erratic-learning-curves]]

불안정한 학습 곡선은 모델이 효과적으로 학습하지 않을 때 발생합니다. 이는 여러 가지 이유로 발생할 수 있습니다.

- 학습률이 너무 높아서 모델이 최적 매개변수를 지나치게 됨
- 배치 크기가 너무 작아서 모델이 천천히 학습함
- 모델이 제대로 정규화되지 않아서 훈련 데이터에 과적합됨
- 데이터 세트가 제대로 전처리되지 않아서 모델이 노이즈에서 학습함

![Erratic Learning Curves](https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter3/3.png)

**증상**
- 손실이나 정확도에서 빈번한 변동
- 곡선이 높은 분산이나 불안정성을 보임
- 성능이 명확한 경향 없이 진동함

훈련과 검증 곡선 모두 불안정한 동작을 보입니다.

![Erratic Learning Curves](https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter3/9.png)

**불안정한 곡선의 해결책**
- **학습률 낮추기**: 더 안정적인 훈련을 위해 단계 크기 줄이기
- **배치 크기 증가**: 더 큰 배치가 더 안정적인 그레이디언트 제공
- **그레이디언트 클리핑**: 그레이디언트 폭발 방지
- **더 나은 데이터 전처리**: 일관된 데이터 품질 보장

아래 샘플에서는 학습률을 낮추고 배치 크기를 증가시킵니다.

```python
from transformers import TrainingArguments

training_args = TrainingArguments(
    output_dir="./results",
    -learning_rate=1e-5,
    +learning_rate=1e-4,
    -per_device_train_batch_size=16,
    +per_device_train_batch_size=32,
)
```

## 핵심 요점[[key-takeaways]]

학습 곡선을 이해하는 것은 효과적인 기계학습 전문가가 되기 위해 중요합니다. 이러한 시각적 도구는 모델의 훈련 진행 상황에 대한 즉각적인 피드백을 제공하고 언제 훈련을 중단하거나 하이퍼파라미터를 조정하거나 다른 접근 방식을 시도할지에 대한 정보에 기반한 결정을 내리는 데 도움이 됩니다. 연습을 통해 건전한 학습 곡선이 어떤 모습인지, 그리고 문제가 발생했을 때 어떻게 해결할지에 대한 직관적인 이해를 개발할 수 있습니다.

<Tip>

💡 **핵심 요점**
- 학습 곡선은 모델 훈련 진행 상황을 이해하는 데 필수적인 도구입니다.
- 손실과 정확도 곡선을 모두 모니터링하되, 서로 다른 특성을 가지고 있음을 기억하세요.
- 과적합은 훈련/검증 성능의 분기로 나타납니다.
- 과소적합은 훈련과 검증 데이터 모두에서 성능이 좋지 않은 것으로 나타납니다.
- Weights & Biases와 같은 도구는 학습 곡선을 쉽게 추적하고 분석할 수 있게 해줍니다.
- 조기 중단과 적절한 정규화는 대부분의 일반적인 훈련 문제를 해결할 수 있습니다.

🔬 **다음 단계**: 자신의 미세 조정 실험에서 학습 곡선을 분석해보세요. 다양한 하이퍼파라미터를 시도하고 곡선 모양에 어떤 영향을 미치는지 관찰하세요. 이러한 실습 경험이 훈련 진행 상황을 읽는 직관을 개발하는 가장 좋은 방법입니다.

</Tip>

## 섹션 퀴즈[[section-quiz]]

학습 곡선과 훈련 분석에 대한 이해를 테스트해보세요.

### 1. 훈련 손실은 감소하지만 검증 손실이 증가하기 시작할 때 일반적으로 무엇을 의미하나요?

<Question
	choices={[
		{
			text: "모델이 성공적으로 학습하고 있으며 계속 향상될 것입니다.",
			explain: "검증 손실이 증가하는 동안 훈련 손실이 감소한다면 이는 성공이 아니라 문제를 나타냅니다."
		},
		{
			text: "모델이 훈련 데이터에 과적합되고 있습니다.",
			explain: "정답입니다! 이는 과적합의 전형적인 신호입니다 - 모델이 훈련 데이터에서는 잘 수행하지만 보지 못한 검증 데이터에서는 성능이 떨어집니다.",
            correct: true
		},
		{
			text: "학습률이 너무 낮습니다.",
			explain: "낮은 학습률은 느린 학습을 야기하지만 훈련과 검증 성능 간의 분기는 아닙니다."
		},
        {
			text: "데이터 세트가 너무 작습니다.",
			explain: "작은 데이터 세트가 과적합에 기여할 수 있지만, 이 특정 패턴은 데이터 세트 크기에 관계없이 과적합의 정의입니다."
		}
	]}
/>

### 2. 정확도 곡선이 부드러운 증가보다는 "계단식" 또는 고원과 같은 패턴을 보이는 이유는 무엇인가요?

<Question
	choices={[
		{
			text: "정확도 계산에 오류가 있습니다.",
			explain: "계단식 패턴은 정상적이고 예상되는 것이며 오류가 아닙니다."
		},
		{
			text: "정확도는 예측이 결정 경계를 넘을 때만 변하는 이산적인 지표입니다.",
			explain: "정답입니다! 손실과 달리 정확도는 이산적인 예측 결정에 의존하므로 신뢰도의 작은 개선이 임계값을 넘을 때까지 최종 정확도를 변경하지 않을 수 있습니다.",
            correct: true
		},
		{
			text: "모델이 효과적으로 학습하지 않고 있습니다.",
			explain: "계단식 정확도 곡선은 모델이 잘 학습하고 있을 때도 정상입니다."
		},
        {
			text: "배치 크기가 너무 작습니다.",
			explain: "배치 크기는 훈련 안정성에 영향을 미치지만 정확도 지표의 본질적으로 이산적인 특성을 설명하지는 않습니다."
		}
	]}
/>

### 3. 불안정하고 심하게 변동하는 학습 곡선을 관찰할 때 가장 좋은 접근법은 무엇인가요?

<Question
	choices={[
		{
			text: "수렴을 가속화하기 위해 학습률을 증가시킵니다.",
			explain: "학습률을 증가시키면 변동이 더 심해질 가능성이 높습니다."
		},
		{
			text: "학습률을 낮추고 가능하면 배치 크기를 증가시킵니다.",
			explain: "정답입니다! 낮은 학습률과 큰 배치 크기는 일반적으로 더 안정적인 훈련으로 이어집니다.",
			correct: true
		},
		{
			text: "모델이 개선되지 않을 것이므로 즉시 훈련을 중단합니다.",
			explain: "불안정한 곡선은 종종 하이퍼파라미터 조정으로 수정할 수 있습니다."
		},
        {
			text: "완전히 다른 모델 아키텍처로 바꿉니다.",
			explain: "이는 성급합니다 - 불안정한 곡선은 보통 하이퍼파라미터 튜닝으로 수정 가능합니다."
		}
	]}
/>

### 4. 언제 조기 중단 사용을 고려해야 하나요?

<Question
	choices={[
		{
			text: "항상, 어떤 형태의 과적합도 방지하기 때문입니다.",
			explain: "조기 중단은 유용하지만 다른 정규화 방법이 작동하고 있다면 항상 필요한 것은 아닙니다."
		},
		{
			text: "검증 성능이 개선을 멈추거나 악화되기 시작할 때입니다.",
			explain: "정답입니다! 조기 중단은 모델이 더 이상 더 잘 일반화하지 않을 때 훈련을 중단하여 과적합을 방지하는 데 도움이 됩니다.",
            correct: true
		},
		{
			text: "훈련 손실이 여전히 빠르게 감소하고 있을 때만입니다.",
			explain: "훈련 손실이 빠르게 감소하고 검증 성능이 좋다면 훈련을 계속하고 싶을 수 있습니다."
		},
        {
			text: "절대로, 모델이 완전한 잠재력에 도달하는 것을 방해하기 때문입니다.",
			explain: "조기 중단은 과적합을 방지하여 최종 모델 성능을 향상시키는 경우가 많은 유용한 기법입니다."
		}
	]}
/>

### 5. 모델이 과소적합일 수 있음을 나타내는 것은 무엇인가요?

<Question
	choices={[
		{
			text: "훈련 정확도가 검증 정확도보다 훨씬 높습니다.",
			explain: "이는 과소적합이 아니라 과적합을 설명합니다."
		},
		{
			text: "훈련과 검증 성능이 모두 좋지 않고 조기에 고원에 도달합니다.",
			explain: "정답입니다! 과소적합은 모델이 패턴을 학습할 용량이 부족할 때 발생하여 훈련과 검증 데이터 모두에서 성능이 좋지 않습니다.",
            correct: true
		},
		{
			text: "학습 곡선이 변동 없이 매우 부드럽습니다.",
			explain: "부드러운 곡선은 일반적으로 좋은 것이며 과소적합을 나타내지 않습니다."
		},
        {
			text: "검증 손실이 훈련 손실보다 빠르게 감소합니다.",
			explain: "이는 실제로 긍정적인 신호이며 문제가 아닙니다."
		}
	]}
/>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ko/chapter3/5.mdx" />