# 좋은 이슈를 작성하는 법

<CourseFloatingBanner chapter={8}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter8/section5.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter8/section5.ipynb"},
]} />

Hugging Face 라이브러리 중에서 이상한 것을 발견하면 고칠 수 있도록 반드시 알려주셔야 합니다(해당 문제에 대해서는 모든 오픈 소스 라이브러리가 동일). 버그가 자신의 코드에 있는지 또는 라이브러리에 있는지 확실하지 않은 경우 가장 먼저 [포럼](https://discuss.huggingface.co/)에서 확인하세요. 커뮤니티에서 이를 파악하는 데 도움을 줄 것이며 Hugging Face 팀도 그곳에서 토론을 면밀히 관찰합니다.

<Youtube id="_PAli-V4wj0"/>

버그가 있다고 확신하는 경우 첫 번째 단계는 최소한의 재현 가능한 예제를 빌드하는 것입니다.

## 재현 가능한 최소한의 예제 만들기

버그를 생성하는 코드 조각을 분리하는 것이 매우 중요합니다. Hugging Face 팀의 어느 누구도 (아직) 마술사가 아니며 볼 수 없는 것을 고칠 수 없기 때문입니다. 최소한의 재현 가능한 예는 이름에서 알 수 있듯이 재현 가능해야 합니다. 즉, 가지고 있는 외부 파일이나 데이터에 의존해서는 안 됩니다. 사용 중인 데이터를 실제 값처럼 보이지만 여전히 동일한 오류를 생성하는 일부 더미 값으로 바꾸세요.

<Tip>

🚨 🤗 Transformers 저장소의 많은 문제는 트랜스포머를 재현하는 데 사용된 데이터에 액세스할 수 없기 때문에 해결되지 않습니다.

</Tip>

코드가 준비되었더라도 더 적은 수의 코드로 줄여서 우리가 _최소 재현 가능한 예제_라고 부르는 것을 만들 수 있습니다. 여기에는 약간의 추가 작업이 필요하지만 멋지고 짧은 버그 재현 코드를 제공하면 코드 수정에 대한 도움이 보장됩니다.

어렵지 않다면 버그가 발생한 소스 코드를 검사해보세요. 문제에 대한 해결책을 찾을 수 있지만(이 경우 문제를 해결하기 위해 직접 풀 요청을 제안할 수도 있음) 일반적으로 이것은 소스코드 메인테이너가 보고서를 읽을 때 소스를 더 잘 이해하는 데 도움을 줄 수 있습니다.

## 이슈 템플릿 작성하기

이슈를 제출하면 작성할 템플릿이 있음을 알 수 있습니다. 여기에서 [🤗 Transformers issues](https://github.com/huggingface/transformers/issues/new/choose)에 대한 정보를 따르지만 다른 프로젝트의 저장소에서 문제를 보고하는 경우에도 동일한 종류의 정보가 필요합니다. 템플릿을 비워두지 마세요. 시간을 들여 템플릿을 작성하면 답을 얻고 문제를 해결할 가능성이 극대화됩니다.

일반적으로 문제를 제기할 때는 항상 정중하게 행동하세요. 이 프로젝트는 오픈소스 이므로 여러분은 무료 소프트웨어를 사용하고 있으며 아무도 여러분을 도울 의무는 없습니다. 이슈에 정당한 비판이라고 생각하는 것을 포함할 수 있지만, 그러면 메인테이너는 그것을 나쁘게 받아들이고 서두르지 않을 것입니다. 프로젝트의 [행동 강령](https://github.com/huggingface/transformers/blob/master/CODE_OF_CONDUCT.md)을 반드시 읽어보세요.

### 개발 환경 정보 포함

🤗 Transformers는 사용자 환경에 대해 필요한 모든 정보를 얻을 수 있는 유틸리티를 제공합니다. 터미널에 다음을 입력하기만 하면 됩니다.:

```
transformers-cli env
```

그러면 아래와 같은 정보를 얻게 됩니다.:

```out
Copy-and-paste the text below in your GitHub issue and FILL OUT the two last points.

- `transformers` version: 4.12.0.dev0
- Platform: Linux-5.10.61-1-MANJARO-x86_64-with-arch-Manjaro-Linux
- Python version: 3.7.9
- PyTorch version (GPU?): 1.8.1+cu111 (True)
- Tensorflow version (GPU?): 2.5.0 (True)
- Flax version (CPU?/GPU?/TPU?): 0.3.4 (cpu)
- Jax version: 0.2.13
- JaxLib version: 0.1.65
- Using GPU in script?: <fill in>
- Using distributed or parallel set-up in script?: <fill in>
```
`transformers-cli env` 명령 시작 부분에 `!`를 추가하여 주피터 노트북 셀에서 실행한 다음 문제 시작 부분에 결과를 복사하여 붙여넣을 수도 있습니다.

### 사람 태깅하기

`@`를 입력하여 사람들을 태그하면 깃허브를 통해 알림이 전송되어 문제를 확인하고 더 빨리 응답할 수 있습니다. 당신이 태그한 사람들이 직접적인 링크가 없는 것에 대해 알림을 받는 것을 달가워하지 않을 수 있기 때문에 이것을 적당히 사용하세요. 버그와 관련된 소스 파일을 살펴본 경우 문제의 원인이라고 생각되는 줄에서 마지막으로 변경한 사람을 태그해야 합니다(이 정보는 GitHub에서 해당 줄을 보고 선택한 다음 "View git blame" 클릭).

아니면 템플릿에서 태그를 지정할 사람에 대한 제안을 받을 수 있습니다. 일반적으로 3명 이상 태그하지 마세요!

### 재현 가능한 예제 포함하기

버그를 생성하는 예제를 생성했다면 이제 버그를 포함할 때입니다! 다음과 같이 백틱 세 개 뒤에 `python`이 오는 행을 입력하세요.:

```
```python
```

그런 다음 최소한의 재현 가능한 예를 붙여넣고 세 개의 백틱이 있는 새 줄을 입력합니다. 이렇게 하면 코드의 형식이 올바르게 지정됩니다.

재현 가능한 예제를 생성하지 못한 경우 문제가 발생하는 방법을 명확한 단계로 설명하세요. 가능한 경우 오류가 발생한 Google Colab 노트북에 대한 링크를 포함합니다. 더 많은 정보를 공유할수록 메인테이너가 더 잘 답변할 수 있습니다.

모든 경우에 표시되는 전체 오류 메시지를 복사하여 붙여넣어야 합니다. Colab에서 작업하는 경우 일부 프레임이 Traceback에서 자동으로 축소될 수 있으므로 복사하기 전에 프레임을 확장했는지 확인하세요. 코드 샘플과 마찬가지로 세 개의 백틱이 있는 두 줄 사이에 해당 오류 메시지를 넣어 형식이 올바르게 지정되도록 합니다.

### 기대하는 동작 설명하기

메인테이너가 문제를 완전히 이해할 수 있도록 기대했던 것을 몇 줄로 설명하세요. 이 부분은 일반적으로 꽤 뻔하기 때문에 한 문장에 정리가 되어야 겠지만 경우에 따라 할 말이 많을 수도 있습니다.

## 그 다음?

이슈를 제출하고나서 모든 것이 괜찮은지 간단하게 확인하세요. 실수를 한 경우 이슈를 편집하거나 문제가 처음 생각한 것과 다르다는 것을 알게 된 경우 제목을 변경할 수도 있습니다.

답을 얻지 못하면 사람들에게 핑을 날릴 이유가 없습니다. 며칠 동안 아무도 당신을 도와주지 않는다면 아무도 이 문제를 이해할 수 없다는 이야기 입니다. 재현 가능한 예로 돌아가는 것을 주저하지 마십시오. 더 짧고 더 요점을 만들 수 있습니까? 일주일 안에 답변을 받지 못한 경우, 특히 문제에 대한 자세한 정보를 포함하도록 문제를 편집한 경우 부드럽게 도움을 요청하는 메시지를 남길 수 있습니다.

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ko/chapter8/5.mdx" />