# Introdução

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

## Bem-vindo(a) ao Curso 🤗!

<Youtube id="00GKzGyWFEs" />

Esse curso te ensinará sobre processamento de linguagem natural (PLN, ou NLP em inglês) usando as bibliotecas do ecossistema [Hugging Face](https://huggingface.co/) — [🤗 Transformers](https://github.com/huggingface/transformers), [🤗 Datasets](https://github.com/huggingface/datasets), [🤗 Tokenizers](https://github.com/huggingface/tokenizers) e [🤗 Accelerate](https://github.com/huggingface/accelerate) — assim como a [Hugging Face Hub](https://huggingface.co/models). É completamente gratuito e sem anúncios!


## O que esperar?

Aqui uma visão geral do curso:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary.svg" alt="Brief overview of the chapters of the course.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary-dark.svg" alt="Brief overview of the chapters of the course.">
</div>

- Capítulos 1 ao 4 dá uma introdução para os principais conceitos da biblioteca Transformers 🤗. No final dessa parte do curso, você se tornará familiar sobre como os modelos Transformers funcionam, saberá como usar o modelo da [Hugging Face Hub](https://huggingface.co/models), fazer um ajuste fino em um dataset e compartilhar os resultados no Hub!
- Capítulo 5 ao 8 ensina o básico dos 🤗 Datasets e 🤗 Tokenizadores antes de mergulhar nas tarefas clássicas de NLP. Ao final dessa parte, você será capaz de resolver por conta própria os problemas mais comuns de NLP. Ao longo do caminho, você aprenderá como construir e compartilhar demonstrações de seus modelos e otimiza-los para ambientes de produção. No final dessa parte, você será capaz de aplicar a 🤗 Transformers para (quase) qualquer problema de aprendizagem de máquina!

Esse curso:
* Requer um bom conhecimento de Python
* É melhor aproveitado depois de um curso de introdução ao deep learning (aprendizagem profunda), como o da [fast.ai](https://www.fast.ai/) [Practical Deep Learning for Coders](https://course.fast.ai/)  ou um dos programas desenvolvidos pela [DeepLearning.AI](https://www.deeplearning.ai/)
* Não se espera nenhum conhecimento prévio em [PyTorch](https://pytorch.org/)  ou em [TensorFlow](https://www.tensorflow.org/) , ainda que certa familiaridade com ambas as ferramentas seja proveitoso

Depois de você ter completado esse curso, nós recomendamos dar uma olhada na especialização da DeepLearning.AI de [Processamento de Linguagem Natural](https://www.coursera.org/specializations/natural-language-processing?utm_source=deeplearning-ai&utm_medium=institutions&utm_campaign=20211011-nlp-2-hugging_face-page-nlp-refresh), que cobre uma grande gama de modelos de NLP como naive Bayes e LSTMs que valem bastante a pena ter conhecimento!

## Quem nós somos?

Sobre os autores:

**Matthew Carrigan** é Engenheiro de Machine Learning na Hugging Face. Ele mora em Dublin na Irlanda e anteriormente trabalhou como Engenheiro de ML na Parse.ly e antes disso como pesquisador pós-doc na Trinity College Dublin. Ele não acredita que chegaremos a um rendimento anual bruto corrigido escalando as arquiteturas existentes, mas de qualquer forma ele tem grandes esperanças na imortalidade das máquinas.

**Lysandre Debut** é um Engenheiro de Machine Learning na Hugging Face e tem trabalhado para a biblioteca 🤗 Transformers desde seus estágios iniciais de desenvolvimento. Seu objetivo é fazer com que a área de NLP se torne acessível para qualquer pessoa através do desenvolvimento de ferramentas com uma API simples.

**Sylvain Gugger** é um Engenheiro Pesquisador na Hugging Face e um dos principais mantenedores da biblioteca 🤗 Transformers. Anteriormente ele foi Cientista Pesquisador na fast.ai, e co-escreveu _[Deep Learning for Coders with fastai and PyTorch](https://learning.oreilly.com/library/view/deep-learning-for/9781492045519/)_ com Jeremy Howard. O principal foco de sua pesquisa está em fazer o deep learning mais acessível, através de desenhos e técnicas de aprimoramento que permitam que modelos sejam treinados mais rápidos e com recursos limitados.

**Merve Noyan** é um desenvolvedor e evangelista na Hugging Face, trabalhando no desenvolvimento e construção de conteúdos envolta da temática de democratização do Machine Learning para todas as pessoas.

**Lucile Saulnier** é uma Engenheira de Machine Learning na Hugging Face, desenvolvendo e apoiando o uso de ferramentas de código aberto. Ela também é ativamente envolvida em muitos projetos de pesquisa no campo do Processamento de Linguagem natural assim como em treinamentos colaborativos e BigScience.

**Lewis Tunstall**  é um Engenheiro de Machine Learning na Hugging Face, focado no desenvolvimento de ferramentas open-source e em fazê-las amplamente acessíveis pela comunidade. Ele também é co-autor do livro que está pra lançar [O’Reilly book on Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/).

**Leandro von Werra**  é um Engenheiro de Machine Learning no time de open-source na Hugging Face e também co-autor do livro [O’Reilly book on Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/). Ele tem muitos anos de experiência na indústria trazendo projetos de NLP para produção trabalhando com várias stacks de Machine Learning.

Está pronto para seguir? Nesse capítulo, você aprenderá:
* Como usar a função `pipeline()`  para solucionar tarefas de NLP tais como geração de texto e classificação
* Sobre a arquitetura Transformer
* Como distinguir entre as arquiteturas encoder, decoder, encoder-decoder e seus casos de uso


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/chapter1/1.mdx" />