# Questionário de fim de capítulo

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

### 1. Qual é a ordem do pipeline para a modelagem de linguagem?

<Question
	choices={[
		{
			text: "Primeiro, o modelo trata de textos e devolve previsões em bruto. O tokenizer, então, trás sentido a estas previsões e as converte de volta ao texto quando necessário.",
			explain: "O modelo não consegue entender o texto! O tokenizer deve primeiro simbolizar o texto e convertê-lo em IDs para que seja compreensível pelo modelo."
		},
		{
			text: "Primeiro, o tokenizer trata de textos e devolve as identificações (IDs). O modelo lida com estas identificações e produz uma predição, que pode ser algum texto.",
			explain: "A predição do modelo não pode ser feita de imediato. O tokenizer tem que ser usado para converter a predição de volta ao texto!"
		},
		{
			text: "O tokenizer trata de textos e devolve os IDs. O modelo lida com estes IDs e produz uma predição. O tokenizer pode então ser usado mais uma vez para converter estas previsões de volta para algum texto.",
			explain: "Correto! O tokenizer pode ser usado tanto para a tokenização quanto para a destokenização.",
            correct: true
		}
	]}
/>

### 2. Quantas dimensões tem o tensor do Transformer de base, e quais são elas?

<Question
	choices={[
		{
			text: "2: O comprimento da sequência e o tamanho do batch (lote)",
			explain: "Falso! A saída do tensor pelo modelo tem uma terceira dimensão: o tamanho das camadas ocultas"
		},
		{
			text: "2: O comprimento da sequência e o tamanho das camadas ocultas",
			explain: "Falso! Todos os Transformer lidam com batches, mesmo com uma única sequência; isso seria um tamanho de batch de 1!"
		},
		{
			text: "3: O comprimento da sequência, o tamanho do batch (lote) e o tamanho das camadas ocultas",
			explain: "Correto!",
            correct: true
		}
	]}
/>

### 3. Qual dos seguintes é um exemplo de Tokenização por sub-palavras?

<Question
	choices={[
		{
			text: "WordPiece",
			explain: "Exatamente, este é um exemplo de Tokenização por sub-palavra!",
            correct: true
		},
		{
			text: "Character-based tokenization",
			explain: "Character-based tokenization não é uma tokenização por sub-palavra!."
		},
		{
			text: "Divisão no espaço em branco e pontuação",
			explain: "Esse é um esquema de tokenization baseado em palavras!"
		},
		{
			text: "BPE",
			explain: "Exatamente, este é um exemplo de Tokenização por sub-palavra!",
            correct: true
        },
		{
			text: "Unigram",
			explain: "Exatamente, este é um exemplo de Tokenização por sub-palavra!",
            correct: true
        },
		{
			text: "Nenhuma das acimas",
			explain: "Errado!"
        }
	]}
/>

### 4. O que é uma *model head*?

<Question
	choices={[
		{
			text: "Um componente dos transformers de base que redireciona os tensores para suas camadas corretas",
			explain: "Incorreto! Não existe tal componente."
		},
		{
			text: "Também conhecido como mecanismo de auto-atenção (*self-attention*), ele adapta a representação de um símbolo de acordo com os outros tokens da sequência",
			explain: "Incorreto! A camada de auto-atenção contém 'attention heads', mas estas não são as heads de adaptação."
		},
		{
			text: "Um componente adicional, geralmente composto de uma ou poucas camadas, para converter as previsões do Transformer em uma saída específica de tarefa",
			explain: "É isso mesmo. As heads de adaptação, também conhecidos simplesmente como heads, surgem em diferentes formas: heads de modelagem de linguagem, heads de resposta a perguntas, heads de classificação de sequência.. ",
			correct: true
		} 
	]}
/>

{#if fw === 'pt'}
### 5. O que seria um `AutoModel`?

<Question
	choices={[
		{
			text: "Um modelo que treina automaticamente com seus dados",
			explain: "Incorreto. Você está confundindo isto com nosso produto de <a href='https://huggingface.co/autonlp'>AutoNLP</a>?"
		},
		{
			text: "Um objeto que devolve a arquitetura correta com base em um checkpoint",
			explain: "Exatamente: o <code>AutoModel</code> só precisa saber o checkpoint para saber como inicializar então devolver a arquitetura correta.",
			correct: true
		},
		{
			text: "Um modelo que detecta automaticamente a linguagem utilizada para suas entradas a fim de carregar os pesos corretos",
			explain: "Incorreto; embora alguns checkpoints e modelos sejam capazes de lidar com vários idiomas, não há ferramentas embutidas para seleção automática de checkpoints de acordo com o idioma. Você deve ir para o  <a href='https://huggingface.co/models'>Model Hub</a> para encontrar o melhor checkpoint para realizar sua tarefa!"
		} 
	]}
/>

{:else}
### 5. O que seria um `TFAutoModel`?

<Question
	choices={[
		{
			text: "Um modelo que treina automaticamente com seus dados",
			explain: "Incorreto. Você está confundindo isto com nosso produto de <a href='https://huggingface.co/autonlp'>AutoNLP</a>?"
		},
		{
			text: "Um objeto que devolve a arquitetura correta com base em um checkpoint",
			explain: "Exatamente: o <code>TFAutoModel</code> só precisa saber o checkpoint para saber como inicializar então devolver a arquitetura correta.",
			correct: true
		},
		{
			text: "Um modelo que detecta automaticamente a linguagem utilizada para suas entradas a fim de carregar os pesos corretos",
			explain: "Incorreto; embora alguns checkpoints e modelos sejam capazes de lidar com vários idiomas, não há ferramentas embutidas para seleção automática de checkpoints de acordo com o idioma. Você deve ir para o  <a href='https://huggingface.co/models'>Model Hub</a> para encontrar o melhor checkpoint para realizar sua tarefa!"
		} 
	]}
/>

{/if}

### 6. Quais são as técnicas a serem observadas quando realizar batches com sequências de diferentes tamanhos?

<Question
	choices={[
		{
			text: "Truncar",
			explain: "Sim, a truncagem é uma forma correta de sequências de saída noturna para que elas se encaixem em forma retangular.No entanto, seria a única?",
			correct: true
		},
		{
			text: "Retornar tensores",
			explain: "Enquanto as outras técnicas permitem retornar tensores retangulares, retornar tensores não é útil quando realizar batches de sequências juntas."
		},
		{
			text: "Padding",
			explain: "Sim, padding é uma forma correta para as sequências de saída para que elas se encaixem em uma forma retangular. No entanto, seria a única?",
			correct: true
		}, 
		{
			text: "Attention masking",
			explain: "Exatamente! As attention masks são de primordial importância quando se trata de sequências de diferentes tamanhos. No entanto, essa não é a única técnica a ser conhecida.",
			correct: true
		} 
	]}
/>

### 7. Qual é o objetivo de aplicar uma função SoftMax à saída de logits para um modelo de classificação sequencial??

<Question
	choices={[
		{
			text: "Suaviza os logits para que sejam mais confiáveis.",
			explain: "Não, a função SoftMax não afeta a confiabilidade dos resultados."
		},
		{
			text: "Aplica um limite inferior e um limite superior para que eles sejam compreensíveis.",
			explain: "Correto! Os valores resultantes estão vinculados entre 0 e 1. Mas essa não é a única razão pela qual usamos uma função SoftMax.",
            correct: true
		},
		{
			text: "A soma total da saída é 1, resultando em uma possível interpretação probabilística.",
			explain: "Correto! Mas essa não é a única razão pela qual usamos uma função SoftMax.",
            correct: true
		}
	]}
/>

### 8. Qual é o método core da API tokenizer?

<Question
	choices={[
		{
			text: "<code>encode</code>, pois pode codificar texto em IDs e IDs em predições",
			explain: "Errado! O método <code>encode</code> existe na tokenização, porém não existe nos modelos."
		},
		{
			text: "Chamando diretamente o objeto de tokenização (tokenizer).",
			explain: "Exatamente! O método <code>__call__</code> do tokenizer é um método muito poderoso que pode lidar com praticamente qualquer coisa. É também o método usado para recuperar as predições de um modelo.",
			correct: true
		},
		{
			text: "<code>padding</code>",
			explain: "Errado! O padding é muito útil, mas é apenas uma parte da API do tokenizer."
		},
		{
			text: "<code>tokenize</code>",
			explain: "O método <code>tokenize</code> é indiscutivelmente um dos métodos mais úteis, mas não é o núcleo do API do tokenizer."
		}
	]}
/>

### 9. O que a variável `result` contém nesta pedaço de código?

```py
from transformers import AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
result = tokenizer.tokenize("Hello!")
```

<Question
	choices={[
		{
			text: "Uma lista de strings, sendo cada uma delas um token",
			explain: "Exatamente! Converta isto em IDs, e envie-os para um modelo!",
            correct: true
		},
		{
			text: "Uma lista de IDs",
			explain: "Incorreto; isto é o para o os métodos <code>__call__</code> ou <code>convert_tokens_to_ids</code>!"
		},
		{
			text: "Uma string contendo todos os tokens ",
			explain: "Isto seria subótimo, pois o objetivo é dividir a string em vários tokens."
		}
	]}
/>

{#if fw === 'pt'}
### 10. Tem algo errado com o código abaixo?

```py
from transformers import AutoTokenizer, AutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = AutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "Não, parece correto.",
			explain: "Infelizmente, acoplar um modelo com um tokenizer que foi treinado com um checkpoint diferente raramente é uma boa ideia. O modelo não foi treinado para fazer sentido a partir da saída deste tokenizer, então a saída do modelo (isto se ele realmente funcionar!) não fará nenhum sentido."
		},
		{
			text: "O tokenizer e o modelo devem ser sempre a partir do mesmo checkpoint.",
			explain: "Correto!",
            correct: true
		},
		{
			text: "É uma boa prática realizar o padding e truncar com o tokenizer, pois cada entrada é um batch.",
			explain: "É verdade que cada entrada do modelo precisa ser um batch. Entretanto, truncando ou realizando o padding desta sequência não faria necessariamente sentido, pois existe apenas uma delas, e estas são técnicas para criar batches de uma lista de sentenças."
		}
	]}
/>

{:else}
### 10. Tem algo errado com o código abaixo?

```py
from transformers import AutoTokenizer, TFAutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = TFAutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "Não, parece correto.",
			explain: "Infelizmente, acoplar um modelo com um tokenizer que foi treinado com um checkpoint diferente raramente é uma boa ideia. O modelo não foi treinado para fazer sentido a partir da saída deste tokenizer, então a saída do modelo (isto se ele realmente funcionar!) não fará nenhum sentido."
		},
		{
			text: "O tokenizer e o modelo devem ser sempre a partir do mesmo checkpoint.",
			explain: "Correto!",
            correct: true
		},
		{
			text: "É uma boa prática realizar o padding e truncar com o tokenizer, pois cada entrada é um batch.",
			explain: "É verdade que cada entrada do modelo precisa ser um batch. Entretanto, truncando ou realizando o padding desta sequência não faria necessariamente sentido, pois existe apenas uma delas, e estas são técnicas para criar batches de uma lista de sentenças."
		}
	]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/chapter2/8.mdx" />