# Questionário de fim de capítulo

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

Vamos testar o que você aprendeu neste capítulo!
  
### 1. A que se limitam os modelos no Hub?

<Question
	choices={[
		{
			text: "Modelos da biblioteca de 🤗 transformers.",
			explain: "Embora os modelos da biblioteca de 🤗 transformers sejam suportados no Hugging Face Hub, eles não são os únicos!"
		},
		{
			text: "Todos os modelos com uma interface semelhante a🤗 Transformers.",
			explain: "Nenhum requisito de interface é definido ao carregar os modelos para o Hugging Face Hub. "
		},
		{
			text: "Não tem limitações.",
			explain: "Certo! Não há limites no carregamento de modelos para o Hub.",
            correct: true
		},
        {
			text: "Modelos que estão de alguma forma relacionados à PNL.",
			explain: "Nenhuma exigência é estabelecida em relação ao campo de aplicação"
		}
	]}
/>

### 2. Como você pode gerenciar modelos no Hub?

<Question
	choices={[
		{
			text: "Através de uma conta GCP.",
			explain: "Errado!"
		},
		{
			text: "Através de uma distribuição peer-to-peer.",
			explain: "Errado!"
		},
		{
			text: "Através do git e git-lfs.",
			explain: "Correto! Os modelos no Hub são repositórios Git simples, deixando o <code>git-lfs</code> para arquivos grandes.",
            correct: true
		}
	]}
/>

### 3. O que você pode fazer usando a interface web do Hugging Face Hub?

<Question
	choices={[
		{
			text: "Fazer um fork de um repositório existente.",
			explain: "Não é possível forkar um repositório no Hugging Face Hub."
		},
		{
			text: "Criar um repositório de um novo modelo.",
			explain: "Correto! Isso não é tudo que você pode fazer.",
            correct: true
		},
		{
			text: "Gerenciar e editar aquivos.",
			explain: "Correto! Isso não é a única resposta.",
            correct: true
		},
        {
			text: "Upload de arquivos.",
			explain: "Certo! Mas não é tudo.",
            correct: true
		},
        {
			text: "Ver as diferenças entre as versões.",
			explain: "Correto! Isso não é tudo que você pode fazer.",
            correct: true
		}
	]}
/>

### 4. O que é um model card (cartão de modelo)?

<Question
	choices={[
		{
			text: "Uma descrição aproximada do modelo, portanto menos importante do que o modelo e os arquivos do tokenizer.",
			explain: "É de fato uma descrição do modelo, mas é uma peça importante: se estiver incompleta ou ausente, a utilidade do modelo é drasticamente reduzida."
		},
		{
			text: "Uma maneira de garantir reprodutibilidade, reusabilidade e equidade.",
			explain: "Correto! Compartilhar as informações corretas no cartão modelo ajudará os usuários a utilizar seu modelo e estar ciente de seus limites e preconceitos.",
            correct: true
		},
		{
			text: "Um arquivo Python que pode ser executado para recuperar informações sobre o modelo.",
			explain: "Cartões de modelos são apenas arquivos Markdown."
		}
	]}
/>

### 5. Quais destes objetos da biblioteca 🤗 Transformers podem ser compartilhados diretamente no Hub com `push_to_hub()`?

{#if fw === 'pt'}
<Question
	choices={[
		{
			text: "Um tokenizer",
			explain: "Correto! Todos os tokenizers possuem o método <code>push_to_hub</code>, e usá-la enviara todos os arquivos tokenizer (vocabulário, arquitetura do tokenizer, etc.) para um determinado repo. Embora essa não seja a única resposta correta!",
            correct: true
		},
		{
			text: "Uma configuração de modelo",
			explain: "Certo! Todas configurações de modelos possuem o método <code>push_to_hub</code>, e usá-la enviara todas para um determinado repositório. O que mais você pode compartilhar?",
            correct: true
		},
		{
			text: "Um modelo",
			explain: "Correto! Todos modelos possuem o método <code>push_to_hub</code>, e usá-la enviara ele e suas configurações para um determinado repositório. Embora essa não seja a única resposta correta!",
            correct: true
		},
        {
			text: "Um Trainer",
			explain: "Está certa — o <code>Trainer</code> também implementa o método <code>push_to_hub</code>, e usa-lo ira enviar os arquivos do modelo, sua configuração, o tokenizer, eo rascunho do cartão de modelo para um repositório. Porém, não é a única resposta correta!",
            correct: true
		}
	]}
/>
{:else}
<Question
	choices={[
		{
			text: "Um tokenizer",
			explain: "Correto! Todos os tokenizers possuem o método <code>push_to_hub</code>, e usá-la enviara todos os arquivos tokenizer (vocabulário, arquitetura do tokenizer, etc.) para um determinado repo. Embora essa não seja a única resposta correta!",
            correct: true
		},
		{
			text: "Uma configuração de modelo",
			explain: "Certo! Todas configurações de modelos possuem o método <code>push_to_hub</code>, e usá-la enviara todas para um determinado repositório. O que mais você pode compartilhar?",
            correct: true
		},
		{
			text: "Um modelo",
			explain: "Correto! Todos modelos possuem o método <code>push_to_hub</code>, e usá-la enviara ele e suas configurações para um determinado repositório. Embora essa não seja a única resposta correta!",
            correct: true
		},
        {
			text: "Todas as opções com uma callback dedicado",
			explain: "Está certa — o <code>PushToHubCallback</code> ira enviar regularmente os arquivos do modelo, sua configuração, e o tokenizer durante o treinamento para um repositório. Porém, não é a única resposta correta!",
            correct: true
		}
	]}
/>
{/if}

### 6. Qual é o primeiro passo ao utilizar o método `push_to_hub()` ou as ferramentas CLI?

<Question
	choices={[
		{
			text: "Entrar no website.",
			explain: "Isto não ira ajudar você na sua máquina local."
		},
		{
			text: "Rodar 'huggingface-cli login' no terminal.",
			explain: "Correto — isto irá baixar e cachear seu token pessoal.",
            correct: true
		},
		{
			text: "Rodar 'notebook_login()' em um notebook.",
			explain: "Correto — isto irá exibir um widget para você se autenticar.",
            correct: true
		},
	]}
/>

### 7.  Você está usando um modelo e um tokenizer - como você pode envia eles para o Hub?

<Question
	choices={[
		{
			text: "Chamando diretamente o método push_to_hub no modelo e no tokenizer.",
			explain: "Correto!",
            correct: true
		},
		{
			text: "Dentro do tempo de execução Python, envolvendo-os em um <code>huggingface_hub</code> utilidade.",
			explain: "Modelos e tokenizers já se beneficiam de <code>huggingface_hub</code> utilidades: não há necessidade de wrappers adicionais!"
		},
		{
			text: "Salvando eles em disco e chamando <code>transformers-cli upload-model</code>",
			explain: "O comando <code>upload-model</code> não existe."
		}
	]}
/>

### 8. Que operações de git você pode fazer com a classe `Repository`?

<Question
	choices={[
		{
			text: "Um commit.",
			explain: "Correto, o método <code>git_commit()</code> é para isto!",
            correct: true
		},
		{
			text: "Um pull",
			explain: "Este é o proposito do método <code>git_pull()</code>.",
            correct: true
		},
		{
			text: "Um push",
			explain: "O método <code>git_push()</code> realiza isto.",
            correct: true
		},
		{
			text: "Um merge",
			explain: "Não, esta operação nunca será permitida nessa API."
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/chapter4/6.mdx" />