# Introdução

<CourseFloatingBanner
    chapter={7}
    classNames="absolute z-10 right-0 top-0"
/>

No [Capítulo 3](/course/chapter3), você viu como fazer o ajuste fino (fine-tune) de um modelo de classificação de texto. Neste capítulo, abordaremos as seguintes tarefas de NLP (também conhecido como PLN):

- Classificação dos Tokens
- Modelagem de linguagem mascarada (como BERT)
- Sumarização 
- Tradução
- Modelagem de linguagem causal pré-treinamento (como GPT-2)
- Responder perguntas

{#if fw === 'pt'}

Para fazer isso, terá de aproveitar tudo o que aprendeu sobre a API `Trainer` e a biblioteca 🤗 Accelerate no [Capítulo 3](/course/chapter3), a biblioteca 🤗 Datasets no [Capítulo 5](/course/chapter5), e a biblioteca 🤗 Tokenizers no [Capítulo 6](/course/chapter6). Também vamos fazer o upload dos nossos resultados para o Model Hub, assim como fizemos no [Capítulo 4](/course/chapter4), então realmente esse é o capítulo onde tudo se junta!

Cada seção pode ser lida de forma independente e irá mostrar como treinar um modelo com a API `Trainer` ou com o seu próprio laço de treinamento, utilizando 🤗 Accelerate. Sinta-se à vontade para pular qualquer parte e se concentrar na que mais lhe interessa: a API `Trainer` é excelente para o ajuste fino ou para treinar o seu modelo sem se preocupar com o que se passa nos bastidores, enquanto que o laço de treinamento com `Accelerate` permite personalizar qualquer parte que queira com mais facilidade.

{:else}

Para fazer isso, terá de aproveitar tudo o que aprendeu sobre o treinamento de modelo com a API Keras no [Capítulo 3](/course/chapter3), a biblioteca 🤗 Datasets no [Capítulo 5](/course/chapter5), e a biblioteca 🤗 Tokenizers no [Capítulo 6](/course/chapter6). Também vamos fazer o upload dos nossos resultados para o Model Hub, assim como fizemos no [Capítulo 4](/course/chapter4), então realmente esse é o capítulo onde tudo se junta!

Cada seção pode ser lida de forma independente.

{/if}


<Tip>

Se ler as seções em sequência, notará que elas têm bastante código e texto em comum. Essa repetição é intencional para que possa mergulhar (ou voltar mais tarde) em qualquer tarefa que lhe interesse e encontrar um exemplo completo.

</Tip>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/chapter7/1.mdx" />