# Pedindo ajuda nos fóruns
<CourseFloatingBanner chapter={8}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/pt/chapter8/section3.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/pt/chapter8/section3.ipynb"},
]} />

<Youtube id="S2EEG3JIt2A"/>

Os [fóruns do Hugging Face](https://discuss.huggingface.co) são um ótimo lugar para obter ajuda da equipe de código aberto e da comunidade Hugging Face. Aqui está a aparência da página principal em um determinado dia:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forums.png" alt="The Hugging Face forums." width="100%"/>
</div>

No lado esquerdo você pode ver todas as categorias em que os vários tópicos estão agrupados, enquanto o lado direito mostra os tópicos mais recentes. Um tópico é uma postagem que contém um título, categoria e descrição; é bastante semelhante ao formato de problemas do GitHub que vimos ao criar nosso próprio conjunto de dados no [Capítulo 5](/course/chapter5). Como o nome sugere, a categoria [Beginners](https://discuss.huggingface.co/c/beginners/5) destina-se principalmente a pessoas que estão começando com as bibliotecas e o ecossistema Hugging Face. Qualquer dúvida sobre qualquer uma das bibliotecas é bem-vinda, seja para depurar algum código ou pedir ajuda sobre como fazer algo. (Dito isso, se sua pergunta diz respeito a uma biblioteca em particular, você provavelmente deve ir para a categoria de biblioteca correspondente no fórum.)

Da mesma forma, as categorias [Intermediário](https://discuss.huggingface.co/c/intermediate/6) e [Pesquisa](https://discuss.huggingface.co/c/research/7) são para perguntas mais avançadas, por exemplo, sobre as bibliotecas ou alguma nova pesquisa interessante sobre PNL que você gostaria de discutir.

E, naturalmente, também devemos mencionar a categoria [Curso](https://discuss.huggingface.co/c/course/20), onde você pode tirar todas as suas dúvidas relacionadas ao curso Hugging Face!

Depois de selecionar uma categoria, você estará pronto para escrever seu primeiro tópico. Você pode encontrar algumas [diretrizes](https://discuss.huggingface.co/t/how-to-request-support/3128) no fórum sobre como fazer isso, e nesta seção veremos algumas características que compõem um bom tópico.

## Escrevendo uma boa postagem no fórum

Como exemplo de execução, vamos supor que estamos tentando gerar embeddings de artigos da Wikipedia para criar um mecanismo de pesquisa personalizado. Como de costume, carregamos o tokenizer e o model da seguinte forma:

```python
from transformers import AutoTokenizer, AutoModel

model_checkpoint = "distilbert-base-uncased"
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)
model = AutoModel.from_pretrained(model_checkpoint)
```

Agora suponha que tentamos incorporar uma seção inteira do [artigo da Wikipédia](https://en.wikipedia.org/wiki/Transformers) em Transformers (a franquia, não a biblioteca!):

```python
text = """
Generation One is a retroactive term for the Transformers characters that
appeared between 1984 and 1993. The Transformers began with the 1980s Japanese
toy lines Micro Change and Diaclone. They presented robots able to transform
into everyday vehicles, electronic items or weapons. Hasbro bought the Micro
Change and Diaclone toys, and partnered with Takara. Marvel Comics was hired by
Hasbro to create the backstory; editor-in-chief Jim Shooter wrote an overall
story, and gave the task of creating the characthers to writer Dennis O'Neil.
Unhappy with O'Neil's work (although O'Neil created the name "Optimus Prime"),
Shooter chose Bob Budiansky to create the characters.

The Transformers mecha were largely designed by Shōji Kawamori, the creator of
the Japanese mecha anime franchise Macross (which was adapted into the Robotech
franchise in North America). Kawamori came up with the idea of transforming
mechs while working on the Diaclone and Macross franchises in the early 1980s
(such as the VF-1 Valkyrie in Macross and Robotech), with his Diaclone mechs
later providing the basis for Transformers.

The primary concept of Generation One is that the heroic Optimus Prime, the
villainous Megatron, and their finest soldiers crash land on pre-historic Earth
in the Ark and the Nemesis before awakening in 1985, Cybertron hurtling through
the Neutral zone as an effect of the war. The Marvel comic was originally part
of the main Marvel Universe, with appearances from Spider-Man and Nick Fury,
plus some cameos, as well as a visit to the Savage Land.

The Transformers TV series began around the same time. Produced by Sunbow
Productions and Marvel Productions, later Hasbro Productions, from the start it
contradicted Budiansky's backstories. The TV series shows the Autobots looking
for new energy sources, and crash landing as the Decepticons attack. Marvel
interpreted the Autobots as destroying a rogue asteroid approaching Cybertron.
Shockwave is loyal to Megatron in the TV series, keeping Cybertron in a
stalemate during his absence, but in the comic book he attempts to take command
of the Decepticons. The TV series would also differ wildly from the origins
Budiansky had created for the Dinobots, the Decepticon turned Autobot Jetfire
(known as Skyfire on TV), the Constructicons (who combine to form
Devastator),[19][20] and Omega Supreme. The Marvel comic establishes early on
that Prime wields the Creation Matrix, which gives life to machines. In the
second season, the two-part episode The Key to Vector Sigma introduced the
ancient Vector Sigma computer, which served the same original purpose as the
Creation Matrix (giving life to Transformers), and its guardian Alpha Trion.
"""

inputs = tokenizer(text, return_tensors="pt")
logits = model(**inputs).logits
```

```python output
IndexError: index out of range in self
```

Uh-oh, encontramos um problema -- e a mensagem de erro é muito mais enigmática do que as que vimos na [seção 2](/curso/chapter8/section2)! Não podemos fazer cara ou coroa do traceback completo, então decidimos recorrer aos fóruns do Hugging Face para obter ajuda. Como podemos elaborar o tema?

Para começar, precisamos clicar no botão "Novo Tópico" (em inglês, **new topic**) no canto superior direito (observe que para criar um tópico, precisamos estar logados):

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forums-new-topic.png" alt="Creating a new forum topic." width="100%"/>
</div>

Isso traz uma interface de escrita onde podemos inserir o título do nosso tópico, selecionar uma categoria e redigir o conteúdo:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic01.png" alt="The interface for creating a forum topic." width="100%"/>
</div>

Como o erro parece ser exclusivamente sobre 🤗 Transformers, selecionaremos isso para a categoria. Nossa primeira tentativa de explicar o problema pode ser algo assim:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic02.png" alt="Drafting the content for a new forum topic." width="100%"/>
</div>

Embora este tópico contenha a mensagem de erro para a qual precisamos de ajuda, há alguns problemas com a forma como ela está escrita:

1. O título não é muito descritivo, então quem estiver navegando no fórum não poderá dizer do que se trata o tópico sem ler também o corpo.
2. O corpo não fornece informações suficientes sobre _onde_ o erro está vindo e _como_ reproduzi-lo.
3. O tópico marca algumas pessoas diretamente com um tom um tanto exigente.

Tópicos como este provavelmente não terão uma resposta rápida (se conseguirem), então vamos ver como podemos melhorá-lo. Vamos começar com a primeira questão de escolher um bom título.

### Escolhendo um título descritivo

Se você estiver tentando obter ajuda com um bug em seu código, uma boa regra geral é incluir informações suficientes no título para que outras pessoas possam determinar rapidamente se acham que podem responder à sua pergunta ou não. Em nosso exemplo em execução, sabemos o nome da exceção que está sendo levantada e temos algumas dicas de que ela é acionada na passagem direta do modelo, onde chamamos `model(**inputs)`. Para comunicar isso, um título possível poderia ser:

> Source of IndexError in the AutoModel forward pass?

Este título diz ao leitor _onde_ você acha que o bug está vindo, e se eles encontraram um `IndexError` antes, há uma boa chance de que eles saibam como depurá-lo. Claro, o título pode ser o que você quiser, e outras variações como:

> Why does my model produce an IndexError?

também pode ficar bem. Agora que temos um título descritivo, vamos dar uma olhada em como melhorar o corpo.

### Formatando seus trechos de código

Ler o código-fonte é bastante difícil em um IDE, mas é ainda mais difícil quando o código é copiado e colado como texto simples! Felizmente, os fóruns do Hugging Face suportam o uso de Markdown, então você deve sempre colocar seus blocos de código com três acentos graves (```) para que seja mais fácil de ler. Vamos fazer isso para embelezar a mensagem de erro - e enquanto estaomos nisso, vamos tornar o corpo um pouco mais educado do que a nossa versão original:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic03.png" alt="Our revised forum topic, with proper code formatting." width="100%"/>
</div>

Como você pode ver na captura de tela, colocar os blocos de código em acentos graves converte o texto bruto em código formatado, completo com estilo de cores! Observe também que backticks simples podem ser usados ​​para formatar variáveis ​​inline, como fizemos para `distilbert-base-uncased`. Este tópico parece muito melhor e, com um pouco de sorte, podemos encontrar alguém na comunidade que possa adivinhar do que se trata o erro. No entanto, em vez de confiar na sorte, vamos facilitar a vida incluindo o rastreamento em todos os seus detalhes sangrentos!

### Incluindo o rastreamento completo

Como a última linha do traceback geralmente é suficiente para depurar seu próprio código, pode ser tentador apenas fornecer isso em seu tópico para "economizar espaço". Embora bem intencionado, isso na verdade torna _mais difícil_ para outros depurar o problema, já que as informações que estão mais acima no traceback também podem ser muito úteis. Portanto, uma boa prática é copiar e colar o traceback _inteiro_, certificando-se de que está bem formatado. Como esses rastreamentos podem ser bastante longos, algumas pessoas preferem mostrá-los depois de explicar o código-fonte. Vamos fazer isso. Agora, nosso tópico do fórum se parece com o seguinte:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic04.png" alt="Our example forum topic, with the complete traceback." width="100%"/>
</div>

Isso é muito mais informativo, e um leitor cuidadoso pode apontar que o problema parece ser devido à passagem de uma entrada longa por causa desta linha no traceback:

> Token indices sequence length is longer than the specified maximum sequence length for this model (583 > 512).

No entanto, podemos tornar as coisas ainda mais fáceis para eles fornecendo o código real que acionou o erro. Vamos fazer isso agora.

### Fornecendo um exemplo reproduzível

Se você já tentou depurar o código de outra pessoa, provavelmente tentou primeiro recriar o problema relatado para poder começar a trabalhar no rastreamento para identificar o erro. Não é diferente quando se trata de obter (ou dar) assistência nos fóruns, então realmente ajuda se você puder fornecer um pequeno exemplo que reproduza o erro. Na metade do tempo, simplesmente fazer este exercício o ajudará a descobrir o que está acontecendo de errado. De qualquer forma, a parte que falta em nosso exemplo é mostrar as _inputs_ que fornecemos ao modelo. Fazer isso nos dá algo como o seguinte exemplo concluído:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic05.png" alt="The final version of our forum topic." width="100%"/>
</div>

Este tópico agora contém muitas informações e foi escrito de uma forma que é muito mais provável de atrair a atenção da comunidade e obter uma resposta útil. Com essas diretrizes básicas, agora você pode criar ótimos tópicos para encontrar as respostas para suas dúvidas sobre 🤗 Transformers!



<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/chapter8/3.mdx" />