# Evento de lançamento da Parte 2

Para o lançamento da parte 2 do curso, organizamos um evento ao vivo com dois dias de palestras antes de um sprint de ajuste. Se você perdeu, pode acompanhar as palestras que estão listadas abaixo!

## Dia 1: Uma visão de alto nível dos Transformers e como treiná-los

**Thomas Wolf:** *Transfer Learning and the birth of the Transformers library*

<div class="flex justify-center">
<Youtube id="wCYVeahJES0"/>
</div>

<p align="center">
<img src="https://i.imgur.com/9eq8oUi.png" alt="A visual summary of Thom's talk" width="80%"/>
</p>

Thomas Wolf é cofundador e Chief Science Officer da Hugging Face. As ferramentas criadas por Thomas Wolf e a equipe Hugging Face são usadas em mais de 5.000 organizações de pesquisa, incluindo Facebook Artificial Intelligence Research, Google Research, DeepMind, Amazon Research, Apple, Allen Institute for Artificial Intelligence e na maioria dos departamentos universitários. Thomas Wolf é o iniciador e presidente sênior da maior colaboração de pesquisa que já existiu em Inteligência Artificial: [“BigScience”](https://bigscience.huggingface.co), bem como um conjunto de [bibliotecas e ferramentas amplamente utilizadas ](https://github.com/huggingface/). Thomas Wolf também é um educador prolífico, um líder de pensamento no campo de Inteligência Artificial e Processamento de Linguagem Natural e um orador convidado regular para conferências em todo o mundo [https://thomwolf.io](https://thomwolf.io ).

**Jay Alammar:** *A gentle visual intro to Transformers models*

<div class="flex justify-center">
<Youtube id="VzvG23gmcYU"/>
</div>

<p align="center">
<img src="https://i.imgur.com/rOZAuE9.png" alt="A visual summary of Jay's talk" width="80%"/>
</p>

Por meio de seu popular blog de ML, Jay ajudou milhões de pesquisadores e engenheiros a entender visualmente ferramentas e conceitos de aprendizado de máquina desde o básico (terminando em NumPy, Pandas docs) até o de ponta (Transformers, BERT, GPT-3).

**Margaret Mitchell:** *On Values in ML Development*

<div class="flex justify-center">
<Youtube id="8j9HRMjh_s8"/>
</div>

<p align="center">
<img src="https://i.imgur.com/NuIsnY3.png" alt="A visual summary of Margaret's talk" width="80%"/>
</p>

Margaret Mitchell é uma pesquisadora que trabalha em IA ética, atualmente focada nos meandros do desenvolvimento de IA informada pela ética em tecnologia. Ela publicou mais de 50 artigos sobre geração de linguagem natural, tecnologia assistiva, visão computacional e ética em IA, e possui várias patentes nas áreas de geração de conversas e classificação de sentimentos. Ela trabalhou anteriormente no Google AI como Staff Research Scientist, onde fundou e co-liderou o grupo Ethical AI do Google, focado na pesquisa básica de ética em IA e na operacionalização da ética de IA internamente no Google. Antes de ingressar no Google, ela foi pesquisadora da Microsoft Research, focada na geração de visão computacional para linguagem; e fez pós-doutorado na Johns Hopkins, com foco em modelagem bayesiana e extração de informações. Ela possui doutorado em Ciência da Computação pela Universidade de Aberdeen e mestrado em linguística computacional pela Universidade de Washington. Enquanto se formava, ela também trabalhou de 2005 a 2012 em aprendizado de máquina, distúrbios neurológicos e tecnologia assistiva na Oregon Health and Science University. Ela liderou uma série de workshops e iniciativas nas interseções de diversidade, inclusão, ciência da computação e ética. Seu trabalho recebeu prêmios do Secretário de Defesa Ash Carter e da Fundação Americana para Cegos e foi implementado por várias empresas de tecnologia. Ela gosta de jardinagem, cães e gatos.

**Matthew Watson and Chen Qian:** *NLP workflows with Keras*

<div class="flex justify-center">
<Youtube id="gZIP-_2XYMM"/>
</div>

<p align="center">
<img src="https://i.imgur.com/1vD2az8.png" alt="A visual summary of Matt and Chen's talk" width="80%"/>
</p>

Matthew Watson é engenheiro de aprendizado de máquina na equipe Keras, com foco em APIs de modelagem de alto nível. Ele estudou Computação Gráfica durante a graduação e mestrado na Universidade de Stanford. Um quase graduado em inglês que se voltou para a ciência da computação, ele é apaixonado por trabalhar em várias disciplinas e tornar a PNL acessível a um público mais amplo.

Chen Qian é engenheiro de software da equipe Keras, com foco em APIs de modelagem de alto nível. Chen obteve um mestrado em Engenharia Elétrica pela Universidade de Stanford e está especialmente interessado em simplificar as implementações de código de tarefas de ML e ML em larga escala.

**Mark Saroufim:** *How to Train a Model with Pytorch*

<div class="flex justify-center">
<Youtube id="KmvPlW2cbIo"/>
</div>

<p align="center">
<img src="https://i.imgur.com/TPmlkm8.png" alt="A visual summary of Mark's talk" width="80%"/>
</p>

Mark Saroufim é um engenheiro parceiro do Pytorch trabalhando em ferramentas de produção OSS, incluindo TorchServe e Pytorch Enterprise. Em suas vidas passadas, Mark foi Cientista Aplicado e Gerente de Produto na Graphcore, [yuri.ai](http://yuri.ai/), Microsoft e JPL da NASA. Sua principal paixão é tornar a programação mais divertida.

**Jakob Uszkoreit:** *It Ain't Broke So <del>Don't Fix</del> Let's Break It*

<div class="flex justify-center">
<Youtube id="C6jweXYFHSA"/>
</div>

<p align="center">
<img src="https://i.imgur.com/5dWQeNB.png" alt="A visual summary of Jakob's talk" width="80%"/>
</p>

Jakob Uszkoreit é o cofundador da Inceptive. A Inceptive projeta moléculas de RNA para vacinas e terapias usando aprendizado profundo em larga escala em um circuito fechado com experimentos de alto rendimento com o objetivo de tornar os medicamentos baseados em RNA mais acessíveis, mais eficazes e mais amplamente aplicáveis. Anteriormente, Jakob trabalhou no Google por mais de uma década, liderando equipes de pesquisa e desenvolvimento no Google Brain, Research and Search trabalhando em fundamentos de aprendizado profundo, visão computacional, compreensão de idiomas e tradução automática.

## Dia 2: As ferramentas a serem usadas

**Lewis Tunstall:** *Simple Training with the 🤗 Transformers Trainer*

<div class="flex justify-center">
<Youtube id="u--UVvH-LIQ"/>
</div>

Lewis é machine learning engineer no Hugging Face, focado em desenvolver ferramentas de código aberto e torná-las acessíveis para a comunidade em geral. Ele também é coautor do livro de O'Reilly [Natural Language Processing with Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/). Você pode segui-lo no Twitter (@_lewtun) para dicas e truques de PNL!

**Matthew Carrigan:** *New TensorFlow Features for 🤗 Transformers and 🤗 Datasets*

<div class="flex justify-center">
<Youtube id="gQUlXp1691w"/>
</div>

Matt é responsável pela manutenção do TensorFlow em Transformers e, eventualmente, liderará um golpe contra a facção PyTorch, que provavelmente será coordenada por meio de sua conta no Twitter @carrigmat.

**Lysandre Debut:** *The Hugging Face Hub as a means to collaborate on and share Machine Learning projects*

<div class="flex justify-center">
<Youtube id="RBw1TmdEZp0"/>
</div>

<p align="center">
<img src="https://i.imgur.com/TarIPCz.png" alt="A visual summary of Lysandre's talk" width="80%"/>
</p>

Lysandre é machine learning engineer no Hugging Face, onde está envolvido em muitos projetos de código aberto. Seu objetivo é tornar o Machine Learning acessível a todos, desenvolvendo ferramentas poderosas com uma API muito simples.

**Lucile Saulnier:** *Get your own tokenizer with 🤗 Transformers & 🤗 Tokenizers*

<div class="flex justify-center">
<Youtube id="UkNmyTFKriI"/>
</div>

Lucile é engenheira de aprendizado de máquina na Hugging Face, desenvolvendo e dando suporte ao uso de ferramentas de código aberto. Ela também está ativamente envolvida em muitos projetos de pesquisa na área de Processamento de Linguagem Natural, como treinamento colaborativo e BigScience.

**Sylvain Gugger:** *Supercharge your PyTorch training loop with 🤗 Accelerate*

<div class="flex justify-center">
<Youtube id="t8Krzu-nSeY"/>
</div>

Sylvain é um Research Engineer no Hugging Face e um dos principais mantenedores do 🤗 Transformers e o desenvolvedor por trás do 🤗 Accelerate. Ele gosta de tornar o treinamento de modelo mais acessível.

**Merve Noyan:** *Showcase your model demos with 🤗 Spaces*

<div class="flex justify-center">
<Youtube id="vbaKOa4UXoM"/>
</div>

Merve é um desenvolvedor defensor da Hugging Face, trabalhando no desenvolvimento de ferramentas e na criação de conteúdo em torno delas para democratizar o aprendizado de máquina para todos.

**Abubakar Abid:** *Building Machine Learning Applications Fast*

<div class="flex justify-center">
<Youtube id="c7mle2yYpwQ"/>
</div>

<p align="center">
<img src="https://i.imgur.com/qWIFeiF.png" alt="A visual summary of Abubakar's talk" width="80%"/>
</p>

Abubakar Abid é o CEO da [Gradio](www.gradio.app). Ele recebeu seu bacharelado em Engenharia Elétrica e Ciência da Computação do MIT em 2015 e seu PhD em Aprendizado de Máquina Aplicado de Stanford em 2021. Em seu papel como CEO da Gradio, Abubakar trabalha para tornar os modelos de aprendizado de máquina mais fáceis de demonstrar, debugar, e implantar.

**Mathieu Desvé:** *AWS ML Vision: Making Machine Learning Accessible to all Customers*

<div class="flex justify-center">
<Youtube id="O2e3pXO4aRE"/>
</div>

<p align="center">
<img src="https://i.imgur.com/oLdZTKy.png" alt="A visual summary of Mathieu's talk" width="80%"/>
</p>

Entusiasta da tecnologia, maker nas horas vagas. Gosto de desafios e resolução de problemas de clientes e usuários, e trabalho com pessoas talentosas para aprender todos os dias. Desde 2004, atuo em várias posições alternando entre frontend, backend, infraestrutura, operações e gerenciamentos. Tente resolver problemas técnicos e gerenciais comuns de maneira ágil.

**Philipp Schmid:** *Managed Training with Amazon SageMaker and 🤗 Transformers*

<div class="flex justify-center">
<Youtube id="yG6J2Zfo8iw"/>
</div>

Philipp Schmid é Machine Learning Engineer and Tech Lead no Hugging Face, onde lidera a colaboração com a equipe do Amazon SageMaker. Ele é apaixonado por democratizar e produzir modelos de PNL de ponta e melhorar a facilidade de uso do Deep Learning.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/events/2.mdx" />