# Introducere[[introducere]]

Bun venit la cursul Hugging Face! Această introducere te va ghida în configurarea environment-ului de lucru. Dacă abia începi cursul, îți recomandăm să arunci o privire mai întâi asupra [Capitolului 1](/course/chapter1), apoi să te întorci și să îți configurezi environment-ul pentru a putea încerca singur codul.

Toate bibliotecile pe care le vom folosi în acest curs sunt disponibile ca Python packages, așa că aici îți vom arăta cum să configurezi Python environment-ul și să instalezi librăriile specifice de care ai nevoie.

Vom acoperi două moduri de a-ți configura environment-ul, folosind un notebook Colab sau un Python environment. Simte-te liber să alegi pe cel care ți se potrivește cel mai bine. Pentru începători, recomandăm să începi folosind un notebook Colab.

Reține că nu vom acoperi sistemul Windows. Dacă folosești Windows, îți recomandăm să urmezi pașii folosind un notebook Colab. Dacă folosești o distribuție Linux sau macOS, poți folosi oricare dintre abordările descrise aici.

Majoritatea cursului se bazează pe faptul că ai un cont Hugging Face. Îți recomandăm să creezi unul acum: [crează un cont](https://huggingface.co/join).

## Folosirea unui notebook Google Colab[[folosind-un-notebook-google-colab]]

Folosirea unui notebook Colab este cea mai simplă configurare posibilă; deschide un notebook în browserul tău și începe imediat să scrii cod!

Dacă nu ești familiarizat cu Colab, îți recomandăm să începi urmând [introducerea](https://colab.research.google.com/notebooks/intro.ipynb). Colab îți permite să folosești hardware accelerat, cum ar fi GPU-uri sau TPU-uri, și este gratuit pentru sarcini mai mici.

Odată ce ești confortabil să te descurci în Colab, creează un nou notebook și începe cu configurarea:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="Un notebook Colab gol" width="80%"/>
</div>

Următorul pas este să instalezi librăriile pe care le vom folosi în acest curs. Vom folosi `pip` pentru instalare, care este managerul de packages pentru Python. În notebook-uri, poți rula comenzi de sistem începând comanda cu caracterul `!`, așa că poți instala librăria 🤗 Transformers astfel:

```
!pip install transformers
```

Te poți asigura că pachetul a fost instalat corect importându-l în cadrul mediului tău Python:

```
import transformers
```

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="O animație care arată rezultatul celor două comenzi de mai sus: instalare și importarea" width="80%"/>
</div>

Aceasta instalează o versiune foarte ușoară a 🤗 Transformers. În special, nu sunt instalate framework-uri specifice de machine learning (cum ar fi PyTorch sau TensorFlow). Deoarece vom folosi multe caracteristici diferite ale librăriei, îți recomandăm să instalezi versiunea pentru development, care vine cu toate dependențele necesare pentru cam orice caz de utilizare imaginabil:

```
!pip install transformers[sentencepiece]
```

Aceasta va dura puțin timp, dar apoi vei fi gata de drum pentru restul cursului!

## Folosirea unui virtual environment Python[[folosirea-unui-virtual-environment-python]]

Dacă preferi să folosești un mediu virtual Python, primul pas este să instalezi Python pe sistemul tău. Îți recomandăm să urmezi [această ghidare](https://realpython.com/installing-python/) pentru a începe.

Odată ce ai Python instalat, ar trebui să poți rula comenzi Python în terminalul tău. Poți începe rulând următoarea comandă pentru a te asigura că este instalat corect înainte de a trece la pașii următori: `python --version`. Aceasta ar trebui să afișeze versiunea Python disponibilă acum pe sistemul tău.

Când rulezi o comandă Python în terminalul tău, cum ar fi `python --version`, ar trebui să te gândești la programul care rulează comanda ta ca la Python-ul "principal" de pe sistemul tău. Îți recomandăm să păstrezi această instalare principală liberă de orice pachete și să o folosești pentru a crea environment-uri separate pentru fiecare aplicație pe care lucrezi — în acest fel, fiecare aplicație poate avea propriile sale dependențe și pachete, și nu va trebui să te preocupi de problemele de compatibilitate potențiale cu alte aplicații.

În Python, acest lucru se face prin [*virtual environments*](https://docs.python.org/3/tutorial/venv.html), care sunt directory trees autonomi ce conțin fiecare o instalare Python cu o anumită versiune Python împreună cu toate pachetele de care are nevoie aplicația. Crearea unui astfel de mediu virtual poate fi realizată cu mai multe instrumente diferite, dar vom folosi pachetul oficial Python pentru acest scop, denumit [`venv`](https://docs.python.org/3/library/venv.html#module-venv).

În primul rând, creează folder în care dorești ca aplicația ta să locuiască — de exemplu, ai putea dori să faci un nou folder numit *transformers-course* în rădăcina folderului tău personal:

```
mkdir ~/transformers-course
cd ~/transformers-course
```

Din interiorul acestui folder, creează un virtual environment folosind modulul Python `venv`:

```
python -m venv .env
```

Acum ar trebui să ai un folder numit *.env* în folderul tău altfel gol:

```
ls -a
```

```out
.      ..    .env
```

Poți să intri și să ieși din environment folosind comenzile `activate` și `deactivate`:

```
# Activează mediul virtual
source .env/bin/activate

# Dezactivează virtual environment-ul
deactivate
```

Te poți asigura că environment-ul este activat rulând comanda `which python`: dacă aceasta indică către virtual environment, atunci l-ai activat cu succes!

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

### Instalarea dependențelor[[instalarea-dependențelor]]

La fel ca în secțiunea anterioară despre utilizarea instanțelor Google Colab, acum va trebui să instalezi pachetele necesare pentru a continua. Din nou, poți instala versiunea pentru development a 🤗 Transformers folosind managerul de pachete `pip`:

```
pip install "transformers[sentencepiece]"
```

Acum ești gata să începi!

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter0/1.mdx" />