# Introducere[[introducere]]

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

## Bun venit la 🤗 curs![[bun-venit-la-curs]]

<Youtube id="00GKzGyWFEs" />

Acest curs are scopul de a vă învăța despre procesarea limbajelor naturale (NLP) folosind biblioteci din ecosistemul [Hugging Face](https://huggingface.co/) — [🤗 Transformers](https://github.com/huggingface/transformers), [🤗 Datasets](https://github.com/huggingface/datasets), [🤗 Tokenizers](https://github.com/huggingface/tokenizers), și [🤗 Accelerate](https://github.com/huggingface/accelerate) — precum și [Hugging Face Hub](https://huggingface.co/models). Cursul este complet gratuit și nu conține reclame.

## Înțelegerea NLP și a LLM-urilor[[înțelegerea-nlp-și-a-llm-urilor]]

Deși acest curs a fost inițial axat pe NLP (Procesarea Limbajului Natural), el a evoluat pentru a pune accentul pe Large Language Models (LLM-uri), care reprezintă cele mai recente progrese din domeniu.

**Care este diferența?**
- **NLP (Procesarea Limbajului Natural)** este domeniul mai larg care se concentrează pe permiterea computerelor să înțeleagă, interpreteze și să genereze limbajul uman. NLP include multe tehnici și sarcini, cum ar fi analiza sentimentelor, recunoașterea entităților numite și traducerea automată.
- **LLM-uri (Modele Mari de Limbaj)** sunt un subset puternic al modelelor NLP, caracterizate prin dimensiuni masive, volume mari de date de antrenament și abilitatea de a îndeplini o gamă largă de sarcini lingvistice cu un antrenament specific minim. Modele precum seriile Llama, GPT sau Claude sunt exemple de LLM-uri care au revoluționat ceea ce este posibil în domeniul NLP.

Pe parcursul acestui curs, vei învăța atât concepte tradiționale din NLP, cât și tehnici de ultimă generație legate de LLM-uri, deoarece înțelegerea fundamentelor NLP este esențială pentru a lucra eficient cu LLM-uri.

## La ce să te aștepți?[[la-ce-sa-te-aștepți]]

Aceasta este o scurtă prezentare a cursului:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary.svg" alt="Brief overview of the chapters of the course.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary-dark.svg" alt="Brief overview of the chapters of the course.">
</div>

- Capitolele 1-4 oferă o introducere în conceptele fundamentale ale bibliotecii 🤗 Transformers. Până la finalul acestei părți a cursului, veți fi familiarizați cu modul în care funcționează modelele Transformer și veți ști cum să utilizați un model din [Hugging Face Hub](https://huggingface.co/models), să îl ajustați pe un set de date și să vă partajați rezultatele pe Hub!
- Capitolele 5-8 predau elementele de bază ale Datasets 🤗 și ale Tokenizatoarelor 🤗 înainte de a vă scufunda în sarcinile NLP. Până la sfârșitul acestei părți, veți fi capabil să abordați singur cele mai frecvente probleme NLP.
- Capitolele 9-12 trec dincolo de NLP și explorează modul în care modelele Transformer pot fi utilizate pentru a aborda sarcini din domeniul procesării semnalelor vorbirii și computer vision. Pe parcurs, veți învăța cum să construiți și să partajați demo-uri ale modelelor dumneavoastră și cum să le optimizați pentru mediul de producție. Până la finalul acestei părți, veți fi gata să aplicați 🤗 Transformers la (aproape) orice problemă de machine learning!

Acest curs:

* Necesită o bună cunoaștere a limbajului Python.
* Este recomandat să fie parcurs după un curs introductiv de deep learning, cum ar fi [fast.ai's](https://www.fast.ai/) [Practical Deep Learning for Coders](https://course.fast.ai/) sau unul dintre cursurile oferite de [DeepLearning.AI](https://www.deeplearning.ai/).
* Nu se așteaptă la cunoștințe anterioare despre [PyTorch](https://pytorch.org/) sau [TensorFlow](https://www.tensorflow.org/), deși o familiaritate cu oricare dintre acestea va fi de ajutor.

După ce ați completat acest curs, vă recomandăm să accesați [Natural Language Processing Specialization](https://www.coursera.org/specializations/natural-language-processing?utm_source=deeplearning-ai&utm_medium=institutions&utm_campaign=20211011-nlp-2-hugging_face-page-nlp-refresh) de la DeepLearning.AI, care acoperă o gamă largă de modele NLP clasice, cum ar fi naive Bayes și LSTMs, despre care este bine să știți!

## Cine suntem noi?[[cine-suntem-noi]]

Despre autori:

[**Abubakar Abid**](https://huggingface.co/abidlabs) și-a susținut doctoratul la Stanford, în domeniul Applied Machine Learning. În timpul doctoratului său, a fondat [Gradio](https://github.com/gradio-app/gradio), o bibliotecă Python open-source care a fost utilizată pentru a construi peste 600.000 de demo-uri de Machine Learning. Gradio a fost achiziționată de Hugging Face, unde Abubakar activează acum ca lider al echipei de Machine Learning.

[**Ben Burtenshaw**](https://huggingface.co/burtenshaw) este Machine Learning Engineer la Hugging Face. A obținut doctoratul în Procesarea Limbajului Natural la Universitatea din Antwerp, unde a aplicat modele Transformer pentru a genera povești pentru copii cu scopul de a îmbunătăți abilitățile de literație. De atunci, s-a concentrat pe materiale educaționale și instrumente pentru comunitatea largă.

[**Matthew Carrigan**](https://huggingface.co/Rocketknight1) este inginer de Machine Learning la Hugging Face. Locuiește în Dublin, Irlanda și anterior a fost inginer ML la Parse.ly și înainte de asta cercetător postdoctoral la Trinity College Dublin. El consideră că atingerea AGI nu se va realiza prin scalarea arhitecturilor existente, dar este optimist în legătură cu viitorul roboților.

[**Lysandre Debut**](https://huggingface.co/lysandre) este inginer de Machine Learning la Hugging Face și a lucrat la biblioteca 🤗 Transformers încă din primele etape de dezvoltare. Scopul său este de a face NLP accesibil pentru toată lumea prin dezvoltarea de instrumente cu un API foarte simplu.

[**Sylvain Gugger**](https://huggingface.co/sgugger) este inginer de cercetare în Machine Learning la Hugging Face și unul dintre principalii întreținători ai bibliotecii 🤗 Transformers. Anterior a fost cercetător științific la fast.ai și a fost coautor la _[Deep Learning for Coders with fastai and PyTorch](https://learning.oreilly.com/library/view/deep-learning-for/9781492045519/)_ cu Jeremy Howard. Obiectivul principal al cercetării sale este de a face învățarea profundă mai accesibilă, prin proiectarea și îmbunătățirea tehnicilor care permit modelelor să se antreneze rapid pe resurse limitate.

[**Dawood Khan**](https://huggingface.co/dawoodkhan82) este inginer de Machine Learning la Hugging Face. Este originar din New York și a absolvit Universitatea din New York, unde a studiat Informatica. După ce a lucrat ca inginer iOS timp de câțiva ani, Dawood a renunțat la poziția sa pentru a înființa Gradio împreună cu colegii săi co-fondatori. Gradio a fost în cele din urmă achiziționat de Hugging Face.

[**Merve Noyan**](https://huggingface.co/merve) este un susținător al dezvoltatorilor la Hugging Face, lucrând la dezvoltarea de instrumente și la crearea de conținut în jurul acestora pentru a facilita învățarea automată pentru toată lumea. 

[**Lucile Saulnier**](https://huggingface.co/SaulLu) este inginer de Machine Learning la Hugging Face, dezvoltând și susținând utilizarea de instrumente open source. De asemenea, este implicată activ în multe proiecte de cercetare în domeniul procesării limbajului natural, cum ar fi formarea colaborativă și BigScience.

[**Lewis Tunstall**](https://huggingface.co/lewtun) este inginer de Machine Learning la Hugging Face, concentrându-se pe dezvoltarea de instrumente open-source și pe asigurarea accesibilității acestora pentru întreaga comunitate. De asemenea, este coautor al cărții O'Reilly [Natural Language Processing with Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/).

[**Leandro von Werra**](https://huggingface.co/lvwerra) este inginer de Machine Learning în cadrul echipei open-source de la Hugging Face și, de asemenea, coautor al cărții O'Reilly [Natural Language Processing with Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/). El are mai mulți ani de experiență în industrie, aducând proiecte NLP în stadiul de producție, lucrând pe întreaga stivă de învățare automată.

## FAQ[[faq]]

Iată câteva răspunsuri la întrebări frecvente:

- **Acest curs permite obținerea unei certificări?**
Momentan nu avem nicio certificare pentru acest curs. Cu toate acestea, lucrăm la un program de certificare pentru ecosistemul Hugging Face - rămâneți pe fază!

- **Cât timp ar trebui să dedic acestui curs?**
Fiecare capitol al acestui curs este gândit să fie parcurs într-o săptămână, necesitând aproximativ 6–8 ore de lucru. Totuși, puteți avansa în ritmul propriu și finaliza cursul în timpul care vi se potrivește cel mai bine.

- **Unde pot să pun o întrebare dacă am una?**
Dacă aveți o întrebare legată de orice secțiune a cursului, faceți clic pe bannerul „Pune o întrebare” din partea de sus a paginii pentru a fi redirecționat automat către secțiunea corespunzătoare din [forumurile Hugging Face](https://discuss.huggingface.co/):

<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/forum-button.png" alt="Link to the Hugging Face forums" width="75%">

De asemenea, o listă de [idei de proiecte](https://discuss.huggingface.co/c/course/course-event/25) este disponibilă pe forumuri, în cazul în care doriți să exersați mai mult după ce ați terminat cursul.

- **De unde pot obține codul pentru curs?**
Pentru fiecare secțiune, faceți clic pe bannerul din partea de sus a paginii pentru a rula codul în Google Colab sau Amazon SageMaker Studio Lab:

<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/notebook-buttons.png" alt="Link to the Hugging Face course notebooks" width="75%">

Notebook-urile Jupyter care conțin întregul cod al cursului sunt găzduite în repo-ul [`huggingface/notebooks`](https://github.com/huggingface/notebooks). Dacă doriți să le generați local, consultați instrucțiunile din repo-ul [`course`](https://github.com/huggingface/course#-jupyter-notebooks) de pe GitHub.


- **Cum pot contribui la curs?**
Există multe modalități de a contribui la curs! Dacă găsiți o greșeală de tipar sau o eroare, vă rugăm să creați o cerere în repo-ul [`course`](https://github.com/huggingface/course). Dacă doriți să ajutați la traducerea cursului în limba dumneavoastră maternă, consultați instrucțiunile [aici](https://github.com/huggingface/course#translating-the-course-into-your-language).

- **Care au fost alegerile făcute pentru fiecare traducere?**
Fiecare traducere are un glosar și un fișier `TRANSLATING.txt` care detaliază alegerile care au fost făcute pentru jargonul de Machine Learning etc. Puteți găsi un exemplu în limba germană [aici](https://github.com/huggingface/course/blob/main/chapters/de/TRANSLATING.txt).


- **Pot reutiliza acest curs?**
Desigur! Cursul este distribuit sub licența [Apache 2 license](https://www.apache.org/licenses/LICENSE-2.0.html), o licență permisivă. Aceasta permite reutilizarea materialului cu condiția să acordați credit autorilor, să includeți un link către licență și să menționați eventualele modificări efectuate. Acest lucru poate fi realizat în orice mod rezonabil, atâta timp cât nu implicați în mod fals că licențiatorul susține în mod explicit persoana sau utilizarea dvs. Dacă doriți să citați acest curs, vă rugăm să folosiți următorul formatBibTeX:

```
@misc{huggingfacecourse,
  author = {Hugging Face},
  title = {The Hugging Face Course, 2022},
  howpublished = "\url{https://huggingface.co/course}",
  year = {2022},
  note = "[Online; accessed <today>]"
}
```

## Să începem!
Sunteți gata să începeți? În acest capitol, veți învăța:

* Cum să utilizați funcția `pipeline()` pentru a rezolva sarcini NLP precum generarea și clasificarea textului
* Despre arhitectura Transformer
* Cum să faceți distincția între arhitecturile și cazurile de utilizare ale encoderului, decoderului și encoder-decoder.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter1/1.mdx" />