# Procesarea limbajului natural[[procesarea-limbajului-natural]]

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

Înainte de a trece la modelele Transformer, haideți să facem o prezentare scurtă despre ce este procesarea limbajului natural și de ce ne interesează.

## Ce este NLP?[[ce-este-nlp]]

NLP este un domeniu al lingvisticii și al învățării automate axat pe înțelegerea a tot ceea ce este legat de limbajul uman. Scopul sarcinilor NLP nu este doar înțelegerea individuală a cuvintelor, ci și capacitatea de a înțelege contextul acelor cuvinte.

În continuare urmează o listă a sarcinilor obișnuite de NLP, cu câteva exemple pentru fiecare:

- **Clasificarea propozițiilor întregi**: Determinarea caracterului unei recenzii, detectarea dacă un e-mail este spam, determinarea dacă o propoziție este corectă gramatical sau dacă două propoziții sunt legate logic sau nu
- **Clasificarea fiecărui cuvânt dintr-o propoziție**: Identificarea componentelor gramaticale ale unei propoziții (substantiv, verb, adjectiv) sau a entităților nominalizate (persoană, locație, organizație)
- **Generarea conținutului de text**: Completarea unui prompt cu text generat automat, completarea spațiilor goale dintr-un text cu cuvinte mascate
- **Extragerea unui răspuns dintr-un text**: Având o întrebare și un context, se extrage răspunsul la întrebare pe baza informațiilor furnizate în context
- **Generarea unei propoziții noi dintr-un text de intrare**: Traducerea unui text într-o altă limbă, rezumarea textului

NLP nu se limitează însă la textul scris. De asemenea, NLP abordează provocări complexe în domeniul recunoașterii vorbirii și al viziunii computerizate, cum ar fi generarea unei transcrieri a unui fragment audio sau a unei descrieri a unei imagini.

## Ascensiunea a Large Language Models (LLM-uri)[[rise-of-llms]]

În ultimii ani, domeniul NLP a fost revoluționat de Large Language Models (LLM-uri). Aceste modele, care includ arhitecturi precum GPT (Generative Pre-trained Transformer) și [Llama](https://huggingface.co/meta-llama), au transformat ceea ce este posibil în procesarea limbajului.

LLM-urile se caracterizează prin:
- **Mărime**: Conțin milioane, miliarde sau chiar sute de miliarde de parametri
- **Capacități generale**: Pot realiza multiple sarcini fără antrenament specific pentru fiecare sarcină
- **Învățare în context**: Pot învăța din exemplele oferite în prompt
- **Abilități emergente**: Pe măsură ce aceste modele cresc în dimensiune, demonstrează capacități care nu au fost programate sau anticipate în mod explicit

Apariția LLM-urilor a schimbat paradigma de la construirea unor modele specializate pentru sarcini NLP specifice la utilizarea unui singur model mare care poate fi direcționat prin prompturi sau ajustat pentru a aborda o gamă largă de sarcini lingvistice. Acest lucru a făcut procesarea sofisticată a limbajului mai accesibilă, dar a introdus și noi provocări în domenii precum eficiența, etica și implementarea.

## De ce este o provocare?[[de-ce-este-o-provocare]]

Computerele nu procesează informațiile în același mod ca oamenii. De exemplu, atunci când citim propoziția „Mi-e foame”, îi putem înțelege cu ușurință semnificația. În mod similar, având în vedere două propoziții precum „Mi-e foame” și „Sunt trist”, suntem capabili să determinăm cu ușurință cât de asemănătoare sunt acestea. Pentru modelele de învățare automată (ML), astfel de sarcini sunt mai dificile. Textul trebuie prelucrat într-un mod care să permită modelului să învețe din conținutul său. Și deoarece limbajul este complex, trebuie să ne gândim cu atenție la modul optim de a realiza această procesare. Au fost efectuate numeroase cercetări cu privire la modul de reprezentare a textului și vom analiza câteva metode în capitolul următor.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter1/2.mdx" />