# Configurați-vă instanța Argilla[[configurați-vă-instanța-argilla]]

<CourseFloatingBanner chapter={10}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter10/section2.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter10/section2.ipynb"},
]} />

Pentru a începe să folosiți Argilla, va trebui să configurați mai întâi propria instanță Argilla. Apoi va trebui să instalați SDK-ul Python pentru a putea gestiona Argilla folosind cod Python.

## Implementați interfața Argilla

Cea mai ușoară modalitate de a configura instanța Argilla este prin Hugging Face Spaces. Pentru a crea Space-ul Argilla, urmați pur și simplu [acest formular](https://huggingface.co/new-space?template=argilla%2Fargilla-template-space). Dacă aveți nevoie de îndrumări suplimentare, consultați [ghidul rapid Argilla](https://docs.argilla.io/latest/getting_started/quickstart/).
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter10/space_config.png" alt="Formularul de configurare Space."/>

>[!WARNING]
> ⚠️ S-ar putea să doriți să activați **Persistent storage** astfel încât datele să nu se piardă dacă Space-ul este pus în pauză sau repornit.
> Puteți face asta din Settings-urile Space-ului dvs. .

Odată ce Argilla este operațională, vă puteți autentifica cu acreditările dvs. .

## Instalați și conectați SDK-ul Python

Acum puteți merge în mediul Python sau notebook-ul dvs. și instala biblioteca argilla:

`!pip install argilla`

Să ne conectăm cu instanța noastră Argilla. Pentru asta veți avea nevoie de următoarele informații:

- **URL-ul API-ului dvs. **: Acesta este URL-ul unde rulează Argilla. Dacă folosiți un Space, puteți deschide Space-ul, face clic pe cele trei puncte din colțul din dreapta sus, apoi "Embed this Space" și copiați **Direct URL**. Ar trebui să arate ca `https://<numele-utilizatorului>.<numele-space-ului>.hf.space`.
- **Cheia API**: Pentru a obține cheia, autentificați-vă în instanța Argilla și mergeți la "My Settings", apoi copiați cheia API.
- **Token-ul HF**: Dacă Space-ul dvs. este privat, veți avea nevoie de un Access Token în contul Hugging Face Hub cu permisiuni de scriere.

```python
import argilla as rg

HF_TOKEN = "..."  # doar pentru space-uri private

client = rg.Argilla(
    api_url="...",
    api_key="...",
    headers={"Authorization": f"Bearer {HF_TOKEN}"},  # doar pentru space-uri private
)
```

Pentru a verifica că totul funcționează corect, vom apela `me`. Aceasta ar trebui să returneze utilizatorul nostru:

```python
client.me
```

Dacă a funcționat, instanța Argilla este operațională și sunteți conectat la ea! Felicitări!

Acum putem începe să încărcăm primul nostru set de date în Argilla. 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter10/2.mdx" />