# Înțelegerea Lucrării DeepSeek R1

Acest capitol este un curs intensiv de lectură a unei lucrări. Vom parcurge lucrarea în termeni simpli, și apoi vom descompune conceptele cheie și concluziile.

DeepSeek R1 reprezintă un progres semnificativ în antrenarea modelelor de limbaj, în special în dezvoltarea capacităților de raționament prin învățarea prin întărire. Lucrarea introduce un nou algoritm de învățare prin întărire numit Optimizarea Relativă a Politicii de Grup (GRPO).

![DeepSeek R1 Overview](https://huggingface.co/reasoning-course/images/resolve/main/grpo/4.png)

În următorul capitol, vom construi pe această cunoaștere și vom implementa GRPO în practică.

Obiectivul inițial al lucrării a fost să exploreze dacă învățarea prin întărire pură ar putea dezvolta capacități de raționament fără ajustarea fină supervizată.

<Tip>

Până la acel moment, toate LLM-urile populare necesitau o anumită ajustare fină supervizată, pe care am explorat-o în [capitolul 11](/course/chapter11/1).

</Tip>

## Momentul Revoluționar 'Aha'

![The 'Aha Moment'](https://huggingface.co/reasoning-course/images/resolve/main/grpo/9.png)

Una dintre cele mai remarcabile descoperiri în antrenarea R1-Zero a fost apariția unui fenomen cunoscut ca "Momentul Aha." Acest fenomen este oarecum similar cu modul în care oamenii experimentează realizări bruște în timpul rezolvării problemelor. Iată cum funcționează:

1. Încercare Inițială: Modelul face o încercare inițială de a rezolva o problemă
2. Recunoaștere: Recunoaște erori potențiale sau inconsistențe
3. Auto-Corecție: Își ajustează abordarea bazat pe această recunoaștere
4. Explicație: Poate explica de ce noua abordare este mai bună

Această descoperire rezonează cu cursanții și se simte ca un moment "Eureka". Demonstrează învățarea mai degrabă decât memorarea simplă, așa că să ne luăm un moment să ne imaginăm cum se simte să ai un moment "Aha".

De exemplu, imaginează-ți că încerci să rezolvi un puzzle:
- Prima încercare: "Această piesă ar trebui să meargă aici bazat pe culoare"
- Recunoaștere: "Dar stai, forma nu se potrivește destul de bine"
- Corecție: "Ah, de fapt merge acolo"
- Explicație: "Pentru că atât culoarea cât și modelul de formă se potrivesc în această poziție"

Această abilitate a apărut natural din antrenamentul RL, fără a fi programată explicit, demonstrând învățarea mai degrabă decât memorarea simplă a unui proces din datele de antrenare.

Cel mai ușor mod de a înțelege momentul 'Aha' este să-l vezi în acțiune. Să aruncăm o privire la un exemplu. În chat-ul de mai jos, întrebăm modelul să rezolve o problemă și UI-ul arată procesul de gândire al modelului pe măsură ce rezolvă problema.

<iframe
    src="https://reasoning-course-deepseek-ai-deepseek-r1-distill-0f5fad4.hf.space/"
	frameborder="0"
	width="850"
	height="450"
></iframe>

Dacă vrei să încerci Deepseek's R1, poți de asemenea să consulți [Hugging Chat](https://huggingface.co/chat/models/deepseek-ai/DeepSeek-R1-Distill-Qwen-32B).

## Procesul de Antrenare

Antrenarea R1 a fost un proces cu mai multe faze. Să descompunem fazele și inovațiile cheie în fiecare fază.

Procesul final rezultă în două modele:
- DeepSeek-R1-Zero: Un model antrenat pur folosind învățarea prin întărire.
- DeepSeek-R1: Un model care construiește pe fundația DeepSeek-R1-Zero și adaugă ajustare fină supervizată.

| Caracteristică | DeepSeek-R1-Zero | DeepSeek-R1 |
|---------|------------------|--------------|
| Abordarea de Antrenare | RL Pur | Multi-fază (SFT + RL) |
| Ajustare Fină | Niciuna | Ajustare fină supervizată |
| Capacitate de Raționament | Emergentă | Îmbunătățită |
| Performanța AIME | 71.0% | 79.8% |
| Caracteristici Cheie | Raționament puternic dar probleme de lizibilitate | Consistență și lizibilitate mai bună a limbajului |

În timp ce DeepSeek-R1-Zero demonstrează potențialul învățării prin întărire pure pentru dezvoltarea capacităților de raționament, DeepSeek-R1 construiește pe această fundație cu o abordare mai echilibrată care prioritizează atât performanța de raționament cât și utilizabilitatea.

Procesul de antrenare implică patru faze:

1. Faza de Pornire la Rece
2. Faza RL de Raționament
3. Faza de Eșantionare prin Respingere
4. Faza RL Diversă

Să descompunem fiecare fază:

### Faza de Pornire la Rece (Fundația Calității)

![Cold Start Phase](https://huggingface.co/reasoning-course/images/resolve/main/grpo/5.png)

Această fază este concepută pentru a stabili o fundație solidă pentru lizibilitatea și calitatea răspunsurilor modelului. Folosește un set de date mic de eșantioane de înaltă calitate de la R1-Zero pentru a ajusta fin modelul V3-Base. Începând cu modelul DeepSeek-V3-Base, echipa a folosit mii de eșantioane validate, de înaltă calitate de la R1-Zero pentru ajustarea fină supervizată. Această abordare inovatoare folosește un set de date mic dar de înaltă calitate pentru a stabili o lizibilitate de bază puternică și calitatea răspunsurilor.

### Faza RL de Raționament (Construirea Capacităților)

![Reasoning RL Phase](https://huggingface.co/reasoning-course/images/resolve/main/grpo/6.png)

Faza RL de Raționament se concentrează pe dezvoltarea capacităților de raționament de bază în domenii incluzând matematica, codarea, știința și logica. Această fază folosește învățarea prin întărire bazată pe reguli, cu recompense direct legate de corectitudinea soluției.

Crucial, toate sarcinile din această fază sunt 'verificabile' deci putem verifica dacă răspunsul modelului este corect sau nu. De exemplu, în cazul matematicii, putem verifica dacă răspunsul modelului este corect folosind un rezolvitor matematic.

Ceea ce face această fază deosebit de inovatoare este abordarea sa de optimizare directă care elimină nevoia unui model de recompensă separat, simplificând procesul de antrenare.

### Faza de Eșantionare prin Respingere (Controlul Calității)

![Rejection Sampling Phase](https://huggingface.co/reasoning-course/images/resolve/main/grpo/7.png)

În timpul Fazei de Eșantionare prin Respingere, modelul generează eșantioane care sunt apoi filtrate printr-un proces de control al calității. DeepSeek-V3 servește ca judecător al calității, evaluând rezultatele într-un domeniu larg care se extinde dincolo de sarcinile pure de raționament. Datele filtrate sunt apoi folosite pentru ajustarea fină supervizată. Inovația acestei faze constă în abilitatea sa de a combina multiple semnale de calitate pentru a asigura rezultate de înalt standard.

### Faza RL Diversă (Alinierea Largă)

![Diverse RL Phase](https://huggingface.co/reasoning-course/images/resolve/main/grpo/8.png)

Faza finală RL Diversă abordează multiple tipuri de sarcini folosind o abordare hibridă sofisticată. Pentru sarcinile deterministe, folosește recompense bazate pe reguli, în timp ce sarcinile subiective sunt evaluate prin feedback LLM. Această fază își propune să atingă alinierea preferințelor umane prin abordarea sa inovatoare de recompense hibride, combinând precizia sistemelor bazate pe reguli cu flexibilitatea evaluării modelelor de limbaj.

## Algoritmul: Optimizarea Relativă a Politicii de Grup (GRPO)

Acum că avem o înțelegere bună a procesului de antrenare, să privim algoritmul care a fost folosit pentru a antrena modelul.

Autorii descriu GRPO ca o descoperire în ajustarea fină a modelelor:

![GRPO Process](https://huggingface.co/reasoning-course/images/resolve/main/grpo/10.png)

Noutatea GRPO constă în capacitatea sa de a "optimiza direct pentru rectificarea preferințelor." Aceasta semnifică o rută mai directă și eficientă către alinierea modelului cu rezultatele dorite, contrastând cu algoritmii tradiționali de Învățare prin Întărire precum PPO. Să descompunem cum funcționează GRPO prin cele trei componente principale ale sale.

### Formarea Grupurilor: Crearea de Multiple Soluții

Primul pas în GRPO este remarcabil de intuitiv - este similar cu modul în care un student ar putea rezolva o problemă dificilă încercând multiple abordări. Când primește o comandă, modelul nu generează doar un răspuns; în schimb, creează multiple încercări de a rezolva aceeași problemă (de obicei 4, 8 sau 16 încercări diferite).

Imaginează-ți că înveți un model să rezolve probleme de matematică. Pentru o întrebare despre numărarea puilor de pe o fermă, modelul ar putea genera mai multe soluții diferite:
- O soluție ar putea descompune problema pas cu pas: prima numărarea puilor totali, apoi scăderea cocoșilor, și în final contabilizarea găinilor care nu produc ouă
- Altă soluție ar putea folosi o abordare diferită dar la fel de validă
- Unele încercări ar putea conține greșeli sau soluții mai puțin eficiente

Toate aceste încercări sunt păstrate împreună ca grup, aproape ca să ai mai mulți studenti cu soluții de comparat și din care să înveți.

![Group Formation](https://huggingface.co/reasoning-course/images/resolve/main/grpo/11.jpg)

### Învățarea Preferințelor: Înțelegerea Ce Face o Soluție Bună

Aici este unde GRPO cu adevărat strălucește în simplitatea sa. Spre deosebire de alte metode pentru RLHF care întotdeauna necesită un model de recompensă separat pentru a prezice cât de bună ar putea fi o soluție, GRPO poate folosi orice funcție sau model pentru a evalua calitatea unei soluții. De exemplu, am putea folosi o funcție de lungime pentru a recompensa răspunsuri mai scurte sau un rezolvitor matematic pentru a recompensa soluții matematice precise.

Procesul de evaluare privește la diverse aspecte ale fiecărei soluții:
- Este răspunsul final corect?
- A urmat soluția formatarea corespunzătoare (cum ar fi folosirea tag-urilor XML corecte)?
- Se potrivește raționamentul cu răspunsul oferit?

Ceea ce face această abordare deosebit de inteligentă este modul în care gestionează evaluarea. În loc să dea doar scoruri absolute, GRPO normalizează recompensele în cadrul fiecărui grup. Folosește o formulă simplă dar eficientă pentru estimarea avantajului relativ al grupului:

```
Avantaj = (recompensă - mean(recompense_grup)) / std(recompense_grup)
```

![Preference Learning](https://huggingface.co/reasoning-course/images/resolve/main/grpo/12.jpg)

Această normalizare este ca să notezi pe o curbă, dar pentru AI. Ajută modelul să înțeleagă care soluții din cadrul grupului au fost mai bune sau mai rele comparativ cu colegii lor, mai degrabă decât să se uite doar la scoruri absolute.

### Optimizarea: Învățarea din Experiență

Pasul final este unde GRPO îi învață modelul să se îmbunătățească bazat pe ceea ce a învățat din evaluarea grupului de soluții. Acest proces este atât puternic cât și stabil, folosind două principii principale:

1. Încurajează modelul să producă mai multe soluții ca cele de succes în timp ce se îndepărtează de abordările mai puțin eficiente
2. Include un mecanism de siguranță (numit penalitate de divergență KL) care previne modelul să se schimbe prea drastic dintr-o dată

Această abordare se dovedește mai stabilă decât metodele tradiționale pentru că:
- Se uită la multiple soluții împreună mai degrabă decât să compare doar două pe rând
- Normalizarea bazată pe grup ajută la prevenirea problemelor cu scalarea recompenselor
- Penalitatea KL acționează ca o plasă de siguranță, asigurându-se că modelul nu uită ce știa deja în timp ce învață lucruri noi

<Tip>

Inovațiile cheie ale GRPO sunt:
- Învățarea direct din orice funcție sau model, eliminând dependența de un model de recompensă separat.
- Învățarea bazată pe grup, care este mai stabilă și eficientă decât metodele tradiționale cum ar fi comparațiile perechi.

</Tip>

Această descompunere este complexă, dar concluzia cheie este că GRPO este o modalitate mai eficientă și stabilă de a antrena un model să raționeze.

### Algoritmul GRPO în Pseudocod

Acum că înțelegem componentele cheie ale GRPO, să privim algoritmul în pseudocod. Aceasta este o versiune simplificată a algoritmului, dar surprinde ideile cheie.

```
Input: 
- initial_policy: Modelul de început care va fi antrenat
- reward_function: Funcția care evaluează rezultatele
- training_prompts: Set de exemple de antrenare
- group_size: Numărul de rezultate per comandă (de obicei 4-16)

Algoritm GRPO:
1. Pentru fiecare iterație de antrenare:
   a. Setează reference_policy = initial_policy (captura politica actuală)
   b. Pentru fiecare comandă în lot:
      i. Generează group_size rezultate diferite folosind initial_policy
      ii. Calculează recompensele pentru fiecare rezultat folosind reward_function
      iii. Normalizează recompensele în cadrul grupului:
           normalized_advantage = (recompensă - mean(recompense)) / std(recompense)
      iv. Actualizează politica maximizând rația tăiată:
          min(prob_ratio * normalized_advantage, 
              clip(prob_ratio, 1-epsilon, 1+epsilon) * normalized_advantage)
          - kl_weight * KL(initial_policy || reference_policy)
          
          unde prob_ratio este current_prob / reference_prob

Output: Model de politică optimizat
```

Acest algoritm arată cum GRPO combină estimarea avantajului bazat pe grup cu optimizarea politicii menținând în același timp stabilitatea prin tăiere și constrângeri de divergență KL.

## Rezultate și Impact

Acum că am explorat algoritmul, să privim rezultatele. DeepSeek R1 atinge performanțe de ultimă generație în multiple domenii:

| Domeniu | Rezultate Cheie |
|--------|-------------|
| Matematică | • 79.8% pe AIME 2024<br>• 97.3% pe MATH-500 |
| Codare | • Rating Codeforces: 2029<br>• LiveCodeBench: 65.9% |
| Cunoștințe Generale | • MMLU: 90.8%<br>• GPQA Diamond: 71.5% |
| Sarcini de Limbaj | • AlpacaEval 2.0: 87.6% rată de câștig<br>• FRAMES: 82.5% |

Impactul practic al modelului se extinde dincolo de benchmark-uri prin prețurile sale cost-eficiente ale API-ului ($0.14 per milion de token-uri de intrare) și distilarea cu succes a modelului în diverse dimensiuni (1.5B la 70B parametri). În mod notabil, chiar și modelul de 7B atinge 55.5% pe AIME 2024, în timp ce versiunea distilată de 70B se apropie de performanța o1-mini pe MATH-500 (94.5%), demonstrând conservarea eficientă a capacităților la diferite scale.

## Limitări și Provocări ale GRPO

În timp ce GRPO reprezintă un progres semnificativ în învățarea prin întărire pentru modelele de limbaj, este important să înțelegem limitările și provocările sale:

- **Costul Generării**: Generarea de multiple completări (4-16) pentru fiecare prompt crește cerințele computaționale comparativ cu metodele care generează doar una sau două completări.
- **Constrângerile Dimensiunii Lotului**: Nevoia de a procesa grupuri de completări împreună poate limita dimensiunile eficiente ale loturilor, adăugând complexitate procesului de antrenare și potențial încetinind antrenarea.
- **Designul Funcției de Recompensă**: Calitatea antrenamentului depinde foarte mult de funcții de recompensă bine concepute. Recompensele prost concepute pot duce la comportamente neintenționate sau optimizarea pentru obiectivele greșite.
- **Compromisurile Dimensiunii Grupului**: Alegerea dimensiunii optime a grupului implică echilibrarea diversității soluțiilor împotriva costului computațional. Prea puține eșantioane s-ar putea să nu ofere suficientă diversitate, în timp ce prea multe cresc timpul de antrenare și cerințele de resurse.
- **Reglarea Divergenței KL**: Găsirea echilibrului potrivit pentru penalitatea divergenței KL necesită reglare atentă - prea mare și modelul nu va învăța eficient, prea mică și poate devia prea departe de capacitățile sale inițiale.

## Concluzie

Lucrarea DeepSeek R1 reprezintă o piatră de hotar semnificativă în dezvoltarea modelelor de limbaj. Algoritmul Group Relative Policy Optimization (GRPO) a demonstrat că învățarea prin întărire pură poate într-adevăr dezvolta capacități puternice de raționament, provocând presupunerile anterioare despre necesitatea ajustării fine supervizate.

Poate cel mai important, DeepSeek R1 a arătat că este posibil să echilibrezi performanța înaltă cu considerații practice precum cost-eficiența și accesibilitatea. Distilarea cu succes a capacităților modelului în diferite dimensiuni, de la 1.5B la 70B parametri, demonstrează o cale înainte pentru a face capacitățile AI avansate mai larg disponibile.

---

În următoarea secțiune, vom explora implementări practice ale acestor concepte, concentrându-ne pe cum să folosești GRPO și RFTrans în propriile tale proiecte de dezvoltare a modelelor de limbaj.

## Quiz

### 1. Care este principala inovație a lucrării DeepSeek R1?

<Question
    choices={[
        {
            text: "Algoritmul GRPO care permite învățarea din preferințe cu și fără un model de recompensă",
            explain: "Corect! Inovația cheie a GRPO este capacitatea sa de a optimiza direct pentru rectificarea preferințelor, făcându-l mai eficient decât metodele RL tradiționale.",
            correct: true
        },
        {
            text: "Folosirea mai multor GPU-uri pentru antrenare decât orice model anterior",
            explain: "Inovația lucrării este în abordarea sa algoritmică (GRPO) mai degrabă decât în resursele computaționale folosite."
        },
        {
            text: "Crearea unui model de limbaj mai mare decât cele existente",
            explain: "Inovația constă în metodologia de antrenare și algoritmul GRPO, nu în dimensiunea modelului."
        }
    ]}
/>

### 2. Care sunt cele patru faze ale procesului de antrenare DeepSeek R1?

<Question
    choices={[
        {
            text: "Pornire la Rece, RL de Raționament, Eșantionare prin Respingere și RL Diversă",
            explain: "Corect! Acestea sunt exact cele patru faze descrise în lucrare, fiecare servind un scop specific în pipeline-ul de antrenare.",
            correct: true
        },
        {
            text: "Pre-antrenare, Ajustare Fină, Testare și Implementare",
            explain: "Lucrarea descrie în mod specific patru faze diferite: Pornire la Rece (fundația calității), RL de Raționament (construirea capacităților), Eșantionare prin Respingere (controlul calității) și RL Diversă (alinierea largă)."
        },
        {
            text: "Colectarea Datelor, Antrenarea Modelului, Evaluarea și Optimizarea",
            explain: "Lucrarea descrie un proces specific cu patru faze care include fazele de Pornire la Rece, RL de Raționament, Eșantionare prin Respingere și RL Diversă."
        }
    ]}
/>

### 3. Ce este fenomenul 'Momentul Aha' în antrenarea R1-Zero?

<Question
    choices={[
        {
            text: "Un proces în care modelul recunoaște erorile, se auto-corectează și explică corecturile sale",
            explain: "Corect! Lucrarea descrie aceasta ca un proces cu patru pași: încercare inițială, recunoașterea erorilor, auto-corecția și explicația îmbunătățirii.",
            correct: true
        },
        {
            text: "Punctul în care modelul atinge performanța la nivel uman",
            explain: "'Momentul Aha' se referă în mod specific la capacitatea modelului de a recunoaște și corecta propriile greșeli, similar cu realizările umane în rezolvarea problemelor."
        },
        {
            text: "Când modelul își completează procesul de antrenare",
            explain: "'Momentul Aha' se referă la capacitatea emergentă a modelului de a recunoaște erorile și de a se auto-corecta în timpul rezolvării problemelor, nu despre completarea antrenării."
        }
    ]}
/>

### 4. Cum funcționează formarea grupurilor în GRPO?

<Question
    choices={[
        {
            text: "Generează multiple soluții (4-16) pentru aceeași problemă și le evaluează împreună",
            explain: "Corect! GRPO generează multiple încercări de a rezolva aceeași problemă, de obicei 4, 8 sau 16 încercări diferite, care sunt apoi evaluate ca grup.",
            correct: true
        },
        {
            text: "Combină multiple modele într-un ansamblu",
            explain: "GRPO folosește un singur model pentru a genera multiple încercări de soluție, nu un ansamblu de modele diferite."
        },
        {
            text: "Împarte datele de antrenare în grupuri diferite",
            explain: "Formarea grupurilor în GRPO implică generarea de multiple soluții pentru aceeași problemă, nu împărțirea datelor de antrenare."
        }
    ]}
/>

### 5. Care este diferența cheie între DeepSeek-R1-Zero și DeepSeek-R1?

<Question
    choices={[
        {
            text: "R1-Zero folosește RL pur în timp ce R1 combină RL cu ajustarea fină supervizată",
            explain: "Corect! După cum se arată în tabelul de comparație, R1-Zero folosește antrenare RL pură în timp ce R1 folosește o abordare multi-fază combinând ajustarea fină supervizată cu RL, rezultând în consistență mai bună a limbajului.",
            correct: true
        },
        {
            text: "R1-Zero este mai mic decât R1",
            explain: "Diferența este în abordările lor de antrenare (RL pur vs. multi-fază), nu în dimensiunile modelelor lor."
        },
        {
            text: "R1-Zero a fost antrenat pe mai puține date",
            explain: "Distincția cheie este metodologia lor de antrenare: RL pur pentru R1-Zero versus o abordare combinată SFT și RL pentru R1."
        }
    ]}
/> 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter12/3.mdx" />