# Modele[[modele]]

{#if fw === 'pt'}

<CourseFloatingBanner chapter={2}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter2/section3_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter2/section3_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={2}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter2/section3_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter2/section3_tf.ipynb"},
]} />

{/if}

{#if fw === 'pt'}
<Youtube id="AhChOFRegn4"/>
{:else}
<Youtube id="d3JVgghSOew"/>
{/if}

{#if fw === 'pt'}
 
În această secțiune vom analiza mai detaliat crearea și utilizarea unui model. Vom folosi clasa `AutoModel`, care este utilă atunci când doriți să instanțiați orice model dintr-un checkpoint.

Clasa `AutoModel` și toate celelalte clase înrudite sunt, de fapt, simple wrappere ale gamei largi de modele disponibile în bibliotecă. Este un wrapper inteligent, deoarece poate ghici automat arhitectura modelului corespunzător pentru checkpoint-ul dumneavoastră și apoi instanțiază un model cu această arhitectură.

{:else}
 
În această secțiune vom analiza mai detaliat crearea și utilizarea unui model. Vom utiliza clasa `TFAutoModel`, care este utilă atunci când doriți să instanțați un model dintr-un checkpoint.

Clasa `TFAutoModel` și toate clasele înrudite cu aceasta sunt de fapt simple wrappere ale gamei largi de modele disponibile în bibliotecă. Este un wrapper inteligent, deoarece poate ghici automat arhitectura modelului corespunzător pentru checkpoint-ul dumneavoastră și apoi instanțiază un model cu această arhitectură.

{/if}

Cu toate acestea, dacă știți ce tip de model doriți să utilizați, puteți folosi direct clasa care definește arhitectura acestuia. Să aruncăm o privire la modul în care funcționează acest lucru cu un model BERT.

## Crearea unui Transformer[[crearea-unui-transformer]]

Primul lucru pe care va trebui să îl facem pentru a inițializa un model BERT este să încărcăm un obiect de configurare:

{#if fw === 'pt'}
```py
from transformers import BertConfig, BertModel

# Construirea configurației
config = BertConfig()

# Construirea modelului pornind de la configurație
model = BertModel(config)
```
{:else}
```py
from transformers import BertConfig, TFBertModel

# Construirea configurației
config = BertConfig()

#  Construirea modelului pornind de la configurație
model = TFBertModel(config)
```
{/if}

Configurația conține multe atribute care sunt utilizate pentru a construi modelul:

```py
print(config)
```

```python out
BertConfig {
  [...]
  "hidden_size": 768,
  "intermediate_size": 3072,
  "max_position_embeddings": 512,
  "num_attention_heads": 12,
  "num_hidden_layers": 12,
  [...]
}
```

Deși nu ați văzut încă ce fac toate aceste atribute, ar trebui să recunoașteți unele dintre ele: atributul `hidden_size` definește dimensiunea vectorului `hidden_states`, iar `num_hidden_layers` definește numărul de straturi pe care le are modelul Transformer.

### Diferite metode de încărcare[[diferite-metode-de-încărcare]]

Crearea unui model din configurația implicită îl inițializează cu valori aleatorii:


{#if fw === 'pt'}
```py
from transformers import BertConfig, BertModel

config = BertConfig()
model = BertModel(config)

# Modelul este inițializat aleatoriu!
```
{:else}
```py
from transformers import BertConfig, TFBertModel

config = BertConfig()
model = TFBertModel(config)

# Modelul este inițializat aleatoriu!
```
{/if}

Modelul poate fi utilizat în această stare, dar va produce rezultate neclare; mai întâi trebuie să fie antrenat. Am putea antrena modelul de la zero pentru sarcina în cauză, dar, după cum ați văzut în [Capitolul 1](/course/chapter1), acest lucru ar necesita mult timp și o mulțime de date și ar avea un impact semnificativ asupra mediului. Pentru a evita efortul inutil, este esențial să puteți partaja și reutiliza modelele care au fost deja antrenate.

Încărcarea unui model Transformer care este deja instruit este simplă - putem face acest lucru utilizând metoda `from_pretrained()`, care este analogă metodei `from_pretrained()` în PyTorch:

{#if fw === 'pt'}
```py
from transformers import BertModel

model = BertModel.from_pretrained("bert-base-cased")
```

După cum ați văzut mai devreme, am putea înlocui `BertModel` cu clasa `AutoModel` echivalentă. Vom face acest lucru în continuare, deoarece acest lucru produce un cod independent de checkpoint-uri; dacă codul dumneavoastră funcționează pentru un checkpoint, ar trebui să funcționeze fără probleme pentru altul. Acest lucru este valabil chiar dacă arhitectura este diferită, atât timp cât checkpoint-ul a fost instruit pentru o sarcină similară (de exemplu, o sarcină de analiză a sentimentelor).

{:else}
```py
from transformers import TFBertModel

model = TFBertModel.from_pretrained("bert-base-cased")
```

După cum ați văzut mai devreme, am putea înlocui `BertModel` cu clasa `AutoModel` echivalentă. Vom face acest lucru în continuare, deoarece acest lucru produce un cod independent de checkpoint-uri; dacă codul dumneavoastră funcționează pentru un checkpoint, ar trebui să funcționeze fără probleme pentru altul. Acest lucru este valabil chiar dacă arhitectura este diferită, atât timp cât checkpoint-ul a fost instruit pentru o sarcină similară (de exemplu, o sarcină de analiză a sentimentelor).

{/if}

În exemplul de cod de mai sus nu am utilizat `BertConfig` și, în loc de acesta, am încărcat un model preantrenat prin intermediul identificatorului `bert-base-cased`. Acesta este un checkpoint al modelului care a fost antrenat chiar de autorii BERT; puteți găsi mai multe detalii despre acesta în [model card](https://huggingface.co/bert-base-cased).

Acest model este acum inițializat cu toate weight-urile din checkpoint. Acesta poate fi utilizat direct pentru inferență pe sarcinile pe care a fost antrenat și poate fi, de asemenea, ajustat pe o sarcină nouă. Prin antrenarea cu weight-uri preantrenate în prealabil, putem obține rapid rezultate bune.

Greutățile au fost descărcate și stocate în memorie cache (astfel încât apelurile viitoare la metoda `from_pretrained()` nu le vor descărca din nou) în folderul cache, care are ca valoare implicită *~/.cache/huggingface/transformers*. Puteți personaliza folderul cache prin setarea variabilei de mediu `HF_HOME`.

Identificatorul utilizat pentru încărcarea modelului poate fi identificatorul oricărui model de pe Model Hub, atâta timp cât acesta este compatibil cu arhitectura BERT. Lista completă a checkpoint-urilor BERT disponibile poate fi găsită [aici](https://huggingface.co/models?filter=bert).


### Metode de salvare[[metode-de-salvare]]

Salvarea unui model este la fel de ușoară ca încărcarea unuia - folosim metoda `save_pretrained()`, care este analogă metodei `from_pretrained()`:

```py
model.save_pretrained("directory_on_my_computer")
```

Se salvează două fișiere pe disc:

{#if fw === 'pt'}
```
ls directory_on_my_computer

config.json pytorch_model.safetensors
```
{:else}
```
ls directory_on_my_computer

config.json tf_model.h5
```
{/if}

Dacă aruncați o privire la fișierul *config.json*, veți recunoaște atributele necesare pentru construirea arhitecturii modelului. Acest fișier conține, de asemenea, unele metadate, cum ar fi locul de origine al checkpoint-ului și ce versiune 🤗 Transformers ați folosit când ați salvat ultima dată checkpoint-ul.

{#if fw === 'pt'}
 
Fișierul *pytorch_model.safetensors* este cunoscut sub numele de *state dictionary*; acesta conține toate weight-urile modelului dumneavoastră. Cele două fișiere merg mână în mână; configurația este necesară pentru a cunoaște arhitectura modelului, în timp ce weight-urile modelului sunt parametrii modelului.

{:else}
 
Fișierul *tf_model.h5* este cunoscut sub numele de *state dictionary*; acesta conține toate weight-urile modelului dumneavoastră. Cele două fișiere merg mână în mână; configurația este necesară pentru a cunoaște arhitectura modelului, în timp ce weight-urile modelului sunt parametrii modelului.

{/if}

## Utilizarea unui model Transformer pentru inferență[[utilizarea-unui-model-transformer-pentru-inferență]]


Acum că știți cum să încărcați și să salvați un model, să încercăm să îl folosim pentru a face câteva predicții. Modelele Transformer pot procesa doar numere - numere pe care le generează tokenizatorul. Dar înainte de a discuta despre tokenizeri, să explorăm ce intrări acceptă modelul.

Tokenizerii se pot ocupa de transformarea intrărilor în tensori ai framework-ului corespunzător, dar pentru a vă ajuta să înțelegeți ce se întâmplă, vom arunca o privire rapidă la ceea ce trebuie făcut înainte de trimiterea intrărilor către model.

Să spunem că avem câteva secvențe:

```py
sequences = ["Hello!", "Cool.", "Nice!"]
```

Tokenizatorul le convertește în indici de vocabular care sunt denumiți în mod obișnuit *input IDs*. Fiecare secvență este acum o listă de numere! Rezultatul este:

```py no-format
encoded_sequences = [
    [101, 7592, 999, 102],
    [101, 4658, 1012, 102],
    [101, 3835, 999, 102],
]
```

Aceasta este o listă de secvențe codificate: o listă de liste. Tensorii acceptă numai forme dreptunghiulare (gândiți-vă la matrici). Acest "array" are deja o formă dreptunghiulară, astfel încât convertirea sa într-un tensor este ușoară:

{#if fw === 'pt'}
```py
import torch

model_inputs = torch.tensor(encoded_sequences)
```
{:else}
```py
import tensorflow as tf

model_inputs = tf.constant(encoded_sequences)
```
{/if}

### Utilizarea tensorilor ca intrări în model[[utilizarea-tensorilor-ca-intrări-în-model]]

Utilizarea tensorilor cu ajutorul modelului este extrem de simplă - trebuie doar să apelăm modelul cu intrările:

```py
output = model(model_inputs)
```

Deși modelul acceptă o mulțime de argumente diferite, doar ID-urile de intrare sunt necesare. Vom explica mai târziu ce fac celelalte argumente și când sunt necesare, 
dar mai întâi trebuie să aruncăm o privire mai atentă la tokenizerii care construiesc intrările pe care un model Transformer le poate înțelege.

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter2/3.mdx" />