# Crearea unui card de model[[building-a-model-card]]


<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

Model card-ul este un fișier care este la fel de important ca și fișierele de model si tokenizer dintr-un repositoriu. Este definiția centrală a modelului, asigurând reutilizarea de către membrii comunității și reproducerea rezultatelor, oferind o platformă pe care alți membri pot construi artefactele lor.

Documentarea procesului de antrenare și evaluare ajută pe ceilalți să înțeleagă la ce să aștepte de la un model - iar oferirea informațiilor suficiente referitoare la datele folosite si preprocesarea acestora (înainte și după antrenare) vor ajuta la identificarea și înțelegerea limitelor, biasurile și contextului în care modelul este și nu este folositor.

Prin urmare, crearea unui model card care definește modelul dvs. este un pas foarte important. Aici, oferim câteva sfaturi care v-ar putea ajuta în acest sens. Crearea model cardului se face prin intermediul fișierului `README.md`, pe care l-ați văzut anterior, care este un fișier Markdown.

Conceptul de "model card" provine dintr-o direcție de cercetare a Google, publicată inițial în articolul ["Model Cards for Model Reporting"](https://arxiv.org/abs/1810.03993) scrisă de Margaret Mitchell et al. O parte semnificativă dintre informațiile conținute aici sunt bazate pe acest articol, iar noi vă recomandăm să verificați dacă doriți să înțelegeți de ce model cardurile sunt atât importante într-o lume care valorifică reproducerea, reutilizarea și echitatea.

Model cardul începe cu o prezentare scurtă și generală a ceea ce este modelul - urmată de detalii suplimentare în secțiunile următoare:

- Descrierea modelului
- Utilizări intenționate și limitările modelului
- Cum se utilizează
- Limitări și bias
- Datele de antrenare
- Procedura de antrenare
- Rezultatele evaluării

Hai să vedem ce ar trebui să conțină fiecare dintre aceste secțiuni.

### Descrierea modelului[[model-description]]

Secțiunea de descriere a modelului conține detalii generale despre model. Aceasta include arhitectura, versiunea, dacă a fost introdus într-un articol științific, dacă este disponibilă o implementare originală, autorul și informații generale despre model. Orice drepturi de autor ar trebui să fie atribuite în această secțiune. Informația generală despre procedurile de antrenare, parametrii și avertismente pot fi menționate aici.

### Utilizări intenționate și limitările modelului[[intended-uses-limitations]]

Aici descrieți utilizările pentru care modelul este destinat - inclusiv limba și domeniile unde se poate aplica. Această secțiune din model card poate documenta și zone cunoscute ca nefiind în scopul modelului sau unde este probabil să funcționeze suboptimal.

### Cum se utilizează[[how-to-use]]

Acesta secțiune ar trebui să includă exemple despre cum să utilizați modelul. Acest lucru poate prezenta utilizarea funcției `pipeline()`, utilizarea claselor de model si tokenizer, și orice cod care credeți că ar putea fi util.

### Datele de antrenare[[training-data]]

Această secțiune trebuie să indice datasetul(urile) folosit pentru instruirea modelului. O descriere scurtă a datasetului(urilor) este binevenită.

### Procedura de antrenare[[training-procedure]]

Aici descrieți toate aspectele relevante ale antrenarii care sunt utile din punct de vedere al reproducerii. Acest lucru include orice preprocessing sau postprocessing efectuat pe date, precum și detalii ca numărul de epoci pe care a fost antrenat modelul, dimensiunea batch-ului, learning rateul și alte astfel de detalii.

### Variabilele si metrice[[variable-and-metrics]]

Aici descrieți metricile utilizate la evaluarea rezultatelor, precum și diferite aspecte pe care le măsurați. Menționați metricile folosite, pe ce dataset și care dataset split, astfel încât să fie ușor de comparat performanțele modelului cu cele ale altor modele.

### Rezultatele evaluării[[evaluation-results]]

În sfârșit, indicați cum s-a comportat modelul pe datasetul de evaluare. Dacă modelul foloseste un decision threshold, atunci includeți acest decision threshold în secțiunea respectivă - sau explicați că rezultatele sunt prezentate la diferite threshold-uri pentru utilizările preconizate.

## Exemplu[[example]]

Aici puteți găsi câteva exemple ale unor Model Card:

- [`bert-base-cased`](https://huggingface.co/bert-base-cased)
- [`gpt2`](https://huggingface.co/gpt2)
- [`distilbert`](https://huggingface.co/distilbert-base-uncased)

Câteva exemple din alte organizații și companii pot fi găsite [aici](https://github.com/huggingface/model_card/blob/master/examples.md).

## Notă[[note]]

Model cardurile nu sunt o cerință obligatorie când se publică modelele și nu este necesar să includeți toate secțiunile descrise mai sus în Model Card. Cu toate acestea, documentarea explicită a modelului poate beneficia utilizatorilor viitori, deci vă recomandăm să completați cât mai multe dintre secțiuni.

## Metadatele cardului de model[[model-card-metadata]]

Dacă ați explorat puțin Hugging Face Hub atunci ar trebui să fi văzut că anumite modele aparțin anumitor categorii: puteți filtra acestea după diverse domenii. Categoriile modelului sunt identificate prin metadata adăugată în secțiunea de header a cardului.

Spre exemplu, dacă vă uitați la modelul [`camembert-base`](https://huggingface.co/camembert-base/blob/main/README.md) atunci veți observa următoarea linii din headerul cardului:

```
---
language: fr
license: mit
datasets:
- oscar
---
```

Metadatele acestei secțiuni sunt analizate de Hugging Face Hub, care apoi identifică acest model ca fiind un model francez, cu licență MIT și antrenat pe datasetul Oscar.

[Toate specificările cardului](https://github.com/huggingface/hub-docs/blame/main/modelcard.md) permite specificarea a mai multor metadate, inclusiv limba, licența, etichetele, dataseturile folosite la antrenare și metricile evaluate.

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter4/4.mdx" />