# Caracteristici avansate ale Interface[[advanced-interface-features]]

<CourseFloatingBanner chapter={9}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section6.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section6.ipynb"},
]} />

Acum că putem construi și partaja o interfață de bază, să explorăm câteva caracteristici mai avansate precum starea și interpretarea.

### Folosirea stării pentru a persista datele[[using-state-to-persist-data]]

Gradio are suport pentru *starea sesiunii*, unde datele persistă prin multiple trimiteri într-o
încărcare de pagină. Starea sesiunii este utilă pentru construirea demo-urilor, de exemplu, chatbot-uri unde doriți să
persistați datele pe măsură ce utilizatorul interacționează cu modelul. Rețineți că starea sesiunii nu partajează datele între diferiți utilizatori ai modelului dvs.

Pentru a stoca date într-o stare de sesiune, trebuie să faceți trei lucruri:

1. Transmiteți un *parametru suplimentar* în funcția dvs., care reprezintă starea interfeței.
1. La sfârșitul funcției, returnați valoarea actualizată a stării ca o *valoare de returnare suplimentară*.
1. Adăugați componentele de intrare 'state' și ieșire 'state' când creați `Interface`-ul dvs.

Vedeți exemplul de chatbot de mai jos:

```py
import random

import gradio as gr


def chat(message, history):
    history = history or []
    if message.startswith("How many"):
        response = random.randint(1, 10)
    elif message.startswith("How"):
        response = random.choice(["Great", "Good", "Okay", "Bad"])
    elif message.startswith("Where"):
        response = random.choice(["Here", "There", "Somewhere"])
    else:
        response = "I don't know"
    history.append((message, response))
    return history, history


iface = gr.Interface(
    chat,
    ["text", "state"],
    ["chatbot", "state"],
    allow_screenshot=False,
    allow_flagging="never",
)
iface.launch()
```

<iframe src="https://course-demos-Chatbot-Demo.hf.space" frameBorder="0" height="350" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Observați cum starea componentei de ieșire persistă prin trimiteri.
Notă: puteți transmite o valoare implicită la parametrul state,
care este folosită ca valoarea inițială a stării.

### Folosirea interpretării pentru a înțelege predicțiile[[using-interpretation-to-understand-predictions]]

Majoritatea modelelor de machine learning sunt cutii negre și logica internă a funcției este ascunsă de utilizatorul final. Pentru a încuraja transparența, am făcut foarte ușor să adăugați interpretare la modelul dvs. prin simpla setare a cuvântului cheie interpretation în clasa Interface la default. Aceasta permite utilizatorilor dvs. să înțeleagă ce părți ale intrării sunt responsabile pentru ieșire. Aruncați o privire la interfața simplă de mai jos care arată un clasificator de imagini care include și interpretare:

```py
import requests
import tensorflow as tf

import gradio as gr

inception_net = tf.keras.applications.MobileNetV2()  # load the model

# Download human-readable labels for ImageNet.
response = requests.get("https://git.io/JJkYN")
labels = response.text.split("\n")


def classify_image(inp):
    inp = inp.reshape((-1, 224, 224, 3))
    inp = tf.keras.applications.mobilenet_v2.preprocess_input(inp)
    prediction = inception_net.predict(inp).flatten()
    return {labels[i]: float(prediction[i]) for i in range(1000)}


image = gr.Image(shape=(224, 224))
label = gr.Label(num_top_classes=3)

title = "Gradio Image Classifiction + Interpretation Example"
gr.Interface(
    fn=classify_image, inputs=image, outputs=label, interpretation="default", title=title
).launch()
```

Testați funcția de interpretare prin trimiterea unei intrări apoi făcând clic pe Interpret sub componenta de ieșire.

<iframe src="https://course-demos-gradio-image-interpretation.hf.space" frameBorder="0" height="570" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Pe lângă metoda de interpretare implicită pe care o oferă Gradio, puteți specifica și `shap` pentru parametrul `interpretation` și să setați parametrul `num_shap`. Aceasta folosește interpretarea bazată pe Shapley, despre care puteți citi mai multe [aici](https://christophm.github.io/interpretable-ml-book/shap.html).
În final, puteți transmite și propria funcție de interpretare în parametrul `interpretation`. Vedeți un exemplu în pagina de început a Gradio [aici](https://gradio.app/getting_started/).

Aceasta încheie explorarea noastră profundă a clasei `Interface` din Gradio. Așa cum am văzut, această clasă face simplu să creați demo-uri de machine learning în câteva linii de cod Python. Cu toate acestea, uneori veți dori să personalizați demo-ul prin schimbarea layout-ului sau înlănțuirea mai multor funcții de predicție împreună. Nu ar fi frumos dacă am putea cumva să împărțim `Interface`-ul în "blocuri" personalizabile? Din fericire, se poate! Aceasta este tema secțiunii finale. 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter9/6.mdx" />