# Введение

Добро пожаловать на курс от Hugging Face! Это введение поможет настроить рабочее окружение. Если вы только начинаете курс, мы рекомендуем сначала заглянуть в [Главу 1](../chapter1/1), затем вернуться и настроить среду, чтобы попробовать запустить код самостоятельно. 

Все библиотеки, которые мы будем использовать в этом курсе, доступны в качестве Python-пакетов. В этом уроке мы покажем, как установить окружение и необходимые библиотеки.

Мы рассмотрим два пути настройки окружения: с использованием Google Colab и виртуального окружения Python. Можно выбрать любой из вариантов, исходя из собственных предпочтений. Если вы начинающий, то лучше начать с Google Colab. 

Если вы пользуетесь операционной системой Windows, то мы рекомендуем сразу использовать Google Colab, т.к. мы не будем рассматривать эту операционную систему в качестве платформы для работы. Если вы используете Linux или MacOS, то можно воспользоваться любым из описанных здесь подходов. 

Для прохождения курса вам понадобится аккаунт на Hugging Face, бесплатно можно зарегистрироваться здесь: [создать учетную запись](https://huggingface.co/join).

## Использование Colab

Использование Colab – самый простой вариант: просто загрузите блокнот в браузере и приступайте к работе! 

Если вы не знакомы с Google Colab, то мы рекомендуем начать с изучения [Введения](https://colab.research.google.com/notebooks/intro.ipynb). Colab позволяет использовать более мощную аппаратную базу (GPU - видеокарты, TPU - тензорные процессоры) и он бесплатен для небольших нагрузок. 

Как только вы освоитесь в Colab, создайте новый блокнот:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="An empty colab notebook" width="80%"/>
</div>

Следующий шаг - установка библиотек, которые мы будем использовать в курсе. В качестве менеджера пакетов будет использоваться `pip`. Для запуска системной команды в ячейке блокнота необходимо в самом начале дописать символ `!`. Библиотеку  🤗 Transformers можно установить так: 

```
!pip install transformers
```

Вы можете удостовериться, что библиотека установилась, просто сделав ее импорт: 

```
import transformers
```

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>

Это установка самой базовой версии 🤗 Transformers. В частности, никаких библиотек машинного обучения (например, PyTorch или TensorFloat) установлено не будет. Так как мы будем использовать множество различных возможностей библиотеки 🤗 Transformers, мы рекомендуем установить версию для разработчиков, в состав которой сразу входят все необходимые зависимости:  

```
!pip install transformers[sentencepiece]
```

Это займет определенное время, но сразу после установки вы будете готовы двигаться дальше!

## Использование виртуального окружения Python

Если вы хотите использовать виртуальное окружение Python, сначала необходимо установить Python. Мы рекомендуем использовать [эти инструкции](https://realpython.com/installing-python/) для установки. 

После установки Python у вас появится возможность запускать Python-команды в терминале. Прежде чем переходить дальше, запустите в терминале команду `python --version`. В результате должна быть распечатана версия Python, доступная для работы. 

Когда вы запускаете Python-команду в терминале (например, `python --version`), эту команду обрабатывает _основной_ Python-интерпретатор вашей системы. Мы не рекомендуем устанавливать в его окружение дополнительные библиотеки, лучше для каждого проекта создавать отдельное виртуальное окружение. Каждый проект будет обладать собственными зависимостями и пакетами, если проекты будут в разных окружениях, то вам меньше придется следить за совместимостью библиотек. 

В Python такой подход можно реализовать с помощью разных библиотек, а подробнее об окружениях можно почитать [тут](https://docs.python.org/3/tutorial/venv.html). Каждое окружение будет содержать в себе необходимую версию языка и набор библиотек. Все эти окружения изолированы друг от друга. Среди самых популярных инструментов для работы с виртуальными окружениями можно отметить [`venv`](https://docs.python.org/3/library/venv.html#module-venv).

Для начала создайте папку в домашней директории, в которой будут храниться ваши файлы курса (ее можно назвать произвольным именем, например, *transformers-course*): 

```
mkdir ~/transformers-course
cd ~/transformers-course
```
Находясь в директории *transformers-course*, создайте виртуальное окружение с использованием `venv`: 

```
python -m venv .env
```

Теперь в папке должна появиться директория с именем *.env*: 

```
ls -a
```

```out
.      ..    .env
```

Переключаться между окружениями можно с помощью команд `activate` и `deactivate`: 

```
# Активировать виртуальное окружение
source .env/bin/activate

# Деактивировать окружение
deactivate
```

Вы можете убедиться, что окружение активировано с помощью команды `which python`: если ее результат указывает на виртуальное окружение, значит, вы успешно активировали его!

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

### Установка зависимостей

Как и в предыдущем разделе, посвященном Google Colab, вам необходимо установить библиотеку 🤗 Transformers(желательно, версию для разработчиков) с помощью менеджера `pip`: 

```
pip install "transformers[sentencepiece]"
```

Теперь все установлено! Двигаемся дальше!


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ru/chapter0/1.mdx" />