# Тест в конце главы[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

### 1. Каков порядок работы конвейера языкового моделирования?

<Question
	choices={[
		{
			text: "Сначала модель, которая обрабатывает текст и возвращает необработанные прогнозы. Затем токенизатор осмысливает эти предсказания и при необходимости преобразует их обратно в текст.",
			explain: "Модель не может понять текст! Токенизатор должен сначала обработать текст и преобразовать его в идентификаторы, чтобы он был понятен модели."
		},
		{
			text: "Сначала работает токенизатор, который обрабатывает текст и возвращает идентификаторы. Модель обрабатывает эти идентификаторы и выдает прогноз, который может представлять собой некоторый текст.",
			explain: "Прогноз модели не может сразу стать текстом. Для преобразования прогноза в текст необходимо использовать токенизатор!"
		},
		{
			text: "Токенизатор обрабатывает текст и возвращает идентификаторы. Модель обрабатывает эти идентификаторы и выдает прогноз. Затем токенизатор можно снова использовать для преобразования этих прогнозов обратно в текст.",
			explain: "Правильно! Токенизатор может использоваться как для токенизации, так и для де-токенизации.",
            correct: true
		}
	]}
/>

### 2. Сколько измерений имеет тензор, выводимый базовой моделью Transformer, и каковы они?

<Question
	choices={[
		{
			text: "2: Длина последовательности и размер батча",
			explain: "Неверно! Тензор, выводимый моделью, имеет третье измерение: скрытый размер."
		},
		{
			text: "2: Длина последовательности и скрытый размер",
			explain: "Неверно! Все модели Transformer работают с батчами, даже с одной последовательностью; размер батча будет равен 1!"
		},
		{
			text: "3: Длина последовательности, размер батча и скрытый размер",
			explain: "Верно!",
            correct: true
		}
	]}
/>

### 3. Что из перечисленного ниже является примером токенизации по подсловам?

<Question
	choices={[
		{
			text: "WordPiece",
			explain: "Да, это один из примеров токенизации по подсловам!",
            correct: true
		},
		{
			text: "Посимвольная токенизация",
			explain: "Токенизация по символам не является разновидностью токенизации по подсловам."
		},
		{
			text: "Разделение по пробелам и пунктуации",
			explain: "Это схема токенизации по подсловам!"
		},
		{
			text: "BPE",
			explain: "Да, это один из примеров токенизации по подсловам!",
            correct: true
        },
		{
			text: "Unigram",
			explain: "Да, это один из примеров токенизации по подсловам!",
            correct: true
        },
		{
			text: "Ничего из вышеперечисленного",
			explain: "Неверно!"
        }
	]}
/>

### 4. Что такое голова модели?

<Question
	choices={[
		{
			text: "Компонент базовой сети Transformer, который перенаправляет тензоры на корректные слои",
			explain: "Неверно! Такого компонента не существует."
		},
		{
			text: "Также известный как механизм самовнимания, он адаптирует представление токена в соответствии с другими токенами последовательности",
			explain: "Неверно! Слой самовнимания действительно содержит \"головы\" внимания, но это не головы адаптации."
		},
		{
			text: "Дополнительный компонент, обычно состоящий из одного или нескольких слоев, для преобразования прогнозов трансформера в специфический для конкретной задачи выход",
			explain: "Именно так. Адаптационные головы, также известные просто как головы, встречаются в разных формах: головы языкового моделирования, головы ответов на вопросы, головы классификации последовательностей... ",
			correct: true
		} 
	]}
/>

{#if fw === 'pt'}
### 5. Что такое AutoModel?

<Question
	choices={[
		{
			text: "Модель, которая автоматически обучается на ваших данных",
			explain: "Неверно. Вы не путаете это с нашим продуктом <a href='https://huggingface.co/autotrain'>AutoTrain</a>?"
		},
		{
			text: "Объект, возвращающий правильную архитектуру на основе контрольной точки",
			explain: "Именно: в <code>AutoModel</code> для возврата правильной архитектуры достаточно знать контрольную точку, с которой нужно инициализироваться.",
			correct: true
		},
		{
			text: "Модель, которая автоматически определяет язык, используемый для входов, чтобы загрузить правильные веса",
			explain: "Неверно; хотя некоторые контрольные точки и модели способны работать с несколькими языками, встроенных инструментов для автоматического выбора контрольной точки в зависимости от языка не существует. Вам следует обратиться в <a href='https://huggingface.co/models'>Model Hub</a>, чтобы найти лучшую контрольную точку для вашей задачи!"
		} 
	]}
/>

{:else}
### 5. Что такое TFAutoModel?

<Question
	choices={[
		{
			text: "Модель, которая автоматически обучается на ваших данных",
			explain: "Неправильно. Вы путаете это с нашим продуктом <a href='https://huggingface.co/autotrain'>AutoTrain</a>?"
		},
		{
			text: "Объект, возвращающий правильную архитектуру на основе контрольной точки",
			explain: "Именно так: в <code>TFAutoModel</code> для возврата правильной архитектуры достаточно знать контрольную точку, с которой нужно инициализироваться.",
			correct: true
		},
		{
			text: "Модель, которая автоматически определяет язык, используемый на входах, чтобы загрузить правильные веса",
			explain: "Неверно; хотя некоторые контрольные точки и модели способны работать с несколькими языками, встроенных инструментов для автоматического выбора контрольной точки в зависимости от языка не существует. Вам следует обратиться в <a href='https://huggingface.co/models'>Model Hub</a>, чтобы найти лучшую контрольную точку для вашей задачи!"
		} 
	]}
/>

{/if}

### 6. На какие техники следует обратить внимание при объединении в батч последовательностей разной длины?

<Question
	choices={[
		{
			text: "Усечение (truncating)",
			explain: "Да, усечение - это правильный способ выровнять последовательности так, чтобы они вписывались в прямоугольную форму. Но разве это единственный способ?",
			correct: true
		},
		{
			text: "Возврат тензоров",
			explain: "Хотя другие методы позволяют возвращать прямоугольные тензоры, возвращение тензоров не поможет при объединении последовательностей в батч."
		},
		{
			text: "Дополнение (padding)",
			explain: "Да, дополнение - это правильный способ выровнять последовательности так, чтобы они вписывались в прямоугольную форму. Но разве это единственный способ?",
			correct: true
		}, 
		{
			text: "Маскирование внимания (attention masking)",
			explain: "Обязательно! Маски внимания имеют первостепенное значение при работе с последовательностями разной длины. Однако это не единственная техника, о которой следует помнить.",
			correct: true
		} 
	]}
/>

### 7. В чем смысл применения функции SoftMax к логитам, выводимым моделью классификации последовательностей?

<Question
	choices={[
		{
			text: "Она смягчает логиты, чтобы они были более надежными.",
			explain: "Нет, функция SoftMax не влияет на достоверность результатов."
		},
		{
			text: "Она применяет нижнюю и верхнюю границы, чтобы они были понятны.",
			explain: "Правильно! Результирующие значения ограничены между 0 и 1. Однако это не единственная причина, по которой мы используем функцию SoftMax.",
            correct: true
		},
		{
			text: "Общая сумма вывода равна 1, что позволяет получить вероятностную интерпретацию.",
			explain: "Правильно! Однако это не единственная причина, по которой мы используем функцию SoftMax.",
            correct: true
		}
	]}
/>

### 8. Какой метод является основным в API токенизатора?

<Question
	choices={[
		{
			text: "<code>encode</code>, поскольку он может кодировать текст в идентификаторы и идентификаторы в прогнозы.",
			explain: "Неверно! Если метод <code>encode</code> существует в токенизаторах, то в моделях его нет."
		},
		{
			text: "Вызов объекта токенизатора напрямую.",
			explain: "Точно! Метод <code>__call__</code> токенизатора - это очень мощный метод, который может обрабатывать практически все. Это также метод, используемый для получения прогнозов из модели.",
			correct: true
		},
		{
			text: "<code>pad</code>",
			explain: "Неверно! Дополнение очень полезно, но это всего лишь одна из частей API токенизатора."
		},
		{
			text: "<code>tokenize</code>",
			explain: "Метод <code>tokenize</code>, пожалуй, один из самых полезных методов, но он не является ядром API токенизатора."
		}
	]}
/>

### 9. Что содержит переменная `result` в этом примере кода?

```py
from transformers import AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
result = tokenizer.tokenize("Hello!")
```

<Question
	choices={[
		{
			text: "Список строк, каждая из которых является токеном",
			explain: "Конечно! Преобразуйте это в идентификаторы и отправьте их в модель!",
            correct: true
		},
		{
			text: "Список идентификаторов",
			explain: "Неверно; для этого и нужен метод <code>__call__</code> или <code>convert_tokens_to_ids</code>!"
		},
		{
			text: "Строка, содержащая все токены",
			explain: "Это было бы неоптимально, поскольку цель состоит в том, чтобы разбить строку на множество токенов."
		}
	]}
/>

{#if fw === 'pt'}
### 10. Есть ли что-то неправильное в следующем коде?

```py
from transformers import AutoTokenizer, AutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = AutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "Нет, кажется, все правильно.",
			explain: "К сожалению, сопряжение модели с токенизатором, который был обучен на другой контрольной точке, редко бывает хорошей идеей. Модель не была обучена извлекать смысл из вывода этого токенизатора, поэтому вывод модели (если она вообще сможет работать!) не будет иметь никакого смысла."
		},
		{
			text: "Токенизатор и модель всегда должны быть из одной контрольной точки.",
			explain: "Правильно!",
            correct: true
		},
		{
			text: "Хорошей практикой является дополнении и усечении с помощью токенизатора, поскольку каждый вход - это батч.",
			explain: "Действительно, каждый вход модели должен быть батчем. Однако в усечении или дополнении этой последовательности нет смысла, поскольку она только одна, а это техника объединения в батч списка предложений."
		}
	]}
/>

{:else}
### 10. Что-то не так с приведенным ниже кодом?

```py
from transformers import AutoTokenizer, TFAutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = TFAutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "Нет, кажется, все правильно.",
			explain: "К сожалению, сопряжение модели с токенизатором, который был обучен на другой контрольной точке, редко бывает хорошей идеей. Модель не была обучена извлекать смысл из вывода этого токенизатора, поэтому вывод модели (если она вообще сможет работать!) не будет иметь никакого смысла."
		},
		{
			text: "Токенизатор и модель всегда должны быть из одной контрольной точки.",
			explain: "Верно!",
            correct: true
		},
		{
			text: "Хорошей практикой является дополнении и усечении с помощью токенизатора, поскольку каждый вход - это батч.",
			explain: "Действительно, каждый вход модели должен быть батчем. Однако в усечении или дополнении этой последовательности нет смысла, поскольку она только одна, а это техника объединения в батч списка предложений."
		}
	]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ru/chapter2/8.mdx" />