# పరిచయం[[introduction]]

<CourseFloatingBanner chapter={1} classNames="absolute z-10 right-0 top-0" />

## 🤗 కోర్స్‌కు స్వాగతం![[welcome-to-the-course]]

<Youtube id="00GKzGyWFEs" />

ఈ కోర్సు మీకు Large Language Models (LLMs) మరియు Natural Language Processing (NLP) గురించి [Hugging Face](https://huggingface.co/) ఎకోసిస్టమ్‌లోని లైబ్రరీలను — [🤗 Transformers](https://github.com/huggingface/transformers), [🤗 Datasets](https://github.com/huggingface/datasets), [🤗 Tokenizers](https://github.com/huggingface/tokenizers), and [🤗 Accelerate](https://github.com/huggingface/accelerate) — అలాగే [Hugging Face Hub](https://huggingface.co/models) ఉపయోగించి నేర్పుతుంది..

మేము Hugging Face ఎకోసిస్టమ్ వెలుపల ఉన్న లైబ్రరీలను కూడా కవర్ చేస్తాం. ఇవి AI కమ్యూనిటీకి అద్భుతమైన సహకారాలు మరియు చాలా ఉపయోగకరమైన సాధనాలు.

ఇది పూర్తిగా ఉచితం మరియు ప్రకటనలు లేవు.

## NLP మరియు LLMలను అర్థం చేసుకోవడం[[understanding-nlp-and-llms]]

ఈ కోర్సు మొదట NLP (Natural Language Processing) పై దృష్టి సారించినప్పటికీ, ఇది Large Language Models (LLMs) పై దృష్టి సారించడానికి అభివృద్ధి చెందింది, ఇది ఈ రంగంలో తాజా పురోగతిని సూచిస్తుంది.

**తేడా ఏమిటి?**

- **NLP (Natural Language Processing)** అనేది కంప్యూటర్‌లు మానవ భాషను అర్థం చేసుకోవడానికి, వివరించడానికి మరియు రూపొందించడానికి వీలు కల్పించడంపై దృష్టి సారించిన విస్తృత రంగం. NLP సెంటిమెంట్ అనాలిసిస్, నేమ్డ్ ఎంటిటీ రికగ్నిషన్ మరియు మెషిన్ ట్రాన్స్‌లేషన్ వంటి అనేక పద్ధతులు మరియు పనులను కలిగి ఉంటుంది.
- **LLMs (Large Language Models)** అనేవి NLP మోడల్‌లలోని ఒక శక్తివంతమైన ఉపసమితి, వాటి భారీ పరిమాణం, విస్తృతమైన శిక్షణ డేటా మరియు కనీస టాస్క్-నిర్దిష్ట శిక్షణతో విస్తృత శ్రేణి భాషా పనులను చేయగల సామర్థ్యం కలిగి ఉంటాయి. Llama, GPT, లేదా Claude సిరీస్ వంటి మోడల్‌లు NLPలో సాధ్యమయ్యే వాటిని విప్లవాత్మకం చేసిన LLMలకు ఉదాహరణలు.

ఈ కోర్సు అంతటా, మీరు సాంప్రదాయ NLP భావనలు మరియు అత్యాధునిక LLM పద్ధతులు రెండింటి గురించి నేర్చుకుంటారు, ఎందుకంటే LLMలతో సమర్థవంతంగా పనిచేయడానికి NLP యొక్క పునాదులను అర్థం చేసుకోవడం చాలా ముఖ్యం.

## ఏమి ఆశించాలి??[[what-to-expect]]

కోర్సు యొక్క సంక్షిప్త అవలోకనం ఇక్కడ ఉంది:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary.svg" alt="Brief overview of the chapters of the course.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary-dark.svg" alt="Brief overview of the chapters of the course.">
</div>

- అధ్యాయాలు 1 నుండి 4 వరకు 🤗 Transformers లైబ్రరీ యొక్క ప్రధాన భావనలకు పరిచయాన్ని అందిస్తాయి. కోర్సులోని ఈ భాగం ముగిసేనాటికి, మీరు Transformer మోడల్‌లు ఎలా పనిచేస్తాయో పరిచయం చేసుకుంటారు మరియు Hugging Face Hub నుండి మోడల్‌ను ఎలా ఉపయోగించాలి, డేటాసెట్‌పై దాన్ని ఫైన్-ట్యూన్ చేయడం మరియు మీ ఫలితాలను Hubలో పంచుకోవడం ఎలాగో తెలుసుకుంటారు!
- అధ్యాయాలు 5 నుండి 8 వరకు 🤗 Datasets మరియు 🤗 Tokenizers యొక్క ప్రాథమికాంశాలను బోధిస్తాయి, ఆపై క్లాసిక్ NLP పనులు మరియు LLM పద్ధతులలోకి వెళ్తాయి. ఈ భాగం ముగిసేనాటికి, మీరు చాలా సాధారణ భాషా ప్రాసెసింగ్ సవాళ్లను మీరే పరిష్కరించగలరు.
- అధ్యాయం 9 NLPకి మించి మీ మోడల్‌ల డెమోలను 🤗 Hubలో ఎలా నిర్మించాలో మరియు పంచుకోవాలో కవర్ చేస్తుంది. ఈ భాగం ముగిసేనాటికి, మీరు మీ 🤗 Transformers అప్లికేషన్‌ను ప్రపంచానికి ప్రదర్శించడానికి సిద్ధంగా ఉంటారు!
- అధ్యాయాలు 10 నుండి 12 వరకు ఫైన్-ట్యూనింగ్, అధిక-నాణ్యత డేటాసెట్‌లను క్యూరేట్ చేయడం మరియు రీజనింగ్ మోడల్‌లను నిర్మించడం వంటి అధునాతన LLM అంశాలలోకి వెళ్తాయి.

ఈ కోర్సు:

- Python పై మంచి జ్ఞానం అవసరం
- fast.ai యొక్క Practical Deep Learning for Coders లేదా DeepLearning.AI అభివృద్ధి చేసిన ప్రోగ్రామ్‌లలో ఒకటైన పరిచయ డీప్ లెర్నింగ్ కోర్సు తర్వాత తీసుకోవడం మంచిది
- ముందస్తు PyTorch లేదా TensorFlow జ్ఞానం అవసరం లేదు, అయితే వాటిలో ఏదో ఒకదానితో కొంత పరిచయం సహాయపడుతుంది.

మీరు ఈ కోర్సును పూర్తి చేసిన తర్వాత, మీరు DeepLearning.AI యొక్క Natural Language Processing Specializationను పరిశీలించమని సిఫార్సు చేస్తున్నాము, ఇది naive Bayes మరియు LSTMs వంటి విస్తృత శ్రేణి సాంప్రదాయ NLP మోడల్‌లను కవర్ చేస్తుంది, అవి తెలుసుకోవడం చాలా విలువైనవి!

## మేము ఎవరము?[[who-are-we]]

రచయితల గురించి:

[**Abubakar Abid**](https://huggingface.co/abidlabs) స్టాన్‌ఫోర్డ్‌లో అప్లైడ్ మెషిన్ లెర్నింగ్‌లో పీహెచ్‌డీ పూర్తి చేశారు. తన పీహెచ్‌డీ సమయంలో, అతను Gradio అనే ఓపెన్ సోర్స్ పైథాన్ లైబ్రరీని స్థాపించారు, ఇది 600,000 పైగా మెషిన్ లెర్నింగ్ డెమోలను రూపొందించడానికి ఉపయోగించబడింది. Gradio ను Hugging Face కొనుగోలు చేసింది, అక్కడ ఇప్పుడు Abubakar మెషిన్ లెర్నింగ్ టీమ్ లీడ్‌గా పనిచేస్తున్నారు.

[**Ben Burtenshaw**](https://huggingface.co/burtenshaw) Hugging Face లో మెషిన్ లెర్నింగ్ ఇంజనీర్. అతను ఆంట్‌వెర్ప్ విశ్వవిద్యాలయంలో నాచురల్ లాంగ్వేజ్ ప్రాసెసింగ్‌లో పీహెచ్‌డీ పూర్తి చేశారు, అక్కడ అతను అక్షరాస్యత నైపుణ్యాలను మెరుగుపరచడం కోసం పిల్లల కథలను రూపొందించడానికి Transformer మోడల్స్‌ను ఉపయోగించారు. అప్పటి నుండి, అతను విస్తృత సమాజం కోసం విద్యా సామగ్రి మరియు సాధనాలపై దృష్టి పెట్టారు.

[**Matthew Carrigan**](https://huggingface.co/Rocketknight1) Hugging Face లో మెషిన్ లెర్నింగ్ ఇంజనీర్. అతను ఐర్లాండ్‌లోని డబ్లిన్‌లో నివసిస్తున్నారు మరియు గతంలో Parse.ly లో ML ఇంజనీర్‌గా మరియు అంతకు ముందు ట్రినిటీ కాలేజ్ డబ్లిన్‌లో పోస్ట్-డాక్టోరల్ పరిశోధకుడిగా పనిచేశారు. ప్రస్తుత ఆర్కిటెక్చర్లను స్కేల్ చేయడం ద్వారా మనం AGI ని సాధిస్తామని అతను నమ్మరు, కానీ రోబోట్ అమరత్వంపై ఆయనకు గొప్ప ఆశలు ఉన్నాయి.

[**Lysandre Debut**](https://huggingface.co/lysandre) Hugging Face లో మెషిన్ లెర్నింగ్ ఇంజనీర్ మరియు అతను 🤗 Transformers లైబ్రరీ అభివృద్ధి యొక్క ప్రారంభ దశల నుండి పనిచేస్తున్నారు. అతని లక్ష్యం చాలా సులభమైన API తో సాధనాలను అభివృద్ధి చేయడం ద్వారా NLP ని ప్రతిఒక్కరికీ అందుబాటులోకి తీసుకురావడం.

[**Sylvain Gugger**](https://huggingface.co/sgugger) Hugging Face లో రీసెర్చ్ ఇంజనీర్ మరియు 🤗 Transformers లైబ్రరీ యొక్క ప్రధాన నిర్వహణదారులలో ఒకరు. గతంలో అతను fast.ai లో రీసెర్చ్ సైంటిస్ట్, మరియు అతను జెరెమీ హోవార్డ్‌తో కలిసి Deep Learning for Coders with fastai and PyTorch పుస్తకాన్ని సహ-రచించారు. పరిమిత వనరులతో మోడల్స్ వేగంగా శిక్షణ పొందడానికి వీలు కల్పించే టెక్నిక్‌లను రూపొందించడం మరియు మెరుగుపరచడం ద్వారా డీప్ లెర్నింగ్‌ను మరింత అందుబాటులోకి తీసుకురావడం అతని పరిశోధన యొక్క ముఖ్య ఉద్దేశ్యం.

[**Dawood Khan**](https://huggingface.co/dawoodkhan82) Hugging Face లో మెషిన్ లెర్నింగ్ ఇంజనీర్. అతను NYC కి చెందినవాడు మరియు న్యూయార్క్ యూనివర్సిటీలో కంప్యూటర్ సైన్స్ చదివి పట్టభద్రుడయ్యాడు. కొన్ని సంవత్సరాలు ఐఓఎస్ ఇంజనీర్‌గా పనిచేసిన తరువాత, దావూద్ తన సహ-వ్యవస్థాపకులతో కలిసి Gradio ని ప్రారంభించడానికి ఉద్యోగాన్ని విడిచిపెట్టాడు. చివరికి Gradio ని Hugging Face కొనుగోలు చేసింది.

[**Merve Noyan**](https://huggingface.co/merve) Hugging Face లో డెవలపర్ అడ్వకేట్, ప్రతిఒక్కరికీ మెషిన్ లెర్నింగ్‌ను ప్రజాస్వామ్యీకరించడానికి సాధనాలను అభివృద్ధి చేయడం మరియు వాటి చుట్టూ కంటెంట్‌ను నిర్మించడంపై పనిచేస్తున్నారు.

[**Lucile Saulnier**](https://huggingface.co/SaulLu) Hugging Face లో మెషిన్ లెర్నింగ్ ఇంజనీర్, ఓపెన్ సోర్స్ సాధనాల వాడకాన్ని అభివృద్ధి చేయడం మరియు మద్దతు ఇవ్వడం. ఆమె సహకార శిక్షణ మరియు BigScience వంటి నాచురల్ లాంగ్వేజ్ ప్రాసెసింగ్ రంగంలో అనేక పరిశోధన ప్రాజెక్టులలో చురుకుగా పాల్గొంటున్నారు.

[**Lewis Tunstall**](https://huggingface.co/lewtun) Hugging Face లో మెషిన్ లెర్నింగ్ ఇంజనీర్, ఓపెన్-సోర్స్ సాధనాలను అభివృద్ధి చేయడం మరియు వాటిని విస్తృత സമൂഹానికి అందుబాటులోకి తీసుకురావడంపై దృష్టి పెట్టారు. అతను ఓ'రైల్లీ వారి [Natural Language Processing with Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/)పుస్తక సహ-రచయిత కూడా.

[**Leandro von Werra**](https://huggingface.co/lvwerra) Hugging Face లోని ఓపెన్-సోర్స్ బృందంలో మెషిన్ లెర్నింగ్ ఇంజనీర్ మరియు ఓ'రైల్లీ వారి [Natural Language Processing with Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/) పుస్తక సహ-రచయిత కూడా. అతను మొత్తం మెషిన్ లెర్నింగ్ స్టాక్‌లో పనిచేయడం ద్వారా NLP ప్రాజెక్టులను ఉత్పత్తికి తీసుకురావడంలో చాలా సంవత్సరాల పరిశ్రమ అనుభవాన్ని కలిగి ఉన్నాడు.

## తరచుగా అడిగే ప్రశ్నలు (FAQ)[[faq]]

తరచుగా అడిగే ప్రశ్నలకు ఇక్కడ కొన్ని సమాధానాలు ఉన్నాయి:

- **ఈ కోర్సు పూర్తి చేయడం ద్వారా సర్టిఫికేషన్ లభిస్తుందా?**
  ప్రస్తుతానికి ఈ కోర్సుకు ఎలాంటి సర్టిఫికేషన్ లేదు. అయితే, మేము Hugging Face ఎకోసిస్టమ్ కోసం ఒక సర్టిఫికేషన్ కార్యక్రమంపై పనిచేస్తున్నాము -- వేచి ఉండండి!

- **ఈ కోర్సుపై నేను ఎంత సమయం కేటాయించాలి?**
  ఈ కోర్సులోని ప్రతి అధ్యాయం వారానికి సుమారు 6-8 గంటల పనితో, 1 వారంలో పూర్తి చేసేలా రూపొందించబడింది. అయితే, కోర్సును పూర్తి చేయడానికి మీకు అవసరమైనంత సమయం తీసుకోవచ్చు.

- **నాకు ఏదైనా ప్రశ్న ఉంటే, ఎక్కడ అడగాలి?**
  కోర్సులోని ఏదైనా విభాగానికి సంబంధించి మీకు ప్రశ్న ఉంటే, పేజీ పైభాగంలో ఉన్న "Ask a question" (ప్రశ్న అడగండి) బ్యానర్‌పై క్లిక్ చేయండి, అప్పుడు మీరు [Hugging Face forums](https://discuss.huggingface.co/) లోని సరైన విభాగానికి ఆటోమేటిక్‌గా మళ్ళించబడతారు:

<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/forum-button.png" alt="Link to the Hugging Face forums" width="75%">

కోర్సు పూర్తి చేసిన తర్వాత మీరు మరింత ప్రాక్టీస్ చేయాలనుకుంటే, ఫోరమ్‌లలో [ప్రాజెక్ట్ ఐడియాల](https://discuss.huggingface.co/c/course/course-event/25) జాబితా కూడా అందుబాటులో ఉందని గమనించండి.

- **ఈ కోర్సు కోసం కోడ్‌ను ఎలా పొందాలి?**
  ప్రతి విభాగం కోసం, Google Colab లేదా Amazon SageMaker Studio Lab లో కోడ్‌ను రన్ చేయడానికి పేజీ పైభాగంలో ఉన్న బ్యానర్‌పై క్లిక్ చేయండి:

<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/notebook-buttons.png" alt="Link to the Hugging Face course notebooks" width="75%">

కోర్సులోని మొత్తం కోడ్‌ను కలిగి ఉన్న Jupyter నోట్‌బుక్‌లు [`huggingface/notebooks`](https://github.com/huggingface/notebooks) రిపోలో హోస్ట్ చేయబడ్డాయి. మీరు వాటిని స్థానికంగా (locally) రూపొందించాలనుకుంటే, GitHub లోని [`course`](https://github.com/huggingface/course#-jupyter-notebooks) రిపోలోని సూచనలను చూడండి.

- **నేను కోర్సుకు ఎలా సహకరించగలను?**
  కోర్సుకు సహకరించడానికి చాలా మార్గాలు ఉన్నాయి! మీరు ఏదైనా అక్షర దోషం (typo) లేదా బగ్ కనుగొంటే, దయచేసి [`course`](https://github.com/huggingface/course) రిపోలో ఒక ఇష్యూను ఓపెన్ చేయండి. మీరు కోర్సును మీ మాతృభాషలోకి అనువదించడానికి సహాయం చేయాలనుకుంటే, [ఇక్కడ](https://github.com/huggingface/course#translating-the-course-into-your-language) సూచనలను చూడండి.

**ప్రతి అనువాదం కోసం తీసుకున్న నిర్ణయాలు ఏమిటి?**
ప్రతి అనువాదం కోసం, మేము అనువాదంలో తీసుకున్న నిర్ణయాలను వివరించే ఒక `TRANSLATING.txt` ఫైల్‌ను కలిగి ఉన్నాము. ఈ ఫైల్‌లో మేము యంత్ర అభ్యాసం పదజాలం మరియు ఇతర సాంకేతిక పదజాలం కోసం చేసిన ఎంపికలను వివరించాము. ఉదాహరణకు, జర్మన్ కోసం [ఇక్కడ](https://github.com/huggingface/course/blob/main/chapters/de/TRANSLATING.txt) చూడండి.

- **నేను ఈ కోర్సును తిరిగి ఉపయోగించుకోవచ్చా?**
  తప్పకుండా! ఈ కోర్సు అనుమతి గల Apache 2 license క్రింద విడుదల చేయబడింది. దీని అర్థం మీరు తగిన క్రెడిట్ ఇవ్వాలి, లైసెన్సుకు లింక్ అందించాలి, మరియు ఏవైనా మార్పులు చేసినట్లయితే సూచించాలి. మీరు దీనిని ఏ సహేతుకమైన పద్ధతిలోనైనా చేయవచ్చు, కానీ లైసెన్సర్ మిమ్మల్ని లేదా మీ వినియోగాన్ని ఆమోదించినట్లు సూచించే ఏ విధంగానూ చేయకూడదు. మీరు కోర్సును ఉదహరించాలనుకుంటే, దయచేసి ఈ క్రింది BibTeX ను ఉపయోగించండి:

```
@misc{huggingfacecourse,
  author = {Hugging Face},
  title = {The Hugging Face Course, 2022},
  howpublished = "\url{https://huggingface.co/course}",
  year = {2022},
  note = "[Online; accessed <today>]"
}
```

## భాషలు మరియు అనువాదాలు[[languages-and-translations]]

మా అద్భుతమైన కమ్యూనిటీకి ధన్యవాదాలు, ఈ కోర్సు ఇంగ్లీష్‌తో పాటు అనేక ఇతర భాషలలో కూడా అందుబాటులో ఉంది 🔥! ఏయే భాషలు అందుబాటులో ఉన్నాయో మరియు అనువాదాలకు ఎవరు సహకరించారో చూడటానికి దిగువ పట్టికను చూడండి:

| భాష                                                                                      | రచయితలు                                                                                                                                                                                                                    |
| :--------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [French](https://huggingface.co/course/fr/chapter1/1)                                    | [@lbourdois](https://github.com/lbourdois), [@ChainYo](https://github.com/ChainYo), [@melaniedrevet](https://github.com/melaniedrevet), [@abdouaziz](https://github.com/abdouaziz)                                         |
| [Vietnamese](https://huggingface.co/course/vi/chapter1/1)                                | [@honghanhh](https://github.com/honghanhh)                                                                                                                                                                                 |
| [Chinese (simplified)](https://huggingface.co/course/zh-CN/chapter1/1)                   | [@zhlhyx](https://github.com/zhlhyx), [petrichor1122](https://github.com/petrichor1122), [@yaoqih](https://github.com/yaoqih)                                                                                              |
| [Bengali](https://huggingface.co/course/bn/chapter1/1) (పని జరుగుతోంది)                  | [@avishek-018](https://github.com/avishek-018), [@eNipu](https://github.com/eNipu)                                                                                                                                         |
| [German](https://huggingface.co/course/de/chapter1/1) (పని జరుగుతోంది)                   | [@JesperDramsch](https://github.com/JesperDramsch), [@MarcusFra](https://github.com/MarcusFra), [@fabridamicelli](https://github.com/fabridamicelli)                                                                       |
| [Spanish](https://huggingface.co/course/es/chapter1/1) (పని జరుగుతోంది)                  | [@camartinezbu](https://github.com/camartinezbu), [@munozariasjm](https://github.com/munozariasjm), [@fordaz](https://github.com/fordaz)                                                                                   |
| [Persian](https://huggingface.co/course/fa/chapter1/1) (పని జరుగుతోంది)                  | [@jowharshamshiri](https://github.com/jowharshamshiri), [@schoobani](https://github.com/schoobani)                                                                                                                         |
| [Gujarati](https://huggingface.co/course/gu/chapter1/1) (పని జరుగుతోంది)                 | [@pandyaved98](https://github.com/pandyaved98)                                                                                                                                                                             |
| [Hebrew](https://huggingface.co/course/he/chapter1/1) (పని జరుగుతోంది)                   | [@omer-dor](https://github.com/omer-dor)                                                                                                                                                                                   |
| [Hindi](https://huggingface.co/course/hi/chapter1/1) (పని జరుగుతోంది)                    | [@pandyaved98](https://github.com/pandyaved98)                                                                                                                                                                             |
| [Bahasa Indonesia](https://huggingface.co/course/id/chapter1/1) (పని జరుగుతోంది)         | [@gstdl](https://github.com/gstdl)                                                                                                                                                                                         |
| [Italian](https://huggingface.co/course/it/chapter1/1) (పని జరుగుతోంది)                  | [@CaterinaBi](https://github.com/CaterinaBi), [@ClonedOne](https://github.com/ClonedOne), [@Nolanogenn](https://github.com/Nolanogenn), [@EdAbati](https://github.com/EdAbati), [@gdacciaro](https://github.com/gdacciaro) |
| [Japanese](https://huggingface.co/course/ja/chapter1/1) (పని జరుగుతోంది)                 | [@hiromu166](https://github.com/@hiromu166), [@younesbelkada](https://github.com/@younesbelkada), [@HiromuHota](https://github.com/@HiromuHota)                                                                            |
| [Korean](https://huggingface.co/course/ko/chapter1/1) (పని జరుగుతోంది)                   | [@Doohae](https://github.com/Doohae), [@wonhyeongseo](https://github.com/wonhyeongseo), [@dlfrnaos19](https://github.com/dlfrnaos19)                                                                                       |
| [Portuguese](https://huggingface.co/course/pt/chapter1/1) (పని జరుగుతోంది)               | [@johnnv1](https://github.com/johnnv1), [@victorescosta](https://github.com/victorescosta), [@LincolnVS](https://github.com/LincolnVS)                                                                                     |
| [Russian](https://huggingface.co/course/ru/chapter1/1) (పని జరుగుతోంది)                  | [@pdumin](https://github.com/pdumin), [@svv73](https://github.com/svv73)                                                                                                                                                   |
| [Thai](https://huggingface.co/course/th/chapter1/1) (పని జరుగుతోంది)                     | [@peeraponw](https://github.com/peeraponw), [@a-krirk](https://github.com/a-krirk), [@jomariya23156](https://github.com/jomariya23156), [@ckingkan](https://github.com/ckingkan)                                           |
| [Turkish](https://huggingface.co/course/tr/chapter1/1) (పని జరుగుతోంది)                  | [@tanersekmen](https://github.com/tanersekmen), [@mertbozkir](https://github.com/mertbozkir), [@ftarlaci](https://github.com/ftarlaci), [@akkasayaz](https://github.com/akkasayaz)                                         |
| [Chinese (traditional)](https://huggingface.co/course/zh-TW/chapter1/1) (పని జరుగుతోంది) | [@davidpeng86](https://github.com/davidpeng86)                                                                                                                                                                             |

కొన్ని భాషల కోసం, [కోర్సు YouTube వీడియోలలో] (https://youtube.com/playlist?list=PLo2EIpI_JMQvWfQndUesu0nPBAtZ9gP1o) ఆ భాషలో సబ్-టైటిల్స్ ఉన్నాయి. వీడియో యొక్క కుడి దిగువ మూలలో ఉన్న CC బటన్‌పై ముందుగా క్లిక్ చేయడం ద్వారా మీరు వాటిని ప్రారంభించవచ్చు. ఆ తర్వాత, సెట్టింగ్స్ ఐకాన్ ⚙️ క్రింద, Subtitles/CC ఎంపికను ఎంచుకోవడం ద్వారా మీకు కావలసిన భాషను ఎంచుకోవచ్చు.

<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/subtitles.png" alt="Activating subtitles for the Hugging Face course YouTube videos" width="75%">

<Tip>
  పైన పట్టికలో మీ భాష కనిపించలేదా లేదా మీరు ఇప్పటికే ఉన్న అనువాదానికి
  సహకరించాలనుకుంటున్నారా? ఇక్కడ ఉన్న సూచనలను{" "}
  <a href="https://github.com/huggingface/course#translating-the-course-into-your-language">
    ఇక్కడ
  </a>
  అనుసరించడం ద్వారా మీరు కోర్సును అనువదించడానికి మాకు సహాయం చేయవచ్చు.
</Tip>

## ప్రారంభిద్దాం 🚀

మీరు సిద్ధంగా ఉన్నారా? ఈ అధ్యాయంలో, మీరు నేర్చుకుంటారు:

- టెక్స్ట్ జనరేషన్ మరియు వర్గీకరణ వంటి NLP పనులను పరిష్కరించడానికి `pipeline()` ఫంక్షన్‌ను ఎలా ఉపయోగించాలో.
- Transformer నిర్మాణం గురించి.
- ఎన్‌కోడర్, డీకోడర్, మరియు ఎన్‌కోడర్-డీకోడర్ ఆర్కిటెక్చర్ల మధ్య తేడాను మరియు వాటి వినియోగ సందర్భాలను ఎలా గుర్తించాలో.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/te/chapter1/1.mdx" />