# ข้อจำกัดจากอคติของข้อมูล

<CourseFloatingBanner chapter={1}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/th/chapter1/section8.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/th/chapter1/section8.ipynb"},
]} />

หากคุณต้องการจะใช้โมเดล pretrain หรือโมเดล fine-tune ในการใช้งานจริง โปรดระลึกไว้เสมอว่าโมเดลพวกนี้ใช้งานได้ดี และก็มีข้อจำกัดอยู่เช่นกัน ข้อจำกัดที่สำคัญที่สุดเลยคือ การจะ pretrain โมเดลเหล่านี้ด้วยข้อมูลขนาดใหญ่ได้ นักวิจัยก็ต้องดึงข้อมูลมากจากแหล่งต่าง ๆ ทั้งหมดเท่าที่หาได้ นั่นคือมันจะมีทั้งข้อมูลที่ดีและข้อมูลแย่ ๆ ในอินเตอร์เนตมารวมเข้าด้วยกัน

เพื่อให้เห็นภาพ ลองมาดูตัวอย่างการ `fill-mask` ด้วยโมเดล BERT:

```python
from transformers import pipeline

unmasker = pipeline("fill-mask", model="bert-base-uncased")
result = unmasker("This man works as a [MASK].")
print([r["token_str"] for r in result])

result = unmasker("This woman works as a [MASK].")
print([r["token_str"] for r in result])
```

```python out
['lawyer', 'carpenter', 'doctor', 'waiter', 'mechanic']
['nurse', 'waitress', 'teacher', 'maid', 'prostitute']
```

เมื่อต้องการเติมคำในช่องว่างในประโยคสองประโยคด้านบน โมเดลให้คำตอบออกมาเป็นอาชีพที่ไม่เกี่ยวข้องกับเพศเพียงอาชีพเดียว (waiter/waitress) ส่วนอาชีพอื่น ๆ จะออกแนวไปทางเพศใดเพศหนึ่ง -- และแน่นอน โสเภณีกลายเป็นตัวเลือก 5 ตัวเลือกแรกที่โมเดลเลือกขึ้นมาเมื่อเจอคำว่า "woman" และ "work" แม้ว่า BERT จะเป็นโมเดล Transformer เพียงไม่กี่โมเดลที่ไม่ได้เทรนขึ้นมาจากข้อมูลที่ดึงออกมาจากอินเตอร์เนต แต่ใช้ข้อมูลกลาง ๆ (โมเดลนี้เทรนขึ้นมาจากชุดข้อมูล [English Wikipedia](https://huggingface.co/datasets/wikipedia) และ [BookCorpus](https://huggingface.co/datasets/bookcorpus))

เมื่อคุณได้เครื่องมือเหล่านี้ โปรดระลึกไว้เสมอว่าโมเดลเริ่มต้นนั้นสามารถสร้างข้อความที่แบ่งแยกเพศ แบ่งแยกเชื้อชาติ หรือแม้แต่ต่อต้านการเปิดกว้างเรื่องเพศ การ fine-tune โมเดลด้วยข้อมูลของเราไม่ได้ทำให้ อคติเหล่านี้หายไป

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/th/chapter1/8.mdx" />