# คำถามท้ายบท

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

มาทดสอบความรู้ที่คุณได้เรียนในบทนี้กันเถอะ!

### 1. อะไรคือข้อจำกัดของโมเดลบน Hub?

<Question
	choices={[
		{
			text: "โมเดลจาก 🤗 Transformers library",
			explain: "แม้ว่า Hugging Face Hub รับรองโมเดลจาก 🤗 Transformers library แต่นั่นก็ไม่ใช่ทั้งหมดที่มี!"
		},
		{
			text: "ทุกโมเดลที่มีอินเตอร์เฟซเหมือนกับ 🤗 Transformers",
			explain: "ไม่มีข้อบังคับเกี่ยวกับอินเตอร์เฟซเมื่อทำการอัพโหลดโมเดลขึ้นสู่ Hugging Face Hub"
		},
		{
			text: "ไม่มีข้อจำกัดใดๆ",
			explain: "ถูกต้องแล้ว! ไม่มีข้อจำกัดใดๆในการอัพโหลดโมเดลขึ้นสู่ Hub",
			explain: "Right! There are no limits when uploading models to the Hub.",
            correct: true
		},
        {
			text: "โมเดลที่ใช้ได้กับงานประเภท NLP",
			explain: "ไม่มีข้อบังคับเกี่ยวกับประเภทของการใช้งาน!"
		}
	]}
/>

### 2. คุณสามารถจัดการโมเดลบน Hub ได้อย่างไร?

<Question
	choices={[
		{
			text: "ผ่านบัญชี GCP",
			explain: "ไม่ถูกต้อง!"
		},
		{
			text: "ผ่านการกระจายแบบ peer-to-peer",
			explain: "ไม่ถูกต้อง!"
		},
		{
			text: "ผ่าน git และ git-lfs",
			explain: "ถูกต้องแล้ว! โมเดลบน Hub เป็น Git repositories แบบเรียบง่าย มีการใช้งาน <code>git-lfs</code> สำหรับไฟล์ขนาดใหญ่",
            correct: true
		}
	]}
/>

### 3. คุณสามารถใช้ web interface ของ Hugging Face Hub ทำอะไรได้บ้าง? 

<Question
	choices={[
		{
			text: "Fork repository ที่มีอยู่แล้ว",
			explain: "การ Fork repository ไม่สามารถทำได้บน Hugging Face Hub"
		},
		{
			text: "สร้าง model repository ใหม่",
			explain: "ถูกต้องแล้ว! แต่นั้นก็ไม่ใช่ทั้งหมดที่คุณทำได้",
            correct: true
		},
		{
			text: "จัดการและแก้ไขไฟล์",
			explain: "ถูกต้องแล้ว! แต่นั้นก็ไม่ใช่คำตอบที่ถูกเพียงข้อเดียว",
            correct: true
		},
        {
			text: "อัพโหลดไฟล์",
			explain: "ถูกต้องแล้ว! แต่ยังไม่ใช่ทั้งหมด",
            correct: true
		},
        {
			text: "ดูความแตกต่างระหว่างเวอร์ชั่นต่างๆ",
			explain: "ถูกต้องแล้ว! แต่นั้นก็ไม่ใช่ทั้งหมดที่คุณทำได้",
            correct: true
		}
	]}
/>

### 4. การ์ดโมเดลคืออะไร?

<Question
	choices={[
		{
			text: "คำอธิบายโมเดลแบบหยาบๆ ดังนั้นจึงสำคัญน้อยกว่าไฟล์โมเดลและ tokenizer",
			explain: "มันคือคำอธิบายของโมเดล แต่มันเป็นชิ้นที่สำคัญมาก: ถ้ามันไม่สมบูรณ์หรือขาดตกบกพร่องบางอย่างไป คุณประโยชน์ของโมเดลจะลงลดอย่างมาก"
		},
		{
			text: "วิธีที่ใช้ในการรับประกันความสามารถในการทำซ้ำ (reproducibility), ความสามารถในการนำกลับมาใช้ (reusability) และความเท่าเทียม (fairness)",
			explain: "ถูกต้องแล้ว! การแบ่งปันข้อมูลที่ถูกต้องในการ์ดโมเดลจะช่วยให้ผู้ใช้สามารถนำโมเดลของคุณไปใช้และคำนึงถึงข้อจำกัดและความลำเอียงของมัน",
            correct: true
		},
		{
			text: "ไฟล์ Python ที่สามารถรันเพื่อดึงข้อมูลเกี่ยวกับโมเดลได้",
			explain: "การ์ดโมเดลเป็นไฟล์ Markdown แบบเรียบง่าย"
		}
	]}
/>

### 5. วัตถุ (objects) ใดต่อไปนี้ของ 🤗 Transformers library ที่สามารถถูกแบ่งปันได้โดยตรงบน Hub ผ่านคำสั่ง `push_to_hub()`?

{#if fw === 'pt'}
<Question
	choices={[
		{
			text: "tokenizer",
			explain: "ถูกต้องแล้ว! tokenizer ทั้งหมดมีคำสั่ง <code>push_to_hub</code> และใช้มันในการดันไฟล์ทั้งหมดของ tokenizer (คำศัพท์ (vocabulary), สถาปัตยกรรมของ tokenizer และอื่นๆ) ไปยัง repo ที่กำหนดได้ แต่นี่ก็ไม่ใช่คำตอบที่ถูกเพียงข้อเดียว!",
            correct: true
		},
		{
			text: "model configuration",
			explain: "ถูกต้องแล้ว! ไฟล์สำหรับกำหนดค่าของโมเดล (model configurations) ทั้งหมดมีคำสั่ง <code>push_to_hub</code> และใช้มันในการดันพวกมันขึ้นไปยัง repo ที่กำหนดได้ มีอะไรอีกที่คุณสามารถแบ่งปันได้?",
            correct: true
		},
		{
			text: "model",
			explain: "ถูกต้องแล้ว! โมเดลทั้งหมดมีคำสั่ง <code>push_to_hub</code> และใช้มันในการดันพวกมันและไฟล์กำหนดค่าของพวกมันขึ้นไปยัง repo ที่กำหนดได้ แต่นั่นก็ไม่ใช่ทั้งหมดที่คุณแบ่งปันได้",
            correct: true
		},
        {
			text: "Trainer",
			explain: "ถูกต้อง — <code>Trainer</code> ก็มีคำสั่ง <code>push_to_hub</code> และใช้มันในการอัพโหลดโมเดล, ไฟล์กำหนดค่า, tokenizer และดราฟของการ์ดโมเดลไปยัง repo ที่กำหนดได้ ลองตอบข้ออื่นดู!",
            correct: true
		}
	]}
/>
{:else}
<Question
	choices={[
		{
			text: "tokenizer",
			explain: "ถูกต้องแล้ว! tokenizer ทั้งหมดมีคำสั่ง <code>push_to_hub</code> และใช้มันในการดันไฟล์ทั้งหมดของ tokenizer (คำศัพท์ (vocabulary), สถาปัตยกรรมของ tokenizer และอื่นๆ) ไปยัง repo ที่กำหนดได้ แต่นี่ก็ไม่ใช่คำตอบที่ถูกเพียงข้อเดียว!",
            correct: true
		},
		{
			text: "model configuration",
			explain: "ถูกต้องแล้ว! ไฟล์สำหรับกำหนดค่าของโมเดล (model configurations) ทั้งหมดมีคำสั่ง <code>push_to_hub</code> และใช้มันในการดันพวกมันขึ้นไปยัง repo ที่กำหนดได้ มีอะไรอีกที่คุณสามารถแบ่งปันได้?",
            correct: true
		},
		{
			text: "model",
			explain: "ถูกต้องแล้ว! โมเดลทั้งหมดมีคำสั่ง <code>push_to_hub</code> และใช้มันในการดันพวกมันและไฟล์กำหนดค่าของพวกมันขึ้นไปยัง repo ที่กำหนดได้ แต่นั่นก็ไม่ใช่ทั้งหมดที่คุณแบ่งปันได้",
            correct: true
		},
		{
			text: "ทั้งหมดที่กล่าวมารวมกับ callback ที่อุทิศให้",
			explain: "ถูกต้อง — โดยปกติ <code>PushToHubCallback</code> จะส่งวัตถุทั้งหมดเหล่านั้นไปยัง repo ระหว่างการเทรน",
            correct: true
		}
	]}
/>
{/if}

### 6. อะไรคือขั้นตอนแรกในการใช้คำสั่ง `push_to_hub()` หรือเครื่องมือ CLI?

<Question
	choices={[
		{
			text: "Log in เข้าสู่หน้าเว็บไซต์",
			explain: "การทำแบบนี้ไม่ได้ช่วยอะไรกับ local machine ของคุณเลย"
		},
		{
			text: "รันคำสั่ง 'huggingface-cli login' ใน terminal",
			explain: "ถูกต้อง — การทำแบบนี้จะดาวน์โหลดและเก็บโทเค็นส่วนตัวของคุณไว้ใน cache",
            correct: true
		},
		{
			text: "รันคำสั่ง 'notebook_login()' ใน notebook",
			explain: "ถูกต้อง — การทำแบบนี้จะแสดงเครื่องมือ (widget) ให้คุณรับรองความถูกต้อง (authentication)",
            correct: true
		},
	]}
/>

### 7. คุณกำลังใช้งานโมเดลและ tokenizer อยู่ — คุณจะสามารถอัพโหลดพวกมันขึ้นไปบน Hub ได้อย่างไร?

<Question
	choices={[
		{
			text: "โดยการเรียกคำสั่ง push_to_hub โดยตรงจากโมเดลและ tokenizer",
			explain: "ถูกต้องแล้ว!",
            correct: true
		},
		{
			text: "ภายใน Python runtime คลุมพวกมันเอาไว้ด้วย <code>huggingface_hub</code> utility",
			explain: "โมเดลและ tokenizers ถ้ารับประโยชน์จาก <code>huggingface_hub</code> utilities อยู่แล้ว: ไม่จำเป็นจะต้องมีการคลุมเพิ่ม!"
		},
		{
			text: "โดยการบันทึกพวกมันลงบนเครื่องและเรียกใช้คำสั่ง <code>transformers-cli upload-model</code>",
			explain: "ไม่มีคำสั่ง <code>upload-model</code> นี้อยู่"
		}
	]}
/>

### 8. มีการดำเนินการ git (git operations) ใดบ้างที่คุณสามารถทำได้กับคลาส `Repository`?

<Question
	choices={[
		{
			text: "commit",
			explain: "ถูกต้อง คำสั่ง <code>git_commit()</code> มีไว้สำหรับสิ่งนี้",
            correct: true
		},
		{
			text: "pull",
			explain: "นั่นคือวัตถุประสงค์ของคำสั่ง <code>git_pull()</code>",
            correct: true
		},
		{
			text: "push",
			explain: "คำสั่ง <code>git_push()</code> มีไว้ทำสิ่งนี้",
            correct: true
		},
		{
			text: "merge",
			explain: "ไม่ การดำเนินการนี้ไม่สามารถทำได้กับ API นี้"
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/th/chapter4/6.mdx" />