# Doğal Dil İşleme (NLP)

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

Transformer modellerine geçiş yapmadan önce, doğal dil işlemenin tanımına ve neden önemli olduğuna kısaca bir göz atalım. 


## NLP Nedir?

NLP, dil bilim ve makina öğrenmesi alanlarini kapsayan, dogal dil üzerine olan herşeyi anlamaya yönelik bir alandır. NLP her bir kelimeyi anlamanın yanısıra, kelimelerin bağlamını anlayabilmeyi amaçlar. Aşağıda NLP görevlerinin genel bir listesini, her bir göreve dair bir kaç örnekle birlikte görülebilir:

- **Cümle Sınıflandırması: Değerlendirmeler üzerine duygu analizi, spam e-posta saptaması, bir cümlenin dilbilgisel doğruluğunu, ya da iki cümlenin mantıksal olarak bağlı olup olmadığını anlama
- **Cümle içerisindeki her bir kelimenin sınıflandırması: Bir cümlenin dilbilgisel öğelerinin (isim, fiil, sıfat), ya da isim verilmiş varlıkların tanımlanması
- **Metin üretme: Verilen bir ipucunu kullanarak, otomatik olarak metni tamamlama, maskeli kelimeler ile metindeki boşlukları doldurma 
- **Metinden cevap çıkarımı: Verilen bir soru ve bağlamı kullanarak, bağlamda verilmi olan bilgiye dayanarak verilen soruyu cevaplama
- **Verilen metni kullanarak yeni bir cümle üretme: Metni başka bir dile çevirme, metin özetleme. 

Metin işlemenin yanısıra, NLP, konuşma tanıma ve bilgisayar görmesi alanlarında gorülen, bir ses örneğini yazıya dökme ya da bir fotoğrafı betimleme gibi komplike işlemleri çözümlemek için de kullanılabilir. 

## NLP Neden Zor? 

Bilgisayarlar, bilgiyi biz insanların yaptığı gibi işlemiyor. Örneğin, insan beyni “Acıktım” gibi basit bir cümlenin anlamını kolaylıkla anlayabilir. Benzer bir şekilde, “acıktım” ve “üzgünüm” cümlelerinin dilbilgisel açıdan benzerliğini kolayca görebiliyoruz. Ancak, makine öğrenmesi modelleri için bu gibi işlemler hiç de kolay değil. Bir modelin, verilen metnin anlamını öğrenebilmesi için metnin belirli bir yöntem ile işlenmesi gerekir. İnsan dilinin bileşikliği nedeniyle, bu işlemenin nasıl yapılacağı konsunu dikkatlice düşünmeliyiz. Bu güne kadar NLP alanında yazının nasıl temsil edileceğine dair bir çok çalışma yapıldı. Bir sonraki bölümde, bu çalışmalarda geliştirilen bazı yöntemlere göz atacağız.



<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/tr/chapter1/2.mdx" />