# Thiên kiến và hạn chế

<CourseFloatingBanner chapter={1}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {
      label: "Google Colab",
      value:
        "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/vi/chapter1/section8.ipynb",
    },
    {
      label: "Aws Studio",
      value:
        "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/vi/chapter1/section8.ipynb",
    },
  ]}
/>

Nếu mục đích của bạn là sử dụng một mô hình được huấn luyện trước hoặc một phiên bản được tinh chỉnh trong quá trình sản xuất, xin lưu ý rằng mặc dù những mô hình này là những công cụ mạnh mẽ nhưng chúng cũng có những hạn chế. Điểm lớn nhất trong số đó là, để cho phép huấn luyện trước trên một lượng lớn dữ liệu, các nhà nghiên cứu thường thu thập tất cả nội dung họ có thể tìm thấy, lấy nội dung tốt nhất cũng như xấu nhất của những gì có sẵn trên internet.

Để đưa ra một minh họa nhanh, hãy quay lại ví dụ về pipeline `fill-mask` với mô hình BERT:

```python
from transformers import pipeline

unmasker = pipeline("fill-mask", model="bert-base-uncased")
result = unmasker("This man works as a [MASK].")
print([r["token_str"] for r in result])

result = unmasker("This woman works as a [MASK].")
print([r["token_str"] for r in result])
```

```python out
['lawyer', 'carpenter', 'doctor', 'waiter', 'mechanic']
['nurse', 'waitress', 'teacher', 'maid', 'prostitute']
```

Khi được yêu cầu điền từ còn thiếu trong hai câu này, mô hình chỉ đưa ra một câu trả lời không phân biệt giới tính (waiter/waitress hay bồi bàn nam/bồi bàn nữ). Những công việc khác thường gắn với một giới tính cụ thể - và vâng, prostitute (gái mại dâm) đã nằm trong 5 khả năng hàng đầu mà người mẫu kết hợp với "woman" (phụ nữ) và "work"(công việc). Điều này xảy ra mặc dù BERT là một trong những mô hình Transformer hiếm hoi không được xây dựng bằng cách thu thập dữ liệu từ khắp nơi trên internet, mà sử dụng dữ liệu có vẻ trung lập (nó được đào tạo trên [Wikipedia tiếng Anh](https://huggingface.co/datasets/wikipedia) và bộ dữ liệu [BookCorpus](https://huggingface.co/datasets/bookcorpus).

Do đó, khi bạn sử dụng những công cụ này, bạn cần lưu ý rằng mô hình gốc mà bạn đang sử dụng rất dễ tạo ra nội dung phân biệt giới tính, phân biệt chủng tộc, hoặc kỳ thị đồng tính. Việc tinh chỉnh mô hình trên dữ liệu của bạn sẽ không làm biến mất xu hướng nội tại này.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter1/8.mdx" />