# Đố vui cuối chương

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

### 1. Thứ tự của một quy trình mô hình hóa ngôn ngữ là gì?

<Question
	choices={[
		{
			text: "Đầu tiên, mô hình xử lý văn bản và trả về các dự đoán thô. Sau đó, tokenizer hiểu các dự đoán này và chuyển đổi chúng trở lại thành văn bản khi cần.",
			explain: "Mô hình không thể hiểu văn bản! Trình tokenize đầu tiên phải tokenize văn bản và chuyển đổi nó thành ID đầu vào để mô hình có thể hiểu được."
		},
		{
			text: "Đầu tiên, tokenizer xử lý văn bản và trả về các ID. Mô hình xử lý các ID này và xuất ra một dự đoán, có thể là một số văn bản.",
			explain: "Dự đoán của mô hình không thể thành văn bản ngay lập tức. Phải sử dụng trình tokenizer để chuyển dự đoán trở lại thành văn bản!"
		},
		{
			text: "Tokenizer xử lý văn bản và trả về các ID. Mô hình xử lý các ID này và đưa ra dự đoán. Sau đó, tokenizer có thể được sử dụng một lần nữa để chuyển đổi các dự đoán này trở lại một số văn bản.",
			explain: "Đúng! Trình mã hóa có thể được sử dụng cho cả mã hóa mã hóa và khử mã hóa hay giải mã.",
            correct: true
		}
	]}
/>

### 2. Đầu ra tensor của mô hình Transformer cơ sở có bao nhiêu chiều, và chúng là gì?

<Question
	choices={[
		{
			text: "2: Độ dài chuỗi và kích thước lô",
			explain: "Sai! Đầu ra tensor của mô hình có một chiều thứ ba: kích thước lớp ẩn."
		},
		{
			text: "2: Độ dài chuỗi và độ dài lớp ẩn",
			explain: "Sai! Tất cả các mô hình Transformer xử lý theo lô, kể cả khi là một chuỗi đơn, khi đó kích thước lô bằng 1!"
		},
		{
			text: "3: Độ dài chuỗi, kích thước lô, và độ dài lớp ẩn",
			explain: "Chính xác!",
            correct: true
		}
	]}
/>

### 3. Trường hợp nào dưới đây không phải là ví dụ về tokenize theo từ phụ?

<Question
	choices={[
		{
			text: "WordPiece",
			explain: "Chính xác, đây là một ví dụ về tokenize theo từ phụ!",
            correct: true
		},
		{
			text: "Tokenize theo kí tự",
			explain: "Tokenize theo kí tự không phải là một ví dụ về tokenize theo từ phụ!"
		},
		{
			text: "Chia theo dấu cách và các dấu câu",
			explain: "Đây là ví dụ về tokenize theo mức từ!"
		},
		{
			text: "BPE",
			explain: "Chính xác, đây là một ví dụ về tokenize theo từ phụ!",
            correct: true
        },
		{
			text: "Unigram",
			explain: "Chính xác, đây là một ví dụ về tokenize theo từ phụ!",
            correct: true
        },
		{
			text: "Không phải các trường hợp trên",
			explain: "Không chính xác!"
        }
	]}
/>

### 4. Model head (Đầu mô hình) là gì?

<Question
	choices={[
		{
			text: "Một thành phần của Transformer cơ sở chuyển hướng các tensor đến các lớp chính xác của chúng",
			explain: "Không chính xác! Không có thành phần như vậy."
		},
		{
			text: "Còn được gọi là cơ chế self-attention haytự chú ý, nó điều chỉnh cách đại diện của một token theo các token khác của chuỗi",
			explain: "Không chính xác! Lớp self-attention có chứa các attention \"heads,\" nhưng đây không phải là các đầu thích ứng."
		},
		{
			text: "Một thành phần bổ sung, thường được tạo thành từ một hoặc một vài lớp, để chuyển đổi các dự đoán transformer thành đầu ra theo tác vụ cụ thể",
			explain: "Đúng vậy. Đầu thích ứng, còn được gọi đơn giản là đầu, xuất hiện ở các dạng khác nhau: đầu mô hình ngôn ngữ, đầu hỏi đáp, đầu phân loại chuỗi ... ",
			correct: true
		} 
	]}
/>

{#if fw === 'pt'}

### 5. AutoModel là gì?

<Question
	choices={[
		{
			text: "Một mô hình tự động huấn luyện trên dữ liệu của bạn",
			explain: "Không chính xác. Bạn có đang nhầm sản phẩm này với sản phẩm <a href='https://huggingface.co/autotrain'>AutoTrain</a> của chúng tôi không?"
		},
		{
			text: "Một đối tượng trả về kiến trúc chính xác dựa trên checkpoint",
			explain: "Chính xác: <code>AutoModel</code> chỉ cần biết checkpoint từ đó khởi tạo để trả về kiến trúc chính xác.",
			correct: true
		},
		{
			text: "Một mô hình tự động phát hiện ngôn ngữ được sử dụng cho đầu vào của nó để tải các trọng số chính xác",
			explain: "Không chính xác; trong khi một số checkpoint và mô hình có khả năng xử lý đa ngôn ngữ, không có công cụ tích hợp nào để lựa chọn checkpoint tự động theo ngôn ngữ. Bạn nên truy cập <a href='https://huggingface.co/models'>Model Hub</a>  để tìm checkpoint tốt nhất cho tác vụ của bạn!"
		} 
	]}
/>

{:else}
### 5. TFAutoModel là gì?

<Question
	choices={[
		{
			text: "Một mô hình tự động huấn luyện trên dữ liệu của bạn",
			explain: "Không chính xác. Bạn có đang nhầm sản phẩm này với sản phẩm <a href='https://huggingface.co/autotrain'>AutoTrain</a> của chúng tôi không?"
		},
		{
			text: "Một đối tượng trả về kiến trúc chính xác dựa trên checkpoint",
			explain: "Chính xác: <code>TFAutoModel</code> chỉ cần biết checkpoint từ đó khởi tạo để trả về kiến trúc chính xác.",
			correct: true
		},
		{
			text: "Một mô hình tự động phát hiện ngôn ngữ được sử dụng cho đầu vào của nó để tải các trọng số chính xác",
			explain: "Không chính xác; trong khi một số checkpoint và mô hình có khả năng xử lý đa ngôn ngữ, không có công cụ tích hợp nào để lựa chọn checkpoint tự động theo ngôn ngữ. Bạn nên truy cập <a href='https://huggingface.co/models'>Model Hub</a>  để tìm checkpoint tốt nhất cho tác vụ của bạn!"
		} 
	]}
/>

{/if}

### 6. Các kỹ thuật cần lưu ý khi ghép các chuỗi có độ dài khác nhau với nhau là gì?

<Question
	choices={[
		{
			text: "Cắt bớt",
			explain: "Vâng, việc cắt bớt là một cách chính xác để sắp xếp các chuỗi sao cho chúng vừa với hình chữ nhật. Tuy nhiên, nó có phải là duy nhất không?",
			correct: true
		},
		{
			text: "Trả về tensor",
			explain: "Trong khi các kỹ thuật khác cho phép bạn trả về các tensor hình chữ nhật, trả về tensor không hữu ích khi kết hợp các chuỗi với nhau."
		},
		{
			text: "Đệm thêm",
			explain: "Vâng, việc đệm thêm là một cách chính xác để sắp xếp các chuỗi sao cho chúng vừa với hình chữ nhật. Tuy nhiên, nó có phải là duy nhất không?",
			correct: true
		}, 
		{
			text: "Attention masking",
			explain: "Hoàn toàn có thể! Attention mask có tầm quan trọng hàng đầu khi xử lý các chuỗi có độ dài khác nhau. Tuy nhiên, đó không phải là kỹ thuật duy nhất cần lưu ý.",
			correct: true
		} 
	]}
/>

### 7. Mục đích của việc áp dụng hàm SoftMax vào đầu ra logit của mô hình phân loại là gì?

<Question
	choices={[
		{
			text: "Nó làm mềm logit để chúng đáng tin cậy hơn.",
			explain: "Không, hàm SoftMax không ảnh hưởng đến độ tin cậy của kết quả."
		},
		{
			text: "Nó áp dụng giới hạn dưới và trên để chúng trở nên dễ hiểu.",
			explain: "Đúng! Các giá trị kết quả bị ràng buộc trong khoảng từ 0 đến 1. Tuy nhiên, đó không phải là lý do duy nhất chúng tôi sử dụng hàm SoftMax.",
            correct: true
		},
		{
			text: "Tổng của kết quả đầu ra khi đó là 1, dẫn đến việc giải thích theo xác suất có thể xảy ra.",
			explain: "Chính xác!  Tuy nhiên, đó không phải là lý do duy nhất chúng tôi sử dụng hàm SoftMax.",
            correct: true
		}
	]}
/>

### 8. Phần lớn API tokenizer tập trung vào phương pháp nào?

<Question
	choices={[
		{
			text: "<code>encode</code>, vì nó có thể mã hóa văn bản thành ID và ID thành dự đoán",
			explain: "Sai! Mặc dù phương thức<code>encode</code> tồn tại trên tokenizers, nhưng nó không tồn tại trên các mô hình."
		},
		{
			text: "Gọi trực tiếp đối tượng tokenizer.",
			explain: "Chính xác! Phương thức <code>__call__</code> của tokenizer là một phương pháp rất mạnh có thể xử lý khá nhiều thứ. Nó cũng là phương pháp được sử dụng để truy xuất các dự đoán từ một mô hình.",
			correct: true
		},
		{
			text: "<code>Đệm thêm</code>",
			explain: "Sai! Đệm thêm rất hữu ích, nhưng nó chỉ là một phần của tokenizer API."
		},
		{
			text: "<code>tokenize</code>",
			explain: "Phương thức <code>tokenize</code> được cho là một trong những phương pháp hữu ích nhất, nhưng nó không phải là cốt lõi của API tokenizer."
		}
	]}
/>

### 9. Biến `result` chứa gì trong đoạn mã dưới đây?

```py
from transformers import AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
result = tokenizer.tokenize("Hello!")
```

<Question
	choices={[
		{
			text: "Danh sách các chuỗi, mỗi chuỗi là một token",
			explain: "Chắc chắn rồi! Chuyển đổi chúng thành ID và gửi chúng đến một mô hình!",
            correct: true
		},
		{
			text: "Danh sách các ID",
			explain: "Sai; đó là những gì phương thức <code>__call__</code> hoặc <code>convert_tokens_to_ids</code> làm!"
		},
		{
			text: "Một chuỗi chứa tất cả các token",
			explain: "Điều này sẽ là không tối ưu, vì mục tiêu là chia chuỗi thành nhiều token."
		}
	]}
/>

{#if fw === 'pt'}

### 10. Có điều gì đó sai với đoạn mã sau đây?

```py
from transformers import AutoTokenizer, AutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = AutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "Không, có vẻ đúng.",
			explain: "Tiếc thay, việc kết hợp một mô hình với một tokenizer đã được huấn luyện với một checkpoint khác hiếm khi là một ý tưởng hay. Mô hình không được huấn luyện để hiểu được đầu ra của tokenizer này, vì vậy mô hình xuất ra (nếu nó thậm chí có thể chạy!) sẽ không có ý nghĩa gì."
		},
		{
			text: "Tokenizer và mô hình phải luôn ở cùng một checkpoint.",
			explain: "Đúng!",
            correct: true
		},
		{
			text: "Đây là một ví dụ thực tiễn về đệm thêm và cắt bớt với tokenizer khi tát cả đầu vào trong cùng một lô.",
			explain: "Đúng là mọi đầu vào của mô hình cần phải là một lô. Tuy nhiên, việc cắt bớt hoặc chèn thêm chuỗi này sẽ không nhất thiết có ý nghĩa vì chỉ cần một trong số đó và đó là các kỹ thuật để gộp một danh sách các câu lại với nhau."
		}
	]}
/>

{:else}
### 10. Có điều gì đó sai với đoạn mã sau đây?

```py
from transformers import AutoTokenizer, TFAutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = TFAutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "Không, có vẻ đúng.",
			explain: "Tiếc thay, việc kết hợp một mô hình với một tokenizer đã được huấn luyện với một checkpoint khác hiếm khi là một ý tưởng hay. Mô hình không được huấn luyện để hiểu được đầu ra của tokenizer này, vì vậy mô hình xuất ra (nếu nó thậm chí có thể chạy!) sẽ không có ý nghĩa gì."
		},
		{
			text: "Tokenizer và mô hình phải luôn ở cùng một checkpoint.",
			explain: "Đúng!",
            correct: true
		},
		{
			text: "Đây là một ví dụ thực tiễn về đệm thêm và cắt bớt với tokenizer khi tát cả đầu vào trong cùng một lô.",
			explain: "Đúng là mọi đầu vào của mô hình cần phải là một lô. Tuy nhiên, việc cắt bớt hoặc chèn thêm chuỗi này sẽ không nhất thiết có ý nghĩa vì chỉ cần một trong số đó và đó là các kỹ thuật để gộp một danh sách các câu lại với nhau."
		}
	]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter2/8.mdx" />