# Đố vui cuối chương

<CourseFloatingBanner
    chapter={3}
    classNames="absolute z-10 right-0 top-0"
/>

Kiểm tra những gì bạn đã học trong chương này!

### 1. Tập dữ liệu `emotion` chứa các tin nhắn Twitter được gắn nhãn cảm xúc. Tìm kiếm nó trong [Hub](https://huggingface.co/datasets) và đọc thẻ tập dữ liệu. Cảm xúc nào trong số này không phải là một trong những cảm xúc cơ bản của nó?

<Question
	choices={[
		{
			text: "Joy (Vui vẻ)",
			explain: "Hãy thử lại - cảm xúc này có trong tập dữ liệu đó!"
		},
		{
			text: "Love (Yêu thích)",
			explain: "Hãy thử lại - cảm xúc này có trong tập dữ liệu đó!"
		},
		{
			text: "Confusion (Bối rối)",
			explain: "Chính xác! Bối rối không phải là một trong sáu cảm xúc cơ bản.",
            correct: true
		},
        {
			text: "Surprise (Ngạc nhiên)",
			explain: "Ngạc nhiên chưa! Thử cái khác xem!"
		}
	]}
/>

### 2. Tìm kiếm tập dữ liệu `ar_sarcasm` trong [Hub](https://huggingface.co/datasets). Nó hỗ trợ tác vụ nào?

<Question
	choices={[
		{
			text: "Phân loại cảm xúc",
			explain: "Đúng rồi! Bạn có thể nhận ra nhờ tên thẻ.",
            correct: true
		},
		{
			text: "Dịch máy",
			explain: "Không phải rồi - thử xem lại tại  <a href='https://huggingface.co/datasets/ar_sarcasm'>thẻ dữ liệu</a> nha!"
		},
		{
			text: "Nhận dạng thực thể",
			explain: "Không phải rồi - thử xem lại tại  <a href='https://huggingface.co/datasets/ar_sarcasm'>thẻ dữ liệu</a> nha!"
		},
        {
			text: "Hỏi đáp",
			explain: "Tiếc ghê, không chính xác rồi. Thử lại nha!"
		}
	]}
/>

### 3. Mô hình BERT mong đợi một cặp câu được xử lý như thế nào?

<Question
	choices={[
		{
			text: "Tokens_of_sentence_1 [SEP] Tokens_of_sentence_2",
			explain: "Cần token đặc biệt <code>[SEP]</code> để phân cách hai câu, nhưng đây không phải thứ duy nhất!"
		},
		{
			text: "[CLS] Tokens_of_sentence_1 Tokens_of_sentence_2",
			explain: "Cần token đặc biệt <code>[CLS]</code> ở đầu, nhưng đây không phải thứ duy nhất!"
		},
		{
			text: "[CLS] Tokens_of_sentence_1 [SEP] Tokens_of_sentence_2 [SEP]",
			explain: "Chính xác!",
            correct: true
		},
        {
			text: "[CLS] Tokens_of_sentence_1 [SEP] Tokens_of_sentence_2",
			explain: "Cần token đặc biệt <code>[CLS]</code> ở đầu cũng như <code>[SEP]</code> để phân cách hai câu, nhưng đây không phải thứ duy nhất!"
		}
	]}
/>

{#if fw === 'pt'}
### 4. Lợi ích của phương thức `Dataset.map()` là gì?

<Question
	choices={[
		{
			text: "Kết quả của hàm được lưu vào bộ nhớ đệm, vì vậy sẽ không mất thời gian nếu chúng tôi thực thi lại mã.",
			explain: "Đó thực sự là một trong những lợi ích của phương pháp này! Tuy nhiên, nó không phải là lợi ích duy nhất...",
            correct: true
		},
		{
			text: "Nó có thể áp dụng xử lý đa luồng để thực thi nhanh hơn so với việc áp dụng hàm trên từng phần tử của tập dữ liệu.",
			explain: "Đây là một tính năng gọn gàng của phương pháp này, nhưng nó không phải là lợi ích duy nhất!",
            correct: true
		},
		{
			text: "Nó không tải toàn bộ tập dữ liệu vào bộ nhớ, lưu kết quả ngay sau khi một phần tử được xử lý.",
			explain: "Đó là một lợi thế của phương pháp này. Tuy nhiên, vẫn có những lợi ích khác!",
            correct: true
		},
	]}
/>

### 5. Đệm động nghĩa là sao?

<Question
	choices={[
		{
			text: "Đó là khi bạn đệm các đầu vào cho mỗi lô đến độ dài tối đa trong toàn bộ tập dữ liệu.",
			explain: "Nó ngụ ý đệm khi tạo lô, nhưng không có độ dài tối đa trong toàn bộ tập dữ liệu."
		},
		{
			text: "Đó là khi bạn đệm đầu vào của mình khi tạo lô, đến độ dài tối đa của các câu bên trong lô đó.",
			explain: "Đúng vậy! Phần \"động\" xuất phát từ thực tế là kích thước của mỗi lô được xác định tại thời điểm tạo ra và kết quả là tất cả các lô của bạn có thể có các hình dạng khác nhau.",
            correct: true
		},
		{
			text: "Đó là khi bạn đệm đầu vào của mình để mỗi câu có cùng số lượng token như câu trước trong tập dữ liệu.",
			explain: "Điều đó không chính xác, cộng với việc xem xét thứ tự trong tập dữ liệu không có ý nghĩa gì vì chúng tôi xáo trộn nó trong quá trình huấn luyện."
		},
	]}
/>

### 6. Mục đích của hàm đối chiếu là gì?

<Question
	choices={[
		{
			text: "Nó đảm bảo tất cả các chuỗi trong tập dữ liệu có cùng độ dài.",
			explain: "Một hàm đối chiếu có liên quan đến việc xử lý các lô riêng lẻ, không phải toàn bộ tập dữ liệu. Ngoài ra, chúng ta đang nói về các hàm đối chiếu chung, không cụ thể là <code>DataCollatorWithPadding</code>."
		},
		{
			text: "Nó tập hợp tất cả các mẫu lại trong một lô.",
			explain: "Đúng! Bạn có thể truyền hàm đối chiếu như một tham số của <code>DataLoader</code>. Chúng tôi đã sử dụng hàm <code>DataCollatorWithPadding</code>, một hàm đệm tất cả các mục trong một lô để chúng giống nhau về chiều dài.",
            correct: true
		},
		{
			text: "Nó tiền xử lý toàn bộ tập dữ liệu.",
			explain: "Đó là một hàm tiền xử lý, không phải là một hàm đối chiếu."
		},
        {
			text: "Nó cắt bớt các chuỗi trong tập dữ liệu.",
			explain: "Một hàm đối chiếu liên quan đến việc xử lý các lô riêng lẻ, không phải toàn bộ tập dữ liệu. Nếu bạn muốn cắt ngắn, bạn có thể sử dụng tham số <code>truncate</code> của <code>tokenizer</code>."
		}
	]}
/>

### 7. Điều gì xảy ra khi bạn khởi tạo một trong các lớp `AutoModelForXxx` với một mô hình ngôn ngữ huấn luyện trước( ví dụ như `bert-base-uncased`) mà liên quan tới một tác vụ khác hơn là tác vụ mà nó được huấn luyện sẵn?

<Question
	choices={[
		{
			text: "Nothing, but you get a warning.",
			explain: "You do get a warning, but that's not all!"
		},
		{
			text: "Phần đầu của mô hình được huấn luyện trước bị loại bỏ và phần đầu mới phù hợp với tác vụ sẽ được chèn vào thay thế.",
			explain: "Chính xác. Ví dụ, Khi ta sử dụng <code>AutoModelForSequenceClassification</code> với <code>bert-base-uncased</code>, ta nhận được cảnh báo khi khởi tạo mô hình. Phần đầu được huấn luyện trước không được sử dụng cho chuỗi tác vụ phân loại, vì vậy nó bị loại bỏ và một phần đầu mới được khởi tạo với các trọng số ngẫu nhiên.",
            correct: true
		},
		{
			text: "Phần đầu của mô hình được huấn luyện trước bị loại bỏ.",
			explain: "Một điều gì đó khác cần phải xảy ra. Hãy thử lại!"
		},
        {
			text: "Không có gì, vì mô hình vẫn có thể được tinh chỉnh cho các tác vụ khác.",
			explain: "Phần đầu của mô hình được huấn luyện trước không được huấn luyện để giải quyết tác vụ này, vì vậy chúng ta nên loại bỏ phần đầu!"
		}
	]}
/>

### 8. Mục đích của `TrainingArguments` là gì?

<Question
	choices={[
		{
			text: "Nó chứa tất cả các siêu tham số được sử dụng để huấn luyện và đánh giá với <code>Trainer</code>.",
			explain: "Chính xác!",
            correct: true
		},
		{
			text: "Nó chỉ định kích thước của mô hình.",
			explain: "Kích thước mô hình được xác định bởi cấu hình mô hình, không phải lớp <code>TrainingArguments</code>."
		},
		{
			text: "Nó chỉ chứa các siêu tham số được sử dụng để đánh giá.",
			explain: "Trong ví dụ này, chúng tôi đã chỉ định nơi mô hình và các checkpoint của nó sẽ được lưu. Hãy thử lại!"
		},
        {
			text: "Nó chỉ chứa các siêu tham số được sử dụng để huấn luyện.",
			explain: "Trong ví dụ này, chúng tôi cũng đã sử dụng <code>evaluation_strategy</code>, vì vậy điều này ảnh hưởng đến việc đánh giá mô hình. Hãy thử lại!"
		}
	]}
/>

### 9. Vì sao bạn nên sử dụng thư viện 🤗 Accelerate?

<Question
	choices={[
		{
			text: "Nó cung cấp quyền truy cập vào các mô hình nhanh hơn.",
			explain: "Không, thư viện 🤗 Accelerate không cung cấp bất kỳ mô hình nào."
		},
		{
			text: "INó cung cấp một API cấp cao nên tôi không phải triển khai vòng lặp huấn luyệncủa riêng mình.",
			explain: "Đây là những gì ta đã làm với <code>Trainer</code>, không phải với thư viện 🤗 Accelerate. Hãy thử lại!"
		},
		{
			text: "Nó làm cho các vòng huấn luyện hoạt động dựa trên các chiến lược phân tán",
			explain: "Đúng! Với 🤗 Accelerate, các vòng huấn luyện của bạn sẽ hoạt động cho nhiều GPU và TPU.",
            correct: true
		},
        {
			text: "Nó cung cấp nhiều hàm tối ưu hơn.",
			explain: "Không, thư viện 🤗 Accelerate không cung cấp bất kỳ hàm tối ưu nào."
		}
	]}
/>

{:else}
### 4. Điều gì xảy ra khi bạn khởi tạo một trong các lớp `TFAutoModelForXxx` với một mô hình ngôn ngữ huấn luyện trước( ví dụ như `bert-base-uncased`) mà liên quan tới một tác vụ khác hơn là tác vụ mà nó được huấn luyện sẵn?

<Question
	choices={[
		{
			text: "Không có gì, nhưng bạn nhận được một cảnh báo.",
			explain: "Bạn nhận được một cảnh báo, nhưng đó không phải là tất cả!"
		},
		{
			text: "Phần đầu của mô hình được huấn luyện trước bị loại bỏ và phần đầu mới phù hợp với tác vụ sẽ được chèn vào thay thế.",
			explain: "Chính xác. Ví dụ, Khi ta sử dụng <code>TFAutoModelForSequenceClassification</code> với <code>bert-base-uncased</code>, ta nhận được cảnh báo khi khởi tạo mô hình. Phần đầu được huấn luyện trước không được sử dụng cho chuỗi tác vụ phân loại, vì vậy nó bị loại bỏ và một phần đầu mới được khởi tạo với các trọng số ngẫu nhiên.",
            correct: true
		},
		{
			text: "Phần đầu của mô hình được huấn luyện trước bị loại bỏ.",
			explain: "Một điều gì đó khác cần phải xảy ra. Hãy thử lại!"
		},
        {
			text: "Không có gì, vì mô hình vẫn có thể được tinh chỉnh cho các tác vụ khác.",
			explain: "Phần đầu của mô hình được huấn luyện trước không được huấn luyện để giải quyết tác vụ này, vì vậy chúng ta nên loại bỏ phần đầu!"
		}
	]}
/>

### 5. Các mô hình TensorFlow từ `transformers` vốn đã là các mô hình Keras. Lợi ích của việc này là gì?

<Question
	choices={[
		{
			text: "Các mô hình hoạt động trên TPU khác với thường lệ.",
			explain: "Gần như vậy! Cần có một số thay đổi bổ sung nhỏ. Ví dụ: bạn cần chạy mọi thứ trong phạm vi <<code>TPUStrategy</code> , bao gồm cả việc khởi tạo mô hình."
		},
		{
			text: "Bạn có thể tận dụng các phương thức hiện có như <code>compile()</code>, <code>fit()</code>, và <code>predict()</code>.",
			explain: "Đúng! Sau khi bạn có dữ liệu, việc đào tạo về dữ liệu đó cần rất ít công việc.",
            correct: true
		},
		{
			text: "Bạn có thể học Keras cũng như transformers.",
			explain: "Đúng, nhưng chúng tôi đang tìm kiếm thứ khác :)",
			correct: true
		},
        {
			text: "Bạn có thể dễ dàng tính toán các chỉ số liên quan đến tập dữ liệu.",
			explain: "Keras giúp chúng ta huấn luyện và đánh giá mô hình, không phải tính toán các số liệu liên quan đến tập dữ liệu."
		}
	]}
/>

### 6. Làm thế nào bạn có thể định nghĩa thước đo tuỳ chỉnh của riêng bạn?

<Question
	choices={[
		{
			text: "Thông qua lớp con <code>tf.keras.metrics.Metric</code>.",
			explain: "Tuyệt vời!",
			correct: true
		},
		{
			text: "Sử dụng API chức năng của Keras.",
			explain: "Thử lại!"
		},
		{
			text: "Thông qua sử dụng <code>metric_fn(y_true, y_pred)</code>.",
			explain: "Chính xác!",
			correct: true
		},
        {
			text: "Sử dụng Googling.",
			explain: "Đó không phải là câu trả lời mà chúng tôi đang tìm kiếm, nhưng nó sẽ giúp bạn tìm thấy nó.",
			correct: true
		}
	]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter3/6.mdx" />