# Sử dụng các mô hình huấn luyện trước

{#if fw === 'pt'}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {
      label: "Google Colab",
      value:
        "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/vi/chapter4/section2_pt.ipynb",
    },
    {
      label: "Aws Studio",
      value:
        "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/vi/chapter4/section2_pt.ipynb",
    },
  ]}
/>

{:else}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {
      label: "Google Colab",
      value:
        "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/vi/chapter4/section2_tf.ipynb",
    },
    {
      label: "Aws Studio",
      value:
        "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/vi/chapter4/section2_tf.ipynb",
    },
  ]}
/>

{/if}

Model Hub làm cho việc chọn mô hình thích hợp trở nên đơn giản, vì vậy việc sử dụng mô hình đó trong bất kỳ thư viện nào dưới đây có thể được thực hiện trong một vài dòng mã. Hãy cùng xem cách thực sự sử dụng một trong những mô hình này và cách đóng góp lại cho cộng đồng.

Giả sử chúng tôi đang tìm kiếm một mô hình cho tiếng Pháp có thể thực hiện tác vụ diền vào phần bị che đi.

<div class="flex justify-center">
  <img
    src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/camembert.gif"
    alt="Selecting the Camembert model."
    width="80%"
  />
</div>

Chúng tôi chọn checkpoint `camembert-base` để dùng thử. Từ `camembert-base` là tất cả những gì chúng ta cần để bắt đầu sử dụng nó! Như bạn đã thấy trong các chương trước, chúng ta có thể khởi tạo nó bằng cách sử dụng hàm `pipeline()`:

```py
from transformers import pipeline

camembert_fill_mask = pipeline("fill-mask", model="camembert-base")
results = camembert_fill_mask("Le camembert est <mask> :)")
```

```python out
[
  {'sequence': 'Le camembert est délicieux :)', 'score': 0.49091005325317383, 'token': 7200, 'token_str': 'délicieux'},
  {'sequence': 'Le camembert est excellent :)', 'score': 0.1055697426199913, 'token': 2183, 'token_str': 'excellent'},
  {'sequence': 'Le camembert est succulent :)', 'score': 0.03453313186764717, 'token': 26202, 'token_str': 'succulent'},
  {'sequence': 'Le camembert est meilleur :)', 'score': 0.0330314114689827, 'token': 528, 'token_str': 'meilleur'},
  {'sequence': 'Le camembert est parfait :)', 'score': 0.03007650189101696, 'token': 1654, 'token_str': 'parfait'}
]
```

Như bạn có thể thấy, việc tải một mô hình trong một pipeline cực kỳ đơn giản. Điều duy nhất bạn cần chú ý là checkpoint đã chọn có phù hợp với tác vụ mà nó sẽ được sử dụng hay không. Ví dụ: ở đây chúng tôi đang tải checkpoint `camembert-base` trong pipeline `fill-mask`, điều này hoàn toàn ổn. Nhưng nếu chúng tôi tải checkpoint này trong pipeline phân loại văn bản, kết quả sẽ không có ý nghĩa gì vì phần đầu của `camembert-base` không phù hợp với tác vụ này! Chúng tôi khuyên bạn nên sử dụng công cụ chọn tác vụ trong giao diện Hugging Face Hub để chọn các checkpoint thích hợp:

<div class="flex justify-center">
  <img
    src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/tasks.png"
    alt="The task selector on the web interface."
    width="80%"
  />
</div>

Bạn cũng có thể khởi tạo checkpoint bằng cách sử dụng kiến trúc mô hình trực tiếp:

{#if fw === 'pt'}

```py
from transformers import CamembertTokenizer, CamembertForMaskedLM

tokenizer = CamembertTokenizer.from_pretrained("camembert-base")
model = CamembertForMaskedLM.from_pretrained("camembert-base")
```

Tuy nhiên, chúng tôi khuyên bạn nên sử dụng [`Auto*` classes](https://huggingface.co/transformers/model_doc/auto.html?highlight=auto#auto-classes) vì đây là của kiến trúc thiết kế-bất khả tri. Trong khi đoạn mã trước đó giới hạn người dùng ở các checkpoint chỉ có thể tải được trong kiến trúc CamemBERT, việc sử dụng các lớp `Auto*` giúp việc chuyển đổi các checkpoint trở nên đơn giản:


```py
from transformers import AutoTokenizer, AutoModelForMaskedLM

tokenizer = AutoTokenizer.from_pretrained("camembert-base")
model = AutoModelForMaskedLM.from_pretrained("camembert-base")
```

{:else}

```py
from transformers import CamembertTokenizer, TFCamembertForMaskedLM

tokenizer = CamembertTokenizer.from_pretrained("camembert-base")
model = TFCamembertForMaskedLM.from_pretrained("camembert-base")
```

Tuy nhiên, chúng tôi khuyên bạn nên sử dụng [`TFAuto*` classes](https://huggingface.co/transformers/model_doc/auto.html?highlight=auto#auto-classes) vì đây là của kiến trúc thiết kế-bất khả tri. Trong khi đoạn mã trước đó giới hạn người dùng ở các checkpoint chỉ có thể tải được trong kiến trúc CamemBERT, việc sử dụng các lớp `TFAuto*` giúp việc chuyển đổi các checkpoint trở nên đơn giản:

```py
from transformers import AutoTokenizer, TFAutoModelForMaskedLM

tokenizer = AutoTokenizer.from_pretrained("camembert-base")
model = TFAutoModelForMaskedLM.from_pretrained("camembert-base")
```

{/if}

<Tip>

Khi sử dụng một mô hình được huấn luyện trước, hãy đảm bảo kiểm tra xem nó được huấn luyện như thế nào, dựa trên tập dữ liệu nào, các giới hạn và độ sai lệch của nó. Tất cả thông tin này phải được ghi trên thẻ mô hình của nó.

</Tip>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter4/2.mdx" />