# 课程简介 [[课程简介]]

欢迎来到 Hugging Face 课程！本小节将指导你搭建工作环境。如果你刚开始学习本课程，我们建议你先阅读 [第一章](/course/chapter1) ，然后返回此处搭建环境，以便你亲自尝试和实现代码。

本课程涉及的所有库均以 Python 包形式提供，因此在这里我们将展示如何搭建 Python 环境并安装所需要的库。

我们将介绍两种设置工作环境的方法，使用 Colab Notebook 或 Python 虚拟环境。选择任意一种趁手的方式即可。对于初学者，我们强烈建议你从使用 Colab Notebook 开始（国内无法访问，可以跳过，直接查阅本页 **安装依赖** 那一节即可在本地的环境下运行，译者注）。

请注意，Python 虚拟环境的一些命令不支持 Windows 系统。如果你使用的操作系统是 Windows，我们建议你继续使用 Colab Notebook 如果你使用的操作系统是 Linux 发行版或 macOS，则可以使用此处的任一方法。

大多数课程和服务都依赖于你拥有 Hugging Face 帐户。我们建议现在创建一个： [创建一个账号](https://huggingface.co/join) 。

## 使用 Google Colab Notebook  [[使用 Google Colab Notebook ]]

使用 Colab Notebook 是最简单的搭建方式；可以在浏览器中启动 Notebook 并直接开始编写自己的代码！

如果你不熟悉 Colab，建议你先查看 [Colab 使用入门](https://colab.research.google.com/notebooks/intro.ipynb) 。Colab 提供一些加速硬件，例如 GPU 或 TPU，并且当我们使用的算力比较少的时候是免费的。

当打开 Colab 后，创建一个新的 Notebook 

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="An empty colab notebook" width="80%"/>
</div>

下一步是安装我们将在本课程中使用的库。我们将使用 **pip** 进行安装，它是 Python 的包管理器。在 Notebook 中，你可以通过加上！字符表示执行系统命令，所以安装🤗 Transformers 的命令如下：

```
!pip install transformers
```

你可以通过在运行 Python 时导入包来判断是否正确安装了该包：

```
import transformers
```

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>

这将安装一个没有安装机器学习框架（如 PyTorch 或 TensorFlow）非常轻量级的 🤗 Transformers。由于之后我们将使用该库的许多不同功能，我们建议安装开发版本，它带有几乎所有所需的依赖项：

```
!pip install transformers[sentencepiece]
```

这将需要一些时间，但当完成之后你就做好学习剩下的课程环境的全部准备了！

## 使用 Python 虚拟环境 [[使用 Python 虚拟环境]]

如果你更喜欢使用 Python 虚拟环境，那么第一步是在你的系统上安装 Python。我们建议你按照 [该指南](https://realpython.com/installing-python/) 进行配置。

安装 Python 后，你应该能够在终端中运行 Python 命令。你可以先运行此命令： `python --version` 来检验安装是否正确，然后再继续下一步。这应该会打印出你系统上现在可用的 Python 版本。

在终端中运行 Python 命令（例如  `python --version` ）时，运行命令的这个 Python 可以视为系统上的“默认”Python。我们建议保持这个默认的 Python 安装程序没有任何包，当运行某个程序的时候就为那个程序创建一个单独的运行环境 —— 这样，每个应用程序都可以有自己的依赖项和包，你无需担心与其他应用程序潜在的兼容性问题。

在 Python 中，这是通过 [*虚拟环境*](https://docs.python.org/3/tutorial/venv.html) 实现的，虚拟环境会创建许多目录树，每个目录树都包含具有特定 Python 版本的 Python 安装以及应用程序所需的所有包。可以使用许多不同的工具来创建这样的虚拟环境，但在此我们将使用官方 Python 包： [`venv`](https://docs.python.org/3/library/venv.html#module-venv) 。

首先，创建你希望 Transformers 所在的目录 - 例如，你可能希望在主目录的根目录下创建一个名为 `Transformers-course` 的新目录：

```
mkdir ~/transformers-course
cd ~/transformers-course
```

在这个目录中，使用 Python `venv` 模块创建一个虚拟环境：

```
python -m venv .env
```

你现在应该在原本为空的文件夹中看到一个名为 `.env` 的目录：

```
ls -a
```

```out
.      ..    .env
```

你可以使用 `activate` 和 `deactivate` 命令来控制进入和退出你的虚拟环境：

```
# 激活虚拟环境
source .env/bin/activate

# 退出虚拟环境
deactivate
```

你可以通过运行 `which python` 命令来检测虚拟环境是否被激活：如果它指向虚拟环境，那么你已经成功激活了它！

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

### 安装依赖 [[安装依赖]]

与前面使用 Google Colab 的部分一样，你现在需要安装继续学习所需的软件包。同样，你可以使用 `pip` 包管理器安装 🤗 Transformers 的开发版本：

```
pip install "transformers[sentencepiece]"
```

你现在已准备就绪，可以开始了！

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter0/1.mdx" />